/*
 * Permify API
 * Permify is an open source authorization service for creating fine-grained and scalable authorization systems.
 *
 * The version of the OpenAPI document: v1.6.1
 * Contact: hello@permify.co
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package co.permify.sdk.model;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;
import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


/**
 * PermissionLookupSubjectResponse is the response message for the LookupSubject method in the Permission service.
 */
@JsonPropertyOrder({
  PermissionLookupSubjectResponse.JSON_PROPERTY_SUBJECT_IDS,
  PermissionLookupSubjectResponse.JSON_PROPERTY_CONTINUOUS_TOKEN
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class PermissionLookupSubjectResponse {
  public static final String JSON_PROPERTY_SUBJECT_IDS = "subject_ids";
  private List<String> subjectIds;

  public static final String JSON_PROPERTY_CONTINUOUS_TOKEN = "continuous_token";
  private String continuousToken;

  public PermissionLookupSubjectResponse() { 
  }

  public PermissionLookupSubjectResponse subjectIds(List<String> subjectIds) {
    this.subjectIds = subjectIds;
    return this;
  }

  public PermissionLookupSubjectResponse addSubjectIdsItem(String subjectIdsItem) {
    if (this.subjectIds == null) {
      this.subjectIds = new ArrayList<>();
    }
    this.subjectIds.add(subjectIdsItem);
    return this;
  }

   /**
   * List of identifiers for subjects that match the lookup.
   * @return subjectIds
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SUBJECT_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getSubjectIds() {
    return subjectIds;
  }


  @JsonProperty(JSON_PROPERTY_SUBJECT_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSubjectIds(List<String> subjectIds) {
    this.subjectIds = subjectIds;
  }


  public PermissionLookupSubjectResponse continuousToken(String continuousToken) {
    this.continuousToken = continuousToken;
    return this;
  }

   /**
   * continuous_token is a string that can be used to paginate and retrieve the next set of results.
   * @return continuousToken
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CONTINUOUS_TOKEN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getContinuousToken() {
    return continuousToken;
  }


  @JsonProperty(JSON_PROPERTY_CONTINUOUS_TOKEN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContinuousToken(String continuousToken) {
    this.continuousToken = continuousToken;
  }


  /**
   * Return true if this PermissionLookupSubjectResponse object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PermissionLookupSubjectResponse permissionLookupSubjectResponse = (PermissionLookupSubjectResponse) o;
    return Objects.equals(this.subjectIds, permissionLookupSubjectResponse.subjectIds) &&
        Objects.equals(this.continuousToken, permissionLookupSubjectResponse.continuousToken);
  }

  @Override
  public int hashCode() {
    return Objects.hash(subjectIds, continuousToken);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PermissionLookupSubjectResponse {\n");
    sb.append("    subjectIds: ").append(toIndentedString(subjectIds)).append("\n");
    sb.append("    continuousToken: ").append(toIndentedString(continuousToken)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `subject_ids` to the URL query string
    if (getSubjectIds() != null) {
      for (int i = 0; i < getSubjectIds().size(); i++) {
        joiner.add(String.format("%ssubject_ids%s%s=%s", prefix, suffix,
            "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
            URLEncoder.encode(String.valueOf(getSubjectIds().get(i)), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
      }
    }

    // add `continuous_token` to the URL query string
    if (getContinuousToken() != null) {
      joiner.add(String.format("%scontinuous_token%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getContinuousToken()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    return joiner.toString();
  }
}

