/*
 * Permify API
 * Permify is an open source authorization service for creating fine-grained and scalable authorization systems.
 *
 * The version of the OpenAPI document: v1.6.1
 * Contact: hello@permify.co
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package co.permify.sdk.model;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;
import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import co.permify.sdk.model.RelationReference;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


/**
 * The RelationDefinition message provides detailed information about a specific relation.
 */
@JsonPropertyOrder({
  RelationDefinition.JSON_PROPERTY_NAME,
  RelationDefinition.JSON_PROPERTY_RELATION_REFERENCES
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class RelationDefinition {
  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_RELATION_REFERENCES = "relationReferences";
  private List<RelationReference> relationReferences;

  public RelationDefinition() { 
  }

  public RelationDefinition name(String name) {
    this.name = name;
    return this;
  }

   /**
   * The name of the relation, which follows a specific string pattern and has a maximum byte size.
   * @return name
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(String name) {
    this.name = name;
  }


  public RelationDefinition relationReferences(List<RelationReference> relationReferences) {
    this.relationReferences = relationReferences;
    return this;
  }

  public RelationDefinition addRelationReferencesItem(RelationReference relationReferencesItem) {
    if (this.relationReferences == null) {
      this.relationReferences = new ArrayList<>();
    }
    this.relationReferences.add(relationReferencesItem);
    return this;
  }

   /**
   * A list of references to other relations.
   * @return relationReferences
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_RELATION_REFERENCES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<RelationReference> getRelationReferences() {
    return relationReferences;
  }


  @JsonProperty(JSON_PROPERTY_RELATION_REFERENCES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRelationReferences(List<RelationReference> relationReferences) {
    this.relationReferences = relationReferences;
  }


  /**
   * Return true if this RelationDefinition object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RelationDefinition relationDefinition = (RelationDefinition) o;
    return Objects.equals(this.name, relationDefinition.name) &&
        Objects.equals(this.relationReferences, relationDefinition.relationReferences);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, relationReferences);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RelationDefinition {\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    relationReferences: ").append(toIndentedString(relationReferences)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `name` to the URL query string
    if (getName() != null) {
      joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `relationReferences` to the URL query string
    if (getRelationReferences() != null) {
      for (int i = 0; i < getRelationReferences().size(); i++) {
        if (getRelationReferences().get(i) != null) {
          joiner.add(getRelationReferences().get(i).toUrlQueryString(String.format("%srelationReferences%s%s", prefix, suffix,
          "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    return joiner.toString();
  }
}

