/*
 * Decompiled with CFR 0.152.
 */
package co.permify.sdk.model;

import co.permify.sdk.model.Attribute;
import co.permify.sdk.model.DataWriteRequestMetadata;
import co.permify.sdk.model.Tuple;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"metadata", "tuples", "attributes"})
public class DataWriteBody {
    public static final String JSON_PROPERTY_METADATA = "metadata";
    private DataWriteRequestMetadata metadata;
    public static final String JSON_PROPERTY_TUPLES = "tuples";
    private List<Tuple> tuples;
    public static final String JSON_PROPERTY_ATTRIBUTES = "attributes";
    private List<Attribute> attributes;

    public DataWriteBody metadata(DataWriteRequestMetadata metadata) {
        this.metadata = metadata;
        return this;
    }

    @Nullable
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DataWriteRequestMetadata getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMetadata(DataWriteRequestMetadata metadata) {
        this.metadata = metadata;
    }

    public DataWriteBody tuples(List<Tuple> tuples) {
        this.tuples = tuples;
        return this;
    }

    public DataWriteBody addTuplesItem(Tuple tuplesItem) {
        if (this.tuples == null) {
            this.tuples = new ArrayList<Tuple>();
        }
        this.tuples.add(tuplesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="tuples")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Tuple> getTuples() {
        return this.tuples;
    }

    @JsonProperty(value="tuples")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTuples(List<Tuple> tuples) {
        this.tuples = tuples;
    }

    public DataWriteBody attributes(List<Attribute> attributes) {
        this.attributes = attributes;
        return this;
    }

    public DataWriteBody addAttributesItem(Attribute attributesItem) {
        if (this.attributes == null) {
            this.attributes = new ArrayList<Attribute>();
        }
        this.attributes.add(attributesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="attributes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    @JsonProperty(value="attributes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAttributes(List<Attribute> attributes) {
        this.attributes = attributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataWriteBody dataWriteBody = (DataWriteBody)o;
        return Objects.equals(this.metadata, dataWriteBody.metadata) && Objects.equals(this.tuples, dataWriteBody.tuples) && Objects.equals(this.attributes, dataWriteBody.attributes);
    }

    public int hashCode() {
        return Objects.hash(this.metadata, this.tuples, this.attributes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DataWriteBody {\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    tuples: ").append(this.toIndentedString(this.tuples)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        int i;
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getMetadata() != null) {
            joiner.add(this.getMetadata().toUrlQueryString((String)prefix + JSON_PROPERTY_METADATA + suffix));
        }
        if (this.getTuples() != null) {
            for (i = 0; i < this.getTuples().size(); ++i) {
                if (this.getTuples().get(i) == null) continue;
                joiner.add(this.getTuples().get(i).toUrlQueryString(String.format("%stuples%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getAttributes() != null) {
            for (i = 0; i < this.getAttributes().size(); ++i) {
                if (this.getAttributes().get(i) == null) continue;
                joiner.add(this.getAttributes().get(i).toUrlQueryString(String.format("%sattributes%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        return joiner.toString();
    }
}

