/*
 * Decompiled with CFR 0.152.
 */
package co.permify.sdk.model;

import co.permify.sdk.model.AttributeDefinition;
import co.permify.sdk.model.EntityDefinitionReference;
import co.permify.sdk.model.PermissionDefinition;
import co.permify.sdk.model.RelationDefinition;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"name", "relations", "permissions", "attributes", "references"})
public class EntityDefinition {
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_RELATIONS = "relations";
    private Map<String, RelationDefinition> relations = new HashMap<String, RelationDefinition>();
    public static final String JSON_PROPERTY_PERMISSIONS = "permissions";
    private Map<String, PermissionDefinition> permissions = new HashMap<String, PermissionDefinition>();
    public static final String JSON_PROPERTY_ATTRIBUTES = "attributes";
    private Map<String, AttributeDefinition> attributes = new HashMap<String, AttributeDefinition>();
    public static final String JSON_PROPERTY_REFERENCES = "references";
    private Map<String, EntityDefinitionReference> references = new HashMap<String, EntityDefinitionReference>();

    public EntityDefinition name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public EntityDefinition relations(Map<String, RelationDefinition> relations) {
        this.relations = relations;
        return this;
    }

    public EntityDefinition putRelationsItem(String key, RelationDefinition relationsItem) {
        if (this.relations == null) {
            this.relations = new HashMap<String, RelationDefinition>();
        }
        this.relations.put(key, relationsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="relations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, RelationDefinition> getRelations() {
        return this.relations;
    }

    @JsonProperty(value="relations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRelations(Map<String, RelationDefinition> relations) {
        this.relations = relations;
    }

    public EntityDefinition permissions(Map<String, PermissionDefinition> permissions) {
        this.permissions = permissions;
        return this;
    }

    public EntityDefinition putPermissionsItem(String key, PermissionDefinition permissionsItem) {
        if (this.permissions == null) {
            this.permissions = new HashMap<String, PermissionDefinition>();
        }
        this.permissions.put(key, permissionsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="permissions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, PermissionDefinition> getPermissions() {
        return this.permissions;
    }

    @JsonProperty(value="permissions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPermissions(Map<String, PermissionDefinition> permissions) {
        this.permissions = permissions;
    }

    public EntityDefinition attributes(Map<String, AttributeDefinition> attributes) {
        this.attributes = attributes;
        return this;
    }

    public EntityDefinition putAttributesItem(String key, AttributeDefinition attributesItem) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, AttributeDefinition>();
        }
        this.attributes.put(key, attributesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="attributes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, AttributeDefinition> getAttributes() {
        return this.attributes;
    }

    @JsonProperty(value="attributes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAttributes(Map<String, AttributeDefinition> attributes) {
        this.attributes = attributes;
    }

    public EntityDefinition references(Map<String, EntityDefinitionReference> references) {
        this.references = references;
        return this;
    }

    public EntityDefinition putReferencesItem(String key, EntityDefinitionReference referencesItem) {
        if (this.references == null) {
            this.references = new HashMap<String, EntityDefinitionReference>();
        }
        this.references.put(key, referencesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="references")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, EntityDefinitionReference> getReferences() {
        return this.references;
    }

    @JsonProperty(value="references")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReferences(Map<String, EntityDefinitionReference> references) {
        this.references = references;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityDefinition entityDefinition = (EntityDefinition)o;
        return Objects.equals(this.name, entityDefinition.name) && Objects.equals(this.relations, entityDefinition.relations) && Objects.equals(this.permissions, entityDefinition.permissions) && Objects.equals(this.attributes, entityDefinition.attributes) && Objects.equals(this.references, entityDefinition.references);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.relations, this.permissions, this.attributes, this.references);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EntityDefinition {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    relations: ").append(this.toIndentedString(this.relations)).append("\n");
        sb.append("    permissions: ").append(this.toIndentedString(this.permissions)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    references: ").append(this.toIndentedString(this.references)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getName() != null) {
            joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getRelations() != null) {
            for (String _key : this.getRelations().keySet()) {
                if (this.getRelations().get(_key) == null) continue;
                joiner.add(this.getRelations().get(_key).toUrlQueryString(String.format("%srelations%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix))));
            }
        }
        if (this.getPermissions() != null) {
            for (String _key : this.getPermissions().keySet()) {
                if (this.getPermissions().get(_key) == null) continue;
                joiner.add(this.getPermissions().get(_key).toUrlQueryString(String.format("%spermissions%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix))));
            }
        }
        if (this.getAttributes() != null) {
            for (String _key : this.getAttributes().keySet()) {
                if (this.getAttributes().get(_key) == null) continue;
                joiner.add(this.getAttributes().get(_key).toUrlQueryString(String.format("%sattributes%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix))));
            }
        }
        if (this.getReferences() != null) {
            for (String _key : this.getReferences().keySet()) {
                joiner.add(String.format("%sreferences%s%s=%s", new Object[]{prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix), this.getReferences().get(_key), URLEncoder.encode(String.valueOf((Object)this.getReferences().get(_key)), StandardCharsets.UTF_8).replaceAll("\\+", "%20")}));
            }
        }
        return joiner.toString();
    }
}

