/*
 * Decompiled with CFR 0.152.
 */
package co.permify.sdk.model;

import co.permify.sdk.model.EntityDefinition;
import co.permify.sdk.model.RuleDefinition;
import co.permify.sdk.model.SchemaDefinitionReference;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"entityDefinitions", "ruleDefinitions", "references"})
public class SchemaDefinition {
    public static final String JSON_PROPERTY_ENTITY_DEFINITIONS = "entityDefinitions";
    private Map<String, EntityDefinition> entityDefinitions = new HashMap<String, EntityDefinition>();
    public static final String JSON_PROPERTY_RULE_DEFINITIONS = "ruleDefinitions";
    private Map<String, RuleDefinition> ruleDefinitions = new HashMap<String, RuleDefinition>();
    public static final String JSON_PROPERTY_REFERENCES = "references";
    private Map<String, SchemaDefinitionReference> references = new HashMap<String, SchemaDefinitionReference>();

    public SchemaDefinition entityDefinitions(Map<String, EntityDefinition> entityDefinitions) {
        this.entityDefinitions = entityDefinitions;
        return this;
    }

    public SchemaDefinition putEntityDefinitionsItem(String key, EntityDefinition entityDefinitionsItem) {
        if (this.entityDefinitions == null) {
            this.entityDefinitions = new HashMap<String, EntityDefinition>();
        }
        this.entityDefinitions.put(key, entityDefinitionsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="entityDefinitions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, EntityDefinition> getEntityDefinitions() {
        return this.entityDefinitions;
    }

    @JsonProperty(value="entityDefinitions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEntityDefinitions(Map<String, EntityDefinition> entityDefinitions) {
        this.entityDefinitions = entityDefinitions;
    }

    public SchemaDefinition ruleDefinitions(Map<String, RuleDefinition> ruleDefinitions) {
        this.ruleDefinitions = ruleDefinitions;
        return this;
    }

    public SchemaDefinition putRuleDefinitionsItem(String key, RuleDefinition ruleDefinitionsItem) {
        if (this.ruleDefinitions == null) {
            this.ruleDefinitions = new HashMap<String, RuleDefinition>();
        }
        this.ruleDefinitions.put(key, ruleDefinitionsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="ruleDefinitions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, RuleDefinition> getRuleDefinitions() {
        return this.ruleDefinitions;
    }

    @JsonProperty(value="ruleDefinitions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRuleDefinitions(Map<String, RuleDefinition> ruleDefinitions) {
        this.ruleDefinitions = ruleDefinitions;
    }

    public SchemaDefinition references(Map<String, SchemaDefinitionReference> references) {
        this.references = references;
        return this;
    }

    public SchemaDefinition putReferencesItem(String key, SchemaDefinitionReference referencesItem) {
        if (this.references == null) {
            this.references = new HashMap<String, SchemaDefinitionReference>();
        }
        this.references.put(key, referencesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="references")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, SchemaDefinitionReference> getReferences() {
        return this.references;
    }

    @JsonProperty(value="references")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReferences(Map<String, SchemaDefinitionReference> references) {
        this.references = references;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchemaDefinition schemaDefinition = (SchemaDefinition)o;
        return Objects.equals(this.entityDefinitions, schemaDefinition.entityDefinitions) && Objects.equals(this.ruleDefinitions, schemaDefinition.ruleDefinitions) && Objects.equals(this.references, schemaDefinition.references);
    }

    public int hashCode() {
        return Objects.hash(this.entityDefinitions, this.ruleDefinitions, this.references);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SchemaDefinition {\n");
        sb.append("    entityDefinitions: ").append(this.toIndentedString(this.entityDefinitions)).append("\n");
        sb.append("    ruleDefinitions: ").append(this.toIndentedString(this.ruleDefinitions)).append("\n");
        sb.append("    references: ").append(this.toIndentedString(this.references)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getEntityDefinitions() != null) {
            for (String _key : this.getEntityDefinitions().keySet()) {
                if (this.getEntityDefinitions().get(_key) == null) continue;
                joiner.add(this.getEntityDefinitions().get(_key).toUrlQueryString(String.format("%sentityDefinitions%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix))));
            }
        }
        if (this.getRuleDefinitions() != null) {
            for (String _key : this.getRuleDefinitions().keySet()) {
                if (this.getRuleDefinitions().get(_key) == null) continue;
                joiner.add(this.getRuleDefinitions().get(_key).toUrlQueryString(String.format("%sruleDefinitions%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix))));
            }
        }
        if (this.getReferences() != null) {
            for (String _key : this.getReferences().keySet()) {
                joiner.add(String.format("%sreferences%s%s=%s", new Object[]{prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix), this.getReferences().get(_key), URLEncoder.encode(String.valueOf((Object)this.getReferences().get(_key)), StandardCharsets.UTF_8).replaceAll("\\+", "%20")}));
            }
        }
        return joiner.toString();
    }
}

