/*
 * Decompiled with CFR 0.152.
 */
package unit.java.sdk.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import unit.java.sdk.model.ApplicationFormPrefill;
import unit.java.sdk.model.ApplicationFormSettingsOverride;

@JsonPropertyOrder(value={"email", "url", "stage", "applicantDetails", "settingsOverride", "tags", "allowedApplicationTypes"})
public class ApplicationFormAttributes {
    public static final String JSON_PROPERTY_EMAIL = "email";
    private String email;
    public static final String JSON_PROPERTY_URL = "url";
    private String url;
    public static final String JSON_PROPERTY_STAGE = "stage";
    private StageEnum stage;
    public static final String JSON_PROPERTY_APPLICANT_DETAILS = "applicantDetails";
    private ApplicationFormPrefill applicantDetails;
    public static final String JSON_PROPERTY_SETTINGS_OVERRIDE = "settingsOverride";
    private ApplicationFormSettingsOverride settingsOverride;
    public static final String JSON_PROPERTY_TAGS = "tags";
    private Object tags;
    public static final String JSON_PROPERTY_ALLOWED_APPLICATION_TYPES = "allowedApplicationTypes";
    private List<AllowedApplicationTypesEnum> allowedApplicationTypes;

    public ApplicationFormAttributes email(String email) {
        this.email = email;
        return this;
    }

    @Nullable
    @JsonProperty(value="email")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEmail() {
        return this.email;
    }

    @JsonProperty(value="email")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEmail(String email) {
        this.email = email;
    }

    public ApplicationFormAttributes url(String url) {
        this.url = url;
        return this;
    }

    @Nonnull
    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getUrl() {
        return this.url;
    }

    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUrl(String url) {
        this.url = url;
    }

    public ApplicationFormAttributes stage(StageEnum stage) {
        this.stage = stage;
        return this;
    }

    @Nullable
    @JsonProperty(value="stage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StageEnum getStage() {
        return this.stage;
    }

    @JsonProperty(value="stage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStage(StageEnum stage) {
        this.stage = stage;
    }

    public ApplicationFormAttributes applicantDetails(ApplicationFormPrefill applicantDetails) {
        this.applicantDetails = applicantDetails;
        return this;
    }

    @Nullable
    @JsonProperty(value="applicantDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ApplicationFormPrefill getApplicantDetails() {
        return this.applicantDetails;
    }

    @JsonProperty(value="applicantDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setApplicantDetails(ApplicationFormPrefill applicantDetails) {
        this.applicantDetails = applicantDetails;
    }

    public ApplicationFormAttributes settingsOverride(ApplicationFormSettingsOverride settingsOverride) {
        this.settingsOverride = settingsOverride;
        return this;
    }

    @Nullable
    @JsonProperty(value="settingsOverride")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ApplicationFormSettingsOverride getSettingsOverride() {
        return this.settingsOverride;
    }

    @JsonProperty(value="settingsOverride")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSettingsOverride(ApplicationFormSettingsOverride settingsOverride) {
        this.settingsOverride = settingsOverride;
    }

    public ApplicationFormAttributes tags(Object tags) {
        this.tags = tags;
        return this;
    }

    @Nullable
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getTags() {
        return this.tags;
    }

    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTags(Object tags) {
        this.tags = tags;
    }

    public ApplicationFormAttributes allowedApplicationTypes(List<AllowedApplicationTypesEnum> allowedApplicationTypes) {
        this.allowedApplicationTypes = allowedApplicationTypes;
        return this;
    }

    public ApplicationFormAttributes addAllowedApplicationTypesItem(AllowedApplicationTypesEnum allowedApplicationTypesItem) {
        if (this.allowedApplicationTypes == null) {
            this.allowedApplicationTypes = new ArrayList<AllowedApplicationTypesEnum>();
        }
        this.allowedApplicationTypes.add(allowedApplicationTypesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="allowedApplicationTypes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<AllowedApplicationTypesEnum> getAllowedApplicationTypes() {
        return this.allowedApplicationTypes;
    }

    @JsonProperty(value="allowedApplicationTypes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAllowedApplicationTypes(List<AllowedApplicationTypesEnum> allowedApplicationTypes) {
        this.allowedApplicationTypes = allowedApplicationTypes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationFormAttributes applicationFormAttributes = (ApplicationFormAttributes)o;
        return Objects.equals(this.email, applicationFormAttributes.email) && Objects.equals(this.url, applicationFormAttributes.url) && Objects.equals((Object)this.stage, (Object)applicationFormAttributes.stage) && Objects.equals(this.applicantDetails, applicationFormAttributes.applicantDetails) && Objects.equals(this.settingsOverride, applicationFormAttributes.settingsOverride) && Objects.equals(this.tags, applicationFormAttributes.tags) && Objects.equals(this.allowedApplicationTypes, applicationFormAttributes.allowedApplicationTypes);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.email, this.url, this.stage, this.applicantDetails, this.settingsOverride, this.tags, this.allowedApplicationTypes});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApplicationFormAttributes {\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    stage: ").append(this.toIndentedString((Object)this.stage)).append("\n");
        sb.append("    applicantDetails: ").append(this.toIndentedString(this.applicantDetails)).append("\n");
        sb.append("    settingsOverride: ").append(this.toIndentedString(this.settingsOverride)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    allowedApplicationTypes: ").append(this.toIndentedString(this.allowedApplicationTypes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getEmail() != null) {
            joiner.add(String.format("%semail%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getEmail()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getUrl() != null) {
            joiner.add(String.format("%surl%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getUrl()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getStage() != null) {
            joiner.add(String.format("%sstage%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getStage()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getApplicantDetails() != null) {
            joiner.add(this.getApplicantDetails().toUrlQueryString((String)prefix + JSON_PROPERTY_APPLICANT_DETAILS + suffix));
        }
        if (this.getSettingsOverride() != null) {
            joiner.add(this.getSettingsOverride().toUrlQueryString((String)prefix + JSON_PROPERTY_SETTINGS_OVERRIDE + suffix));
        }
        if (this.getTags() != null) {
            joiner.add(String.format("%stags%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getTags()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getAllowedApplicationTypes() != null) {
            for (int i = 0; i < this.getAllowedApplicationTypes().size(); ++i) {
                joiner.add(String.format("%sallowedApplicationTypes%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf((Object)this.getAllowedApplicationTypes().get(i)), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
            }
        }
        return joiner.toString();
    }

    public static enum AllowedApplicationTypesEnum {
        INDIVIDUAL("Individual"),
        BUSINESS("Business"),
        SOLEPROPRIETORSHIP("SoleProprietorship");

        private String value;

        private AllowedApplicationTypesEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AllowedApplicationTypesEnum fromValue(String value) {
            for (AllowedApplicationTypesEnum b : AllowedApplicationTypesEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum StageEnum {
        CHOOSEBUSINESSORINDIVIDUAL("ChooseBusinessOrIndividual"),
        ENTERINDIVIDUALINFORMATION("EnterIndividualInformation"),
        INDIVIDUALPHONEVERIFICATION("IndividualPhoneVerification"),
        INDIVIDUALAPPLICATIONCREATED("IndividualApplicationCreated"),
        ENTERBUSINESSINFORMATION("EnterBusinessInformation"),
        ENTERBUSINESSADDITIONALINFORMATION("EnterBusinessAdditionalInformation"),
        ENTEROFFICERINFORMATION("EnterOfficerInformation"),
        BUSINESSPHONEVERIFICATION("BusinessPhoneVerification"),
        ENTERBENEFICIALOWNERSINFORMATION("EnterBeneficialOwnersInformation"),
        BUSINESSAPPLICATIONCREATED("BusinessApplicationCreated"),
        ENTERSOLEPROPRIETORSHIPINFORMATION("EnterSoleProprietorshipInformation"),
        ENTERSOLEPROPRIETORSHIPBUSINESSINFORMATION("EnterSoleProprietorshipBusinessInformation"),
        SOLEPROPRIETORSHIPPHONEVERIFICATION("SoleProprietorshipPhoneVerification"),
        SOLEPROPRIETORSHIPAPPLICATIONCREATED("SoleProprietorshipApplicationCreated");

        private String value;

        private StageEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StageEnum fromValue(String value) {
            for (StageEnum b : StageEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

