/*
 * Decompiled with CFR 0.152.
 */
package unit.java.sdk.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.openapitools.jackson.nullable.JsonNullable;
import unit.java.sdk.model.Address;
import unit.java.sdk.model.ApplicationStatus;
import unit.java.sdk.model.BeneficialOwner;
import unit.java.sdk.model.BusinessAnnualRevenue;
import unit.java.sdk.model.BusinessNumberOfEmployees;
import unit.java.sdk.model.BusinessVertical;
import unit.java.sdk.model.CashFlow;
import unit.java.sdk.model.Contact;
import unit.java.sdk.model.EntityType;
import unit.java.sdk.model.Industry;
import unit.java.sdk.model.Officer;
import unit.java.sdk.model.Phone;

@JsonPropertyOrder(value={"createdAt", "updatedAt", "status", "message", "evaluationOutcome", "evaluationId", "evaluationEntityId", "name", "dba", "ein", "entityType", "dateOfIncorporation", "stateOfIncorporation", "purpose", "phone", "address", "contact", "officer", "ip", "website", "beneficialOwners", "decisionMethod", "decisionUserId", "decisionReason", "decisionDateTime", "tags", "riskRate", "evaluationFlags", "ipLocationDetails", "phoneLocationDetails", "archived", "industry", "annualRevenue", "numberOfEmployees", "cashFlow", "yearOfIncorporation", "countriesOfOperation", "stockSymbol", "businessVertical"})
public class BusinessApplicationAllOfAttributes {
    public static final String JSON_PROPERTY_CREATED_AT = "createdAt";
    private OffsetDateTime createdAt;
    public static final String JSON_PROPERTY_UPDATED_AT = "updatedAt";
    private OffsetDateTime updatedAt;
    public static final String JSON_PROPERTY_STATUS = "status";
    private ApplicationStatus status;
    public static final String JSON_PROPERTY_MESSAGE = "message";
    private String message;
    public static final String JSON_PROPERTY_EVALUATION_OUTCOME = "evaluationOutcome";
    private String evaluationOutcome;
    public static final String JSON_PROPERTY_EVALUATION_ID = "evaluationId";
    private String evaluationId;
    public static final String JSON_PROPERTY_EVALUATION_ENTITY_ID = "evaluationEntityId";
    private String evaluationEntityId;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_DBA = "dba";
    private JsonNullable<String> dba = JsonNullable.undefined();
    public static final String JSON_PROPERTY_EIN = "ein";
    private String ein;
    public static final String JSON_PROPERTY_ENTITY_TYPE = "entityType";
    private EntityType entityType;
    public static final String JSON_PROPERTY_DATE_OF_INCORPORATION = "dateOfIncorporation";
    private LocalDate dateOfIncorporation;
    public static final String JSON_PROPERTY_STATE_OF_INCORPORATION = "stateOfIncorporation";
    private String stateOfIncorporation;
    public static final String JSON_PROPERTY_PURPOSE = "purpose";
    private String purpose;
    public static final String JSON_PROPERTY_PHONE = "phone";
    private Phone phone;
    public static final String JSON_PROPERTY_ADDRESS = "address";
    private Address address;
    public static final String JSON_PROPERTY_CONTACT = "contact";
    private Contact contact;
    public static final String JSON_PROPERTY_OFFICER = "officer";
    private Officer officer;
    public static final String JSON_PROPERTY_IP = "ip";
    private String ip;
    public static final String JSON_PROPERTY_WEBSITE = "website";
    private String website;
    public static final String JSON_PROPERTY_BENEFICIAL_OWNERS = "beneficialOwners";
    private List<BeneficialOwner> beneficialOwners = new ArrayList<BeneficialOwner>();
    public static final String JSON_PROPERTY_DECISION_METHOD = "decisionMethod";
    private DecisionMethodEnum decisionMethod;
    public static final String JSON_PROPERTY_DECISION_USER_ID = "decisionUserId";
    private String decisionUserId;
    public static final String JSON_PROPERTY_DECISION_REASON = "decisionReason";
    private String decisionReason;
    public static final String JSON_PROPERTY_DECISION_DATE_TIME = "decisionDateTime";
    private OffsetDateTime decisionDateTime;
    public static final String JSON_PROPERTY_TAGS = "tags";
    private Object tags;
    public static final String JSON_PROPERTY_RISK_RATE = "riskRate";
    private RiskRateEnum riskRate;
    public static final String JSON_PROPERTY_EVALUATION_FLAGS = "evaluationFlags";
    private List<String> evaluationFlags;
    public static final String JSON_PROPERTY_IP_LOCATION_DETAILS = "ipLocationDetails";
    private Object ipLocationDetails;
    public static final String JSON_PROPERTY_PHONE_LOCATION_DETAILS = "phoneLocationDetails";
    private Object phoneLocationDetails;
    public static final String JSON_PROPERTY_ARCHIVED = "archived";
    private Boolean archived;
    public static final String JSON_PROPERTY_INDUSTRY = "industry";
    private Industry industry;
    public static final String JSON_PROPERTY_ANNUAL_REVENUE = "annualRevenue";
    private BusinessAnnualRevenue annualRevenue;
    public static final String JSON_PROPERTY_NUMBER_OF_EMPLOYEES = "numberOfEmployees";
    private BusinessNumberOfEmployees numberOfEmployees;
    public static final String JSON_PROPERTY_CASH_FLOW = "cashFlow";
    private CashFlow cashFlow;
    public static final String JSON_PROPERTY_YEAR_OF_INCORPORATION = "yearOfIncorporation";
    private String yearOfIncorporation;
    public static final String JSON_PROPERTY_COUNTRIES_OF_OPERATION = "countriesOfOperation";
    private List<String> countriesOfOperation;
    public static final String JSON_PROPERTY_STOCK_SYMBOL = "stockSymbol";
    private String stockSymbol;
    public static final String JSON_PROPERTY_BUSINESS_VERTICAL = "businessVertical";
    private BusinessVertical businessVertical;

    public BusinessApplicationAllOfAttributes createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nonnull
    @JsonProperty(value="createdAt")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="createdAt")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public BusinessApplicationAllOfAttributes updatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Nullable
    @JsonProperty(value="updatedAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="updatedAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUpdatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public BusinessApplicationAllOfAttributes status(ApplicationStatus status) {
        this.status = status;
        return this;
    }

    @Nonnull
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ApplicationStatus getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStatus(ApplicationStatus status) {
        this.status = status;
    }

    public BusinessApplicationAllOfAttributes message(String message) {
        this.message = message;
        return this;
    }

    @Nullable
    @JsonProperty(value="message")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMessage() {
        return this.message;
    }

    @JsonProperty(value="message")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMessage(String message) {
        this.message = message;
    }

    public BusinessApplicationAllOfAttributes evaluationOutcome(String evaluationOutcome) {
        this.evaluationOutcome = evaluationOutcome;
        return this;
    }

    @Nullable
    @JsonProperty(value="evaluationOutcome")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEvaluationOutcome() {
        return this.evaluationOutcome;
    }

    @JsonProperty(value="evaluationOutcome")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEvaluationOutcome(String evaluationOutcome) {
        this.evaluationOutcome = evaluationOutcome;
    }

    public BusinessApplicationAllOfAttributes evaluationId(String evaluationId) {
        this.evaluationId = evaluationId;
        return this;
    }

    @Nullable
    @JsonProperty(value="evaluationId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEvaluationId() {
        return this.evaluationId;
    }

    @JsonProperty(value="evaluationId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEvaluationId(String evaluationId) {
        this.evaluationId = evaluationId;
    }

    public BusinessApplicationAllOfAttributes evaluationEntityId(String evaluationEntityId) {
        this.evaluationEntityId = evaluationEntityId;
        return this;
    }

    @Nullable
    @JsonProperty(value="evaluationEntityId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEvaluationEntityId() {
        return this.evaluationEntityId;
    }

    @JsonProperty(value="evaluationEntityId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEvaluationEntityId(String evaluationEntityId) {
        this.evaluationEntityId = evaluationEntityId;
    }

    public BusinessApplicationAllOfAttributes name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public BusinessApplicationAllOfAttributes dba(String dba) {
        this.dba = JsonNullable.of((Object)dba);
        return this;
    }

    @Nullable
    @JsonIgnore
    public String getDba() {
        return (String)this.dba.orElse(null);
    }

    @JsonProperty(value="dba")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getDba_JsonNullable() {
        return this.dba;
    }

    @JsonProperty(value="dba")
    public void setDba_JsonNullable(JsonNullable<String> dba) {
        this.dba = dba;
    }

    public void setDba(String dba) {
        this.dba = JsonNullable.of((Object)dba);
    }

    public BusinessApplicationAllOfAttributes ein(String ein) {
        this.ein = ein;
        return this;
    }

    @Nullable
    @JsonProperty(value="ein")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEin() {
        return this.ein;
    }

    @JsonProperty(value="ein")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEin(String ein) {
        this.ein = ein;
    }

    public BusinessApplicationAllOfAttributes entityType(EntityType entityType) {
        this.entityType = entityType;
        return this;
    }

    @Nonnull
    @JsonProperty(value="entityType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public EntityType getEntityType() {
        return this.entityType;
    }

    @JsonProperty(value="entityType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEntityType(EntityType entityType) {
        this.entityType = entityType;
    }

    public BusinessApplicationAllOfAttributes dateOfIncorporation(LocalDate dateOfIncorporation) {
        this.dateOfIncorporation = dateOfIncorporation;
        return this;
    }

    @Nullable
    @JsonProperty(value="dateOfIncorporation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDate getDateOfIncorporation() {
        return this.dateOfIncorporation;
    }

    @JsonProperty(value="dateOfIncorporation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDateOfIncorporation(LocalDate dateOfIncorporation) {
        this.dateOfIncorporation = dateOfIncorporation;
    }

    public BusinessApplicationAllOfAttributes stateOfIncorporation(String stateOfIncorporation) {
        this.stateOfIncorporation = stateOfIncorporation;
        return this;
    }

    @Nonnull
    @JsonProperty(value="stateOfIncorporation")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getStateOfIncorporation() {
        return this.stateOfIncorporation;
    }

    @JsonProperty(value="stateOfIncorporation")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStateOfIncorporation(String stateOfIncorporation) {
        this.stateOfIncorporation = stateOfIncorporation;
    }

    public BusinessApplicationAllOfAttributes purpose(String purpose) {
        this.purpose = purpose;
        return this;
    }

    @Nullable
    @JsonProperty(value="purpose")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPurpose() {
        return this.purpose;
    }

    @JsonProperty(value="purpose")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPurpose(String purpose) {
        this.purpose = purpose;
    }

    public BusinessApplicationAllOfAttributes phone(Phone phone) {
        this.phone = phone;
        return this;
    }

    @Nullable
    @JsonProperty(value="phone")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Phone getPhone() {
        return this.phone;
    }

    @JsonProperty(value="phone")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPhone(Phone phone) {
        this.phone = phone;
    }

    public BusinessApplicationAllOfAttributes address(Address address) {
        this.address = address;
        return this;
    }

    @Nullable
    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Address getAddress() {
        return this.address;
    }

    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAddress(Address address) {
        this.address = address;
    }

    public BusinessApplicationAllOfAttributes contact(Contact contact) {
        this.contact = contact;
        return this;
    }

    @Nonnull
    @JsonProperty(value="contact")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Contact getContact() {
        return this.contact;
    }

    @JsonProperty(value="contact")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setContact(Contact contact) {
        this.contact = contact;
    }

    public BusinessApplicationAllOfAttributes officer(Officer officer) {
        this.officer = officer;
        return this;
    }

    @Nonnull
    @JsonProperty(value="officer")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Officer getOfficer() {
        return this.officer;
    }

    @JsonProperty(value="officer")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setOfficer(Officer officer) {
        this.officer = officer;
    }

    public BusinessApplicationAllOfAttributes ip(String ip) {
        this.ip = ip;
        return this;
    }

    @Nullable
    @JsonProperty(value="ip")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIp() {
        return this.ip;
    }

    @JsonProperty(value="ip")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIp(String ip) {
        this.ip = ip;
    }

    public BusinessApplicationAllOfAttributes website(String website) {
        this.website = website;
        return this;
    }

    @Nullable
    @JsonProperty(value="website")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getWebsite() {
        return this.website;
    }

    @JsonProperty(value="website")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWebsite(String website) {
        this.website = website;
    }

    public BusinessApplicationAllOfAttributes beneficialOwners(List<BeneficialOwner> beneficialOwners) {
        this.beneficialOwners = beneficialOwners;
        return this;
    }

    public BusinessApplicationAllOfAttributes addBeneficialOwnersItem(BeneficialOwner beneficialOwnersItem) {
        if (this.beneficialOwners == null) {
            this.beneficialOwners = new ArrayList<BeneficialOwner>();
        }
        this.beneficialOwners.add(beneficialOwnersItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="beneficialOwners")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<BeneficialOwner> getBeneficialOwners() {
        return this.beneficialOwners;
    }

    @JsonProperty(value="beneficialOwners")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setBeneficialOwners(List<BeneficialOwner> beneficialOwners) {
        this.beneficialOwners = beneficialOwners;
    }

    public BusinessApplicationAllOfAttributes decisionMethod(DecisionMethodEnum decisionMethod) {
        this.decisionMethod = decisionMethod;
        return this;
    }

    @Nullable
    @JsonProperty(value="decisionMethod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DecisionMethodEnum getDecisionMethod() {
        return this.decisionMethod;
    }

    @JsonProperty(value="decisionMethod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDecisionMethod(DecisionMethodEnum decisionMethod) {
        this.decisionMethod = decisionMethod;
    }

    public BusinessApplicationAllOfAttributes decisionUserId(String decisionUserId) {
        this.decisionUserId = decisionUserId;
        return this;
    }

    @Nullable
    @JsonProperty(value="decisionUserId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDecisionUserId() {
        return this.decisionUserId;
    }

    @JsonProperty(value="decisionUserId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDecisionUserId(String decisionUserId) {
        this.decisionUserId = decisionUserId;
    }

    public BusinessApplicationAllOfAttributes decisionReason(String decisionReason) {
        this.decisionReason = decisionReason;
        return this;
    }

    @Nullable
    @JsonProperty(value="decisionReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDecisionReason() {
        return this.decisionReason;
    }

    @JsonProperty(value="decisionReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDecisionReason(String decisionReason) {
        this.decisionReason = decisionReason;
    }

    public BusinessApplicationAllOfAttributes decisionDateTime(OffsetDateTime decisionDateTime) {
        this.decisionDateTime = decisionDateTime;
        return this;
    }

    @Nullable
    @JsonProperty(value="decisionDateTime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getDecisionDateTime() {
        return this.decisionDateTime;
    }

    @JsonProperty(value="decisionDateTime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDecisionDateTime(OffsetDateTime decisionDateTime) {
        this.decisionDateTime = decisionDateTime;
    }

    public BusinessApplicationAllOfAttributes tags(Object tags) {
        this.tags = tags;
        return this;
    }

    @Nullable
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getTags() {
        return this.tags;
    }

    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTags(Object tags) {
        this.tags = tags;
    }

    public BusinessApplicationAllOfAttributes riskRate(RiskRateEnum riskRate) {
        this.riskRate = riskRate;
        return this;
    }

    @Nullable
    @JsonProperty(value="riskRate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RiskRateEnum getRiskRate() {
        return this.riskRate;
    }

    @JsonProperty(value="riskRate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRiskRate(RiskRateEnum riskRate) {
        this.riskRate = riskRate;
    }

    public BusinessApplicationAllOfAttributes evaluationFlags(List<String> evaluationFlags) {
        this.evaluationFlags = evaluationFlags;
        return this;
    }

    public BusinessApplicationAllOfAttributes addEvaluationFlagsItem(String evaluationFlagsItem) {
        if (this.evaluationFlags == null) {
            this.evaluationFlags = new ArrayList<String>();
        }
        this.evaluationFlags.add(evaluationFlagsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="evaluationFlags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getEvaluationFlags() {
        return this.evaluationFlags;
    }

    @JsonProperty(value="evaluationFlags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEvaluationFlags(List<String> evaluationFlags) {
        this.evaluationFlags = evaluationFlags;
    }

    public BusinessApplicationAllOfAttributes ipLocationDetails(Object ipLocationDetails) {
        this.ipLocationDetails = ipLocationDetails;
        return this;
    }

    @Nullable
    @JsonProperty(value="ipLocationDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getIpLocationDetails() {
        return this.ipLocationDetails;
    }

    @JsonProperty(value="ipLocationDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIpLocationDetails(Object ipLocationDetails) {
        this.ipLocationDetails = ipLocationDetails;
    }

    public BusinessApplicationAllOfAttributes phoneLocationDetails(Object phoneLocationDetails) {
        this.phoneLocationDetails = phoneLocationDetails;
        return this;
    }

    @Nullable
    @JsonProperty(value="phoneLocationDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getPhoneLocationDetails() {
        return this.phoneLocationDetails;
    }

    @JsonProperty(value="phoneLocationDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPhoneLocationDetails(Object phoneLocationDetails) {
        this.phoneLocationDetails = phoneLocationDetails;
    }

    public BusinessApplicationAllOfAttributes archived(Boolean archived) {
        this.archived = archived;
        return this;
    }

    @Nullable
    @JsonProperty(value="archived")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getArchived() {
        return this.archived;
    }

    @JsonProperty(value="archived")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setArchived(Boolean archived) {
        this.archived = archived;
    }

    public BusinessApplicationAllOfAttributes industry(Industry industry) {
        this.industry = industry;
        return this;
    }

    @Nullable
    @JsonProperty(value="industry")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Industry getIndustry() {
        return this.industry;
    }

    @JsonProperty(value="industry")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIndustry(Industry industry) {
        this.industry = industry;
    }

    public BusinessApplicationAllOfAttributes annualRevenue(BusinessAnnualRevenue annualRevenue) {
        this.annualRevenue = annualRevenue;
        return this;
    }

    @Nullable
    @JsonProperty(value="annualRevenue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BusinessAnnualRevenue getAnnualRevenue() {
        return this.annualRevenue;
    }

    @JsonProperty(value="annualRevenue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAnnualRevenue(BusinessAnnualRevenue annualRevenue) {
        this.annualRevenue = annualRevenue;
    }

    public BusinessApplicationAllOfAttributes numberOfEmployees(BusinessNumberOfEmployees numberOfEmployees) {
        this.numberOfEmployees = numberOfEmployees;
        return this;
    }

    @Nullable
    @JsonProperty(value="numberOfEmployees")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BusinessNumberOfEmployees getNumberOfEmployees() {
        return this.numberOfEmployees;
    }

    @JsonProperty(value="numberOfEmployees")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNumberOfEmployees(BusinessNumberOfEmployees numberOfEmployees) {
        this.numberOfEmployees = numberOfEmployees;
    }

    public BusinessApplicationAllOfAttributes cashFlow(CashFlow cashFlow) {
        this.cashFlow = cashFlow;
        return this;
    }

    @Nullable
    @JsonProperty(value="cashFlow")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CashFlow getCashFlow() {
        return this.cashFlow;
    }

    @JsonProperty(value="cashFlow")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCashFlow(CashFlow cashFlow) {
        this.cashFlow = cashFlow;
    }

    public BusinessApplicationAllOfAttributes yearOfIncorporation(String yearOfIncorporation) {
        this.yearOfIncorporation = yearOfIncorporation;
        return this;
    }

    @Nullable
    @JsonProperty(value="yearOfIncorporation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getYearOfIncorporation() {
        return this.yearOfIncorporation;
    }

    @JsonProperty(value="yearOfIncorporation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setYearOfIncorporation(String yearOfIncorporation) {
        this.yearOfIncorporation = yearOfIncorporation;
    }

    public BusinessApplicationAllOfAttributes countriesOfOperation(List<String> countriesOfOperation) {
        this.countriesOfOperation = countriesOfOperation;
        return this;
    }

    public BusinessApplicationAllOfAttributes addCountriesOfOperationItem(String countriesOfOperationItem) {
        if (this.countriesOfOperation == null) {
            this.countriesOfOperation = new ArrayList<String>();
        }
        this.countriesOfOperation.add(countriesOfOperationItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="countriesOfOperation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getCountriesOfOperation() {
        return this.countriesOfOperation;
    }

    @JsonProperty(value="countriesOfOperation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCountriesOfOperation(List<String> countriesOfOperation) {
        this.countriesOfOperation = countriesOfOperation;
    }

    public BusinessApplicationAllOfAttributes stockSymbol(String stockSymbol) {
        this.stockSymbol = stockSymbol;
        return this;
    }

    @Nullable
    @JsonProperty(value="stockSymbol")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStockSymbol() {
        return this.stockSymbol;
    }

    @JsonProperty(value="stockSymbol")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStockSymbol(String stockSymbol) {
        this.stockSymbol = stockSymbol;
    }

    public BusinessApplicationAllOfAttributes businessVertical(BusinessVertical businessVertical) {
        this.businessVertical = businessVertical;
        return this;
    }

    @Nullable
    @JsonProperty(value="businessVertical")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BusinessVertical getBusinessVertical() {
        return this.businessVertical;
    }

    @JsonProperty(value="businessVertical")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBusinessVertical(BusinessVertical businessVertical) {
        this.businessVertical = businessVertical;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BusinessApplicationAllOfAttributes businessApplicationAllOfAttributes = (BusinessApplicationAllOfAttributes)o;
        return Objects.equals(this.createdAt, businessApplicationAllOfAttributes.createdAt) && Objects.equals(this.updatedAt, businessApplicationAllOfAttributes.updatedAt) && Objects.equals((Object)this.status, (Object)businessApplicationAllOfAttributes.status) && Objects.equals(this.message, businessApplicationAllOfAttributes.message) && Objects.equals(this.evaluationOutcome, businessApplicationAllOfAttributes.evaluationOutcome) && Objects.equals(this.evaluationId, businessApplicationAllOfAttributes.evaluationId) && Objects.equals(this.evaluationEntityId, businessApplicationAllOfAttributes.evaluationEntityId) && Objects.equals(this.name, businessApplicationAllOfAttributes.name) && BusinessApplicationAllOfAttributes.equalsNullable(this.dba, businessApplicationAllOfAttributes.dba) && Objects.equals(this.ein, businessApplicationAllOfAttributes.ein) && Objects.equals((Object)this.entityType, (Object)businessApplicationAllOfAttributes.entityType) && Objects.equals(this.dateOfIncorporation, businessApplicationAllOfAttributes.dateOfIncorporation) && Objects.equals(this.stateOfIncorporation, businessApplicationAllOfAttributes.stateOfIncorporation) && Objects.equals(this.purpose, businessApplicationAllOfAttributes.purpose) && Objects.equals(this.phone, businessApplicationAllOfAttributes.phone) && Objects.equals(this.address, businessApplicationAllOfAttributes.address) && Objects.equals(this.contact, businessApplicationAllOfAttributes.contact) && Objects.equals(this.officer, businessApplicationAllOfAttributes.officer) && Objects.equals(this.ip, businessApplicationAllOfAttributes.ip) && Objects.equals(this.website, businessApplicationAllOfAttributes.website) && Objects.equals(this.beneficialOwners, businessApplicationAllOfAttributes.beneficialOwners) && Objects.equals((Object)this.decisionMethod, (Object)businessApplicationAllOfAttributes.decisionMethod) && Objects.equals(this.decisionUserId, businessApplicationAllOfAttributes.decisionUserId) && Objects.equals(this.decisionReason, businessApplicationAllOfAttributes.decisionReason) && Objects.equals(this.decisionDateTime, businessApplicationAllOfAttributes.decisionDateTime) && Objects.equals(this.tags, businessApplicationAllOfAttributes.tags) && Objects.equals((Object)this.riskRate, (Object)businessApplicationAllOfAttributes.riskRate) && Objects.equals(this.evaluationFlags, businessApplicationAllOfAttributes.evaluationFlags) && Objects.equals(this.ipLocationDetails, businessApplicationAllOfAttributes.ipLocationDetails) && Objects.equals(this.phoneLocationDetails, businessApplicationAllOfAttributes.phoneLocationDetails) && Objects.equals(this.archived, businessApplicationAllOfAttributes.archived) && Objects.equals((Object)this.industry, (Object)businessApplicationAllOfAttributes.industry) && Objects.equals((Object)this.annualRevenue, (Object)businessApplicationAllOfAttributes.annualRevenue) && Objects.equals((Object)this.numberOfEmployees, (Object)businessApplicationAllOfAttributes.numberOfEmployees) && Objects.equals((Object)this.cashFlow, (Object)businessApplicationAllOfAttributes.cashFlow) && Objects.equals(this.yearOfIncorporation, businessApplicationAllOfAttributes.yearOfIncorporation) && Objects.equals(this.countriesOfOperation, businessApplicationAllOfAttributes.countriesOfOperation) && Objects.equals(this.stockSymbol, businessApplicationAllOfAttributes.stockSymbol) && Objects.equals((Object)this.businessVertical, (Object)businessApplicationAllOfAttributes.businessVertical);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.createdAt, this.updatedAt, this.status, this.message, this.evaluationOutcome, this.evaluationId, this.evaluationEntityId, this.name, BusinessApplicationAllOfAttributes.hashCodeNullable(this.dba), this.ein, this.entityType, this.dateOfIncorporation, this.stateOfIncorporation, this.purpose, this.phone, this.address, this.contact, this.officer, this.ip, this.website, this.beneficialOwners, this.decisionMethod, this.decisionUserId, this.decisionReason, this.decisionDateTime, this.tags, this.riskRate, this.evaluationFlags, this.ipLocationDetails, this.phoneLocationDetails, this.archived, this.industry, this.annualRevenue, this.numberOfEmployees, this.cashFlow, this.yearOfIncorporation, this.countriesOfOperation, this.stockSymbol, this.businessVertical});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BusinessApplicationAllOfAttributes {\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    evaluationOutcome: ").append(this.toIndentedString(this.evaluationOutcome)).append("\n");
        sb.append("    evaluationId: ").append(this.toIndentedString(this.evaluationId)).append("\n");
        sb.append("    evaluationEntityId: ").append(this.toIndentedString(this.evaluationEntityId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    dba: ").append(this.toIndentedString(this.dba)).append("\n");
        sb.append("    ein: ").append(this.toIndentedString(this.ein)).append("\n");
        sb.append("    entityType: ").append(this.toIndentedString((Object)this.entityType)).append("\n");
        sb.append("    dateOfIncorporation: ").append(this.toIndentedString(this.dateOfIncorporation)).append("\n");
        sb.append("    stateOfIncorporation: ").append(this.toIndentedString(this.stateOfIncorporation)).append("\n");
        sb.append("    purpose: ").append(this.toIndentedString(this.purpose)).append("\n");
        sb.append("    phone: ").append(this.toIndentedString(this.phone)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    contact: ").append(this.toIndentedString(this.contact)).append("\n");
        sb.append("    officer: ").append(this.toIndentedString(this.officer)).append("\n");
        sb.append("    ip: ").append(this.toIndentedString(this.ip)).append("\n");
        sb.append("    website: ").append(this.toIndentedString(this.website)).append("\n");
        sb.append("    beneficialOwners: ").append(this.toIndentedString(this.beneficialOwners)).append("\n");
        sb.append("    decisionMethod: ").append(this.toIndentedString((Object)this.decisionMethod)).append("\n");
        sb.append("    decisionUserId: ").append(this.toIndentedString(this.decisionUserId)).append("\n");
        sb.append("    decisionReason: ").append(this.toIndentedString(this.decisionReason)).append("\n");
        sb.append("    decisionDateTime: ").append(this.toIndentedString(this.decisionDateTime)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    riskRate: ").append(this.toIndentedString((Object)this.riskRate)).append("\n");
        sb.append("    evaluationFlags: ").append(this.toIndentedString(this.evaluationFlags)).append("\n");
        sb.append("    ipLocationDetails: ").append(this.toIndentedString(this.ipLocationDetails)).append("\n");
        sb.append("    phoneLocationDetails: ").append(this.toIndentedString(this.phoneLocationDetails)).append("\n");
        sb.append("    archived: ").append(this.toIndentedString(this.archived)).append("\n");
        sb.append("    industry: ").append(this.toIndentedString((Object)this.industry)).append("\n");
        sb.append("    annualRevenue: ").append(this.toIndentedString((Object)this.annualRevenue)).append("\n");
        sb.append("    numberOfEmployees: ").append(this.toIndentedString((Object)this.numberOfEmployees)).append("\n");
        sb.append("    cashFlow: ").append(this.toIndentedString((Object)this.cashFlow)).append("\n");
        sb.append("    yearOfIncorporation: ").append(this.toIndentedString(this.yearOfIncorporation)).append("\n");
        sb.append("    countriesOfOperation: ").append(this.toIndentedString(this.countriesOfOperation)).append("\n");
        sb.append("    stockSymbol: ").append(this.toIndentedString(this.stockSymbol)).append("\n");
        sb.append("    businessVertical: ").append(this.toIndentedString((Object)this.businessVertical)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        int i;
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getCreatedAt() != null) {
            joiner.add(String.format("%screatedAt%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getCreatedAt()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getUpdatedAt() != null) {
            joiner.add(String.format("%supdatedAt%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getUpdatedAt()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getStatus() != null) {
            joiner.add(String.format("%sstatus%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getStatus()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getMessage() != null) {
            joiner.add(String.format("%smessage%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getMessage()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getEvaluationOutcome() != null) {
            joiner.add(String.format("%sevaluationOutcome%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getEvaluationOutcome()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getEvaluationId() != null) {
            joiner.add(String.format("%sevaluationId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getEvaluationId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getEvaluationEntityId() != null) {
            joiner.add(String.format("%sevaluationEntityId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getEvaluationEntityId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getName() != null) {
            joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getDba() != null) {
            joiner.add(String.format("%sdba%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getDba()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getEin() != null) {
            joiner.add(String.format("%sein%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getEin()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getEntityType() != null) {
            joiner.add(String.format("%sentityType%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getEntityType()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getDateOfIncorporation() != null) {
            joiner.add(String.format("%sdateOfIncorporation%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getDateOfIncorporation()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getStateOfIncorporation() != null) {
            joiner.add(String.format("%sstateOfIncorporation%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getStateOfIncorporation()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getPurpose() != null) {
            joiner.add(String.format("%spurpose%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getPurpose()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getPhone() != null) {
            joiner.add(this.getPhone().toUrlQueryString((String)prefix + JSON_PROPERTY_PHONE + suffix));
        }
        if (this.getAddress() != null) {
            joiner.add(this.getAddress().toUrlQueryString((String)prefix + JSON_PROPERTY_ADDRESS + suffix));
        }
        if (this.getContact() != null) {
            joiner.add(this.getContact().toUrlQueryString((String)prefix + JSON_PROPERTY_CONTACT + suffix));
        }
        if (this.getOfficer() != null) {
            joiner.add(this.getOfficer().toUrlQueryString((String)prefix + JSON_PROPERTY_OFFICER + suffix));
        }
        if (this.getIp() != null) {
            joiner.add(String.format("%sip%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getIp()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getWebsite() != null) {
            joiner.add(String.format("%swebsite%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getWebsite()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getBeneficialOwners() != null) {
            for (i = 0; i < this.getBeneficialOwners().size(); ++i) {
                if (this.getBeneficialOwners().get(i) == null) continue;
                joiner.add(this.getBeneficialOwners().get(i).toUrlQueryString(String.format("%sbeneficialOwners%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getDecisionMethod() != null) {
            joiner.add(String.format("%sdecisionMethod%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getDecisionMethod()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getDecisionUserId() != null) {
            joiner.add(String.format("%sdecisionUserId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getDecisionUserId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getDecisionReason() != null) {
            joiner.add(String.format("%sdecisionReason%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getDecisionReason()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getDecisionDateTime() != null) {
            joiner.add(String.format("%sdecisionDateTime%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getDecisionDateTime()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getTags() != null) {
            joiner.add(String.format("%stags%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getTags()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getRiskRate() != null) {
            joiner.add(String.format("%sriskRate%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getRiskRate()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getEvaluationFlags() != null) {
            for (i = 0; i < this.getEvaluationFlags().size(); ++i) {
                joiner.add(String.format("%sevaluationFlags%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(this.getEvaluationFlags().get(i)), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
            }
        }
        if (this.getIpLocationDetails() != null) {
            joiner.add(String.format("%sipLocationDetails%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getIpLocationDetails()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getPhoneLocationDetails() != null) {
            joiner.add(String.format("%sphoneLocationDetails%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getPhoneLocationDetails()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getArchived() != null) {
            joiner.add(String.format("%sarchived%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getArchived()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getIndustry() != null) {
            joiner.add(String.format("%sindustry%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getIndustry()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getAnnualRevenue() != null) {
            joiner.add(String.format("%sannualRevenue%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getAnnualRevenue()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getNumberOfEmployees() != null) {
            joiner.add(String.format("%snumberOfEmployees%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getNumberOfEmployees()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getCashFlow() != null) {
            joiner.add(String.format("%scashFlow%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getCashFlow()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getYearOfIncorporation() != null) {
            joiner.add(String.format("%syearOfIncorporation%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getYearOfIncorporation()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getCountriesOfOperation() != null) {
            for (i = 0; i < this.getCountriesOfOperation().size(); ++i) {
                joiner.add(String.format("%scountriesOfOperation%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(this.getCountriesOfOperation().get(i)), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
            }
        }
        if (this.getStockSymbol() != null) {
            joiner.add(String.format("%sstockSymbol%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getStockSymbol()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getBusinessVertical() != null) {
            joiner.add(String.format("%sbusinessVertical%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getBusinessVertical()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }

    public static enum RiskRateEnum {
        LOW("low"),
        MEDIUM("medium"),
        HIGH("high");

        private String value;

        private RiskRateEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static RiskRateEnum fromValue(String value) {
            for (RiskRateEnum b : RiskRateEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum DecisionMethodEnum {
        MANUALLY("Manually"),
        AUTOMATICALLY("Automatically");

        private String value;

        private DecisionMethodEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static DecisionMethodEnum fromValue(String value) {
            for (DecisionMethodEnum b : DecisionMethodEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

