/*
 * Decompiled with CFR 0.152.
 */
package unit.java.sdk.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nonnull;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"longitude", "latitude"})
public class Coordinates {
    public static final String JSON_PROPERTY_LONGITUDE = "longitude";
    private BigDecimal longitude;
    public static final String JSON_PROPERTY_LATITUDE = "latitude";
    private BigDecimal latitude;

    public Coordinates longitude(BigDecimal longitude) {
        this.longitude = longitude;
        return this;
    }

    @Nonnull
    @JsonProperty(value="longitude")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public BigDecimal getLongitude() {
        return this.longitude;
    }

    @JsonProperty(value="longitude")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLongitude(BigDecimal longitude) {
        this.longitude = longitude;
    }

    public Coordinates latitude(BigDecimal latitude) {
        this.latitude = latitude;
        return this;
    }

    @Nonnull
    @JsonProperty(value="latitude")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public BigDecimal getLatitude() {
        return this.latitude;
    }

    @JsonProperty(value="latitude")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLatitude(BigDecimal latitude) {
        this.latitude = latitude;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Coordinates coordinates = (Coordinates)o;
        return Objects.equals(this.longitude, coordinates.longitude) && Objects.equals(this.latitude, coordinates.latitude);
    }

    public int hashCode() {
        return Objects.hash(this.longitude, this.latitude);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Coordinates {\n");
        sb.append("    longitude: ").append(this.toIndentedString(this.longitude)).append("\n");
        sb.append("    latitude: ").append(this.toIndentedString(this.latitude)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getLongitude() != null) {
            joiner.add(String.format("%slongitude%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getLongitude()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getLatitude() != null) {
            joiner.add(String.format("%slatitude%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getLatitude()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }
}

