/*
 * Decompiled with CFR 0.152.
 */
package unit.java.sdk.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.util.Objects;
import java.util.StringJoiner;
import unit.java.sdk.model.FullName;

@JsonPropertyOrder(value={"billerId", "accountNumber", "amount", "description", "idempotencyKey", "tags", "fullName", "dateOfBirth"})
public class CreateBillPaymentAttributes {
    public static final String JSON_PROPERTY_BILLER_ID = "billerId";
    private String billerId;
    public static final String JSON_PROPERTY_ACCOUNT_NUMBER = "accountNumber";
    private String accountNumber;
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private Integer amount;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_IDEMPOTENCY_KEY = "idempotencyKey";
    private String idempotencyKey;
    public static final String JSON_PROPERTY_TAGS = "tags";
    private Object tags;
    public static final String JSON_PROPERTY_FULL_NAME = "fullName";
    private FullName fullName;
    public static final String JSON_PROPERTY_DATE_OF_BIRTH = "dateOfBirth";
    private LocalDate dateOfBirth;

    public CreateBillPaymentAttributes billerId(String billerId) {
        this.billerId = billerId;
        return this;
    }

    @Nonnull
    @JsonProperty(value="billerId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getBillerId() {
        return this.billerId;
    }

    @JsonProperty(value="billerId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setBillerId(String billerId) {
        this.billerId = billerId;
    }

    public CreateBillPaymentAttributes accountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
        return this;
    }

    @Nonnull
    @JsonProperty(value="accountNumber")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAccountNumber() {
        return this.accountNumber;
    }

    @JsonProperty(value="accountNumber")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public CreateBillPaymentAttributes amount(Integer amount) {
        this.amount = amount;
        return this;
    }

    @Nonnull
    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Integer getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAmount(Integer amount) {
        this.amount = amount;
    }

    public CreateBillPaymentAttributes description(String description) {
        this.description = description;
        return this;
    }

    @Nonnull
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDescription(String description) {
        this.description = description;
    }

    public CreateBillPaymentAttributes idempotencyKey(String idempotencyKey) {
        this.idempotencyKey = idempotencyKey;
        return this;
    }

    @Nullable
    @JsonProperty(value="idempotencyKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    @JsonProperty(value="idempotencyKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIdempotencyKey(String idempotencyKey) {
        this.idempotencyKey = idempotencyKey;
    }

    public CreateBillPaymentAttributes tags(Object tags) {
        this.tags = tags;
        return this;
    }

    @Nullable
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getTags() {
        return this.tags;
    }

    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTags(Object tags) {
        this.tags = tags;
    }

    public CreateBillPaymentAttributes fullName(FullName fullName) {
        this.fullName = fullName;
        return this;
    }

    @Nullable
    @JsonProperty(value="fullName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public FullName getFullName() {
        return this.fullName;
    }

    @JsonProperty(value="fullName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFullName(FullName fullName) {
        this.fullName = fullName;
    }

    public CreateBillPaymentAttributes dateOfBirth(LocalDate dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
        return this;
    }

    @Nullable
    @JsonProperty(value="dateOfBirth")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDate getDateOfBirth() {
        return this.dateOfBirth;
    }

    @JsonProperty(value="dateOfBirth")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDateOfBirth(LocalDate dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateBillPaymentAttributes createBillPaymentAttributes = (CreateBillPaymentAttributes)o;
        return Objects.equals(this.billerId, createBillPaymentAttributes.billerId) && Objects.equals(this.accountNumber, createBillPaymentAttributes.accountNumber) && Objects.equals(this.amount, createBillPaymentAttributes.amount) && Objects.equals(this.description, createBillPaymentAttributes.description) && Objects.equals(this.idempotencyKey, createBillPaymentAttributes.idempotencyKey) && Objects.equals(this.tags, createBillPaymentAttributes.tags) && Objects.equals(this.fullName, createBillPaymentAttributes.fullName) && Objects.equals(this.dateOfBirth, createBillPaymentAttributes.dateOfBirth);
    }

    public int hashCode() {
        return Objects.hash(this.billerId, this.accountNumber, this.amount, this.description, this.idempotencyKey, this.tags, this.fullName, this.dateOfBirth);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateBillPaymentAttributes {\n");
        sb.append("    billerId: ").append(this.toIndentedString(this.billerId)).append("\n");
        sb.append("    accountNumber: ").append(this.toIndentedString(this.accountNumber)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    idempotencyKey: ").append(this.toIndentedString(this.idempotencyKey)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    fullName: ").append(this.toIndentedString(this.fullName)).append("\n");
        sb.append("    dateOfBirth: ").append(this.toIndentedString(this.dateOfBirth)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getBillerId() != null) {
            joiner.add(String.format("%sbillerId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getBillerId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getAccountNumber() != null) {
            joiner.add(String.format("%saccountNumber%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getAccountNumber()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getAmount() != null) {
            joiner.add(String.format("%samount%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getAmount()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getDescription() != null) {
            joiner.add(String.format("%sdescription%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getDescription()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getIdempotencyKey() != null) {
            joiner.add(String.format("%sidempotencyKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getIdempotencyKey()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getTags() != null) {
            joiner.add(String.format("%stags%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getTags()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getFullName() != null) {
            joiner.add(this.getFullName().toUrlQueryString((String)prefix + JSON_PROPERTY_FULL_NAME + suffix));
        }
        if (this.getDateOfBirth() != null) {
            joiner.add(String.format("%sdateOfBirth%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getDateOfBirth()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }
}

