/*
 * Decompiled with CFR 0.152.
 */
package unit.java.sdk.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"customerId", "accountNumber", "routingNumber", "permissions", "tags"})
public class ExecuteFilterParameter5 {
    public static final String JSON_PROPERTY_CUSTOMER_ID = "customerId";
    private String customerId;
    public static final String JSON_PROPERTY_ACCOUNT_NUMBER = "accountNumber";
    private String accountNumber;
    public static final String JSON_PROPERTY_ROUTING_NUMBER = "routingNumber";
    private String routingNumber;
    public static final String JSON_PROPERTY_PERMISSIONS = "permissions";
    private List<PermissionsEnum> permissions;
    public static final String JSON_PROPERTY_TAGS = "tags";
    private Map<String, String> tags = new HashMap<String, String>();

    public ExecuteFilterParameter5 customerId(String customerId) {
        this.customerId = customerId;
        return this;
    }

    @Nullable
    @JsonProperty(value="customerId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCustomerId() {
        return this.customerId;
    }

    @JsonProperty(value="customerId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCustomerId(String customerId) {
        this.customerId = customerId;
    }

    public ExecuteFilterParameter5 accountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
        return this;
    }

    @Nullable
    @JsonProperty(value="accountNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccountNumber() {
        return this.accountNumber;
    }

    @JsonProperty(value="accountNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public ExecuteFilterParameter5 routingNumber(String routingNumber) {
        this.routingNumber = routingNumber;
        return this;
    }

    @Nullable
    @JsonProperty(value="routingNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRoutingNumber() {
        return this.routingNumber;
    }

    @JsonProperty(value="routingNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRoutingNumber(String routingNumber) {
        this.routingNumber = routingNumber;
    }

    public ExecuteFilterParameter5 permissions(List<PermissionsEnum> permissions) {
        this.permissions = permissions;
        return this;
    }

    public ExecuteFilterParameter5 addPermissionsItem(PermissionsEnum permissionsItem) {
        if (this.permissions == null) {
            this.permissions = new ArrayList<PermissionsEnum>();
        }
        this.permissions.add(permissionsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="permissions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<PermissionsEnum> getPermissions() {
        return this.permissions;
    }

    @JsonProperty(value="permissions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPermissions(List<PermissionsEnum> permissions) {
        this.permissions = permissions;
    }

    public ExecuteFilterParameter5 tags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public ExecuteFilterParameter5 putTagsItem(String key, String tagsItem) {
        if (this.tags == null) {
            this.tags = new HashMap<String, String>();
        }
        this.tags.put(key, tagsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getTags() {
        return this.tags;
    }

    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExecuteFilterParameter5 executeFilterParameter5 = (ExecuteFilterParameter5)o;
        return Objects.equals(this.customerId, executeFilterParameter5.customerId) && Objects.equals(this.accountNumber, executeFilterParameter5.accountNumber) && Objects.equals(this.routingNumber, executeFilterParameter5.routingNumber) && Objects.equals(this.permissions, executeFilterParameter5.permissions) && Objects.equals(this.tags, executeFilterParameter5.tags);
    }

    public int hashCode() {
        return Objects.hash(this.customerId, this.accountNumber, this.routingNumber, this.permissions, this.tags);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ExecuteFilterParameter5 {\n");
        sb.append("    customerId: ").append(this.toIndentedString(this.customerId)).append("\n");
        sb.append("    accountNumber: ").append(this.toIndentedString(this.accountNumber)).append("\n");
        sb.append("    routingNumber: ").append(this.toIndentedString(this.routingNumber)).append("\n");
        sb.append("    permissions: ").append(this.toIndentedString(this.permissions)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getCustomerId() != null) {
            joiner.add(String.format("%scustomerId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getCustomerId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getAccountNumber() != null) {
            joiner.add(String.format("%saccountNumber%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getAccountNumber()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getRoutingNumber() != null) {
            joiner.add(String.format("%sroutingNumber%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getRoutingNumber()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getPermissions() != null) {
            for (int i = 0; i < this.getPermissions().size(); ++i) {
                joiner.add(String.format("%spermissions%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf((Object)this.getPermissions().get(i)), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
            }
        }
        if (this.getTags() != null) {
            for (String _key : this.getTags().keySet()) {
                joiner.add(String.format("%stags%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix), this.getTags().get(_key), URLEncoder.encode(String.valueOf(this.getTags().get(_key)), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
            }
        }
        return joiner.toString();
    }

    public static enum PermissionsEnum {
        CREDITONLY("CreditOnly"),
        DEBITONLY("DebitOnly"),
        CREDITANDDEBIT("CreditAndDebit");

        private String value;

        private PermissionsEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PermissionsEnum fromValue(String value) {
            for (PermissionsEnum b : PermissionsEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

