/*
 * Decompiled with CFR 0.152.
 */
package unit.java.sdk.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import unit.java.sdk.model.IncludedResourceInner;
import unit.java.sdk.model.PaginationMeta;
import unit.java.sdk.model.Transaction;

@JsonPropertyOrder(value={"data", "included", "meta"})
public class UnitTransactionsListResponse {
    public static final String JSON_PROPERTY_DATA = "data";
    private List<Transaction> data;
    public static final String JSON_PROPERTY_INCLUDED = "included";
    private List<IncludedResourceInner> included;
    public static final String JSON_PROPERTY_META = "meta";
    private PaginationMeta meta;

    public UnitTransactionsListResponse data(List<Transaction> data) {
        this.data = data;
        return this;
    }

    public UnitTransactionsListResponse addDataItem(Transaction dataItem) {
        if (this.data == null) {
            this.data = new ArrayList<Transaction>();
        }
        this.data.add(dataItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="data")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Transaction> getData() {
        return this.data;
    }

    @JsonProperty(value="data")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setData(List<Transaction> data) {
        this.data = data;
    }

    public UnitTransactionsListResponse included(List<IncludedResourceInner> included) {
        this.included = included;
        return this;
    }

    public UnitTransactionsListResponse addIncludedItem(IncludedResourceInner includedItem) {
        if (this.included == null) {
            this.included = new ArrayList<IncludedResourceInner>();
        }
        this.included.add(includedItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="included")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<IncludedResourceInner> getIncluded() {
        return this.included;
    }

    @JsonProperty(value="included")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIncluded(List<IncludedResourceInner> included) {
        this.included = included;
    }

    public UnitTransactionsListResponse meta(PaginationMeta meta) {
        this.meta = meta;
        return this;
    }

    @Nullable
    @JsonProperty(value="meta")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PaginationMeta getMeta() {
        return this.meta;
    }

    @JsonProperty(value="meta")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMeta(PaginationMeta meta) {
        this.meta = meta;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnitTransactionsListResponse unitTransactionsListResponse = (UnitTransactionsListResponse)o;
        return Objects.equals(this.data, unitTransactionsListResponse.data) && Objects.equals(this.included, unitTransactionsListResponse.included) && Objects.equals(this.meta, unitTransactionsListResponse.meta);
    }

    public int hashCode() {
        return Objects.hash(this.data, this.included, this.meta);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UnitTransactionsListResponse {\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("    included: ").append(this.toIndentedString(this.included)).append("\n");
        sb.append("    meta: ").append(this.toIndentedString(this.meta)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        int i;
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getData() != null) {
            for (i = 0; i < this.getData().size(); ++i) {
                if (this.getData().get(i) == null) continue;
                joiner.add(this.getData().get(i).toUrlQueryString(String.format("%sdata%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getIncluded() != null) {
            for (i = 0; i < this.getIncluded().size(); ++i) {
                if (this.getIncluded().get(i) == null) continue;
                joiner.add(this.getIncluded().get(i).toUrlQueryString(String.format("%sincluded%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getMeta() != null) {
            joiner.add(this.getMeta().toUrlQueryString((String)prefix + JSON_PROPERTY_META + suffix));
        }
        return joiner.toString();
    }
}

