/*
 * Decompiled with CFR 0.152.
 */
package unit.java.sdk.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;
import java.util.StringJoiner;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"street", "street2", "city", "state", "postalCode", "country"})
public class Address {
    public static final String JSON_PROPERTY_STREET = "street";
    private String street;
    public static final String JSON_PROPERTY_STREET2 = "street2";
    private JsonNullable<String> street2 = JsonNullable.undefined();
    public static final String JSON_PROPERTY_CITY = "city";
    private String city;
    public static final String JSON_PROPERTY_STATE = "state";
    private String state;
    public static final String JSON_PROPERTY_POSTAL_CODE = "postalCode";
    private String postalCode;
    public static final String JSON_PROPERTY_COUNTRY = "country";
    private String country = "US";

    public Address street(String street) {
        this.street = street;
        return this;
    }

    @Nonnull
    @JsonProperty(value="street")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getStreet() {
        return this.street;
    }

    @JsonProperty(value="street")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStreet(String street) {
        this.street = street;
    }

    public Address street2(String street2) {
        this.street2 = JsonNullable.of((Object)street2);
        return this;
    }

    @Nullable
    @JsonIgnore
    public String getStreet2() {
        return (String)this.street2.orElse(null);
    }

    @JsonProperty(value="street2")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getStreet2_JsonNullable() {
        return this.street2;
    }

    @JsonProperty(value="street2")
    public void setStreet2_JsonNullable(JsonNullable<String> street2) {
        this.street2 = street2;
    }

    public void setStreet2(String street2) {
        this.street2 = JsonNullable.of((Object)street2);
    }

    public Address city(String city) {
        this.city = city;
        return this;
    }

    @Nonnull
    @JsonProperty(value="city")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getCity() {
        return this.city;
    }

    @JsonProperty(value="city")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCity(String city) {
        this.city = city;
    }

    public Address state(String state) {
        this.state = state;
        return this;
    }

    @Nonnull
    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getState() {
        return this.state;
    }

    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setState(String state) {
        this.state = state;
    }

    public Address postalCode(String postalCode) {
        this.postalCode = postalCode;
        return this;
    }

    @Nonnull
    @JsonProperty(value="postalCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getPostalCode() {
        return this.postalCode;
    }

    @JsonProperty(value="postalCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public Address country(String country) {
        this.country = country;
        return this;
    }

    @Nonnull
    @JsonProperty(value="country")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getCountry() {
        return this.country;
    }

    @JsonProperty(value="country")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCountry(String country) {
        this.country = country;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Address address = (Address)o;
        return Objects.equals(this.street, address.street) && Address.equalsNullable(this.street2, address.street2) && Objects.equals(this.city, address.city) && Objects.equals(this.state, address.state) && Objects.equals(this.postalCode, address.postalCode) && Objects.equals(this.country, address.country);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(this.street, Address.hashCodeNullable(this.street2), this.city, this.state, this.postalCode, this.country);
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Address {\n");
        sb.append("    street: ").append(this.toIndentedString(this.street)).append("\n");
        sb.append("    street2: ").append(this.toIndentedString(this.street2)).append("\n");
        sb.append("    city: ").append(this.toIndentedString(this.city)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    postalCode: ").append(this.toIndentedString(this.postalCode)).append("\n");
        sb.append("    country: ").append(this.toIndentedString(this.country)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getStreet() != null) {
            joiner.add(String.format("%sstreet%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getStreet()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getStreet2() != null) {
            joiner.add(String.format("%sstreet2%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getStreet2()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getCity() != null) {
            joiner.add(String.format("%scity%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getCity()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getState() != null) {
            joiner.add(String.format("%sstate%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getState()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getPostalCode() != null) {
            joiner.add(String.format("%spostalCode%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getPostalCode()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getCountry() != null) {
            joiner.add(String.format("%scountry%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getCountry()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }
}

