/*
 * Decompiled with CFR 0.152.
 */
package unit.java.sdk.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.StringJoiner;
import unit.java.sdk.model.Address;
import unit.java.sdk.model.Coordinates;

@JsonPropertyOrder(value={"network", "locationName", "coordinates", "address", "distance", "surchargeFree", "acceptDeposits"})
public class AtmLocationAttributes {
    public static final String JSON_PROPERTY_NETWORK = "network";
    private String network;
    public static final String JSON_PROPERTY_LOCATION_NAME = "locationName";
    private String locationName;
    public static final String JSON_PROPERTY_COORDINATES = "coordinates";
    private Coordinates coordinates;
    public static final String JSON_PROPERTY_ADDRESS = "address";
    private Address address;
    public static final String JSON_PROPERTY_DISTANCE = "distance";
    private Integer distance;
    public static final String JSON_PROPERTY_SURCHARGE_FREE = "surchargeFree";
    private Boolean surchargeFree;
    public static final String JSON_PROPERTY_ACCEPT_DEPOSITS = "acceptDeposits";
    private Boolean acceptDeposits;

    public AtmLocationAttributes network(String network) {
        this.network = network;
        return this;
    }

    @Nullable
    @JsonProperty(value="network")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getNetwork() {
        return this.network;
    }

    @JsonProperty(value="network")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNetwork(String network) {
        this.network = network;
    }

    public AtmLocationAttributes locationName(String locationName) {
        this.locationName = locationName;
        return this;
    }

    @Nullable
    @JsonProperty(value="locationName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLocationName() {
        return this.locationName;
    }

    @JsonProperty(value="locationName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLocationName(String locationName) {
        this.locationName = locationName;
    }

    public AtmLocationAttributes coordinates(Coordinates coordinates) {
        this.coordinates = coordinates;
        return this;
    }

    @Nullable
    @JsonProperty(value="coordinates")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Coordinates getCoordinates() {
        return this.coordinates;
    }

    @JsonProperty(value="coordinates")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCoordinates(Coordinates coordinates) {
        this.coordinates = coordinates;
    }

    public AtmLocationAttributes address(Address address) {
        this.address = address;
        return this;
    }

    @Nullable
    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Address getAddress() {
        return this.address;
    }

    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAddress(Address address) {
        this.address = address;
    }

    public AtmLocationAttributes distance(Integer distance) {
        this.distance = distance;
        return this;
    }

    @Nullable
    @JsonProperty(value="distance")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getDistance() {
        return this.distance;
    }

    @JsonProperty(value="distance")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDistance(Integer distance) {
        this.distance = distance;
    }

    public AtmLocationAttributes surchargeFree(Boolean surchargeFree) {
        this.surchargeFree = surchargeFree;
        return this;
    }

    @Nullable
    @JsonProperty(value="surchargeFree")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSurchargeFree() {
        return this.surchargeFree;
    }

    @JsonProperty(value="surchargeFree")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSurchargeFree(Boolean surchargeFree) {
        this.surchargeFree = surchargeFree;
    }

    public AtmLocationAttributes acceptDeposits(Boolean acceptDeposits) {
        this.acceptDeposits = acceptDeposits;
        return this;
    }

    @Nullable
    @JsonProperty(value="acceptDeposits")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAcceptDeposits() {
        return this.acceptDeposits;
    }

    @JsonProperty(value="acceptDeposits")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAcceptDeposits(Boolean acceptDeposits) {
        this.acceptDeposits = acceptDeposits;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AtmLocationAttributes atmLocationAttributes = (AtmLocationAttributes)o;
        return Objects.equals(this.network, atmLocationAttributes.network) && Objects.equals(this.locationName, atmLocationAttributes.locationName) && Objects.equals(this.coordinates, atmLocationAttributes.coordinates) && Objects.equals(this.address, atmLocationAttributes.address) && Objects.equals(this.distance, atmLocationAttributes.distance) && Objects.equals(this.surchargeFree, atmLocationAttributes.surchargeFree) && Objects.equals(this.acceptDeposits, atmLocationAttributes.acceptDeposits);
    }

    public int hashCode() {
        return Objects.hash(this.network, this.locationName, this.coordinates, this.address, this.distance, this.surchargeFree, this.acceptDeposits);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AtmLocationAttributes {\n");
        sb.append("    network: ").append(this.toIndentedString(this.network)).append("\n");
        sb.append("    locationName: ").append(this.toIndentedString(this.locationName)).append("\n");
        sb.append("    coordinates: ").append(this.toIndentedString(this.coordinates)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    distance: ").append(this.toIndentedString(this.distance)).append("\n");
        sb.append("    surchargeFree: ").append(this.toIndentedString(this.surchargeFree)).append("\n");
        sb.append("    acceptDeposits: ").append(this.toIndentedString(this.acceptDeposits)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getNetwork() != null) {
            joiner.add(String.format("%snetwork%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getNetwork()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getLocationName() != null) {
            joiner.add(String.format("%slocationName%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getLocationName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getCoordinates() != null) {
            joiner.add(this.getCoordinates().toUrlQueryString((String)prefix + JSON_PROPERTY_COORDINATES + suffix));
        }
        if (this.getAddress() != null) {
            joiner.add(this.getAddress().toUrlQueryString((String)prefix + JSON_PROPERTY_ADDRESS + suffix));
        }
        if (this.getDistance() != null) {
            joiner.add(String.format("%sdistance%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getDistance()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getSurchargeFree() != null) {
            joiner.add(String.format("%ssurchargeFree%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getSurchargeFree()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getAcceptDeposits() != null) {
            joiner.add(String.format("%sacceptDeposits%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getAcceptDeposits()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }
}

