/*
 * Decompiled with CFR 0.152.
 */
package unit.java.sdk.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.StringJoiner;
import unit.java.sdk.model.AuthorizationAttributes;

@JsonPropertyOrder(value={"type", "id", "attributes", "relationships"})
public class Authorization {
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type = "authorization";
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_ATTRIBUTES = "attributes";
    private AuthorizationAttributes attributes;
    public static final String JSON_PROPERTY_RELATIONSHIPS = "relationships";
    private Object relationships;

    public Authorization type(String type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(String type) {
        this.type = type;
    }

    public Authorization id(String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setId(String id) {
        this.id = id;
    }

    public Authorization attributes(AuthorizationAttributes attributes) {
        this.attributes = attributes;
        return this;
    }

    @Nullable
    @JsonProperty(value="attributes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AuthorizationAttributes getAttributes() {
        return this.attributes;
    }

    @JsonProperty(value="attributes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAttributes(AuthorizationAttributes attributes) {
        this.attributes = attributes;
    }

    public Authorization relationships(Object relationships) {
        this.relationships = relationships;
        return this;
    }

    @Nonnull
    @JsonProperty(value="relationships")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Object getRelationships() {
        return this.relationships;
    }

    @JsonProperty(value="relationships")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRelationships(Object relationships) {
        this.relationships = relationships;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Authorization authorization = (Authorization)o;
        return Objects.equals(this.type, authorization.type) && Objects.equals(this.id, authorization.id) && Objects.equals(this.attributes, authorization.attributes) && Objects.equals(this.relationships, authorization.relationships);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.id, this.attributes, this.relationships);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Authorization {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    relationships: ").append(this.toIndentedString(this.relationships)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getType() != null) {
            joiner.add(String.format("%stype%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getType()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getId() != null) {
            joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getAttributes() != null) {
            joiner.add(this.getAttributes().toUrlQueryString((String)prefix + JSON_PROPERTY_ATTRIBUTES + suffix));
        }
        if (this.getRelationships() != null) {
            joiner.add(String.format("%srelationships%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getRelationships()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }
}

