/*
 * Decompiled with CFR 0.152.
 */
package unit.java.sdk.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Objects;
import java.util.StringJoiner;
import unit.java.sdk.JSON;
import unit.java.sdk.model.AtmAuthorizationRequest;
import unit.java.sdk.model.CardTransactionAuthorizationRequest;
import unit.java.sdk.model.PurchaseAuthorizationRequest;

@JsonPropertyOrder(value={"type", "id"})
@JsonIgnoreProperties(value={"type"}, allowSetters=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type", visible=true)
@JsonSubTypes(value={@JsonSubTypes.Type(value=AtmAuthorizationRequest.class, name="atmAuthorizationRequest"), @JsonSubTypes.Type(value=CardTransactionAuthorizationRequest.class, name="cardTransactionAuthorizationRequest"), @JsonSubTypes.Type(value=PurchaseAuthorizationRequest.class, name="purchaseAuthorizationRequest")})
public class AuthorizationRequest {
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;

    public AuthorizationRequest type(String type) {
        this.type = type;
        return this;
    }

    @Nullable
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(String type) {
        this.type = type;
    }

    public AuthorizationRequest id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthorizationRequest authorizationRequest = (AuthorizationRequest)o;
        return Objects.equals(this.type, authorizationRequest.type) && Objects.equals(this.id, authorizationRequest.id);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.id);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuthorizationRequest {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getType() != null) {
            joiner.add(String.format("%stype%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getType()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getId() != null) {
            joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }

    static {
        HashMap mappings = new HashMap();
        mappings.put("atmAuthorizationRequest", AtmAuthorizationRequest.class);
        mappings.put("cardTransactionAuthorizationRequest", CardTransactionAuthorizationRequest.class);
        mappings.put("purchaseAuthorizationRequest", PurchaseAuthorizationRequest.class);
        mappings.put("authorization_request", AuthorizationRequest.class);
        JSON.registerDiscriminator(AuthorizationRequest.class, JSON_PROPERTY_TYPE, mappings);
    }
}

