/*
 * Decompiled with CFR 0.152.
 */
package unit.java.sdk.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;
import java.util.StringJoiner;
import org.openapitools.jackson.nullable.JsonNullable;
import unit.java.sdk.model.FullName;
import unit.java.sdk.model.Phone;

@JsonPropertyOrder(value={"fullName", "email", "phone", "jwtSubject"})
public class AuthorizedUser {
    public static final String JSON_PROPERTY_FULL_NAME = "fullName";
    private FullName fullName;
    public static final String JSON_PROPERTY_EMAIL = "email";
    private String email;
    public static final String JSON_PROPERTY_PHONE = "phone";
    private Phone phone;
    public static final String JSON_PROPERTY_JWT_SUBJECT = "jwtSubject";
    private JsonNullable<String> jwtSubject = JsonNullable.undefined();

    public AuthorizedUser fullName(FullName fullName) {
        this.fullName = fullName;
        return this;
    }

    @Nonnull
    @JsonProperty(value="fullName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public FullName getFullName() {
        return this.fullName;
    }

    @JsonProperty(value="fullName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setFullName(FullName fullName) {
        this.fullName = fullName;
    }

    public AuthorizedUser email(String email) {
        this.email = email;
        return this;
    }

    @Nonnull
    @JsonProperty(value="email")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getEmail() {
        return this.email;
    }

    @JsonProperty(value="email")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEmail(String email) {
        this.email = email;
    }

    public AuthorizedUser phone(Phone phone) {
        this.phone = phone;
        return this;
    }

    @Nonnull
    @JsonProperty(value="phone")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Phone getPhone() {
        return this.phone;
    }

    @JsonProperty(value="phone")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPhone(Phone phone) {
        this.phone = phone;
    }

    public AuthorizedUser jwtSubject(String jwtSubject) {
        this.jwtSubject = JsonNullable.of((Object)jwtSubject);
        return this;
    }

    @Nullable
    @JsonIgnore
    public String getJwtSubject() {
        return (String)this.jwtSubject.orElse(null);
    }

    @JsonProperty(value="jwtSubject")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getJwtSubject_JsonNullable() {
        return this.jwtSubject;
    }

    @JsonProperty(value="jwtSubject")
    public void setJwtSubject_JsonNullable(JsonNullable<String> jwtSubject) {
        this.jwtSubject = jwtSubject;
    }

    public void setJwtSubject(String jwtSubject) {
        this.jwtSubject = JsonNullable.of((Object)jwtSubject);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthorizedUser authorizedUser = (AuthorizedUser)o;
        return Objects.equals(this.fullName, authorizedUser.fullName) && Objects.equals(this.email, authorizedUser.email) && Objects.equals(this.phone, authorizedUser.phone) && AuthorizedUser.equalsNullable(this.jwtSubject, authorizedUser.jwtSubject);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(this.fullName, this.email, this.phone, AuthorizedUser.hashCodeNullable(this.jwtSubject));
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuthorizedUser {\n");
        sb.append("    fullName: ").append(this.toIndentedString(this.fullName)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    phone: ").append(this.toIndentedString(this.phone)).append("\n");
        sb.append("    jwtSubject: ").append(this.toIndentedString(this.jwtSubject)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getFullName() != null) {
            joiner.add(this.getFullName().toUrlQueryString((String)prefix + JSON_PROPERTY_FULL_NAME + suffix));
        }
        if (this.getEmail() != null) {
            joiner.add(String.format("%semail%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getEmail()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getPhone() != null) {
            joiner.add(this.getPhone().toUrlQueryString((String)prefix + JSON_PROPERTY_PHONE + suffix));
        }
        if (this.getJwtSubject() != null) {
            joiner.add(String.format("%sjwtSubject%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getJwtSubject()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }
}

