/*
 * Decompiled with CFR 0.152.
 */
package unit.java.sdk.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;
import java.util.StringJoiner;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"reason", "fraudReason"})
public class CloseAccountRequestAttributes {
    public static final String JSON_PROPERTY_REASON = "reason";
    private ReasonEnum reason = ReasonEnum.BYCUSTOMER;
    public static final String JSON_PROPERTY_FRAUD_REASON = "fraudReason";
    private JsonNullable<FraudReasonEnum> fraudReason = JsonNullable.undefined();

    public CloseAccountRequestAttributes reason(ReasonEnum reason) {
        this.reason = reason;
        return this;
    }

    @Nullable
    @JsonProperty(value="reason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ReasonEnum getReason() {
        return this.reason;
    }

    @JsonProperty(value="reason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReason(ReasonEnum reason) {
        this.reason = reason;
    }

    public CloseAccountRequestAttributes fraudReason(FraudReasonEnum fraudReason) {
        this.fraudReason = JsonNullable.of((Object)((Object)fraudReason));
        return this;
    }

    @Nullable
    @JsonIgnore
    public FraudReasonEnum getFraudReason() {
        return (FraudReasonEnum)((Object)this.fraudReason.orElse(null));
    }

    @JsonProperty(value="fraudReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<FraudReasonEnum> getFraudReason_JsonNullable() {
        return this.fraudReason;
    }

    @JsonProperty(value="fraudReason")
    public void setFraudReason_JsonNullable(JsonNullable<FraudReasonEnum> fraudReason) {
        this.fraudReason = fraudReason;
    }

    public void setFraudReason(FraudReasonEnum fraudReason) {
        this.fraudReason = JsonNullable.of((Object)((Object)fraudReason));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CloseAccountRequestAttributes closeAccountRequestAttributes = (CloseAccountRequestAttributes)o;
        return Objects.equals((Object)this.reason, (Object)closeAccountRequestAttributes.reason) && CloseAccountRequestAttributes.equalsNullable(this.fraudReason, closeAccountRequestAttributes.fraudReason);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.reason, CloseAccountRequestAttributes.hashCodeNullable(this.fraudReason)});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CloseAccountRequestAttributes {\n");
        sb.append("    reason: ").append(this.toIndentedString((Object)this.reason)).append("\n");
        sb.append("    fraudReason: ").append(this.toIndentedString(this.fraudReason)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getReason() != null) {
            joiner.add(String.format("%sreason%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getReason()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getFraudReason() != null) {
            joiner.add(String.format("%sfraudReason%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getFraudReason()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }

    public static enum FraudReasonEnum {
        ACHACTIVITY("ACHActivity"),
        CARDACTIVITY("CardActivity"),
        CHECKACTIVITY("CheckActivity"),
        APPLICATIONHISTORY("ApplicationHistory"),
        ACCOUNTACTIVITY("AccountActivity"),
        CLIENTIDENTIFIED("ClientIdentified"),
        IDENTITYTHEFT("IdentityTheft"),
        LINKEDTOFRAUDULENTCUSTOMER("LinkedToFraudulentCustomer");

        private String value;

        private FraudReasonEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static FraudReasonEnum fromValue(String value) {
            for (FraudReasonEnum b : FraudReasonEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum ReasonEnum {
        BYCUSTOMER("ByCustomer"),
        FRAUD("Fraud");

        private String value;

        private ReasonEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ReasonEnum fromValue(String value) {
            for (ReasonEnum b : ReasonEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

