/*
 * Decompiled with CFR 0.152.
 */
package unit.java.sdk.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import unit.java.sdk.model.Beneficiary;
import unit.java.sdk.model.DeviceFingerprint;
import unit.java.sdk.model.Grantor;
import unit.java.sdk.model.TrustContact;
import unit.java.sdk.model.Trustee;

@JsonPropertyOrder(value={"name", "stateOfIncorporation", "revocability", "sourceOfFunds", "taxId", "grantor", "trustees", "beneficiaries", "contact", "ip", "tags", "idempotencyKey", "deviceFingerprints"})
public class CreateTrustApplicationAttributes {
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_STATE_OF_INCORPORATION = "stateOfIncorporation";
    private String stateOfIncorporation;
    public static final String JSON_PROPERTY_REVOCABILITY = "revocability";
    private RevocabilityEnum revocability;
    public static final String JSON_PROPERTY_SOURCE_OF_FUNDS = "sourceOfFunds";
    private SourceOfFundsEnum sourceOfFunds;
    public static final String JSON_PROPERTY_TAX_ID = "taxId";
    private String taxId;
    public static final String JSON_PROPERTY_GRANTOR = "grantor";
    private Grantor grantor;
    public static final String JSON_PROPERTY_TRUSTEES = "trustees";
    private List<Trustee> trustees = new ArrayList<Trustee>();
    public static final String JSON_PROPERTY_BENEFICIARIES = "beneficiaries";
    private List<Beneficiary> beneficiaries = new ArrayList<Beneficiary>();
    public static final String JSON_PROPERTY_CONTACT = "contact";
    private TrustContact contact;
    public static final String JSON_PROPERTY_IP = "ip";
    private String ip;
    public static final String JSON_PROPERTY_TAGS = "tags";
    private Object tags;
    public static final String JSON_PROPERTY_IDEMPOTENCY_KEY = "idempotencyKey";
    private String idempotencyKey;
    public static final String JSON_PROPERTY_DEVICE_FINGERPRINTS = "deviceFingerprints";
    private List<DeviceFingerprint> deviceFingerprints;

    public CreateTrustApplicationAttributes name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public CreateTrustApplicationAttributes stateOfIncorporation(String stateOfIncorporation) {
        this.stateOfIncorporation = stateOfIncorporation;
        return this;
    }

    @Nonnull
    @JsonProperty(value="stateOfIncorporation")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getStateOfIncorporation() {
        return this.stateOfIncorporation;
    }

    @JsonProperty(value="stateOfIncorporation")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStateOfIncorporation(String stateOfIncorporation) {
        this.stateOfIncorporation = stateOfIncorporation;
    }

    public CreateTrustApplicationAttributes revocability(RevocabilityEnum revocability) {
        this.revocability = revocability;
        return this;
    }

    @Nonnull
    @JsonProperty(value="revocability")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public RevocabilityEnum getRevocability() {
        return this.revocability;
    }

    @JsonProperty(value="revocability")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRevocability(RevocabilityEnum revocability) {
        this.revocability = revocability;
    }

    public CreateTrustApplicationAttributes sourceOfFunds(SourceOfFundsEnum sourceOfFunds) {
        this.sourceOfFunds = sourceOfFunds;
        return this;
    }

    @Nonnull
    @JsonProperty(value="sourceOfFunds")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public SourceOfFundsEnum getSourceOfFunds() {
        return this.sourceOfFunds;
    }

    @JsonProperty(value="sourceOfFunds")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSourceOfFunds(SourceOfFundsEnum sourceOfFunds) {
        this.sourceOfFunds = sourceOfFunds;
    }

    public CreateTrustApplicationAttributes taxId(String taxId) {
        this.taxId = taxId;
        return this;
    }

    @Nonnull
    @JsonProperty(value="taxId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getTaxId() {
        return this.taxId;
    }

    @JsonProperty(value="taxId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTaxId(String taxId) {
        this.taxId = taxId;
    }

    public CreateTrustApplicationAttributes grantor(Grantor grantor) {
        this.grantor = grantor;
        return this;
    }

    @Nonnull
    @JsonProperty(value="grantor")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Grantor getGrantor() {
        return this.grantor;
    }

    @JsonProperty(value="grantor")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setGrantor(Grantor grantor) {
        this.grantor = grantor;
    }

    public CreateTrustApplicationAttributes trustees(List<Trustee> trustees) {
        this.trustees = trustees;
        return this;
    }

    public CreateTrustApplicationAttributes addTrusteesItem(Trustee trusteesItem) {
        if (this.trustees == null) {
            this.trustees = new ArrayList<Trustee>();
        }
        this.trustees.add(trusteesItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="trustees")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<Trustee> getTrustees() {
        return this.trustees;
    }

    @JsonProperty(value="trustees")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTrustees(List<Trustee> trustees) {
        this.trustees = trustees;
    }

    public CreateTrustApplicationAttributes beneficiaries(List<Beneficiary> beneficiaries) {
        this.beneficiaries = beneficiaries;
        return this;
    }

    public CreateTrustApplicationAttributes addBeneficiariesItem(Beneficiary beneficiariesItem) {
        if (this.beneficiaries == null) {
            this.beneficiaries = new ArrayList<Beneficiary>();
        }
        this.beneficiaries.add(beneficiariesItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="beneficiaries")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<Beneficiary> getBeneficiaries() {
        return this.beneficiaries;
    }

    @JsonProperty(value="beneficiaries")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setBeneficiaries(List<Beneficiary> beneficiaries) {
        this.beneficiaries = beneficiaries;
    }

    public CreateTrustApplicationAttributes contact(TrustContact contact) {
        this.contact = contact;
        return this;
    }

    @Nonnull
    @JsonProperty(value="contact")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TrustContact getContact() {
        return this.contact;
    }

    @JsonProperty(value="contact")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setContact(TrustContact contact) {
        this.contact = contact;
    }

    public CreateTrustApplicationAttributes ip(String ip) {
        this.ip = ip;
        return this;
    }

    @Nullable
    @JsonProperty(value="ip")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIp() {
        return this.ip;
    }

    @JsonProperty(value="ip")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIp(String ip) {
        this.ip = ip;
    }

    public CreateTrustApplicationAttributes tags(Object tags) {
        this.tags = tags;
        return this;
    }

    @Nullable
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getTags() {
        return this.tags;
    }

    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTags(Object tags) {
        this.tags = tags;
    }

    public CreateTrustApplicationAttributes idempotencyKey(String idempotencyKey) {
        this.idempotencyKey = idempotencyKey;
        return this;
    }

    @Nullable
    @JsonProperty(value="idempotencyKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    @JsonProperty(value="idempotencyKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIdempotencyKey(String idempotencyKey) {
        this.idempotencyKey = idempotencyKey;
    }

    public CreateTrustApplicationAttributes deviceFingerprints(List<DeviceFingerprint> deviceFingerprints) {
        this.deviceFingerprints = deviceFingerprints;
        return this;
    }

    public CreateTrustApplicationAttributes addDeviceFingerprintsItem(DeviceFingerprint deviceFingerprintsItem) {
        if (this.deviceFingerprints == null) {
            this.deviceFingerprints = new ArrayList<DeviceFingerprint>();
        }
        this.deviceFingerprints.add(deviceFingerprintsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="deviceFingerprints")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<DeviceFingerprint> getDeviceFingerprints() {
        return this.deviceFingerprints;
    }

    @JsonProperty(value="deviceFingerprints")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDeviceFingerprints(List<DeviceFingerprint> deviceFingerprints) {
        this.deviceFingerprints = deviceFingerprints;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateTrustApplicationAttributes createTrustApplicationAttributes = (CreateTrustApplicationAttributes)o;
        return Objects.equals(this.name, createTrustApplicationAttributes.name) && Objects.equals(this.stateOfIncorporation, createTrustApplicationAttributes.stateOfIncorporation) && Objects.equals((Object)this.revocability, (Object)createTrustApplicationAttributes.revocability) && Objects.equals((Object)this.sourceOfFunds, (Object)createTrustApplicationAttributes.sourceOfFunds) && Objects.equals(this.taxId, createTrustApplicationAttributes.taxId) && Objects.equals(this.grantor, createTrustApplicationAttributes.grantor) && Objects.equals(this.trustees, createTrustApplicationAttributes.trustees) && Objects.equals(this.beneficiaries, createTrustApplicationAttributes.beneficiaries) && Objects.equals(this.contact, createTrustApplicationAttributes.contact) && Objects.equals(this.ip, createTrustApplicationAttributes.ip) && Objects.equals(this.tags, createTrustApplicationAttributes.tags) && Objects.equals(this.idempotencyKey, createTrustApplicationAttributes.idempotencyKey) && Objects.equals(this.deviceFingerprints, createTrustApplicationAttributes.deviceFingerprints);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.stateOfIncorporation, this.revocability, this.sourceOfFunds, this.taxId, this.grantor, this.trustees, this.beneficiaries, this.contact, this.ip, this.tags, this.idempotencyKey, this.deviceFingerprints});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateTrustApplicationAttributes {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    stateOfIncorporation: ").append(this.toIndentedString(this.stateOfIncorporation)).append("\n");
        sb.append("    revocability: ").append(this.toIndentedString((Object)this.revocability)).append("\n");
        sb.append("    sourceOfFunds: ").append(this.toIndentedString((Object)this.sourceOfFunds)).append("\n");
        sb.append("    taxId: ").append(this.toIndentedString(this.taxId)).append("\n");
        sb.append("    grantor: ").append(this.toIndentedString(this.grantor)).append("\n");
        sb.append("    trustees: ").append(this.toIndentedString(this.trustees)).append("\n");
        sb.append("    beneficiaries: ").append(this.toIndentedString(this.beneficiaries)).append("\n");
        sb.append("    contact: ").append(this.toIndentedString(this.contact)).append("\n");
        sb.append("    ip: ").append(this.toIndentedString(this.ip)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    idempotencyKey: ").append(this.toIndentedString(this.idempotencyKey)).append("\n");
        sb.append("    deviceFingerprints: ").append(this.toIndentedString(this.deviceFingerprints)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        int i;
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getName() != null) {
            joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getStateOfIncorporation() != null) {
            joiner.add(String.format("%sstateOfIncorporation%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getStateOfIncorporation()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getRevocability() != null) {
            joiner.add(String.format("%srevocability%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getRevocability()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getSourceOfFunds() != null) {
            joiner.add(String.format("%ssourceOfFunds%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getSourceOfFunds()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getTaxId() != null) {
            joiner.add(String.format("%staxId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getTaxId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getGrantor() != null) {
            joiner.add(this.getGrantor().toUrlQueryString((String)prefix + JSON_PROPERTY_GRANTOR + suffix));
        }
        if (this.getTrustees() != null) {
            for (i = 0; i < this.getTrustees().size(); ++i) {
                if (this.getTrustees().get(i) == null) continue;
                joiner.add(this.getTrustees().get(i).toUrlQueryString(String.format("%strustees%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getBeneficiaries() != null) {
            for (i = 0; i < this.getBeneficiaries().size(); ++i) {
                if (this.getBeneficiaries().get(i) == null) continue;
                joiner.add(this.getBeneficiaries().get(i).toUrlQueryString(String.format("%sbeneficiaries%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getContact() != null) {
            joiner.add(this.getContact().toUrlQueryString((String)prefix + JSON_PROPERTY_CONTACT + suffix));
        }
        if (this.getIp() != null) {
            joiner.add(String.format("%sip%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getIp()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getTags() != null) {
            joiner.add(String.format("%stags%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getTags()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getIdempotencyKey() != null) {
            joiner.add(String.format("%sidempotencyKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getIdempotencyKey()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getDeviceFingerprints() != null) {
            for (i = 0; i < this.getDeviceFingerprints().size(); ++i) {
                if (this.getDeviceFingerprints().get(i) == null) continue;
                joiner.add(this.getDeviceFingerprints().get(i).toUrlQueryString(String.format("%sdeviceFingerprints%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        return joiner.toString();
    }

    public static enum SourceOfFundsEnum {
        INHERITANCE("Inheritance"),
        SALARY("Salary"),
        SAVINGS("Savings"),
        INVESTMENTRETURNS("InvestmentReturns"),
        GIFTS("Gifts");

        private String value;

        private SourceOfFundsEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SourceOfFundsEnum fromValue(String value) {
            for (SourceOfFundsEnum b : SourceOfFundsEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum RevocabilityEnum {
        REVOCABLE("Revocable"),
        IRREVOCABLE("Irrevocable");

        private String value;

        private RevocabilityEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static RevocabilityEnum fromValue(String value) {
            for (RevocabilityEnum b : RevocabilityEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

