/*
 * Decompiled with CFR 0.152.
 */
package unit.java.sdk.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"status", "accountId", "customerId", "tags"})
public class ExecuteFilterParameter7 {
    public static final String JSON_PROPERTY_STATUS = "status";
    private List<StatusEnum> status;
    public static final String JSON_PROPERTY_ACCOUNT_ID = "accountId";
    private String accountId;
    public static final String JSON_PROPERTY_CUSTOMER_ID = "customerId";
    private String customerId;
    public static final String JSON_PROPERTY_TAGS = "tags";
    private Map<String, String> tags = new HashMap<String, String>();

    public ExecuteFilterParameter7 status(List<StatusEnum> status) {
        this.status = status;
        return this;
    }

    public ExecuteFilterParameter7 addStatusItem(StatusEnum statusItem) {
        if (this.status == null) {
            this.status = new ArrayList<StatusEnum>();
        }
        this.status.add(statusItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<StatusEnum> getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(List<StatusEnum> status) {
        this.status = status;
    }

    public ExecuteFilterParameter7 accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @Nullable
    @JsonProperty(value="accountId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccountId() {
        return this.accountId;
    }

    @JsonProperty(value="accountId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public ExecuteFilterParameter7 customerId(String customerId) {
        this.customerId = customerId;
        return this;
    }

    @Nullable
    @JsonProperty(value="customerId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCustomerId() {
        return this.customerId;
    }

    @JsonProperty(value="customerId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCustomerId(String customerId) {
        this.customerId = customerId;
    }

    public ExecuteFilterParameter7 tags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public ExecuteFilterParameter7 putTagsItem(String key, String tagsItem) {
        if (this.tags == null) {
            this.tags = new HashMap<String, String>();
        }
        this.tags.put(key, tagsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getTags() {
        return this.tags;
    }

    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExecuteFilterParameter7 executeFilterParameter7 = (ExecuteFilterParameter7)o;
        return Objects.equals(this.status, executeFilterParameter7.status) && Objects.equals(this.accountId, executeFilterParameter7.accountId) && Objects.equals(this.customerId, executeFilterParameter7.customerId) && Objects.equals(this.tags, executeFilterParameter7.tags);
    }

    public int hashCode() {
        return Objects.hash(this.status, this.accountId, this.customerId, this.tags);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ExecuteFilterParameter7 {\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    customerId: ").append(this.toIndentedString(this.customerId)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getStatus() != null) {
            for (int i = 0; i < this.getStatus().size(); ++i) {
                joiner.add(String.format("%sstatus%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf((Object)this.getStatus().get(i)), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
            }
        }
        if (this.getAccountId() != null) {
            joiner.add(String.format("%saccountId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getAccountId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getCustomerId() != null) {
            joiner.add(String.format("%scustomerId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getCustomerId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getTags() != null) {
            for (String _key : this.getTags().keySet()) {
                joiner.add(String.format("%stags%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix), this.getTags().get(_key), URLEncoder.encode(String.valueOf(this.getTags().get(_key)), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
            }
        }
        return joiner.toString();
    }

    public static enum StatusEnum {
        INACTIVE("Inactive"),
        ACTIVE("Active"),
        STOLEN("Stolen"),
        LOST("Lost"),
        FROZEN("Frozen"),
        CLOSEDBYCUSTOMER("ClosedByCustomer"),
        SUSPECTEDFRAUD("SuspectedFraud");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

