/*
 * Decompiled with CFR 0.152.
 */
package unit.java.sdk.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.StringJoiner;
import unit.java.sdk.model.Address;
import unit.java.sdk.model.Counterparty;

@JsonPropertyOrder(value={"createdAt", "direction", "amount", "balance", "summary", "senderName", "description", "senderAccountNumber", "senderAddress", "counterparty", "tags"})
public class ReleaseTransactionAllOfAttributes {
    public static final String JSON_PROPERTY_CREATED_AT = "createdAt";
    private OffsetDateTime createdAt;
    public static final String JSON_PROPERTY_DIRECTION = "direction";
    private DirectionEnum direction;
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private Integer amount;
    public static final String JSON_PROPERTY_BALANCE = "balance";
    private Integer balance;
    public static final String JSON_PROPERTY_SUMMARY = "summary";
    private String summary;
    public static final String JSON_PROPERTY_SENDER_NAME = "senderName";
    private String senderName;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_SENDER_ACCOUNT_NUMBER = "senderAccountNumber";
    private String senderAccountNumber;
    public static final String JSON_PROPERTY_SENDER_ADDRESS = "senderAddress";
    private Address senderAddress;
    public static final String JSON_PROPERTY_COUNTERPARTY = "counterparty";
    private Counterparty counterparty;
    public static final String JSON_PROPERTY_TAGS = "tags";
    private Object tags;

    public ReleaseTransactionAllOfAttributes createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nonnull
    @JsonProperty(value="createdAt")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="createdAt")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public ReleaseTransactionAllOfAttributes direction(DirectionEnum direction) {
        this.direction = direction;
        return this;
    }

    @Nonnull
    @JsonProperty(value="direction")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public DirectionEnum getDirection() {
        return this.direction;
    }

    @JsonProperty(value="direction")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDirection(DirectionEnum direction) {
        this.direction = direction;
    }

    public ReleaseTransactionAllOfAttributes amount(Integer amount) {
        this.amount = amount;
        return this;
    }

    @Nonnull
    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Integer getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAmount(Integer amount) {
        this.amount = amount;
    }

    public ReleaseTransactionAllOfAttributes balance(Integer balance) {
        this.balance = balance;
        return this;
    }

    @Nonnull
    @JsonProperty(value="balance")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Integer getBalance() {
        return this.balance;
    }

    @JsonProperty(value="balance")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setBalance(Integer balance) {
        this.balance = balance;
    }

    public ReleaseTransactionAllOfAttributes summary(String summary) {
        this.summary = summary;
        return this;
    }

    @Nonnull
    @JsonProperty(value="summary")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSummary() {
        return this.summary;
    }

    @JsonProperty(value="summary")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSummary(String summary) {
        this.summary = summary;
    }

    public ReleaseTransactionAllOfAttributes senderName(String senderName) {
        this.senderName = senderName;
        return this;
    }

    @Nullable
    @JsonProperty(value="senderName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSenderName() {
        return this.senderName;
    }

    @JsonProperty(value="senderName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSenderName(String senderName) {
        this.senderName = senderName;
    }

    public ReleaseTransactionAllOfAttributes description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public ReleaseTransactionAllOfAttributes senderAccountNumber(String senderAccountNumber) {
        this.senderAccountNumber = senderAccountNumber;
        return this;
    }

    @Nullable
    @JsonProperty(value="senderAccountNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSenderAccountNumber() {
        return this.senderAccountNumber;
    }

    @JsonProperty(value="senderAccountNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSenderAccountNumber(String senderAccountNumber) {
        this.senderAccountNumber = senderAccountNumber;
    }

    public ReleaseTransactionAllOfAttributes senderAddress(Address senderAddress) {
        this.senderAddress = senderAddress;
        return this;
    }

    @Nullable
    @JsonProperty(value="senderAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Address getSenderAddress() {
        return this.senderAddress;
    }

    @JsonProperty(value="senderAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSenderAddress(Address senderAddress) {
        this.senderAddress = senderAddress;
    }

    public ReleaseTransactionAllOfAttributes counterparty(Counterparty counterparty) {
        this.counterparty = counterparty;
        return this;
    }

    @Nonnull
    @JsonProperty(value="counterparty")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Counterparty getCounterparty() {
        return this.counterparty;
    }

    @JsonProperty(value="counterparty")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCounterparty(Counterparty counterparty) {
        this.counterparty = counterparty;
    }

    public ReleaseTransactionAllOfAttributes tags(Object tags) {
        this.tags = tags;
        return this;
    }

    @Nullable
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getTags() {
        return this.tags;
    }

    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTags(Object tags) {
        this.tags = tags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReleaseTransactionAllOfAttributes releaseTransactionAllOfAttributes = (ReleaseTransactionAllOfAttributes)o;
        return Objects.equals(this.createdAt, releaseTransactionAllOfAttributes.createdAt) && Objects.equals((Object)this.direction, (Object)releaseTransactionAllOfAttributes.direction) && Objects.equals(this.amount, releaseTransactionAllOfAttributes.amount) && Objects.equals(this.balance, releaseTransactionAllOfAttributes.balance) && Objects.equals(this.summary, releaseTransactionAllOfAttributes.summary) && Objects.equals(this.senderName, releaseTransactionAllOfAttributes.senderName) && Objects.equals(this.description, releaseTransactionAllOfAttributes.description) && Objects.equals(this.senderAccountNumber, releaseTransactionAllOfAttributes.senderAccountNumber) && Objects.equals(this.senderAddress, releaseTransactionAllOfAttributes.senderAddress) && Objects.equals(this.counterparty, releaseTransactionAllOfAttributes.counterparty) && Objects.equals(this.tags, releaseTransactionAllOfAttributes.tags);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.createdAt, this.direction, this.amount, this.balance, this.summary, this.senderName, this.description, this.senderAccountNumber, this.senderAddress, this.counterparty, this.tags});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ReleaseTransactionAllOfAttributes {\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    direction: ").append(this.toIndentedString((Object)this.direction)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    balance: ").append(this.toIndentedString(this.balance)).append("\n");
        sb.append("    summary: ").append(this.toIndentedString(this.summary)).append("\n");
        sb.append("    senderName: ").append(this.toIndentedString(this.senderName)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    senderAccountNumber: ").append(this.toIndentedString(this.senderAccountNumber)).append("\n");
        sb.append("    senderAddress: ").append(this.toIndentedString(this.senderAddress)).append("\n");
        sb.append("    counterparty: ").append(this.toIndentedString(this.counterparty)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getCreatedAt() != null) {
            joiner.add(String.format("%screatedAt%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getCreatedAt()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getDirection() != null) {
            joiner.add(String.format("%sdirection%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getDirection()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getAmount() != null) {
            joiner.add(String.format("%samount%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getAmount()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getBalance() != null) {
            joiner.add(String.format("%sbalance%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getBalance()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getSummary() != null) {
            joiner.add(String.format("%ssummary%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getSummary()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getSenderName() != null) {
            joiner.add(String.format("%ssenderName%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getSenderName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getDescription() != null) {
            joiner.add(String.format("%sdescription%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getDescription()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getSenderAccountNumber() != null) {
            joiner.add(String.format("%ssenderAccountNumber%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getSenderAccountNumber()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getSenderAddress() != null) {
            joiner.add(this.getSenderAddress().toUrlQueryString((String)prefix + JSON_PROPERTY_SENDER_ADDRESS + suffix));
        }
        if (this.getCounterparty() != null) {
            joiner.add(this.getCounterparty().toUrlQueryString((String)prefix + JSON_PROPERTY_COUNTERPARTY + suffix));
        }
        if (this.getTags() != null) {
            joiner.add(String.format("%stags%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getTags()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }

    public static enum DirectionEnum {
        CREDIT("Credit"),
        DEBIT("Debit");

        private String value;

        private DirectionEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static DirectionEnum fromValue(String value) {
            for (DirectionEnum b : DirectionEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

