/*
 * Decompiled with CFR 0.152.
 */
package unit.java.sdk.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nonnull;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.StringJoiner;
import unit.java.sdk.model.Address;

@JsonPropertyOrder(value={"routingNumber", "accountNumber", "name", "address"})
public class WireCounterparty {
    public static final String JSON_PROPERTY_ROUTING_NUMBER = "routingNumber";
    private String routingNumber;
    public static final String JSON_PROPERTY_ACCOUNT_NUMBER = "accountNumber";
    private String accountNumber;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_ADDRESS = "address";
    private Address address;

    public WireCounterparty routingNumber(String routingNumber) {
        this.routingNumber = routingNumber;
        return this;
    }

    @Nonnull
    @JsonProperty(value="routingNumber")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getRoutingNumber() {
        return this.routingNumber;
    }

    @JsonProperty(value="routingNumber")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRoutingNumber(String routingNumber) {
        this.routingNumber = routingNumber;
    }

    public WireCounterparty accountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
        return this;
    }

    @Nonnull
    @JsonProperty(value="accountNumber")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAccountNumber() {
        return this.accountNumber;
    }

    @JsonProperty(value="accountNumber")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public WireCounterparty name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public WireCounterparty address(Address address) {
        this.address = address;
        return this;
    }

    @Nonnull
    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Address getAddress() {
        return this.address;
    }

    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAddress(Address address) {
        this.address = address;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WireCounterparty wireCounterparty = (WireCounterparty)o;
        return Objects.equals(this.routingNumber, wireCounterparty.routingNumber) && Objects.equals(this.accountNumber, wireCounterparty.accountNumber) && Objects.equals(this.name, wireCounterparty.name) && Objects.equals(this.address, wireCounterparty.address);
    }

    public int hashCode() {
        return Objects.hash(this.routingNumber, this.accountNumber, this.name, this.address);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WireCounterparty {\n");
        sb.append("    routingNumber: ").append(this.toIndentedString(this.routingNumber)).append("\n");
        sb.append("    accountNumber: ").append(this.toIndentedString(this.accountNumber)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getRoutingNumber() != null) {
            joiner.add(String.format("%sroutingNumber%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getRoutingNumber()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getAccountNumber() != null) {
            joiner.add(String.format("%saccountNumber%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getAccountNumber()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getName() != null) {
            joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getAddress() != null) {
            joiner.add(this.getAddress().toUrlQueryString((String)prefix + JSON_PROPERTY_ADDRESS + suffix));
        }
        return joiner.toString();
    }
}

