/*
 * Decompiled with CFR 0.152.
 */
package unit.java.sdk.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import java.util.function.Consumer;
import unit.java.sdk.ApiClient;
import unit.java.sdk.ApiException;
import unit.java.sdk.ApiResponse;
import unit.java.sdk.Pair;
import unit.java.sdk.model.AddAuthorizedUsersRequest;
import unit.java.sdk.model.ApproveAuthorizationRequest;
import unit.java.sdk.model.ApproveCheckPaymentRequest;
import unit.java.sdk.model.ArchiveCustomerRequest;
import unit.java.sdk.model.AtmLocation;
import unit.java.sdk.model.CancelApplicationRequest;
import unit.java.sdk.model.CloseAccountRequest;
import unit.java.sdk.model.CreateAccountRequest;
import unit.java.sdk.model.CreateApiTokenRequest;
import unit.java.sdk.model.CreateApplicationFormRequest;
import unit.java.sdk.model.CreateApplicationRequest;
import unit.java.sdk.model.CreateCardRequest;
import unit.java.sdk.model.CreateCheckDepositRequest;
import unit.java.sdk.model.CreateCheckPaymentRequest;
import unit.java.sdk.model.CreateCounterpartyRequest;
import unit.java.sdk.model.CreateCustomerTokenRequest;
import unit.java.sdk.model.CreateCustomerTokenVerificationRequest;
import unit.java.sdk.model.CreateFeeRequest;
import unit.java.sdk.model.CreatePaymentRequest;
import unit.java.sdk.model.CreateRecurringPaymentRequest;
import unit.java.sdk.model.CreateRecurringRepaymentRequest;
import unit.java.sdk.model.CreateRepaymentRequest;
import unit.java.sdk.model.CreateRewardRequest;
import unit.java.sdk.model.CreateStopPaymentRequest;
import unit.java.sdk.model.CreateWebhook;
import unit.java.sdk.model.DeclineAuthorizationRequest;
import unit.java.sdk.model.DefaultContentType;
import unit.java.sdk.model.Dispute;
import unit.java.sdk.model.FreezeAccountRequest;
import unit.java.sdk.model.GetAccountsListFilterParameter;
import unit.java.sdk.model.GetApplicationFormsListFilterParameter;
import unit.java.sdk.model.GetApplicationsListFilterParameter;
import unit.java.sdk.model.GetAtmLocationsListFilterParameter;
import unit.java.sdk.model.GetAuthorizationRequestsListFilterParameter;
import unit.java.sdk.model.GetAuthorizationsListFilterParameter;
import unit.java.sdk.model.GetCardsListFilterParameter;
import unit.java.sdk.model.GetCheckDepositsListFilterParameter;
import unit.java.sdk.model.GetCheckPaymentsListFilterParameter;
import unit.java.sdk.model.GetCounterpartiesListFilterParameter;
import unit.java.sdk.model.GetCustomersListFilterParameter;
import unit.java.sdk.model.GetDisputesListFilterParameter;
import unit.java.sdk.model.GetEventsListFilterParameter;
import unit.java.sdk.model.GetListRewardsFilterParameter;
import unit.java.sdk.model.GetPaymentsListFilterParameter;
import unit.java.sdk.model.GetRecurringPaymentsListFilterParameter;
import unit.java.sdk.model.GetRecurringRepaymentsListFilterParameter;
import unit.java.sdk.model.GetRepaymentsListFilterParameter;
import unit.java.sdk.model.GetStatementsListFilterParameter;
import unit.java.sdk.model.GetStopPaymentsListFilterParameter;
import unit.java.sdk.model.GetTransactionsListFilterParameter;
import unit.java.sdk.model.GetWebhooksListFilterParameter;
import unit.java.sdk.model.ListPageParameters;
import unit.java.sdk.model.RemoveAuthorizedUsersRequest;
import unit.java.sdk.model.ReturnCheckPaymentRequest;
import unit.java.sdk.model.StopPaymentListResponse;
import unit.java.sdk.model.StopPaymentResponse;
import unit.java.sdk.model.UnitAccountResponse;
import unit.java.sdk.model.UnitAccountResponseWithIncluded;
import unit.java.sdk.model.UnitAccountsListResponse;
import unit.java.sdk.model.UnitApiTokenResponse;
import unit.java.sdk.model.UnitApplicationFormResponse;
import unit.java.sdk.model.UnitApplicationFormResponseWithIncluded;
import unit.java.sdk.model.UnitApplicationFormsListResponse;
import unit.java.sdk.model.UnitApplicationResponseWithIncluded;
import unit.java.sdk.model.UnitAuthorizationRequestResponse;
import unit.java.sdk.model.UnitAuthorizationRequestsResponse;
import unit.java.sdk.model.UnitAuthorizationResponse;
import unit.java.sdk.model.UnitBackCheckDepositResponse;
import unit.java.sdk.model.UnitBeneficialOwnerResponse;
import unit.java.sdk.model.UnitCancelApplicationResponse;
import unit.java.sdk.model.UnitCardLimitsResponse;
import unit.java.sdk.model.UnitCardResponse;
import unit.java.sdk.model.UnitCardResponseCardsList;
import unit.java.sdk.model.UnitCardsListResponse;
import unit.java.sdk.model.UnitCheckDepositResponse;
import unit.java.sdk.model.UnitCheckPaymentResponse;
import unit.java.sdk.model.UnitCloseCardResponse;
import unit.java.sdk.model.UnitConfirmCheckDepositResponse;
import unit.java.sdk.model.UnitCounterpartiesListResponse;
import unit.java.sdk.model.UnitCounterpartyResponse;
import unit.java.sdk.model.UnitCounterpartyResponse1;
import unit.java.sdk.model.UnitCreateApplicationResponse;
import unit.java.sdk.model.UnitCustomerResponse;
import unit.java.sdk.model.UnitCustomerTokenResponse;
import unit.java.sdk.model.UnitCustomerTokenVerificationResponse;
import unit.java.sdk.model.UnitCustomersListResponse;
import unit.java.sdk.model.UnitDisputeResponse;
import unit.java.sdk.model.UnitDocumentResponse;
import unit.java.sdk.model.UnitEventListResponse;
import unit.java.sdk.model.UnitEventResponse;
import unit.java.sdk.model.UnitFeeResponse;
import unit.java.sdk.model.UnitFreezeCardResponse;
import unit.java.sdk.model.UnitFrontCheckDepositResponse;
import unit.java.sdk.model.UnitGetAccountEndOfDayListResponse;
import unit.java.sdk.model.UnitGetAccountLimitsResponse;
import unit.java.sdk.model.UnitInstitutionResponse;
import unit.java.sdk.model.UnitListApplicationsResponse;
import unit.java.sdk.model.UnitListAuthorizationRequestsResponse;
import unit.java.sdk.model.UnitListAuthorizationsResponse;
import unit.java.sdk.model.UnitListCheckDepositsResponse;
import unit.java.sdk.model.UnitListCheckDepositsResponse1;
import unit.java.sdk.model.UnitListCheckPaymentsResponse;
import unit.java.sdk.model.UnitListDocumentsResponse;
import unit.java.sdk.model.UnitOrgApiTokensListResponse;
import unit.java.sdk.model.UnitPaymentResponse;
import unit.java.sdk.model.UnitPaymentResponseWithIncluded;
import unit.java.sdk.model.UnitPaymentsListResponse;
import unit.java.sdk.model.UnitPinStatusResponse;
import unit.java.sdk.model.UnitReceivedPaymentListResponse;
import unit.java.sdk.model.UnitReceivedPaymentResponse;
import unit.java.sdk.model.UnitReceivedPaymentResponseWithIncluded;
import unit.java.sdk.model.UnitRecurringPaymentListResponse;
import unit.java.sdk.model.UnitRecurringPaymentResponse;
import unit.java.sdk.model.UnitRecurringRepaymentResponse;
import unit.java.sdk.model.UnitRecurringRepaymentsListResponse;
import unit.java.sdk.model.UnitRepaymentResponse;
import unit.java.sdk.model.UnitRepaymentsListResponse;
import unit.java.sdk.model.UnitReportLostCardResponse;
import unit.java.sdk.model.UnitReportStolenCardResponse;
import unit.java.sdk.model.UnitRewardResponse;
import unit.java.sdk.model.UnitRewardsListResponse;
import unit.java.sdk.model.UnitStatementsResponse;
import unit.java.sdk.model.UnitTransactionResponse;
import unit.java.sdk.model.UnitTransactionResponseWithIncludedResource;
import unit.java.sdk.model.UnitTransactionsListResponse;
import unit.java.sdk.model.UnitUnfreezeCardResponse;
import unit.java.sdk.model.UnitUpdateCardResponse;
import unit.java.sdk.model.UnitUpdateCheckDepositResponse;
import unit.java.sdk.model.UnitWebhooksListResponse;
import unit.java.sdk.model.UpdateAccountRequest;
import unit.java.sdk.model.UpdateApplicationRequest;
import unit.java.sdk.model.UpdateBusinessBeneficialOwnerRequest;
import unit.java.sdk.model.UpdateCardRequest;
import unit.java.sdk.model.UpdateCheckDepositRequest;
import unit.java.sdk.model.UpdateCounterpartyRequest;
import unit.java.sdk.model.UpdateCustomerRequest;
import unit.java.sdk.model.UpdatePaymentRequest;
import unit.java.sdk.model.UpdateReceivedPaymentRequest;
import unit.java.sdk.model.UpdateStopPaymentRequest;
import unit.java.sdk.model.UpdateTransactionRequest;
import unit.java.sdk.model.UpdateWebhookRequest;
import unit.java.sdk.model.VerifyDocument;
import unit.java.sdk.model.WebhookResponse;

public class UnitApi {
    private final HttpClient memberVarHttpClient;
    private final ObjectMapper memberVarObjectMapper;
    private final String memberVarBaseUri;
    private final Consumer<HttpRequest.Builder> memberVarInterceptor;
    private final Duration memberVarReadTimeout;
    private final Consumer<HttpResponse<InputStream>> memberVarResponseInterceptor;
    private final Consumer<HttpResponse<String>> memberVarAsyncResponseInterceptor;

    public UnitApi() {
        this(new ApiClient());
    }

    public UnitApi(ApiClient apiClient) {
        this.memberVarHttpClient = apiClient.getHttpClient();
        this.memberVarObjectMapper = apiClient.getObjectMapper();
        this.memberVarBaseUri = apiClient.getBaseUri();
        this.memberVarInterceptor = apiClient.getRequestInterceptor();
        this.memberVarReadTimeout = apiClient.getReadTimeout();
        this.memberVarResponseInterceptor = apiClient.getResponseInterceptor();
        this.memberVarAsyncResponseInterceptor = apiClient.getAsyncResponseInterceptor();
    }

    protected ApiException getApiException(String operationId, HttpResponse<InputStream> response) throws IOException {
        String body = response.body() == null ? null : new String(response.body().readAllBytes());
        String message = this.formatExceptionMessage(operationId, response.statusCode(), body);
        return new ApiException(response.statusCode(), message, response.headers(), body);
    }

    private String formatExceptionMessage(String operationId, int statusCode, String body) {
        if (body == null || body.isEmpty()) {
            body = "[no body]";
        }
        return operationId + " call failed with: " + statusCode + " - " + body;
    }

    public UnitAccountResponse activateControlAgreementForAccount(String accountId) throws ApiException {
        ApiResponse<UnitAccountResponse> localVarResponse = this.activateControlAgreementForAccountWithHttpInfo(accountId);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitAccountResponse> activateControlAgreementForAccountWithHttpInfo(String accountId) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.activateControlAgreementForAccountRequestBuilder(accountId);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("activateControlAgreementForAccount", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitAccountResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitAccountResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder activateControlAgreementForAccountRequestBuilder(String accountId) throws ApiException {
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling activateControlAgreementForAccount");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/accounts/{accountId}/activate-daca".replace("{accountId}", ApiClient.urlEncode(accountId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitCustomerResponse addAuthorizedUsers(String customerId, AddAuthorizedUsersRequest addAuthorizedUsersRequest) throws ApiException {
        ApiResponse<UnitCustomerResponse> localVarResponse = this.addAuthorizedUsersWithHttpInfo(customerId, addAuthorizedUsersRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitCustomerResponse> addAuthorizedUsersWithHttpInfo(String customerId, AddAuthorizedUsersRequest addAuthorizedUsersRequest) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.addAuthorizedUsersRequestBuilder(customerId, addAuthorizedUsersRequest);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("addAuthorizedUsers", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitCustomerResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitCustomerResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder addAuthorizedUsersRequestBuilder(String customerId, AddAuthorizedUsersRequest addAuthorizedUsersRequest) throws ApiException {
        if (customerId == null) {
            throw new ApiException(400, "Missing the required parameter 'customerId' when calling addAuthorizedUsers");
        }
        if (addAuthorizedUsersRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'addAuthorizedUsersRequest' when calling addAuthorizedUsers");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/customers/{customerId}/authorized-users".replace("{customerId}", ApiClient.urlEncode(customerId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/vnd.api+json");
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)addAuthorizedUsersRequest);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitReceivedPaymentResponse advanceReceivedPayment(String paymentId) throws ApiException {
        ApiResponse<UnitReceivedPaymentResponse> localVarResponse = this.advanceReceivedPaymentWithHttpInfo(paymentId);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitReceivedPaymentResponse> advanceReceivedPaymentWithHttpInfo(String paymentId) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.advanceReceivedPaymentRequestBuilder(paymentId);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("advanceReceivedPayment", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitReceivedPaymentResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitReceivedPaymentResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder advanceReceivedPaymentRequestBuilder(String paymentId) throws ApiException {
        if (paymentId == null) {
            throw new ApiException(400, "Missing the required parameter 'paymentId' when calling advanceReceivedPayment");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/received-payments/{paymentId}/advance".replace("{paymentId}", ApiClient.urlEncode(paymentId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitAuthorizationRequestResponse approveAuthorizationRequest(String authorizationId, ApproveAuthorizationRequest approveAuthorizationRequest) throws ApiException {
        ApiResponse<UnitAuthorizationRequestResponse> localVarResponse = this.approveAuthorizationRequestWithHttpInfo(authorizationId, approveAuthorizationRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitAuthorizationRequestResponse> approveAuthorizationRequestWithHttpInfo(String authorizationId, ApproveAuthorizationRequest approveAuthorizationRequest) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.approveAuthorizationRequestRequestBuilder(authorizationId, approveAuthorizationRequest);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("approveAuthorizationRequest", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitAuthorizationRequestResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitAuthorizationRequestResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder approveAuthorizationRequestRequestBuilder(String authorizationId, ApproveAuthorizationRequest approveAuthorizationRequest) throws ApiException {
        if (authorizationId == null) {
            throw new ApiException(400, "Missing the required parameter 'authorizationId' when calling approveAuthorizationRequest");
        }
        if (approveAuthorizationRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'approveAuthorizationRequest' when calling approveAuthorizationRequest");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/authorization-requests/{authorizationId}/approve".replace("{authorizationId}", ApiClient.urlEncode(authorizationId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/vnd.api+json");
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)approveAuthorizationRequest);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitCheckPaymentResponse approveCheckPayment(String checkPaymentId, ApproveCheckPaymentRequest approveCheckPaymentRequest) throws ApiException {
        ApiResponse<UnitCheckPaymentResponse> localVarResponse = this.approveCheckPaymentWithHttpInfo(checkPaymentId, approveCheckPaymentRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitCheckPaymentResponse> approveCheckPaymentWithHttpInfo(String checkPaymentId, ApproveCheckPaymentRequest approveCheckPaymentRequest) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.approveCheckPaymentRequestBuilder(checkPaymentId, approveCheckPaymentRequest);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("approveCheckPayment", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitCheckPaymentResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitCheckPaymentResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder approveCheckPaymentRequestBuilder(String checkPaymentId, ApproveCheckPaymentRequest approveCheckPaymentRequest) throws ApiException {
        if (checkPaymentId == null) {
            throw new ApiException(400, "Missing the required parameter 'checkPaymentId' when calling approveCheckPayment");
        }
        if (approveCheckPaymentRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'approveCheckPaymentRequest' when calling approveCheckPayment");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/check-payments/{checkPaymentId}/approve".replace("{checkPaymentId}", ApiClient.urlEncode(checkPaymentId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/vnd.api+json");
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)approveCheckPaymentRequest);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitCustomerResponse archiveCustomer(String customerId, ArchiveCustomerRequest archiveCustomerRequest) throws ApiException {
        ApiResponse<UnitCustomerResponse> localVarResponse = this.archiveCustomerWithHttpInfo(customerId, archiveCustomerRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitCustomerResponse> archiveCustomerWithHttpInfo(String customerId, ArchiveCustomerRequest archiveCustomerRequest) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.archiveCustomerRequestBuilder(customerId, archiveCustomerRequest);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("archiveCustomer", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitCustomerResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitCustomerResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder archiveCustomerRequestBuilder(String customerId, ArchiveCustomerRequest archiveCustomerRequest) throws ApiException {
        if (customerId == null) {
            throw new ApiException(400, "Missing the required parameter 'customerId' when calling archiveCustomer");
        }
        if (archiveCustomerRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'archiveCustomerRequest' when calling archiveCustomer");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/customers/{customerId}/archive".replace("{customerId}", ApiClient.urlEncode(customerId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/vnd.api+json");
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)archiveCustomerRequest);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitCancelApplicationResponse cancelApplication(String applicationId, CancelApplicationRequest cancelApplicationRequest) throws ApiException {
        ApiResponse<UnitCancelApplicationResponse> localVarResponse = this.cancelApplicationWithHttpInfo(applicationId, cancelApplicationRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitCancelApplicationResponse> cancelApplicationWithHttpInfo(String applicationId, CancelApplicationRequest cancelApplicationRequest) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.cancelApplicationRequestBuilder(applicationId, cancelApplicationRequest);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("cancelApplication", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitCancelApplicationResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitCancelApplicationResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder cancelApplicationRequestBuilder(String applicationId, CancelApplicationRequest cancelApplicationRequest) throws ApiException {
        if (applicationId == null) {
            throw new ApiException(400, "Missing the required parameter 'applicationId' when calling cancelApplication");
        }
        if (cancelApplicationRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'cancelApplicationRequest' when calling cancelApplication");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/applications/{applicationId}/cancel".replace("{applicationId}", ApiClient.urlEncode(applicationId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/vnd.api+json");
        localVarRequestBuilder.header("Accept", "application/vnd.api+json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)cancelApplicationRequest);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitCheckPaymentResponse cancelCheckPayment(String checkPaymentId) throws ApiException {
        ApiResponse<UnitCheckPaymentResponse> localVarResponse = this.cancelCheckPaymentWithHttpInfo(checkPaymentId);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitCheckPaymentResponse> cancelCheckPaymentWithHttpInfo(String checkPaymentId) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.cancelCheckPaymentRequestBuilder(checkPaymentId);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("cancelCheckPayment", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitCheckPaymentResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitCheckPaymentResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder cancelCheckPaymentRequestBuilder(String checkPaymentId) throws ApiException {
        if (checkPaymentId == null) {
            throw new ApiException(400, "Missing the required parameter 'checkPaymentId' when calling cancelCheckPayment");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/check-payments/{checkPaymentId}/cancel".replace("{checkPaymentId}", ApiClient.urlEncode(checkPaymentId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitPaymentResponse cancelPayment(String paymentId) throws ApiException {
        ApiResponse<UnitPaymentResponse> localVarResponse = this.cancelPaymentWithHttpInfo(paymentId);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitPaymentResponse> cancelPaymentWithHttpInfo(String paymentId) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.cancelPaymentRequestBuilder(paymentId);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("cancelPayment", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitPaymentResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitPaymentResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder cancelPaymentRequestBuilder(String paymentId) throws ApiException {
        if (paymentId == null) {
            throw new ApiException(400, "Missing the required parameter 'paymentId' when calling cancelPayment");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/payments/{paymentId}/cancel".replace("{paymentId}", ApiClient.urlEncode(paymentId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitAccountResponse closeAccount(String accountId, CloseAccountRequest closeAccountRequest) throws ApiException {
        ApiResponse<UnitAccountResponse> localVarResponse = this.closeAccountWithHttpInfo(accountId, closeAccountRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitAccountResponse> closeAccountWithHttpInfo(String accountId, CloseAccountRequest closeAccountRequest) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.closeAccountRequestBuilder(accountId, closeAccountRequest);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("closeAccount", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitAccountResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitAccountResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder closeAccountRequestBuilder(String accountId, CloseAccountRequest closeAccountRequest) throws ApiException {
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling closeAccount");
        }
        if (closeAccountRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'closeAccountRequest' when calling closeAccount");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/accounts/{accountId}/close".replace("{accountId}", ApiClient.urlEncode(accountId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/vnd.api+json");
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)closeAccountRequest);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitCloseCardResponse closeCard(String cardId) throws ApiException {
        ApiResponse<UnitCloseCardResponse> localVarResponse = this.closeCardWithHttpInfo(cardId);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitCloseCardResponse> closeCardWithHttpInfo(String cardId) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.closeCardRequestBuilder(cardId);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("closeCard", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitCloseCardResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitCloseCardResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder closeCardRequestBuilder(String cardId) throws ApiException {
        if (cardId == null) {
            throw new ApiException(400, "Missing the required parameter 'cardId' when calling closeCard");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/cards/{cardId}/close".replace("{cardId}", ApiClient.urlEncode(cardId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitConfirmCheckDepositResponse confirmCheckDeposit(String checkDepositId) throws ApiException {
        ApiResponse<UnitConfirmCheckDepositResponse> localVarResponse = this.confirmCheckDepositWithHttpInfo(checkDepositId);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitConfirmCheckDepositResponse> confirmCheckDepositWithHttpInfo(String checkDepositId) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.confirmCheckDepositRequestBuilder(checkDepositId);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("confirmCheckDeposit", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitConfirmCheckDepositResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitConfirmCheckDepositResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder confirmCheckDepositRequestBuilder(String checkDepositId) throws ApiException {
        if (checkDepositId == null) {
            throw new ApiException(400, "Missing the required parameter 'checkDepositId' when calling confirmCheckDeposit");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/check-deposits/{checkDepositId}/confirm".replace("{checkDepositId}", ApiClient.urlEncode(checkDepositId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitAccountResponse createAccount(CreateAccountRequest createAccountRequest) throws ApiException {
        ApiResponse<UnitAccountResponse> localVarResponse = this.createAccountWithHttpInfo(createAccountRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitAccountResponse> createAccountWithHttpInfo(CreateAccountRequest createAccountRequest) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.createAccountRequestBuilder(createAccountRequest);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("createAccount", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitAccountResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitAccountResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder createAccountRequestBuilder(CreateAccountRequest createAccountRequest) throws ApiException {
        if (createAccountRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'createAccountRequest' when calling createAccount");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/accounts";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/vnd.api+json");
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)createAccountRequest);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitApiTokenResponse createApiToken(String userId, CreateApiTokenRequest createApiTokenRequest) throws ApiException {
        ApiResponse<UnitApiTokenResponse> localVarResponse = this.createApiTokenWithHttpInfo(userId, createApiTokenRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitApiTokenResponse> createApiTokenWithHttpInfo(String userId, CreateApiTokenRequest createApiTokenRequest) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.createApiTokenRequestBuilder(userId, createApiTokenRequest);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("createApiToken", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitApiTokenResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitApiTokenResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder createApiTokenRequestBuilder(String userId, CreateApiTokenRequest createApiTokenRequest) throws ApiException {
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling createApiToken");
        }
        if (createApiTokenRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'createApiTokenRequest' when calling createApiToken");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/users/{userId}/api-tokens".replace("{userId}", ApiClient.urlEncode(userId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/vnd.api+json");
        localVarRequestBuilder.header("Accept", "application/vnd.api+json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)createApiTokenRequest);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitCreateApplicationResponse createApplication(CreateApplicationRequest createApplicationRequest) throws ApiException {
        ApiResponse<UnitCreateApplicationResponse> localVarResponse = this.createApplicationWithHttpInfo(createApplicationRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitCreateApplicationResponse> createApplicationWithHttpInfo(CreateApplicationRequest createApplicationRequest) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.createApplicationRequestBuilder(createApplicationRequest);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("createApplication", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitCreateApplicationResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitCreateApplicationResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder createApplicationRequestBuilder(CreateApplicationRequest createApplicationRequest) throws ApiException {
        if (createApplicationRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'createApplicationRequest' when calling createApplication");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/applications";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/vnd.api+json");
        localVarRequestBuilder.header("Accept", "application/vnd.api+json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)createApplicationRequest);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitDocumentResponse createApplicationDocument(String applicationId, DefaultContentType contentType) throws ApiException {
        ApiResponse<UnitDocumentResponse> localVarResponse = this.createApplicationDocumentWithHttpInfo(applicationId, contentType);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitDocumentResponse> createApplicationDocumentWithHttpInfo(String applicationId, DefaultContentType contentType) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.createApplicationDocumentRequestBuilder(applicationId, contentType);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("createApplicationDocument", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitDocumentResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitDocumentResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder createApplicationDocumentRequestBuilder(String applicationId, DefaultContentType contentType) throws ApiException {
        if (applicationId == null) {
            throw new ApiException(400, "Missing the required parameter 'applicationId' when calling createApplicationDocument");
        }
        if (contentType == null) {
            throw new ApiException(400, "Missing the required parameter 'contentType' when calling createApplicationDocument");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/applications/{applicationId}/documents".replace("{applicationId}", ApiClient.urlEncode(applicationId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        if (contentType != null) {
            localVarRequestBuilder.header("Content-Type", contentType.toString());
        }
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitApplicationFormResponse createApplicationForm(CreateApplicationFormRequest createApplicationFormRequest) throws ApiException {
        ApiResponse<UnitApplicationFormResponse> localVarResponse = this.createApplicationFormWithHttpInfo(createApplicationFormRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitApplicationFormResponse> createApplicationFormWithHttpInfo(CreateApplicationFormRequest createApplicationFormRequest) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.createApplicationFormRequestBuilder(createApplicationFormRequest);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("createApplicationForm", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitApplicationFormResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitApplicationFormResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder createApplicationFormRequestBuilder(CreateApplicationFormRequest createApplicationFormRequest) throws ApiException {
        if (createApplicationFormRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'createApplicationFormRequest' when calling createApplicationForm");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/application-forms";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/vnd.api+json");
        localVarRequestBuilder.header("Accept", "application/vnd.api+json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)createApplicationFormRequest);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitCardsListResponse createCard(CreateCardRequest createCardRequest) throws ApiException {
        ApiResponse<UnitCardsListResponse> localVarResponse = this.createCardWithHttpInfo(createCardRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitCardsListResponse> createCardWithHttpInfo(CreateCardRequest createCardRequest) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.createCardRequestBuilder(createCardRequest);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("createCard", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitCardsListResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitCardsListResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder createCardRequestBuilder(CreateCardRequest createCardRequest) throws ApiException {
        if (createCardRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'createCardRequest' when calling createCard");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/cards";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/vnd.api+json");
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)createCardRequest);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitListCheckDepositsResponse1 createCheckDeposit(CreateCheckDepositRequest createCheckDepositRequest) throws ApiException {
        ApiResponse<UnitListCheckDepositsResponse1> localVarResponse = this.createCheckDepositWithHttpInfo(createCheckDepositRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitListCheckDepositsResponse1> createCheckDepositWithHttpInfo(CreateCheckDepositRequest createCheckDepositRequest) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.createCheckDepositRequestBuilder(createCheckDepositRequest);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("createCheckDeposit", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitListCheckDepositsResponse1)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitListCheckDepositsResponse1>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder createCheckDepositRequestBuilder(CreateCheckDepositRequest createCheckDepositRequest) throws ApiException {
        if (createCheckDepositRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'createCheckDepositRequest' when calling createCheckDeposit");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/check-deposits";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/vnd.api+json");
        localVarRequestBuilder.header("Accept", "application/vnd.api+json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)createCheckDepositRequest);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitCheckPaymentResponse createCheckPayment(CreateCheckPaymentRequest createCheckPaymentRequest) throws ApiException {
        ApiResponse<UnitCheckPaymentResponse> localVarResponse = this.createCheckPaymentWithHttpInfo(createCheckPaymentRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitCheckPaymentResponse> createCheckPaymentWithHttpInfo(CreateCheckPaymentRequest createCheckPaymentRequest) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.createCheckPaymentRequestBuilder(createCheckPaymentRequest);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("createCheckPayment", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitCheckPaymentResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitCheckPaymentResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder createCheckPaymentRequestBuilder(CreateCheckPaymentRequest createCheckPaymentRequest) throws ApiException {
        if (createCheckPaymentRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'createCheckPaymentRequest' when calling createCheckPayment");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/check-payments";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/vnd.api+json");
        localVarRequestBuilder.header("Accept", "application/vnd.api+json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)createCheckPaymentRequest);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitCounterpartyResponse createCounterparty(CreateCounterpartyRequest createCounterpartyRequest) throws ApiException {
        ApiResponse<UnitCounterpartyResponse> localVarResponse = this.createCounterpartyWithHttpInfo(createCounterpartyRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitCounterpartyResponse> createCounterpartyWithHttpInfo(CreateCounterpartyRequest createCounterpartyRequest) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.createCounterpartyRequestBuilder(createCounterpartyRequest);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("createCounterparty", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitCounterpartyResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitCounterpartyResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder createCounterpartyRequestBuilder(CreateCounterpartyRequest createCounterpartyRequest) throws ApiException {
        if (createCounterpartyRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'createCounterpartyRequest' when calling createCounterparty");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/counterparties";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/vnd.api+json");
        localVarRequestBuilder.header("Accept", "application/vnd.api+json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)createCounterpartyRequest);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitCustomerTokenResponse createCustomerToken(String customerId, CreateCustomerTokenRequest createCustomerTokenRequest) throws ApiException {
        ApiResponse<UnitCustomerTokenResponse> localVarResponse = this.createCustomerTokenWithHttpInfo(customerId, createCustomerTokenRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitCustomerTokenResponse> createCustomerTokenWithHttpInfo(String customerId, CreateCustomerTokenRequest createCustomerTokenRequest) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.createCustomerTokenRequestBuilder(customerId, createCustomerTokenRequest);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("createCustomerToken", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitCustomerTokenResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitCustomerTokenResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder createCustomerTokenRequestBuilder(String customerId, CreateCustomerTokenRequest createCustomerTokenRequest) throws ApiException {
        if (customerId == null) {
            throw new ApiException(400, "Missing the required parameter 'customerId' when calling createCustomerToken");
        }
        if (createCustomerTokenRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'createCustomerTokenRequest' when calling createCustomerToken");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/customers/{customerId}/token".replace("{customerId}", ApiClient.urlEncode(customerId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/vnd.api+json");
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)createCustomerTokenRequest);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitCustomerTokenVerificationResponse createCustomerTokenVerification(String customerId, CreateCustomerTokenVerificationRequest createCustomerTokenVerificationRequest) throws ApiException {
        ApiResponse<UnitCustomerTokenVerificationResponse> localVarResponse = this.createCustomerTokenVerificationWithHttpInfo(customerId, createCustomerTokenVerificationRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitCustomerTokenVerificationResponse> createCustomerTokenVerificationWithHttpInfo(String customerId, CreateCustomerTokenVerificationRequest createCustomerTokenVerificationRequest) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.createCustomerTokenVerificationRequestBuilder(customerId, createCustomerTokenVerificationRequest);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("createCustomerTokenVerification", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitCustomerTokenVerificationResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitCustomerTokenVerificationResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder createCustomerTokenVerificationRequestBuilder(String customerId, CreateCustomerTokenVerificationRequest createCustomerTokenVerificationRequest) throws ApiException {
        if (customerId == null) {
            throw new ApiException(400, "Missing the required parameter 'customerId' when calling createCustomerTokenVerification");
        }
        if (createCustomerTokenVerificationRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'createCustomerTokenVerificationRequest' when calling createCustomerTokenVerification");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/customers/{customerId}/token/verification".replace("{customerId}", ApiClient.urlEncode(customerId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/vnd.api+json");
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)createCustomerTokenVerificationRequest);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitFeeResponse createFee(CreateFeeRequest createFeeRequest) throws ApiException {
        ApiResponse<UnitFeeResponse> localVarResponse = this.createFeeWithHttpInfo(createFeeRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitFeeResponse> createFeeWithHttpInfo(CreateFeeRequest createFeeRequest) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.createFeeRequestBuilder(createFeeRequest);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("createFee", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitFeeResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitFeeResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder createFeeRequestBuilder(CreateFeeRequest createFeeRequest) throws ApiException {
        if (createFeeRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'createFeeRequest' when calling createFee");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/fees";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/vnd.api+json");
        localVarRequestBuilder.header("Accept", "application/vnd.api+json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)createFeeRequest);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitPaymentResponse createPayment(CreatePaymentRequest createPaymentRequest) throws ApiException {
        ApiResponse<UnitPaymentResponse> localVarResponse = this.createPaymentWithHttpInfo(createPaymentRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitPaymentResponse> createPaymentWithHttpInfo(CreatePaymentRequest createPaymentRequest) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.createPaymentRequestBuilder(createPaymentRequest);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("createPayment", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitPaymentResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitPaymentResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder createPaymentRequestBuilder(CreatePaymentRequest createPaymentRequest) throws ApiException {
        if (createPaymentRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'createPaymentRequest' when calling createPayment");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/payments";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/vnd.api+json");
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)createPaymentRequest);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitRecurringPaymentResponse createRecurringPayment(CreateRecurringPaymentRequest createRecurringPaymentRequest) throws ApiException {
        ApiResponse<UnitRecurringPaymentResponse> localVarResponse = this.createRecurringPaymentWithHttpInfo(createRecurringPaymentRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitRecurringPaymentResponse> createRecurringPaymentWithHttpInfo(CreateRecurringPaymentRequest createRecurringPaymentRequest) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.createRecurringPaymentRequestBuilder(createRecurringPaymentRequest);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("createRecurringPayment", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitRecurringPaymentResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitRecurringPaymentResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder createRecurringPaymentRequestBuilder(CreateRecurringPaymentRequest createRecurringPaymentRequest) throws ApiException {
        if (createRecurringPaymentRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'createRecurringPaymentRequest' when calling createRecurringPayment");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/recurring-payments";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/vnd.api+json");
        localVarRequestBuilder.header("Accept", "application/vnd.api+json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)createRecurringPaymentRequest);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitRecurringRepaymentResponse createRecurringRepayment(CreateRecurringRepaymentRequest createRecurringRepaymentRequest) throws ApiException {
        ApiResponse<UnitRecurringRepaymentResponse> localVarResponse = this.createRecurringRepaymentWithHttpInfo(createRecurringRepaymentRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitRecurringRepaymentResponse> createRecurringRepaymentWithHttpInfo(CreateRecurringRepaymentRequest createRecurringRepaymentRequest) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.createRecurringRepaymentRequestBuilder(createRecurringRepaymentRequest);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("createRecurringRepayment", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitRecurringRepaymentResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitRecurringRepaymentResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder createRecurringRepaymentRequestBuilder(CreateRecurringRepaymentRequest createRecurringRepaymentRequest) throws ApiException {
        if (createRecurringRepaymentRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'createRecurringRepaymentRequest' when calling createRecurringRepayment");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/recurring-repayments";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/vnd.api+json");
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)createRecurringRepaymentRequest);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitRepaymentResponse createRepayment(CreateRepaymentRequest createRepaymentRequest) throws ApiException {
        ApiResponse<UnitRepaymentResponse> localVarResponse = this.createRepaymentWithHttpInfo(createRepaymentRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitRepaymentResponse> createRepaymentWithHttpInfo(CreateRepaymentRequest createRepaymentRequest) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.createRepaymentRequestBuilder(createRepaymentRequest);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("createRepayment", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitRepaymentResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitRepaymentResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder createRepaymentRequestBuilder(CreateRepaymentRequest createRepaymentRequest) throws ApiException {
        if (createRepaymentRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'createRepaymentRequest' when calling createRepayment");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/repayments";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/vnd.api+json");
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)createRepaymentRequest);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitRewardResponse createReward(CreateRewardRequest createRewardRequest) throws ApiException {
        ApiResponse<UnitRewardResponse> localVarResponse = this.createRewardWithHttpInfo(createRewardRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitRewardResponse> createRewardWithHttpInfo(CreateRewardRequest createRewardRequest) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.createRewardRequestBuilder(createRewardRequest);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("createReward", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitRewardResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitRewardResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder createRewardRequestBuilder(CreateRewardRequest createRewardRequest) throws ApiException {
        if (createRewardRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'createRewardRequest' when calling createReward");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/rewards";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/vnd.api+json");
        localVarRequestBuilder.header("Accept", "application/vnd.api+json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)createRewardRequest);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public StopPaymentResponse createStopPayment(CreateStopPaymentRequest createStopPaymentRequest) throws ApiException {
        ApiResponse<StopPaymentResponse> localVarResponse = this.createStopPaymentWithHttpInfo(createStopPaymentRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<StopPaymentResponse> createStopPaymentWithHttpInfo(CreateStopPaymentRequest createStopPaymentRequest) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.createStopPaymentRequestBuilder(createStopPaymentRequest);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("createStopPayment", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (StopPaymentResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<StopPaymentResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder createStopPaymentRequestBuilder(CreateStopPaymentRequest createStopPaymentRequest) throws ApiException {
        if (createStopPaymentRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'createStopPaymentRequest' when calling createStopPayment");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/stop-payments";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)createStopPaymentRequest);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public WebhookResponse createWebhook(CreateWebhook createWebhook) throws ApiException {
        ApiResponse<WebhookResponse> localVarResponse = this.createWebhookWithHttpInfo(createWebhook);
        return localVarResponse.getData();
    }

    public ApiResponse<WebhookResponse> createWebhookWithHttpInfo(CreateWebhook createWebhook) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.createWebhookRequestBuilder(createWebhook);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("createWebhook", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (WebhookResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<WebhookResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder createWebhookRequestBuilder(CreateWebhook createWebhook) throws ApiException {
        if (createWebhook == null) {
            throw new ApiException(400, "Missing the required parameter 'createWebhook' when calling createWebhook");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/webhooks";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/vnd.api+json");
        localVarRequestBuilder.header("Accept", "application/vnd.api+json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)createWebhook);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitAccountResponse deactivateControlAgreementForAccount(String accountId) throws ApiException {
        ApiResponse<UnitAccountResponse> localVarResponse = this.deactivateControlAgreementForAccountWithHttpInfo(accountId);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitAccountResponse> deactivateControlAgreementForAccountWithHttpInfo(String accountId) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.deactivateControlAgreementForAccountRequestBuilder(accountId);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("deactivateControlAgreementForAccount", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitAccountResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitAccountResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder deactivateControlAgreementForAccountRequestBuilder(String accountId) throws ApiException {
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deactivateControlAgreementForAccount");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/accounts/{accountId}/deactivate-daca".replace("{accountId}", ApiClient.urlEncode(accountId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitAuthorizationRequestResponse declineAuthorizationRequest(String authorizationId, DeclineAuthorizationRequest declineAuthorizationRequest) throws ApiException {
        ApiResponse<UnitAuthorizationRequestResponse> localVarResponse = this.declineAuthorizationRequestWithHttpInfo(authorizationId, declineAuthorizationRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitAuthorizationRequestResponse> declineAuthorizationRequestWithHttpInfo(String authorizationId, DeclineAuthorizationRequest declineAuthorizationRequest) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.declineAuthorizationRequestRequestBuilder(authorizationId, declineAuthorizationRequest);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("declineAuthorizationRequest", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitAuthorizationRequestResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitAuthorizationRequestResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder declineAuthorizationRequestRequestBuilder(String authorizationId, DeclineAuthorizationRequest declineAuthorizationRequest) throws ApiException {
        if (authorizationId == null) {
            throw new ApiException(400, "Missing the required parameter 'authorizationId' when calling declineAuthorizationRequest");
        }
        if (declineAuthorizationRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'declineAuthorizationRequest' when calling declineAuthorizationRequest");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/authorization-requests/{authorizationId}/decline".replace("{authorizationId}", ApiClient.urlEncode(authorizationId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/vnd.api+json");
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)declineAuthorizationRequest);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public void deleteCounterparty(String counterpartyId) throws ApiException {
        this.deleteCounterpartyWithHttpInfo(counterpartyId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApiResponse<Void> deleteCounterpartyWithHttpInfo(String counterpartyId) throws ApiException {
        ApiResponse<Object> apiResponse;
        HttpRequest.Builder localVarRequestBuilder = this.deleteCounterpartyRequestBuilder(counterpartyId);
        HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
        if (this.memberVarResponseInterceptor != null) {
            this.memberVarResponseInterceptor.accept(localVarResponse);
        }
        try {
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("deleteCounterparty", localVarResponse);
            }
            apiResponse = new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
        }
        catch (Throwable throwable) {
            try {
                while (localVarResponse.body().read() != -1) {
                }
                localVarResponse.body().close();
                throw throwable;
            }
            catch (IOException e) {
                throw new ApiException(e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new ApiException(e);
            }
        }
        while (localVarResponse.body().read() != -1) {
        }
        localVarResponse.body().close();
        return apiResponse;
    }

    private HttpRequest.Builder deleteCounterpartyRequestBuilder(String counterpartyId) throws ApiException {
        if (counterpartyId == null) {
            throw new ApiException(400, "Missing the required parameter 'counterpartyId' when calling deleteCounterparty");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/counterparties/{counterpartyId}".replace("{counterpartyId}", ApiClient.urlEncode(counterpartyId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("DELETE", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitApiTokenResponse deleteToken(String userId, String tokenId) throws ApiException {
        ApiResponse<UnitApiTokenResponse> localVarResponse = this.deleteTokenWithHttpInfo(userId, tokenId);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitApiTokenResponse> deleteTokenWithHttpInfo(String userId, String tokenId) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.deleteTokenRequestBuilder(userId, tokenId);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("deleteToken", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitApiTokenResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitApiTokenResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder deleteTokenRequestBuilder(String userId, String tokenId) throws ApiException {
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling deleteToken");
        }
        if (tokenId == null) {
            throw new ApiException(400, "Missing the required parameter 'tokenId' when calling deleteToken");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/users/{userId}/api-tokens/{tokenId}".replace("{userId}", ApiClient.urlEncode(userId.toString())).replace("{tokenId}", ApiClient.urlEncode(tokenId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        localVarRequestBuilder.method("DELETE", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitRecurringPaymentResponse disableRecurringPayment(String paymentId) throws ApiException {
        ApiResponse<UnitRecurringPaymentResponse> localVarResponse = this.disableRecurringPaymentWithHttpInfo(paymentId);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitRecurringPaymentResponse> disableRecurringPaymentWithHttpInfo(String paymentId) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.disableRecurringPaymentRequestBuilder(paymentId);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("disableRecurringPayment", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitRecurringPaymentResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitRecurringPaymentResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder disableRecurringPaymentRequestBuilder(String paymentId) throws ApiException {
        if (paymentId == null) {
            throw new ApiException(400, "Missing the required parameter 'paymentId' when calling disableRecurringPayment");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/recurring-payments/{paymentId}/disable".replace("{paymentId}", ApiClient.urlEncode(paymentId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitRecurringRepaymentResponse disableRecurringRepayment(String recurringRepaymentId, String include) throws ApiException {
        ApiResponse<UnitRecurringRepaymentResponse> localVarResponse = this.disableRecurringRepaymentWithHttpInfo(recurringRepaymentId, include);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitRecurringRepaymentResponse> disableRecurringRepaymentWithHttpInfo(String recurringRepaymentId, String include) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.disableRecurringRepaymentRequestBuilder(recurringRepaymentId, include);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("disableRecurringRepayment", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitRecurringRepaymentResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitRecurringRepaymentResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder disableRecurringRepaymentRequestBuilder(String recurringRepaymentId, String include) throws ApiException {
        if (recurringRepaymentId == null) {
            throw new ApiException(400, "Missing the required parameter 'recurringRepaymentId' when calling disableRecurringRepayment");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/recurring-repayments/{recurringRepaymentId}/disable".replace("{recurringRepaymentId}", ApiClient.urlEncode(recurringRepaymentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName = "include";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("include", include));
        if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + "=" + p.getValue()));
            if (localVarQueryStringJoiner.length() != 0) {
                queryJoiner.add(localVarQueryStringJoiner.toString());
            }
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public StopPaymentResponse disableStopPayment(String stopPaymentId) throws ApiException {
        ApiResponse<StopPaymentResponse> localVarResponse = this.disableStopPaymentWithHttpInfo(stopPaymentId);
        return localVarResponse.getData();
    }

    public ApiResponse<StopPaymentResponse> disableStopPaymentWithHttpInfo(String stopPaymentId) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.disableStopPaymentRequestBuilder(stopPaymentId);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("disableStopPayment", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (StopPaymentResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<StopPaymentResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder disableStopPaymentRequestBuilder(String stopPaymentId) throws ApiException {
        if (stopPaymentId == null) {
            throw new ApiException(400, "Missing the required parameter 'stopPaymentId' when calling disableStopPayment");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/stop-payments/{stopPaymentId}/disable".replace("{stopPaymentId}", ApiClient.urlEncode(stopPaymentId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public WebhookResponse disableWebhook(String webhookId) throws ApiException {
        ApiResponse<WebhookResponse> localVarResponse = this.disableWebhookWithHttpInfo(webhookId);
        return localVarResponse.getData();
    }

    public ApiResponse<WebhookResponse> disableWebhookWithHttpInfo(String webhookId) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.disableWebhookRequestBuilder(webhookId);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("disableWebhook", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (WebhookResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<WebhookResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder disableWebhookRequestBuilder(String webhookId) throws ApiException {
        if (webhookId == null) {
            throw new ApiException(400, "Missing the required parameter 'webhookId' when calling disableWebhook");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/webhooks/{webhookId}/disable".replace("{webhookId}", ApiClient.urlEncode(webhookId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public File downloadApplicationBackSideDocument(String applicationId, String documentId) throws ApiException {
        ApiResponse<File> localVarResponse = this.downloadApplicationBackSideDocumentWithHttpInfo(applicationId, documentId);
        return localVarResponse.getData();
    }

    public ApiResponse<File> downloadApplicationBackSideDocumentWithHttpInfo(String applicationId, String documentId) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.downloadApplicationBackSideDocumentRequestBuilder(applicationId, documentId);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("downloadApplicationBackSideDocument", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (File)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<File>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder downloadApplicationBackSideDocumentRequestBuilder(String applicationId, String documentId) throws ApiException {
        if (applicationId == null) {
            throw new ApiException(400, "Missing the required parameter 'applicationId' when calling downloadApplicationBackSideDocument");
        }
        if (documentId == null) {
            throw new ApiException(400, "Missing the required parameter 'documentId' when calling downloadApplicationBackSideDocument");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/applications/{applicationId}/documents/{documentId}/download/back".replace("{applicationId}", ApiClient.urlEncode(applicationId.toString())).replace("{documentId}", ApiClient.urlEncode(documentId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/octet-stream");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public File downloadApplicationDocument(String applicationId, String documentId) throws ApiException {
        ApiResponse<File> localVarResponse = this.downloadApplicationDocumentWithHttpInfo(applicationId, documentId);
        return localVarResponse.getData();
    }

    public ApiResponse<File> downloadApplicationDocumentWithHttpInfo(String applicationId, String documentId) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.downloadApplicationDocumentRequestBuilder(applicationId, documentId);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("downloadApplicationDocument", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (File)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<File>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder downloadApplicationDocumentRequestBuilder(String applicationId, String documentId) throws ApiException {
        if (applicationId == null) {
            throw new ApiException(400, "Missing the required parameter 'applicationId' when calling downloadApplicationDocument");
        }
        if (documentId == null) {
            throw new ApiException(400, "Missing the required parameter 'documentId' when calling downloadApplicationDocument");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/applications/{applicationId}/documents/{documentId}/download".replace("{applicationId}", ApiClient.urlEncode(applicationId.toString())).replace("{documentId}", ApiClient.urlEncode(documentId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/octet-stream");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitRecurringPaymentResponse enableRecurringPayment(String paymentId) throws ApiException {
        ApiResponse<UnitRecurringPaymentResponse> localVarResponse = this.enableRecurringPaymentWithHttpInfo(paymentId);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitRecurringPaymentResponse> enableRecurringPaymentWithHttpInfo(String paymentId) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.enableRecurringPaymentRequestBuilder(paymentId);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("enableRecurringPayment", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitRecurringPaymentResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitRecurringPaymentResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder enableRecurringPaymentRequestBuilder(String paymentId) throws ApiException {
        if (paymentId == null) {
            throw new ApiException(400, "Missing the required parameter 'paymentId' when calling enableRecurringPayment");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/recurring-payments/{paymentId}/enable".replace("{paymentId}", ApiClient.urlEncode(paymentId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitRecurringRepaymentResponse enableRecurringRepayment(String recurringRepaymentId, String include) throws ApiException {
        ApiResponse<UnitRecurringRepaymentResponse> localVarResponse = this.enableRecurringRepaymentWithHttpInfo(recurringRepaymentId, include);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitRecurringRepaymentResponse> enableRecurringRepaymentWithHttpInfo(String recurringRepaymentId, String include) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.enableRecurringRepaymentRequestBuilder(recurringRepaymentId, include);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("enableRecurringRepayment", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitRecurringRepaymentResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitRecurringRepaymentResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder enableRecurringRepaymentRequestBuilder(String recurringRepaymentId, String include) throws ApiException {
        if (recurringRepaymentId == null) {
            throw new ApiException(400, "Missing the required parameter 'recurringRepaymentId' when calling enableRecurringRepayment");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/recurring-repayments/{recurringRepaymentId}/enable".replace("{recurringRepaymentId}", ApiClient.urlEncode(recurringRepaymentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName = "include";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("include", include));
        if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + "=" + p.getValue()));
            if (localVarQueryStringJoiner.length() != 0) {
                queryJoiner.add(localVarQueryStringJoiner.toString());
            }
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public WebhookResponse enableWebhook(String webhookId) throws ApiException {
        ApiResponse<WebhookResponse> localVarResponse = this.enableWebhookWithHttpInfo(webhookId);
        return localVarResponse.getData();
    }

    public ApiResponse<WebhookResponse> enableWebhookWithHttpInfo(String webhookId) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.enableWebhookRequestBuilder(webhookId);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("enableWebhook", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (WebhookResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<WebhookResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder enableWebhookRequestBuilder(String webhookId) throws ApiException {
        if (webhookId == null) {
            throw new ApiException(400, "Missing the required parameter 'webhookId' when calling enableWebhook");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/webhooks/{webhookId}/enable".replace("{webhookId}", ApiClient.urlEncode(webhookId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitAccountResponse enterControlAgreementForAccount(String accountId) throws ApiException {
        ApiResponse<UnitAccountResponse> localVarResponse = this.enterControlAgreementForAccountWithHttpInfo(accountId);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitAccountResponse> enterControlAgreementForAccountWithHttpInfo(String accountId) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.enterControlAgreementForAccountRequestBuilder(accountId);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("enterControlAgreementForAccount", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitAccountResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitAccountResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder enterControlAgreementForAccountRequestBuilder(String accountId) throws ApiException {
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling enterControlAgreementForAccount");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/accounts/{accountId}/enter-daca".replace("{accountId}", ApiClient.urlEncode(accountId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitEventResponse fireEvent(String eventId) throws ApiException {
        ApiResponse<UnitEventResponse> localVarResponse = this.fireEventWithHttpInfo(eventId);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitEventResponse> fireEventWithHttpInfo(String eventId) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.fireEventRequestBuilder(eventId);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("fireEvent", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitEventResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitEventResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder fireEventRequestBuilder(String eventId) throws ApiException {
        if (eventId == null) {
            throw new ApiException(400, "Missing the required parameter 'eventId' when calling fireEvent");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/events/{eventId}".replace("{eventId}", ApiClient.urlEncode(eventId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitAccountResponse freezeAccount(String accountId, FreezeAccountRequest freezeAccountRequest) throws ApiException {
        ApiResponse<UnitAccountResponse> localVarResponse = this.freezeAccountWithHttpInfo(accountId, freezeAccountRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitAccountResponse> freezeAccountWithHttpInfo(String accountId, FreezeAccountRequest freezeAccountRequest) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.freezeAccountRequestBuilder(accountId, freezeAccountRequest);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("freezeAccount", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitAccountResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitAccountResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder freezeAccountRequestBuilder(String accountId, FreezeAccountRequest freezeAccountRequest) throws ApiException {
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling freezeAccount");
        }
        if (freezeAccountRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'freezeAccountRequest' when calling freezeAccount");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/accounts/{accountId}/freeze".replace("{accountId}", ApiClient.urlEncode(accountId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/vnd.api+json");
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)freezeAccountRequest);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitFreezeCardResponse freezeCard(String cardId) throws ApiException {
        ApiResponse<UnitFreezeCardResponse> localVarResponse = this.freezeCardWithHttpInfo(cardId);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitFreezeCardResponse> freezeCardWithHttpInfo(String cardId) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.freezeCardRequestBuilder(cardId);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("freezeCard", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitFreezeCardResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitFreezeCardResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder freezeCardRequestBuilder(String cardId) throws ApiException {
        if (cardId == null) {
            throw new ApiException(400, "Missing the required parameter 'cardId' when calling freezeCard");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/cards/{cardId}/freeze".replace("{cardId}", ApiClient.urlEncode(cardId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitAccountResponseWithIncluded getAccount(String accountId, String include) throws ApiException {
        ApiResponse<UnitAccountResponseWithIncluded> localVarResponse = this.getAccountWithHttpInfo(accountId, include);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitAccountResponseWithIncluded> getAccountWithHttpInfo(String accountId, String include) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.getAccountRequestBuilder(accountId, include);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("getAccount", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitAccountResponseWithIncluded)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitAccountResponseWithIncluded>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder getAccountRequestBuilder(String accountId, String include) throws ApiException {
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getAccount");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/accounts/{accountId}".replace("{accountId}", ApiClient.urlEncode(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName = "include";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("include", include));
        if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + "=" + p.getValue()));
            if (localVarQueryStringJoiner.length() != 0) {
                queryJoiner.add(localVarQueryStringJoiner.toString());
            }
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitGetAccountEndOfDayListResponse getAccountEndOfDay() throws ApiException {
        ApiResponse<UnitGetAccountEndOfDayListResponse> localVarResponse = this.getAccountEndOfDayWithHttpInfo();
        return localVarResponse.getData();
    }

    public ApiResponse<UnitGetAccountEndOfDayListResponse> getAccountEndOfDayWithHttpInfo() throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.getAccountEndOfDayRequestBuilder();
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("getAccountEndOfDay", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitGetAccountEndOfDayListResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitGetAccountEndOfDayListResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder getAccountEndOfDayRequestBuilder() throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/account-end-of-day";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitGetAccountLimitsResponse getAccountLimits(String accountId) throws ApiException {
        ApiResponse<UnitGetAccountLimitsResponse> localVarResponse = this.getAccountLimitsWithHttpInfo(accountId);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitGetAccountLimitsResponse> getAccountLimitsWithHttpInfo(String accountId) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.getAccountLimitsRequestBuilder(accountId);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("getAccountLimits", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitGetAccountLimitsResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitGetAccountLimitsResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder getAccountLimitsRequestBuilder(String accountId) throws ApiException {
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getAccountLimits");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/accounts/{accountId}/limits".replace("{accountId}", ApiClient.urlEncode(accountId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitAccountsListResponse getAccountsList(ListPageParameters page, GetAccountsListFilterParameter filter, String include) throws ApiException {
        ApiResponse<UnitAccountsListResponse> localVarResponse = this.getAccountsListWithHttpInfo(page, filter, include);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitAccountsListResponse> getAccountsListWithHttpInfo(ListPageParameters page, GetAccountsListFilterParameter filter, String include) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.getAccountsListRequestBuilder(page, filter, include);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("getAccountsList", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitAccountsListResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitAccountsListResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder getAccountsListRequestBuilder(ListPageParameters page, GetAccountsListFilterParameter filter, String include) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/accounts";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName = "page";
        if (page != null) {
            localVarQueryStringJoiner.add(page.toUrlQueryString("page"));
        }
        localVarQueryParameterBaseName = "filter";
        if (filter != null) {
            localVarQueryStringJoiner.add(filter.toUrlQueryString("filter"));
        }
        localVarQueryParameterBaseName = "include";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("include", include));
        if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + "=" + p.getValue()));
            if (localVarQueryStringJoiner.length() != 0) {
                queryJoiner.add(localVarQueryStringJoiner.toString());
            }
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitOrgApiTokensListResponse getApiTokensList(String userId) throws ApiException {
        ApiResponse<UnitOrgApiTokensListResponse> localVarResponse = this.getApiTokensListWithHttpInfo(userId);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitOrgApiTokensListResponse> getApiTokensListWithHttpInfo(String userId) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.getApiTokensListRequestBuilder(userId);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("getApiTokensList", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitOrgApiTokensListResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitOrgApiTokensListResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder getApiTokensListRequestBuilder(String userId) throws ApiException {
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling getApiTokensList");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/users/{userId}/api-tokens".replace("{userId}", ApiClient.urlEncode(userId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitApplicationResponseWithIncluded getApplication(String applicationId, String included) throws ApiException {
        ApiResponse<UnitApplicationResponseWithIncluded> localVarResponse = this.getApplicationWithHttpInfo(applicationId, included);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitApplicationResponseWithIncluded> getApplicationWithHttpInfo(String applicationId, String included) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.getApplicationRequestBuilder(applicationId, included);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("getApplication", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitApplicationResponseWithIncluded)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitApplicationResponseWithIncluded>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder getApplicationRequestBuilder(String applicationId, String included) throws ApiException {
        if (applicationId == null) {
            throw new ApiException(400, "Missing the required parameter 'applicationId' when calling getApplication");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/applications/{applicationId}".replace("{applicationId}", ApiClient.urlEncode(applicationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName = "included";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("included", included));
        if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + "=" + p.getValue()));
            if (localVarQueryStringJoiner.length() != 0) {
                queryJoiner.add(localVarQueryStringJoiner.toString());
            }
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitListDocumentsResponse getApplicationDocuments(String applicationId) throws ApiException {
        ApiResponse<UnitListDocumentsResponse> localVarResponse = this.getApplicationDocumentsWithHttpInfo(applicationId);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitListDocumentsResponse> getApplicationDocumentsWithHttpInfo(String applicationId) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.getApplicationDocumentsRequestBuilder(applicationId);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("getApplicationDocuments", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitListDocumentsResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitListDocumentsResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder getApplicationDocumentsRequestBuilder(String applicationId) throws ApiException {
        if (applicationId == null) {
            throw new ApiException(400, "Missing the required parameter 'applicationId' when calling getApplicationDocuments");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/applications/{applicationId}/documents".replace("{applicationId}", ApiClient.urlEncode(applicationId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitApplicationFormResponseWithIncluded getApplicationForm(String applicationFormId, String included) throws ApiException {
        ApiResponse<UnitApplicationFormResponseWithIncluded> localVarResponse = this.getApplicationFormWithHttpInfo(applicationFormId, included);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitApplicationFormResponseWithIncluded> getApplicationFormWithHttpInfo(String applicationFormId, String included) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.getApplicationFormRequestBuilder(applicationFormId, included);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("getApplicationForm", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitApplicationFormResponseWithIncluded)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitApplicationFormResponseWithIncluded>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder getApplicationFormRequestBuilder(String applicationFormId, String included) throws ApiException {
        if (applicationFormId == null) {
            throw new ApiException(400, "Missing the required parameter 'applicationFormId' when calling getApplicationForm");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/application-forms/{applicationFormId}".replace("{applicationFormId}", ApiClient.urlEncode(applicationFormId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName = "included";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("included", included));
        if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + "=" + p.getValue()));
            if (localVarQueryStringJoiner.length() != 0) {
                queryJoiner.add(localVarQueryStringJoiner.toString());
            }
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitApplicationFormsListResponse getApplicationFormsList(ListPageParameters page, GetApplicationFormsListFilterParameter filter, String sort) throws ApiException {
        ApiResponse<UnitApplicationFormsListResponse> localVarResponse = this.getApplicationFormsListWithHttpInfo(page, filter, sort);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitApplicationFormsListResponse> getApplicationFormsListWithHttpInfo(ListPageParameters page, GetApplicationFormsListFilterParameter filter, String sort) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.getApplicationFormsListRequestBuilder(page, filter, sort);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("getApplicationFormsList", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitApplicationFormsListResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitApplicationFormsListResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder getApplicationFormsListRequestBuilder(ListPageParameters page, GetApplicationFormsListFilterParameter filter, String sort) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/application-forms";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName = "page";
        if (page != null) {
            localVarQueryStringJoiner.add(page.toUrlQueryString("page"));
        }
        localVarQueryParameterBaseName = "filter";
        if (filter != null) {
            localVarQueryStringJoiner.add(filter.toUrlQueryString("filter"));
        }
        localVarQueryParameterBaseName = "sort";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("sort", sort));
        if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + "=" + p.getValue()));
            if (localVarQueryStringJoiner.length() != 0) {
                queryJoiner.add(localVarQueryStringJoiner.toString());
            }
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitListApplicationsResponse getApplicationsList(ListPageParameters page, GetApplicationsListFilterParameter filter, String sort) throws ApiException {
        ApiResponse<UnitListApplicationsResponse> localVarResponse = this.getApplicationsListWithHttpInfo(page, filter, sort);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitListApplicationsResponse> getApplicationsListWithHttpInfo(ListPageParameters page, GetApplicationsListFilterParameter filter, String sort) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.getApplicationsListRequestBuilder(page, filter, sort);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("getApplicationsList", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitListApplicationsResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitListApplicationsResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder getApplicationsListRequestBuilder(ListPageParameters page, GetApplicationsListFilterParameter filter, String sort) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/applications";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName = "page";
        if (page != null) {
            localVarQueryStringJoiner.add(page.toUrlQueryString("page"));
        }
        localVarQueryParameterBaseName = "filter";
        if (filter != null) {
            localVarQueryStringJoiner.add(filter.toUrlQueryString("filter"));
        }
        localVarQueryParameterBaseName = "sort";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("sort", sort));
        if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + "=" + p.getValue()));
            if (localVarQueryStringJoiner.length() != 0) {
                queryJoiner.add(localVarQueryStringJoiner.toString());
            }
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "application/vnd.api+json, application/vnd.api+json; charset=utf-8");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public List<AtmLocation> getAtmLocationsList(GetAtmLocationsListFilterParameter filter) throws ApiException {
        ApiResponse<List<AtmLocation>> localVarResponse = this.getAtmLocationsListWithHttpInfo(filter);
        return localVarResponse.getData();
    }

    public ApiResponse<List<AtmLocation>> getAtmLocationsListWithHttpInfo(GetAtmLocationsListFilterParameter filter) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.getAtmLocationsListRequestBuilder(filter);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("getAtmLocationsList", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (List)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<List<AtmLocation>>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder getAtmLocationsListRequestBuilder(GetAtmLocationsListFilterParameter filter) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/atm-locations";
        ArrayList localVarQueryParams = new ArrayList();
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName = "filter";
        if (filter != null) {
            localVarQueryStringJoiner.add(filter.toUrlQueryString("filter"));
        }
        if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + "=" + p.getValue()));
            if (localVarQueryStringJoiner.length() != 0) {
                queryJoiner.add(localVarQueryStringJoiner.toString());
            }
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitAuthorizationResponse getAuthorization(String authorizationId, Boolean includeNoneAuthorized) throws ApiException {
        ApiResponse<UnitAuthorizationResponse> localVarResponse = this.getAuthorizationWithHttpInfo(authorizationId, includeNoneAuthorized);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitAuthorizationResponse> getAuthorizationWithHttpInfo(String authorizationId, Boolean includeNoneAuthorized) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.getAuthorizationRequestBuilder(authorizationId, includeNoneAuthorized);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("getAuthorization", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitAuthorizationResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitAuthorizationResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder getAuthorizationRequestBuilder(String authorizationId, Boolean includeNoneAuthorized) throws ApiException {
        if (authorizationId == null) {
            throw new ApiException(400, "Missing the required parameter 'authorizationId' when calling getAuthorization");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/authorizations/{authorizationId}".replace("{authorizationId}", ApiClient.urlEncode(authorizationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName = "includeNoneAuthorized";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("includeNoneAuthorized", includeNoneAuthorized));
        if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + "=" + p.getValue()));
            if (localVarQueryStringJoiner.length() != 0) {
                queryJoiner.add(localVarQueryStringJoiner.toString());
            }
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitAuthorizationRequestsResponse getAuthorizationRequest(String authorizationId) throws ApiException {
        ApiResponse<UnitAuthorizationRequestsResponse> localVarResponse = this.getAuthorizationRequestWithHttpInfo(authorizationId);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitAuthorizationRequestsResponse> getAuthorizationRequestWithHttpInfo(String authorizationId) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.getAuthorizationRequestRequestBuilder(authorizationId);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("getAuthorizationRequest", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitAuthorizationRequestsResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitAuthorizationRequestsResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder getAuthorizationRequestRequestBuilder(String authorizationId) throws ApiException {
        if (authorizationId == null) {
            throw new ApiException(400, "Missing the required parameter 'authorizationId' when calling getAuthorizationRequest");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/authorization-requests/{authorizationId}".replace("{authorizationId}", ApiClient.urlEncode(authorizationId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitListAuthorizationRequestsResponse getAuthorizationRequestsList(ListPageParameters page, GetAuthorizationRequestsListFilterParameter filter) throws ApiException {
        ApiResponse<UnitListAuthorizationRequestsResponse> localVarResponse = this.getAuthorizationRequestsListWithHttpInfo(page, filter);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitListAuthorizationRequestsResponse> getAuthorizationRequestsListWithHttpInfo(ListPageParameters page, GetAuthorizationRequestsListFilterParameter filter) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.getAuthorizationRequestsListRequestBuilder(page, filter);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("getAuthorizationRequestsList", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitListAuthorizationRequestsResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitListAuthorizationRequestsResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder getAuthorizationRequestsListRequestBuilder(ListPageParameters page, GetAuthorizationRequestsListFilterParameter filter) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/authorization-requests";
        ArrayList localVarQueryParams = new ArrayList();
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName = "page";
        if (page != null) {
            localVarQueryStringJoiner.add(page.toUrlQueryString("page"));
        }
        localVarQueryParameterBaseName = "filter";
        if (filter != null) {
            localVarQueryStringJoiner.add(filter.toUrlQueryString("filter"));
        }
        if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + "=" + p.getValue()));
            if (localVarQueryStringJoiner.length() != 0) {
                queryJoiner.add(localVarQueryStringJoiner.toString());
            }
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitListAuthorizationsResponse getAuthorizationsList(ListPageParameters page, GetAuthorizationsListFilterParameter filter, String sort) throws ApiException {
        ApiResponse<UnitListAuthorizationsResponse> localVarResponse = this.getAuthorizationsListWithHttpInfo(page, filter, sort);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitListAuthorizationsResponse> getAuthorizationsListWithHttpInfo(ListPageParameters page, GetAuthorizationsListFilterParameter filter, String sort) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.getAuthorizationsListRequestBuilder(page, filter, sort);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("getAuthorizationsList", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitListAuthorizationsResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitListAuthorizationsResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder getAuthorizationsListRequestBuilder(ListPageParameters page, GetAuthorizationsListFilterParameter filter, String sort) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/authorizations";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName = "page";
        if (page != null) {
            localVarQueryStringJoiner.add(page.toUrlQueryString("page"));
        }
        localVarQueryParameterBaseName = "filter";
        if (filter != null) {
            localVarQueryStringJoiner.add(filter.toUrlQueryString("filter"));
        }
        localVarQueryParameterBaseName = "sort";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("sort", sort));
        if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + "=" + p.getValue()));
            if (localVarQueryStringJoiner.length() != 0) {
                queryJoiner.add(localVarQueryStringJoiner.toString());
            }
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitBackCheckDepositResponse getBackCheckDeposit(String checkDepositId) throws ApiException {
        ApiResponse<UnitBackCheckDepositResponse> localVarResponse = this.getBackCheckDepositWithHttpInfo(checkDepositId);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitBackCheckDepositResponse> getBackCheckDepositWithHttpInfo(String checkDepositId) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.getBackCheckDepositRequestBuilder(checkDepositId);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("getBackCheckDeposit", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitBackCheckDepositResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitBackCheckDepositResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder getBackCheckDepositRequestBuilder(String checkDepositId) throws ApiException {
        if (checkDepositId == null) {
            throw new ApiException(400, "Missing the required parameter 'checkDepositId' when calling getBackCheckDeposit");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/check-deposits/{checkDepositId}/back".replace("{checkDepositId}", ApiClient.urlEncode(checkDepositId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitCardResponse getCard(String cardId, String included) throws ApiException {
        ApiResponse<UnitCardResponse> localVarResponse = this.getCardWithHttpInfo(cardId, included);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitCardResponse> getCardWithHttpInfo(String cardId, String included) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.getCardRequestBuilder(cardId, included);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("getCard", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitCardResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitCardResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder getCardRequestBuilder(String cardId, String included) throws ApiException {
        if (cardId == null) {
            throw new ApiException(400, "Missing the required parameter 'cardId' when calling getCard");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/cards/{cardId}".replace("{cardId}", ApiClient.urlEncode(cardId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName = "included";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("included", included));
        if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + "=" + p.getValue()));
            if (localVarQueryStringJoiner.length() != 0) {
                queryJoiner.add(localVarQueryStringJoiner.toString());
            }
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitCardLimitsResponse getCardLimits(String cardId) throws ApiException {
        ApiResponse<UnitCardLimitsResponse> localVarResponse = this.getCardLimitsWithHttpInfo(cardId);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitCardLimitsResponse> getCardLimitsWithHttpInfo(String cardId) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.getCardLimitsRequestBuilder(cardId);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("getCardLimits", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitCardLimitsResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitCardLimitsResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder getCardLimitsRequestBuilder(String cardId) throws ApiException {
        if (cardId == null) {
            throw new ApiException(400, "Missing the required parameter 'cardId' when calling getCardLimits");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/cards/{cardId}/limits".replace("{cardId}", ApiClient.urlEncode(cardId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitPinStatusResponse getCardPinStatus(String cardId) throws ApiException {
        ApiResponse<UnitPinStatusResponse> localVarResponse = this.getCardPinStatusWithHttpInfo(cardId);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitPinStatusResponse> getCardPinStatusWithHttpInfo(String cardId) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.getCardPinStatusRequestBuilder(cardId);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("getCardPinStatus", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitPinStatusResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitPinStatusResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder getCardPinStatusRequestBuilder(String cardId) throws ApiException {
        if (cardId == null) {
            throw new ApiException(400, "Missing the required parameter 'cardId' when calling getCardPinStatus");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/cards/{cardId}/secure-data/pin/status".replace("{cardId}", ApiClient.urlEncode(cardId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitCardResponseCardsList getCardsList(ListPageParameters page, GetCardsListFilterParameter filter, String include, String sort) throws ApiException {
        ApiResponse<UnitCardResponseCardsList> localVarResponse = this.getCardsListWithHttpInfo(page, filter, include, sort);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitCardResponseCardsList> getCardsListWithHttpInfo(ListPageParameters page, GetCardsListFilterParameter filter, String include, String sort) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.getCardsListRequestBuilder(page, filter, include, sort);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("getCardsList", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitCardResponseCardsList)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitCardResponseCardsList>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder getCardsListRequestBuilder(ListPageParameters page, GetCardsListFilterParameter filter, String include, String sort) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/cards";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName = "page";
        if (page != null) {
            localVarQueryStringJoiner.add(page.toUrlQueryString("page"));
        }
        localVarQueryParameterBaseName = "filter";
        if (filter != null) {
            localVarQueryStringJoiner.add(filter.toUrlQueryString("filter"));
        }
        localVarQueryParameterBaseName = "include";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("include", include));
        localVarQueryParameterBaseName = "sort";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("sort", sort));
        if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + "=" + p.getValue()));
            if (localVarQueryStringJoiner.length() != 0) {
                queryJoiner.add(localVarQueryStringJoiner.toString());
            }
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitCheckDepositResponse getCheckDeposit(String checkDepositId) throws ApiException {
        ApiResponse<UnitCheckDepositResponse> localVarResponse = this.getCheckDepositWithHttpInfo(checkDepositId);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitCheckDepositResponse> getCheckDepositWithHttpInfo(String checkDepositId) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.getCheckDepositRequestBuilder(checkDepositId);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("getCheckDeposit", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitCheckDepositResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitCheckDepositResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder getCheckDepositRequestBuilder(String checkDepositId) throws ApiException {
        if (checkDepositId == null) {
            throw new ApiException(400, "Missing the required parameter 'checkDepositId' when calling getCheckDeposit");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/check-deposits/{checkDepositId}".replace("{checkDepositId}", ApiClient.urlEncode(checkDepositId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitListCheckDepositsResponse getCheckDepositsList(ListPageParameters page, GetCheckDepositsListFilterParameter filter, String sort, String include) throws ApiException {
        ApiResponse<UnitListCheckDepositsResponse> localVarResponse = this.getCheckDepositsListWithHttpInfo(page, filter, sort, include);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitListCheckDepositsResponse> getCheckDepositsListWithHttpInfo(ListPageParameters page, GetCheckDepositsListFilterParameter filter, String sort, String include) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.getCheckDepositsListRequestBuilder(page, filter, sort, include);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("getCheckDepositsList", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitListCheckDepositsResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitListCheckDepositsResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder getCheckDepositsListRequestBuilder(ListPageParameters page, GetCheckDepositsListFilterParameter filter, String sort, String include) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/check-deposits";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName = "page";
        if (page != null) {
            localVarQueryStringJoiner.add(page.toUrlQueryString("page"));
        }
        localVarQueryParameterBaseName = "filter";
        if (filter != null) {
            localVarQueryStringJoiner.add(filter.toUrlQueryString("filter"));
        }
        localVarQueryParameterBaseName = "sort";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("sort", sort));
        localVarQueryParameterBaseName = "include";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("include", include));
        if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + "=" + p.getValue()));
            if (localVarQueryStringJoiner.length() != 0) {
                queryJoiner.add(localVarQueryStringJoiner.toString());
            }
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitCheckPaymentResponse getCheckPayment(String checkPaymentId) throws ApiException {
        ApiResponse<UnitCheckPaymentResponse> localVarResponse = this.getCheckPaymentWithHttpInfo(checkPaymentId);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitCheckPaymentResponse> getCheckPaymentWithHttpInfo(String checkPaymentId) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.getCheckPaymentRequestBuilder(checkPaymentId);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("getCheckPayment", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitCheckPaymentResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitCheckPaymentResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder getCheckPaymentRequestBuilder(String checkPaymentId) throws ApiException {
        if (checkPaymentId == null) {
            throw new ApiException(400, "Missing the required parameter 'checkPaymentId' when calling getCheckPayment");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/check-payments/{checkPaymentId}".replace("{checkPaymentId}", ApiClient.urlEncode(checkPaymentId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public File getCheckPaymentBack(String checkPaymentId) throws ApiException {
        ApiResponse<File> localVarResponse = this.getCheckPaymentBackWithHttpInfo(checkPaymentId);
        return localVarResponse.getData();
    }

    public ApiResponse<File> getCheckPaymentBackWithHttpInfo(String checkPaymentId) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.getCheckPaymentBackRequestBuilder(checkPaymentId);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("getCheckPaymentBack", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (File)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<File>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder getCheckPaymentBackRequestBuilder(String checkPaymentId) throws ApiException {
        if (checkPaymentId == null) {
            throw new ApiException(400, "Missing the required parameter 'checkPaymentId' when calling getCheckPaymentBack");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/check-payments/{checkPaymentId}/back".replace("{checkPaymentId}", ApiClient.urlEncode(checkPaymentId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "image/png");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public File getCheckPaymentFront(String checkPaymentId) throws ApiException {
        ApiResponse<File> localVarResponse = this.getCheckPaymentFrontWithHttpInfo(checkPaymentId);
        return localVarResponse.getData();
    }

    public ApiResponse<File> getCheckPaymentFrontWithHttpInfo(String checkPaymentId) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.getCheckPaymentFrontRequestBuilder(checkPaymentId);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("getCheckPaymentFront", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (File)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<File>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder getCheckPaymentFrontRequestBuilder(String checkPaymentId) throws ApiException {
        if (checkPaymentId == null) {
            throw new ApiException(400, "Missing the required parameter 'checkPaymentId' when calling getCheckPaymentFront");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/check-payments/{checkPaymentId}/front".replace("{checkPaymentId}", ApiClient.urlEncode(checkPaymentId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "image/png");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitListCheckPaymentsResponse getCheckPaymentsList(ListPageParameters page, GetCheckPaymentsListFilterParameter filter, String sort, String include) throws ApiException {
        ApiResponse<UnitListCheckPaymentsResponse> localVarResponse = this.getCheckPaymentsListWithHttpInfo(page, filter, sort, include);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitListCheckPaymentsResponse> getCheckPaymentsListWithHttpInfo(ListPageParameters page, GetCheckPaymentsListFilterParameter filter, String sort, String include) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.getCheckPaymentsListRequestBuilder(page, filter, sort, include);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("getCheckPaymentsList", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitListCheckPaymentsResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitListCheckPaymentsResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder getCheckPaymentsListRequestBuilder(ListPageParameters page, GetCheckPaymentsListFilterParameter filter, String sort, String include) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/check-payments";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName = "page";
        if (page != null) {
            localVarQueryStringJoiner.add(page.toUrlQueryString("page"));
        }
        localVarQueryParameterBaseName = "filter";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("accountId", filter.getAccountId()));
        localVarQueryParams.addAll(ApiClient.parameterToPairs("customerId", filter.getCustomerId()));
        localVarQueryParams.addAll(ApiClient.parameterToPairs("multi", "status", filter.getStatus()));
        localVarQueryParams.addAll(ApiClient.parameterToPairs("tags", filter.getTags()));
        localVarQueryParams.addAll(ApiClient.parameterToPairs("since", filter.getSince()));
        localVarQueryParams.addAll(ApiClient.parameterToPairs("until", filter.getUntil()));
        localVarQueryParams.addAll(ApiClient.parameterToPairs("fromAmount", filter.getFromAmount()));
        localVarQueryParams.addAll(ApiClient.parameterToPairs("toAmount", filter.getToAmount()));
        localVarQueryParams.addAll(ApiClient.parameterToPairs("checkNumber", filter.getCheckNumber()));
        localVarQueryParameterBaseName = "sort";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("sort", sort));
        localVarQueryParameterBaseName = "include";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("include", include));
        if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + "=" + p.getValue()));
            if (localVarQueryStringJoiner.length() != 0) {
                queryJoiner.add(localVarQueryStringJoiner.toString());
            }
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitCounterpartiesListResponse getCounterpartiesList(ListPageParameters page, GetCounterpartiesListFilterParameter filter, String sort) throws ApiException {
        ApiResponse<UnitCounterpartiesListResponse> localVarResponse = this.getCounterpartiesListWithHttpInfo(page, filter, sort);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitCounterpartiesListResponse> getCounterpartiesListWithHttpInfo(ListPageParameters page, GetCounterpartiesListFilterParameter filter, String sort) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.getCounterpartiesListRequestBuilder(page, filter, sort);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("getCounterpartiesList", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitCounterpartiesListResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitCounterpartiesListResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder getCounterpartiesListRequestBuilder(ListPageParameters page, GetCounterpartiesListFilterParameter filter, String sort) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/counterparties";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName = "page";
        if (page != null) {
            localVarQueryStringJoiner.add(page.toUrlQueryString("page"));
        }
        localVarQueryParameterBaseName = "filter";
        if (filter != null) {
            localVarQueryStringJoiner.add(filter.toUrlQueryString("filter"));
        }
        localVarQueryParameterBaseName = "sort";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("sort", sort));
        if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + "=" + p.getValue()));
            if (localVarQueryStringJoiner.length() != 0) {
                queryJoiner.add(localVarQueryStringJoiner.toString());
            }
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitCounterpartyResponse getCounterparty(String counterpartyId, String included) throws ApiException {
        ApiResponse<UnitCounterpartyResponse> localVarResponse = this.getCounterpartyWithHttpInfo(counterpartyId, included);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitCounterpartyResponse> getCounterpartyWithHttpInfo(String counterpartyId, String included) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.getCounterpartyRequestBuilder(counterpartyId, included);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("getCounterparty", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitCounterpartyResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitCounterpartyResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder getCounterpartyRequestBuilder(String counterpartyId, String included) throws ApiException {
        if (counterpartyId == null) {
            throw new ApiException(400, "Missing the required parameter 'counterpartyId' when calling getCounterparty");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/counterparties/{counterpartyId}".replace("{counterpartyId}", ApiClient.urlEncode(counterpartyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName = "included";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("included", included));
        if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + "=" + p.getValue()));
            if (localVarQueryStringJoiner.length() != 0) {
                queryJoiner.add(localVarQueryStringJoiner.toString());
            }
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitCounterpartyResponse1 getCounterpartyBalance(String counterpartyId) throws ApiException {
        ApiResponse<UnitCounterpartyResponse1> localVarResponse = this.getCounterpartyBalanceWithHttpInfo(counterpartyId);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitCounterpartyResponse1> getCounterpartyBalanceWithHttpInfo(String counterpartyId) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.getCounterpartyBalanceRequestBuilder(counterpartyId);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("getCounterpartyBalance", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitCounterpartyResponse1)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitCounterpartyResponse1>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder getCounterpartyBalanceRequestBuilder(String counterpartyId) throws ApiException {
        if (counterpartyId == null) {
            throw new ApiException(400, "Missing the required parameter 'counterpartyId' when calling getCounterpartyBalance");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/counterparties/{counterpartyId}/balance".replace("{counterpartyId}", ApiClient.urlEncode(counterpartyId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitCustomerResponse getCustomer(String customerId) throws ApiException {
        ApiResponse<UnitCustomerResponse> localVarResponse = this.getCustomerWithHttpInfo(customerId);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitCustomerResponse> getCustomerWithHttpInfo(String customerId) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.getCustomerRequestBuilder(customerId);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("getCustomer", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitCustomerResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitCustomerResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder getCustomerRequestBuilder(String customerId) throws ApiException {
        if (customerId == null) {
            throw new ApiException(400, "Missing the required parameter 'customerId' when calling getCustomer");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/customers/{customerId}".replace("{customerId}", ApiClient.urlEncode(customerId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitCustomersListResponse getCustomersList(ListPageParameters page, GetCustomersListFilterParameter filter, String sort) throws ApiException {
        ApiResponse<UnitCustomersListResponse> localVarResponse = this.getCustomersListWithHttpInfo(page, filter, sort);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitCustomersListResponse> getCustomersListWithHttpInfo(ListPageParameters page, GetCustomersListFilterParameter filter, String sort) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.getCustomersListRequestBuilder(page, filter, sort);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("getCustomersList", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitCustomersListResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitCustomersListResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder getCustomersListRequestBuilder(ListPageParameters page, GetCustomersListFilterParameter filter, String sort) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/customers";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName = "page";
        if (page != null) {
            localVarQueryStringJoiner.add(page.toUrlQueryString("page"));
        }
        localVarQueryParameterBaseName = "filter";
        if (filter != null) {
            localVarQueryStringJoiner.add(filter.toUrlQueryString("filter"));
        }
        localVarQueryParameterBaseName = "sort";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("sort", sort));
        if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + "=" + p.getValue()));
            if (localVarQueryStringJoiner.length() != 0) {
                queryJoiner.add(localVarQueryStringJoiner.toString());
            }
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitDisputeResponse getDispute(String disputeId) throws ApiException {
        ApiResponse<UnitDisputeResponse> localVarResponse = this.getDisputeWithHttpInfo(disputeId);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitDisputeResponse> getDisputeWithHttpInfo(String disputeId) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.getDisputeRequestBuilder(disputeId);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("getDispute", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitDisputeResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitDisputeResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder getDisputeRequestBuilder(String disputeId) throws ApiException {
        if (disputeId == null) {
            throw new ApiException(400, "Missing the required parameter 'disputeId' when calling getDispute");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/disputes/{disputeId}".replace("{disputeId}", ApiClient.urlEncode(disputeId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public List<Dispute> getDisputesList(ListPageParameters page, GetDisputesListFilterParameter filter) throws ApiException {
        ApiResponse<List<Dispute>> localVarResponse = this.getDisputesListWithHttpInfo(page, filter);
        return localVarResponse.getData();
    }

    public ApiResponse<List<Dispute>> getDisputesListWithHttpInfo(ListPageParameters page, GetDisputesListFilterParameter filter) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.getDisputesListRequestBuilder(page, filter);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("getDisputesList", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (List)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<List<Dispute>>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder getDisputesListRequestBuilder(ListPageParameters page, GetDisputesListFilterParameter filter) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/disputes";
        ArrayList localVarQueryParams = new ArrayList();
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName = "page";
        if (page != null) {
            localVarQueryStringJoiner.add(page.toUrlQueryString("page"));
        }
        localVarQueryParameterBaseName = "filter";
        if (filter != null) {
            localVarQueryStringJoiner.add(filter.toUrlQueryString("filter"));
        }
        if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + "=" + p.getValue()));
            if (localVarQueryStringJoiner.length() != 0) {
                queryJoiner.add(localVarQueryStringJoiner.toString());
            }
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitEventResponse getEvent(String eventId) throws ApiException {
        ApiResponse<UnitEventResponse> localVarResponse = this.getEventWithHttpInfo(eventId);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitEventResponse> getEventWithHttpInfo(String eventId) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.getEventRequestBuilder(eventId);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("getEvent", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitEventResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitEventResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder getEventRequestBuilder(String eventId) throws ApiException {
        if (eventId == null) {
            throw new ApiException(400, "Missing the required parameter 'eventId' when calling getEvent");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/events/{eventId}".replace("{eventId}", ApiClient.urlEncode(eventId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitEventListResponse getEventsList(ListPageParameters page, GetEventsListFilterParameter filter) throws ApiException {
        ApiResponse<UnitEventListResponse> localVarResponse = this.getEventsListWithHttpInfo(page, filter);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitEventListResponse> getEventsListWithHttpInfo(ListPageParameters page, GetEventsListFilterParameter filter) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.getEventsListRequestBuilder(page, filter);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("getEventsList", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitEventListResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitEventListResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder getEventsListRequestBuilder(ListPageParameters page, GetEventsListFilterParameter filter) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/events";
        ArrayList localVarQueryParams = new ArrayList();
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName = "page";
        if (page != null) {
            localVarQueryStringJoiner.add(page.toUrlQueryString("page"));
        }
        localVarQueryParameterBaseName = "filter";
        if (filter != null) {
            localVarQueryStringJoiner.add(filter.toUrlQueryString("filter"));
        }
        if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + "=" + p.getValue()));
            if (localVarQueryStringJoiner.length() != 0) {
                queryJoiner.add(localVarQueryStringJoiner.toString());
            }
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitFrontCheckDepositResponse getFrontCheckDeposit(String checkDepositId) throws ApiException {
        ApiResponse<UnitFrontCheckDepositResponse> localVarResponse = this.getFrontCheckDepositWithHttpInfo(checkDepositId);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitFrontCheckDepositResponse> getFrontCheckDepositWithHttpInfo(String checkDepositId) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.getFrontCheckDepositRequestBuilder(checkDepositId);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("getFrontCheckDeposit", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitFrontCheckDepositResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitFrontCheckDepositResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder getFrontCheckDepositRequestBuilder(String checkDepositId) throws ApiException {
        if (checkDepositId == null) {
            throw new ApiException(400, "Missing the required parameter 'checkDepositId' when calling getFrontCheckDeposit");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/check-deposits/{checkDepositId}/front".replace("{checkDepositId}", ApiClient.urlEncode(checkDepositId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitInstitutionResponse getInstitution(String routingNumber) throws ApiException {
        ApiResponse<UnitInstitutionResponse> localVarResponse = this.getInstitutionWithHttpInfo(routingNumber);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitInstitutionResponse> getInstitutionWithHttpInfo(String routingNumber) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.getInstitutionRequestBuilder(routingNumber);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("getInstitution", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitInstitutionResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitInstitutionResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder getInstitutionRequestBuilder(String routingNumber) throws ApiException {
        if (routingNumber == null) {
            throw new ApiException(400, "Missing the required parameter 'routingNumber' when calling getInstitution");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/institutions/{routingNumber}".replace("{routingNumber}", ApiClient.urlEncode(routingNumber.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitRewardsListResponse getListRewards(ListPageParameters page, GetListRewardsFilterParameter filter, String sort, String include) throws ApiException {
        ApiResponse<UnitRewardsListResponse> localVarResponse = this.getListRewardsWithHttpInfo(page, filter, sort, include);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitRewardsListResponse> getListRewardsWithHttpInfo(ListPageParameters page, GetListRewardsFilterParameter filter, String sort, String include) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.getListRewardsRequestBuilder(page, filter, sort, include);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("getListRewards", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitRewardsListResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitRewardsListResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder getListRewardsRequestBuilder(ListPageParameters page, GetListRewardsFilterParameter filter, String sort, String include) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/rewards";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName = "page";
        if (page != null) {
            localVarQueryStringJoiner.add(page.toUrlQueryString("page"));
        }
        localVarQueryParameterBaseName = "filter";
        if (filter != null) {
            localVarQueryStringJoiner.add(filter.toUrlQueryString("filter"));
        }
        localVarQueryParameterBaseName = "sort";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("sort", sort));
        localVarQueryParameterBaseName = "include";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("include", include));
        if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + "=" + p.getValue()));
            if (localVarQueryStringJoiner.length() != 0) {
                queryJoiner.add(localVarQueryStringJoiner.toString());
            }
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitPaymentResponseWithIncluded getPayment(String paymentId, String included) throws ApiException {
        ApiResponse<UnitPaymentResponseWithIncluded> localVarResponse = this.getPaymentWithHttpInfo(paymentId, included);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitPaymentResponseWithIncluded> getPaymentWithHttpInfo(String paymentId, String included) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.getPaymentRequestBuilder(paymentId, included);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("getPayment", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitPaymentResponseWithIncluded)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitPaymentResponseWithIncluded>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder getPaymentRequestBuilder(String paymentId, String included) throws ApiException {
        if (paymentId == null) {
            throw new ApiException(400, "Missing the required parameter 'paymentId' when calling getPayment");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/payments/{paymentId}".replace("{paymentId}", ApiClient.urlEncode(paymentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName = "included";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("included", included));
        if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + "=" + p.getValue()));
            if (localVarQueryStringJoiner.length() != 0) {
                queryJoiner.add(localVarQueryStringJoiner.toString());
            }
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitPaymentsListResponse getPaymentsList(ListPageParameters page, GetPaymentsListFilterParameter filter, String include, String sort) throws ApiException {
        ApiResponse<UnitPaymentsListResponse> localVarResponse = this.getPaymentsListWithHttpInfo(page, filter, include, sort);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitPaymentsListResponse> getPaymentsListWithHttpInfo(ListPageParameters page, GetPaymentsListFilterParameter filter, String include, String sort) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.getPaymentsListRequestBuilder(page, filter, include, sort);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("getPaymentsList", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitPaymentsListResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitPaymentsListResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder getPaymentsListRequestBuilder(ListPageParameters page, GetPaymentsListFilterParameter filter, String include, String sort) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/payments";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName = "page";
        if (page != null) {
            localVarQueryStringJoiner.add(page.toUrlQueryString("page"));
        }
        localVarQueryParameterBaseName = "filter";
        if (filter != null) {
            localVarQueryStringJoiner.add(filter.toUrlQueryString("filter"));
        }
        localVarQueryParameterBaseName = "include";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("include", include));
        localVarQueryParameterBaseName = "sort";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("sort", sort));
        if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + "=" + p.getValue()));
            if (localVarQueryStringJoiner.length() != 0) {
                queryJoiner.add(localVarQueryStringJoiner.toString());
            }
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitReceivedPaymentResponseWithIncluded getReceivedPayment(String paymentId, String included) throws ApiException {
        ApiResponse<UnitReceivedPaymentResponseWithIncluded> localVarResponse = this.getReceivedPaymentWithHttpInfo(paymentId, included);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitReceivedPaymentResponseWithIncluded> getReceivedPaymentWithHttpInfo(String paymentId, String included) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.getReceivedPaymentRequestBuilder(paymentId, included);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("getReceivedPayment", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitReceivedPaymentResponseWithIncluded)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitReceivedPaymentResponseWithIncluded>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder getReceivedPaymentRequestBuilder(String paymentId, String included) throws ApiException {
        if (paymentId == null) {
            throw new ApiException(400, "Missing the required parameter 'paymentId' when calling getReceivedPayment");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/received-payments/{paymentId}".replace("{paymentId}", ApiClient.urlEncode(paymentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName = "included";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("included", included));
        if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + "=" + p.getValue()));
            if (localVarQueryStringJoiner.length() != 0) {
                queryJoiner.add(localVarQueryStringJoiner.toString());
            }
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitReceivedPaymentListResponse getReceivedPaymentsList(String included) throws ApiException {
        ApiResponse<UnitReceivedPaymentListResponse> localVarResponse = this.getReceivedPaymentsListWithHttpInfo(included);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitReceivedPaymentListResponse> getReceivedPaymentsListWithHttpInfo(String included) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.getReceivedPaymentsListRequestBuilder(included);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("getReceivedPaymentsList", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitReceivedPaymentListResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitReceivedPaymentListResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder getReceivedPaymentsListRequestBuilder(String included) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/received-payments";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName = "included";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("included", included));
        if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + "=" + p.getValue()));
            if (localVarQueryStringJoiner.length() != 0) {
                queryJoiner.add(localVarQueryStringJoiner.toString());
            }
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitRecurringPaymentResponse getRecurringPayment(String paymentId) throws ApiException {
        ApiResponse<UnitRecurringPaymentResponse> localVarResponse = this.getRecurringPaymentWithHttpInfo(paymentId);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitRecurringPaymentResponse> getRecurringPaymentWithHttpInfo(String paymentId) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.getRecurringPaymentRequestBuilder(paymentId);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("getRecurringPayment", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitRecurringPaymentResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitRecurringPaymentResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder getRecurringPaymentRequestBuilder(String paymentId) throws ApiException {
        if (paymentId == null) {
            throw new ApiException(400, "Missing the required parameter 'paymentId' when calling getRecurringPayment");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/recurring-payments/{paymentId}".replace("{paymentId}", ApiClient.urlEncode(paymentId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitRecurringPaymentListResponse getRecurringPaymentsList(ListPageParameters page, GetRecurringPaymentsListFilterParameter filter, String sort) throws ApiException {
        ApiResponse<UnitRecurringPaymentListResponse> localVarResponse = this.getRecurringPaymentsListWithHttpInfo(page, filter, sort);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitRecurringPaymentListResponse> getRecurringPaymentsListWithHttpInfo(ListPageParameters page, GetRecurringPaymentsListFilterParameter filter, String sort) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.getRecurringPaymentsListRequestBuilder(page, filter, sort);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("getRecurringPaymentsList", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitRecurringPaymentListResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitRecurringPaymentListResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder getRecurringPaymentsListRequestBuilder(ListPageParameters page, GetRecurringPaymentsListFilterParameter filter, String sort) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/recurring-payments";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName = "page";
        if (page != null) {
            localVarQueryStringJoiner.add(page.toUrlQueryString("page"));
        }
        localVarQueryParameterBaseName = "filter";
        if (filter != null) {
            localVarQueryStringJoiner.add(filter.toUrlQueryString("filter"));
        }
        localVarQueryParameterBaseName = "sort";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("sort", sort));
        if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + "=" + p.getValue()));
            if (localVarQueryStringJoiner.length() != 0) {
                queryJoiner.add(localVarQueryStringJoiner.toString());
            }
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitRecurringRepaymentResponse getRecurringRepayment(String recurringRepaymentId, String include) throws ApiException {
        ApiResponse<UnitRecurringRepaymentResponse> localVarResponse = this.getRecurringRepaymentWithHttpInfo(recurringRepaymentId, include);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitRecurringRepaymentResponse> getRecurringRepaymentWithHttpInfo(String recurringRepaymentId, String include) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.getRecurringRepaymentRequestBuilder(recurringRepaymentId, include);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("getRecurringRepayment", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitRecurringRepaymentResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitRecurringRepaymentResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder getRecurringRepaymentRequestBuilder(String recurringRepaymentId, String include) throws ApiException {
        if (recurringRepaymentId == null) {
            throw new ApiException(400, "Missing the required parameter 'recurringRepaymentId' when calling getRecurringRepayment");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/recurring-repayments/{recurringRepaymentId}".replace("{recurringRepaymentId}", ApiClient.urlEncode(recurringRepaymentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName = "include";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("include", include));
        if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + "=" + p.getValue()));
            if (localVarQueryStringJoiner.length() != 0) {
                queryJoiner.add(localVarQueryStringJoiner.toString());
            }
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitRecurringRepaymentsListResponse getRecurringRepaymentsList(ListPageParameters page, GetRecurringRepaymentsListFilterParameter filter, String sort) throws ApiException {
        ApiResponse<UnitRecurringRepaymentsListResponse> localVarResponse = this.getRecurringRepaymentsListWithHttpInfo(page, filter, sort);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitRecurringRepaymentsListResponse> getRecurringRepaymentsListWithHttpInfo(ListPageParameters page, GetRecurringRepaymentsListFilterParameter filter, String sort) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.getRecurringRepaymentsListRequestBuilder(page, filter, sort);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("getRecurringRepaymentsList", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitRecurringRepaymentsListResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitRecurringRepaymentsListResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder getRecurringRepaymentsListRequestBuilder(ListPageParameters page, GetRecurringRepaymentsListFilterParameter filter, String sort) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/recurring-repayments";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName = "page";
        if (page != null) {
            localVarQueryStringJoiner.add(page.toUrlQueryString("page"));
        }
        localVarQueryParameterBaseName = "filter";
        if (filter != null) {
            localVarQueryStringJoiner.add(filter.toUrlQueryString("filter"));
        }
        localVarQueryParameterBaseName = "sort";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("sort", sort));
        if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + "=" + p.getValue()));
            if (localVarQueryStringJoiner.length() != 0) {
                queryJoiner.add(localVarQueryStringJoiner.toString());
            }
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitRepaymentResponse getRepayment(String repaymentId, String include) throws ApiException {
        ApiResponse<UnitRepaymentResponse> localVarResponse = this.getRepaymentWithHttpInfo(repaymentId, include);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitRepaymentResponse> getRepaymentWithHttpInfo(String repaymentId, String include) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.getRepaymentRequestBuilder(repaymentId, include);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("getRepayment", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitRepaymentResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitRepaymentResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder getRepaymentRequestBuilder(String repaymentId, String include) throws ApiException {
        if (repaymentId == null) {
            throw new ApiException(400, "Missing the required parameter 'repaymentId' when calling getRepayment");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/repayments/{repaymentId}".replace("{repaymentId}", ApiClient.urlEncode(repaymentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName = "include";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("include", include));
        if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + "=" + p.getValue()));
            if (localVarQueryStringJoiner.length() != 0) {
                queryJoiner.add(localVarQueryStringJoiner.toString());
            }
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitRepaymentsListResponse getRepaymentsList(ListPageParameters page, GetRepaymentsListFilterParameter filter) throws ApiException {
        ApiResponse<UnitRepaymentsListResponse> localVarResponse = this.getRepaymentsListWithHttpInfo(page, filter);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitRepaymentsListResponse> getRepaymentsListWithHttpInfo(ListPageParameters page, GetRepaymentsListFilterParameter filter) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.getRepaymentsListRequestBuilder(page, filter);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("getRepaymentsList", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitRepaymentsListResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitRepaymentsListResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder getRepaymentsListRequestBuilder(ListPageParameters page, GetRepaymentsListFilterParameter filter) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/repayments";
        ArrayList localVarQueryParams = new ArrayList();
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName = "page";
        if (page != null) {
            localVarQueryStringJoiner.add(page.toUrlQueryString("page"));
        }
        localVarQueryParameterBaseName = "filter";
        if (filter != null) {
            localVarQueryStringJoiner.add(filter.toUrlQueryString("filter"));
        }
        if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + "=" + p.getValue()));
            if (localVarQueryStringJoiner.length() != 0) {
                queryJoiner.add(localVarQueryStringJoiner.toString());
            }
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitRewardResponse getReward(String rewardId) throws ApiException {
        ApiResponse<UnitRewardResponse> localVarResponse = this.getRewardWithHttpInfo(rewardId);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitRewardResponse> getRewardWithHttpInfo(String rewardId) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.getRewardRequestBuilder(rewardId);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("getReward", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitRewardResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitRewardResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder getRewardRequestBuilder(String rewardId) throws ApiException {
        if (rewardId == null) {
            throw new ApiException(400, "Missing the required parameter 'rewardId' when calling getReward");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/rewards/{rewardId}".replace("{rewardId}", ApiClient.urlEncode(rewardId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public File getStatementBankPdf(String accountId) throws ApiException {
        ApiResponse<File> localVarResponse = this.getStatementBankPdfWithHttpInfo(accountId);
        return localVarResponse.getData();
    }

    public ApiResponse<File> getStatementBankPdfWithHttpInfo(String accountId) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.getStatementBankPdfRequestBuilder(accountId);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("getStatementBankPdf", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (File)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<File>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder getStatementBankPdfRequestBuilder(String accountId) throws ApiException {
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getStatementBankPdf");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/statements/{accountId}/bank/pdf".replace("{accountId}", ApiClient.urlEncode(accountId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/pdf");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public String getStatementHtml(String statementId) throws ApiException {
        ApiResponse<String> localVarResponse = this.getStatementHtmlWithHttpInfo(statementId);
        return localVarResponse.getData();
    }

    public ApiResponse<String> getStatementHtmlWithHttpInfo(String statementId) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.getStatementHtmlRequestBuilder(statementId);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("getStatementHtml", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (String)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<String>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder getStatementHtmlRequestBuilder(String statementId) throws ApiException {
        if (statementId == null) {
            throw new ApiException(400, "Missing the required parameter 'statementId' when calling getStatementHtml");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/statements/{statementId}/html".replace("{statementId}", ApiClient.urlEncode(statementId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "text/html");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public File getStatementPdf(String statementId) throws ApiException {
        ApiResponse<File> localVarResponse = this.getStatementPdfWithHttpInfo(statementId);
        return localVarResponse.getData();
    }

    public ApiResponse<File> getStatementPdfWithHttpInfo(String statementId) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.getStatementPdfRequestBuilder(statementId);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("getStatementPdf", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (File)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<File>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder getStatementPdfRequestBuilder(String statementId) throws ApiException {
        if (statementId == null) {
            throw new ApiException(400, "Missing the required parameter 'statementId' when calling getStatementPdf");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/statements/{statementId}/pdf".replace("{statementId}", ApiClient.urlEncode(statementId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/pdf");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitStatementsResponse getStatementsList(ListPageParameters page, GetStatementsListFilterParameter filter, String sort) throws ApiException {
        ApiResponse<UnitStatementsResponse> localVarResponse = this.getStatementsListWithHttpInfo(page, filter, sort);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitStatementsResponse> getStatementsListWithHttpInfo(ListPageParameters page, GetStatementsListFilterParameter filter, String sort) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.getStatementsListRequestBuilder(page, filter, sort);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("getStatementsList", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitStatementsResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitStatementsResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder getStatementsListRequestBuilder(ListPageParameters page, GetStatementsListFilterParameter filter, String sort) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/statements";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName = "page";
        if (page != null) {
            localVarQueryStringJoiner.add(page.toUrlQueryString("page"));
        }
        localVarQueryParameterBaseName = "filter";
        if (filter != null) {
            localVarQueryStringJoiner.add(filter.toUrlQueryString("filter"));
        }
        localVarQueryParameterBaseName = "sort";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("sort", sort));
        if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + "=" + p.getValue()));
            if (localVarQueryStringJoiner.length() != 0) {
                queryJoiner.add(localVarQueryStringJoiner.toString());
            }
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public StopPaymentResponse getStopPayment(String stopPaymentId) throws ApiException {
        ApiResponse<StopPaymentResponse> localVarResponse = this.getStopPaymentWithHttpInfo(stopPaymentId);
        return localVarResponse.getData();
    }

    public ApiResponse<StopPaymentResponse> getStopPaymentWithHttpInfo(String stopPaymentId) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.getStopPaymentRequestBuilder(stopPaymentId);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("getStopPayment", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (StopPaymentResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<StopPaymentResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder getStopPaymentRequestBuilder(String stopPaymentId) throws ApiException {
        if (stopPaymentId == null) {
            throw new ApiException(400, "Missing the required parameter 'stopPaymentId' when calling getStopPayment");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/stop-payments/{stopPaymentId}".replace("{stopPaymentId}", ApiClient.urlEncode(stopPaymentId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public StopPaymentListResponse getStopPaymentsList(ListPageParameters page, GetStopPaymentsListFilterParameter filter, String sort) throws ApiException {
        ApiResponse<StopPaymentListResponse> localVarResponse = this.getStopPaymentsListWithHttpInfo(page, filter, sort);
        return localVarResponse.getData();
    }

    public ApiResponse<StopPaymentListResponse> getStopPaymentsListWithHttpInfo(ListPageParameters page, GetStopPaymentsListFilterParameter filter, String sort) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.getStopPaymentsListRequestBuilder(page, filter, sort);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("getStopPaymentsList", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (StopPaymentListResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<StopPaymentListResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder getStopPaymentsListRequestBuilder(ListPageParameters page, GetStopPaymentsListFilterParameter filter, String sort) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/stop-payments";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName = "page";
        if (page != null) {
            localVarQueryStringJoiner.add(page.toUrlQueryString("page"));
        }
        localVarQueryParameterBaseName = "filter";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("accountId", filter.getAccountId()));
        localVarQueryParams.addAll(ApiClient.parameterToPairs("customerId", filter.getCustomerId()));
        localVarQueryParams.addAll(ApiClient.parameterToPairs("multi", "status", filter.getStatus()));
        localVarQueryParams.addAll(ApiClient.parameterToPairs("tags", filter.getTags()));
        localVarQueryParams.addAll(ApiClient.parameterToPairs("since", filter.getSince()));
        localVarQueryParams.addAll(ApiClient.parameterToPairs("until", filter.getUntil()));
        localVarQueryParams.addAll(ApiClient.parameterToPairs("fromAmount", filter.getFromAmount()));
        localVarQueryParams.addAll(ApiClient.parameterToPairs("toAmount", filter.getToAmount()));
        localVarQueryParams.addAll(ApiClient.parameterToPairs("checkNumber", filter.getCheckNumber()));
        localVarQueryParameterBaseName = "sort";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("sort", sort));
        if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + "=" + p.getValue()));
            if (localVarQueryStringJoiner.length() != 0) {
                queryJoiner.add(localVarQueryStringJoiner.toString());
            }
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitTransactionResponseWithIncludedResource getTransaction(String accountId, String transactionId) throws ApiException {
        ApiResponse<UnitTransactionResponseWithIncludedResource> localVarResponse = this.getTransactionWithHttpInfo(accountId, transactionId);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitTransactionResponseWithIncludedResource> getTransactionWithHttpInfo(String accountId, String transactionId) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.getTransactionRequestBuilder(accountId, transactionId);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("getTransaction", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitTransactionResponseWithIncludedResource)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitTransactionResponseWithIncludedResource>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder getTransactionRequestBuilder(String accountId, String transactionId) throws ApiException {
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getTransaction");
        }
        if (transactionId == null) {
            throw new ApiException(400, "Missing the required parameter 'transactionId' when calling getTransaction");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/accounts/{accountId}/transactions/{transactionId}".replace("{accountId}", ApiClient.urlEncode(accountId.toString())).replace("{transactionId}", ApiClient.urlEncode(transactionId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitTransactionsListResponse getTransactionsList(ListPageParameters page, GetTransactionsListFilterParameter filter, String sort, String include) throws ApiException {
        ApiResponse<UnitTransactionsListResponse> localVarResponse = this.getTransactionsListWithHttpInfo(page, filter, sort, include);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitTransactionsListResponse> getTransactionsListWithHttpInfo(ListPageParameters page, GetTransactionsListFilterParameter filter, String sort, String include) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.getTransactionsListRequestBuilder(page, filter, sort, include);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("getTransactionsList", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitTransactionsListResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitTransactionsListResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder getTransactionsListRequestBuilder(ListPageParameters page, GetTransactionsListFilterParameter filter, String sort, String include) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/transactions";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName = "page";
        if (page != null) {
            localVarQueryStringJoiner.add(page.toUrlQueryString("page"));
        }
        localVarQueryParameterBaseName = "filter";
        if (filter != null) {
            localVarQueryStringJoiner.add(filter.toUrlQueryString("filter"));
        }
        localVarQueryParameterBaseName = "sort";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("sort", sort));
        localVarQueryParameterBaseName = "include";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("include", include));
        if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + "=" + p.getValue()));
            if (localVarQueryStringJoiner.length() != 0) {
                queryJoiner.add(localVarQueryStringJoiner.toString());
            }
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "application/vnd.api+json");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public WebhookResponse getWebhook(String webhookId) throws ApiException {
        ApiResponse<WebhookResponse> localVarResponse = this.getWebhookWithHttpInfo(webhookId);
        return localVarResponse.getData();
    }

    public ApiResponse<WebhookResponse> getWebhookWithHttpInfo(String webhookId) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.getWebhookRequestBuilder(webhookId);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("getWebhook", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (WebhookResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<WebhookResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder getWebhookRequestBuilder(String webhookId) throws ApiException {
        if (webhookId == null) {
            throw new ApiException(400, "Missing the required parameter 'webhookId' when calling getWebhook");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/webhooks/{webhookId}".replace("{webhookId}", ApiClient.urlEncode(webhookId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitWebhooksListResponse getWebhooksList(ListPageParameters page, GetWebhooksListFilterParameter filter, String sort) throws ApiException {
        ApiResponse<UnitWebhooksListResponse> localVarResponse = this.getWebhooksListWithHttpInfo(page, filter, sort);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitWebhooksListResponse> getWebhooksListWithHttpInfo(ListPageParameters page, GetWebhooksListFilterParameter filter, String sort) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.getWebhooksListRequestBuilder(page, filter, sort);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("getWebhooksList", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitWebhooksListResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitWebhooksListResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder getWebhooksListRequestBuilder(ListPageParameters page, GetWebhooksListFilterParameter filter, String sort) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/webhooks";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName = "page";
        if (page != null) {
            localVarQueryStringJoiner.add(page.toUrlQueryString("page"));
        }
        localVarQueryParameterBaseName = "filter";
        if (filter != null) {
            localVarQueryStringJoiner.add(filter.toUrlQueryString("filter"));
        }
        localVarQueryParameterBaseName = "sort";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("sort", sort));
        if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + "=" + p.getValue()));
            if (localVarQueryStringJoiner.length() != 0) {
                queryJoiner.add(localVarQueryStringJoiner.toString());
            }
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "application/vnd.api+json");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitReceivedPaymentResponse receivedPaymentsPaymentIdPatch(String paymentId, UpdateReceivedPaymentRequest updateReceivedPaymentRequest) throws ApiException {
        ApiResponse<UnitReceivedPaymentResponse> localVarResponse = this.receivedPaymentsPaymentIdPatchWithHttpInfo(paymentId, updateReceivedPaymentRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitReceivedPaymentResponse> receivedPaymentsPaymentIdPatchWithHttpInfo(String paymentId, UpdateReceivedPaymentRequest updateReceivedPaymentRequest) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.receivedPaymentsPaymentIdPatchRequestBuilder(paymentId, updateReceivedPaymentRequest);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("receivedPaymentsPaymentIdPatch", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitReceivedPaymentResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitReceivedPaymentResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder receivedPaymentsPaymentIdPatchRequestBuilder(String paymentId, UpdateReceivedPaymentRequest updateReceivedPaymentRequest) throws ApiException {
        if (paymentId == null) {
            throw new ApiException(400, "Missing the required parameter 'paymentId' when calling receivedPaymentsPaymentIdPatch");
        }
        if (updateReceivedPaymentRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'updateReceivedPaymentRequest' when calling receivedPaymentsPaymentIdPatch");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/received-payments/{paymentId}".replace("{paymentId}", ApiClient.urlEncode(paymentId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/vnd.api+json");
        localVarRequestBuilder.header("Accept", "application/vnd.api+json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)updateReceivedPaymentRequest);
            localVarRequestBuilder.method("PATCH", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitCustomerResponse removeAuthorizedUsers(String customerId, RemoveAuthorizedUsersRequest removeAuthorizedUsersRequest) throws ApiException {
        ApiResponse<UnitCustomerResponse> localVarResponse = this.removeAuthorizedUsersWithHttpInfo(customerId, removeAuthorizedUsersRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitCustomerResponse> removeAuthorizedUsersWithHttpInfo(String customerId, RemoveAuthorizedUsersRequest removeAuthorizedUsersRequest) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.removeAuthorizedUsersRequestBuilder(customerId, removeAuthorizedUsersRequest);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("removeAuthorizedUsers", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitCustomerResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitCustomerResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder removeAuthorizedUsersRequestBuilder(String customerId, RemoveAuthorizedUsersRequest removeAuthorizedUsersRequest) throws ApiException {
        if (customerId == null) {
            throw new ApiException(400, "Missing the required parameter 'customerId' when calling removeAuthorizedUsers");
        }
        if (removeAuthorizedUsersRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'removeAuthorizedUsersRequest' when calling removeAuthorizedUsers");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/customers/{customerId}/authorized-users".replace("{customerId}", ApiClient.urlEncode(customerId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/vnd.api+json");
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)removeAuthorizedUsersRequest);
            localVarRequestBuilder.method("DELETE", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitAccountResponse reopenAccount(String accountId) throws ApiException {
        ApiResponse<UnitAccountResponse> localVarResponse = this.reopenAccountWithHttpInfo(accountId);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitAccountResponse> reopenAccountWithHttpInfo(String accountId) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.reopenAccountRequestBuilder(accountId);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("reopenAccount", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitAccountResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitAccountResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder reopenAccountRequestBuilder(String accountId) throws ApiException {
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling reopenAccount");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/accounts/{accountId}/reopen".replace("{accountId}", ApiClient.urlEncode(accountId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitReportLostCardResponse reportCardAsLost(String cardId) throws ApiException {
        ApiResponse<UnitReportLostCardResponse> localVarResponse = this.reportCardAsLostWithHttpInfo(cardId);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitReportLostCardResponse> reportCardAsLostWithHttpInfo(String cardId) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.reportCardAsLostRequestBuilder(cardId);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("reportCardAsLost", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitReportLostCardResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitReportLostCardResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder reportCardAsLostRequestBuilder(String cardId) throws ApiException {
        if (cardId == null) {
            throw new ApiException(400, "Missing the required parameter 'cardId' when calling reportCardAsLost");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/cards/{cardId}/report-lost".replace("{cardId}", ApiClient.urlEncode(cardId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitReportStolenCardResponse reportCardAsStolen(String cardId) throws ApiException {
        ApiResponse<UnitReportStolenCardResponse> localVarResponse = this.reportCardAsStolenWithHttpInfo(cardId);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitReportStolenCardResponse> reportCardAsStolenWithHttpInfo(String cardId) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.reportCardAsStolenRequestBuilder(cardId);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("reportCardAsStolen", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitReportStolenCardResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitReportStolenCardResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder reportCardAsStolenRequestBuilder(String cardId) throws ApiException {
        if (cardId == null) {
            throw new ApiException(400, "Missing the required parameter 'cardId' when calling reportCardAsStolen");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/cards/{cardId}/report-stolen".replace("{cardId}", ApiClient.urlEncode(cardId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitCheckPaymentResponse returnCheckPayment(String checkPaymentId, ReturnCheckPaymentRequest returnCheckPaymentRequest) throws ApiException {
        ApiResponse<UnitCheckPaymentResponse> localVarResponse = this.returnCheckPaymentWithHttpInfo(checkPaymentId, returnCheckPaymentRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitCheckPaymentResponse> returnCheckPaymentWithHttpInfo(String checkPaymentId, ReturnCheckPaymentRequest returnCheckPaymentRequest) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.returnCheckPaymentRequestBuilder(checkPaymentId, returnCheckPaymentRequest);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("returnCheckPayment", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitCheckPaymentResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitCheckPaymentResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder returnCheckPaymentRequestBuilder(String checkPaymentId, ReturnCheckPaymentRequest returnCheckPaymentRequest) throws ApiException {
        if (checkPaymentId == null) {
            throw new ApiException(400, "Missing the required parameter 'checkPaymentId' when calling returnCheckPayment");
        }
        if (returnCheckPaymentRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'returnCheckPaymentRequest' when calling returnCheckPayment");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/check-payments/{checkPaymentId}/return".replace("{checkPaymentId}", ApiClient.urlEncode(checkPaymentId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/vnd.api+json");
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)returnCheckPaymentRequest);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitAccountResponse unfreezeAccount(String accountId) throws ApiException {
        ApiResponse<UnitAccountResponse> localVarResponse = this.unfreezeAccountWithHttpInfo(accountId);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitAccountResponse> unfreezeAccountWithHttpInfo(String accountId) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.unfreezeAccountRequestBuilder(accountId);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("unfreezeAccount", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitAccountResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitAccountResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder unfreezeAccountRequestBuilder(String accountId) throws ApiException {
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling unfreezeAccount");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/accounts/{accountId}/unfreeze".replace("{accountId}", ApiClient.urlEncode(accountId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitUnfreezeCardResponse unfreezeCard(String cardId) throws ApiException {
        ApiResponse<UnitUnfreezeCardResponse> localVarResponse = this.unfreezeCardWithHttpInfo(cardId);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitUnfreezeCardResponse> unfreezeCardWithHttpInfo(String cardId) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.unfreezeCardRequestBuilder(cardId);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("unfreezeCard", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitUnfreezeCardResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitUnfreezeCardResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder unfreezeCardRequestBuilder(String cardId) throws ApiException {
        if (cardId == null) {
            throw new ApiException(400, "Missing the required parameter 'cardId' when calling unfreezeCard");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/cards/{cardId}/unfreeze".replace("{cardId}", ApiClient.urlEncode(cardId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitAccountResponse updateAccount(String accountId, UpdateAccountRequest updateAccountRequest) throws ApiException {
        ApiResponse<UnitAccountResponse> localVarResponse = this.updateAccountWithHttpInfo(accountId, updateAccountRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitAccountResponse> updateAccountWithHttpInfo(String accountId, UpdateAccountRequest updateAccountRequest) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.updateAccountRequestBuilder(accountId, updateAccountRequest);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("updateAccount", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitAccountResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitAccountResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder updateAccountRequestBuilder(String accountId, UpdateAccountRequest updateAccountRequest) throws ApiException {
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateAccount");
        }
        if (updateAccountRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'updateAccountRequest' when calling updateAccount");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/accounts/{accountId}".replace("{accountId}", ApiClient.urlEncode(accountId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/vnd.api+json");
        localVarRequestBuilder.header("Accept", "application/vnd.api+json, application/vnd.api+json; charset=utf-8");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)updateAccountRequest);
            localVarRequestBuilder.method("PATCH", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitApplicationResponseWithIncluded updateApplication(String applicationId, UpdateApplicationRequest updateApplicationRequest) throws ApiException {
        ApiResponse<UnitApplicationResponseWithIncluded> localVarResponse = this.updateApplicationWithHttpInfo(applicationId, updateApplicationRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitApplicationResponseWithIncluded> updateApplicationWithHttpInfo(String applicationId, UpdateApplicationRequest updateApplicationRequest) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.updateApplicationRequestBuilder(applicationId, updateApplicationRequest);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("updateApplication", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitApplicationResponseWithIncluded)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitApplicationResponseWithIncluded>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder updateApplicationRequestBuilder(String applicationId, UpdateApplicationRequest updateApplicationRequest) throws ApiException {
        if (applicationId == null) {
            throw new ApiException(400, "Missing the required parameter 'applicationId' when calling updateApplication");
        }
        if (updateApplicationRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'updateApplicationRequest' when calling updateApplication");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/applications/{applicationId}".replace("{applicationId}", ApiClient.urlEncode(applicationId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/vnd.api+json");
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)updateApplicationRequest);
            localVarRequestBuilder.method("PATCH", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitBeneficialOwnerResponse updateBusinessBeneficialOwner(String beneficialOwnerId, UpdateBusinessBeneficialOwnerRequest updateBusinessBeneficialOwnerRequest) throws ApiException {
        ApiResponse<UnitBeneficialOwnerResponse> localVarResponse = this.updateBusinessBeneficialOwnerWithHttpInfo(beneficialOwnerId, updateBusinessBeneficialOwnerRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitBeneficialOwnerResponse> updateBusinessBeneficialOwnerWithHttpInfo(String beneficialOwnerId, UpdateBusinessBeneficialOwnerRequest updateBusinessBeneficialOwnerRequest) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.updateBusinessBeneficialOwnerRequestBuilder(beneficialOwnerId, updateBusinessBeneficialOwnerRequest);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("updateBusinessBeneficialOwner", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitBeneficialOwnerResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitBeneficialOwnerResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder updateBusinessBeneficialOwnerRequestBuilder(String beneficialOwnerId, UpdateBusinessBeneficialOwnerRequest updateBusinessBeneficialOwnerRequest) throws ApiException {
        if (beneficialOwnerId == null) {
            throw new ApiException(400, "Missing the required parameter 'beneficialOwnerId' when calling updateBusinessBeneficialOwner");
        }
        if (updateBusinessBeneficialOwnerRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'updateBusinessBeneficialOwnerRequest' when calling updateBusinessBeneficialOwner");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/beneficial-owner/{beneficialOwnerId}".replace("{beneficialOwnerId}", ApiClient.urlEncode(beneficialOwnerId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/vnd.api+json");
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)updateBusinessBeneficialOwnerRequest);
            localVarRequestBuilder.method("PATCH", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitUpdateCardResponse updateCard(String cardId, UpdateCardRequest updateCardRequest) throws ApiException {
        ApiResponse<UnitUpdateCardResponse> localVarResponse = this.updateCardWithHttpInfo(cardId, updateCardRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitUpdateCardResponse> updateCardWithHttpInfo(String cardId, UpdateCardRequest updateCardRequest) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.updateCardRequestBuilder(cardId, updateCardRequest);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("updateCard", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitUpdateCardResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitUpdateCardResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder updateCardRequestBuilder(String cardId, UpdateCardRequest updateCardRequest) throws ApiException {
        if (cardId == null) {
            throw new ApiException(400, "Missing the required parameter 'cardId' when calling updateCard");
        }
        if (updateCardRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'updateCardRequest' when calling updateCard");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/cards/{cardId}".replace("{cardId}", ApiClient.urlEncode(cardId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/vnd.api+json");
        localVarRequestBuilder.header("Accept", "application/vnd.api+json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)updateCardRequest);
            localVarRequestBuilder.method("PATCH", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitUpdateCheckDepositResponse updateCheckDeposit(String checkDepositId, UpdateCheckDepositRequest updateCheckDepositRequest) throws ApiException {
        ApiResponse<UnitUpdateCheckDepositResponse> localVarResponse = this.updateCheckDepositWithHttpInfo(checkDepositId, updateCheckDepositRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitUpdateCheckDepositResponse> updateCheckDepositWithHttpInfo(String checkDepositId, UpdateCheckDepositRequest updateCheckDepositRequest) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.updateCheckDepositRequestBuilder(checkDepositId, updateCheckDepositRequest);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("updateCheckDeposit", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitUpdateCheckDepositResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitUpdateCheckDepositResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder updateCheckDepositRequestBuilder(String checkDepositId, UpdateCheckDepositRequest updateCheckDepositRequest) throws ApiException {
        if (checkDepositId == null) {
            throw new ApiException(400, "Missing the required parameter 'checkDepositId' when calling updateCheckDeposit");
        }
        if (updateCheckDepositRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'updateCheckDepositRequest' when calling updateCheckDeposit");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/check-deposits/{checkDepositId}".replace("{checkDepositId}", ApiClient.urlEncode(checkDepositId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/vnd.api+json");
        localVarRequestBuilder.header("Accept", "application/vnd.api+json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)updateCheckDepositRequest);
            localVarRequestBuilder.method("PATCH", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitCounterpartyResponse updateCounterparty(String counterpartyId, UpdateCounterpartyRequest updateCounterpartyRequest) throws ApiException {
        ApiResponse<UnitCounterpartyResponse> localVarResponse = this.updateCounterpartyWithHttpInfo(counterpartyId, updateCounterpartyRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitCounterpartyResponse> updateCounterpartyWithHttpInfo(String counterpartyId, UpdateCounterpartyRequest updateCounterpartyRequest) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.updateCounterpartyRequestBuilder(counterpartyId, updateCounterpartyRequest);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("updateCounterparty", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitCounterpartyResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitCounterpartyResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder updateCounterpartyRequestBuilder(String counterpartyId, UpdateCounterpartyRequest updateCounterpartyRequest) throws ApiException {
        if (counterpartyId == null) {
            throw new ApiException(400, "Missing the required parameter 'counterpartyId' when calling updateCounterparty");
        }
        if (updateCounterpartyRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'updateCounterpartyRequest' when calling updateCounterparty");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/counterparties/{counterpartyId}".replace("{counterpartyId}", ApiClient.urlEncode(counterpartyId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/vnd.api+json");
        localVarRequestBuilder.header("Accept", "application/vnd.api+json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)updateCounterpartyRequest);
            localVarRequestBuilder.method("PATCH", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitCustomerResponse updateCustomer(String customerId, UpdateCustomerRequest updateCustomerRequest) throws ApiException {
        ApiResponse<UnitCustomerResponse> localVarResponse = this.updateCustomerWithHttpInfo(customerId, updateCustomerRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitCustomerResponse> updateCustomerWithHttpInfo(String customerId, UpdateCustomerRequest updateCustomerRequest) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.updateCustomerRequestBuilder(customerId, updateCustomerRequest);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("updateCustomer", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitCustomerResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitCustomerResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder updateCustomerRequestBuilder(String customerId, UpdateCustomerRequest updateCustomerRequest) throws ApiException {
        if (customerId == null) {
            throw new ApiException(400, "Missing the required parameter 'customerId' when calling updateCustomer");
        }
        if (updateCustomerRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'updateCustomerRequest' when calling updateCustomer");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/customers/{customerId}".replace("{customerId}", ApiClient.urlEncode(customerId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/vnd.api+json");
        localVarRequestBuilder.header("Accept", "application/vnd.api+json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)updateCustomerRequest);
            localVarRequestBuilder.method("PATCH", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitPaymentResponse updatePayment(String paymentId, UpdatePaymentRequest updatePaymentRequest) throws ApiException {
        ApiResponse<UnitPaymentResponse> localVarResponse = this.updatePaymentWithHttpInfo(paymentId, updatePaymentRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitPaymentResponse> updatePaymentWithHttpInfo(String paymentId, UpdatePaymentRequest updatePaymentRequest) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.updatePaymentRequestBuilder(paymentId, updatePaymentRequest);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("updatePayment", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitPaymentResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitPaymentResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder updatePaymentRequestBuilder(String paymentId, UpdatePaymentRequest updatePaymentRequest) throws ApiException {
        if (paymentId == null) {
            throw new ApiException(400, "Missing the required parameter 'paymentId' when calling updatePayment");
        }
        if (updatePaymentRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'updatePaymentRequest' when calling updatePayment");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/payments/{paymentId}".replace("{paymentId}", ApiClient.urlEncode(paymentId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/vnd.api+json");
        localVarRequestBuilder.header("Accept", "application/vnd.api+json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)updatePaymentRequest);
            localVarRequestBuilder.method("PATCH", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public StopPaymentResponse updateStopPayment(String stopPaymentId, UpdateStopPaymentRequest updateStopPaymentRequest) throws ApiException {
        ApiResponse<StopPaymentResponse> localVarResponse = this.updateStopPaymentWithHttpInfo(stopPaymentId, updateStopPaymentRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<StopPaymentResponse> updateStopPaymentWithHttpInfo(String stopPaymentId, UpdateStopPaymentRequest updateStopPaymentRequest) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.updateStopPaymentRequestBuilder(stopPaymentId, updateStopPaymentRequest);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("updateStopPayment", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (StopPaymentResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<StopPaymentResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder updateStopPaymentRequestBuilder(String stopPaymentId, UpdateStopPaymentRequest updateStopPaymentRequest) throws ApiException {
        if (stopPaymentId == null) {
            throw new ApiException(400, "Missing the required parameter 'stopPaymentId' when calling updateStopPayment");
        }
        if (updateStopPaymentRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'updateStopPaymentRequest' when calling updateStopPayment");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/stop-payments/{stopPaymentId}".replace("{stopPaymentId}", ApiClient.urlEncode(stopPaymentId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)updateStopPaymentRequest);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitTransactionResponse updateTransaction(String accountId, String transactionId, UpdateTransactionRequest updateTransactionRequest) throws ApiException {
        ApiResponse<UnitTransactionResponse> localVarResponse = this.updateTransactionWithHttpInfo(accountId, transactionId, updateTransactionRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitTransactionResponse> updateTransactionWithHttpInfo(String accountId, String transactionId, UpdateTransactionRequest updateTransactionRequest) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.updateTransactionRequestBuilder(accountId, transactionId, updateTransactionRequest);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("updateTransaction", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitTransactionResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitTransactionResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder updateTransactionRequestBuilder(String accountId, String transactionId, UpdateTransactionRequest updateTransactionRequest) throws ApiException {
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateTransaction");
        }
        if (transactionId == null) {
            throw new ApiException(400, "Missing the required parameter 'transactionId' when calling updateTransaction");
        }
        if (updateTransactionRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'updateTransactionRequest' when calling updateTransaction");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/accounts/{accountId}/transactions/{transactionId}".replace("{accountId}", ApiClient.urlEncode(accountId.toString())).replace("{transactionId}", ApiClient.urlEncode(transactionId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/vnd.api+json");
        localVarRequestBuilder.header("Accept", "application/vnd.api+json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)updateTransactionRequest);
            localVarRequestBuilder.method("PATCH", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public WebhookResponse updateWebhook(String webhookId, UpdateWebhookRequest updateWebhookRequest) throws ApiException {
        ApiResponse<WebhookResponse> localVarResponse = this.updateWebhookWithHttpInfo(webhookId, updateWebhookRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<WebhookResponse> updateWebhookWithHttpInfo(String webhookId, UpdateWebhookRequest updateWebhookRequest) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.updateWebhookRequestBuilder(webhookId, updateWebhookRequest);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("updateWebhook", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (WebhookResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<WebhookResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder updateWebhookRequestBuilder(String webhookId, UpdateWebhookRequest updateWebhookRequest) throws ApiException {
        if (webhookId == null) {
            throw new ApiException(400, "Missing the required parameter 'webhookId' when calling updateWebhook");
        }
        if (updateWebhookRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'updateWebhookRequest' when calling updateWebhook");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/webhooks/{webhookId}".replace("{webhookId}", ApiClient.urlEncode(webhookId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/vnd.api+json");
        localVarRequestBuilder.header("Accept", "application/vnd.api+json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)updateWebhookRequest);
            localVarRequestBuilder.method("PATCH", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitDocumentResponse uploadApplicationDocumentFile(String applicationId, String documentId, File body) throws ApiException {
        ApiResponse<UnitDocumentResponse> localVarResponse = this.uploadApplicationDocumentFileWithHttpInfo(applicationId, documentId, body);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitDocumentResponse> uploadApplicationDocumentFileWithHttpInfo(String applicationId, String documentId, File body) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.uploadApplicationDocumentFileRequestBuilder(applicationId, documentId, body);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("uploadApplicationDocumentFile", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitDocumentResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitDocumentResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder uploadApplicationDocumentFileRequestBuilder(String applicationId, String documentId, File body) throws ApiException {
        if (applicationId == null) {
            throw new ApiException(400, "Missing the required parameter 'applicationId' when calling uploadApplicationDocumentFile");
        }
        if (documentId == null) {
            throw new ApiException(400, "Missing the required parameter 'documentId' when calling uploadApplicationDocumentFile");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling uploadApplicationDocumentFile");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/applications/{applicationId}/documents/{documentId}".replace("{applicationId}", ApiClient.urlEncode(applicationId.toString())).replace("{documentId}", ApiClient.urlEncode(documentId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/pdf");
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)body);
            localVarRequestBuilder.method("PUT", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitDocumentResponse uploadApplicationDocumentFileBackSide(String applicationId, String documentId, Object body) throws ApiException {
        ApiResponse<UnitDocumentResponse> localVarResponse = this.uploadApplicationDocumentFileBackSideWithHttpInfo(applicationId, documentId, body);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitDocumentResponse> uploadApplicationDocumentFileBackSideWithHttpInfo(String applicationId, String documentId, Object body) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.uploadApplicationDocumentFileBackSideRequestBuilder(applicationId, documentId, body);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("uploadApplicationDocumentFileBackSide", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitDocumentResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitDocumentResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder uploadApplicationDocumentFileBackSideRequestBuilder(String applicationId, String documentId, Object body) throws ApiException {
        if (applicationId == null) {
            throw new ApiException(400, "Missing the required parameter 'applicationId' when calling uploadApplicationDocumentFileBackSide");
        }
        if (documentId == null) {
            throw new ApiException(400, "Missing the required parameter 'documentId' when calling uploadApplicationDocumentFileBackSide");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling uploadApplicationDocumentFileBackSide");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/applications/{applicationId}/documents/{documentId}/back".replace("{applicationId}", ApiClient.urlEncode(applicationId.toString())).replace("{documentId}", ApiClient.urlEncode(documentId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/pdf");
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes(body);
            localVarRequestBuilder.method("PUT", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public UnitDocumentResponse verifyApplicationDocument(String applicationId, String documentId, VerifyDocument verifyDocument) throws ApiException {
        ApiResponse<UnitDocumentResponse> localVarResponse = this.verifyApplicationDocumentWithHttpInfo(applicationId, documentId, verifyDocument);
        return localVarResponse.getData();
    }

    public ApiResponse<UnitDocumentResponse> verifyApplicationDocumentWithHttpInfo(String applicationId, String documentId, VerifyDocument verifyDocument) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.verifyApplicationDocumentRequestBuilder(applicationId, documentId, verifyDocument);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("verifyApplicationDocument", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (UnitDocumentResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<UnitDocumentResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder verifyApplicationDocumentRequestBuilder(String applicationId, String documentId, VerifyDocument verifyDocument) throws ApiException {
        if (applicationId == null) {
            throw new ApiException(400, "Missing the required parameter 'applicationId' when calling verifyApplicationDocument");
        }
        if (documentId == null) {
            throw new ApiException(400, "Missing the required parameter 'documentId' when calling verifyApplicationDocument");
        }
        if (verifyDocument == null) {
            throw new ApiException(400, "Missing the required parameter 'verifyDocument' when calling verifyApplicationDocument");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/applications/{applicationId}/documents/{documentId}/verify".replace("{applicationId}", ApiClient.urlEncode(applicationId.toString())).replace("{documentId}", ApiClient.urlEncode(documentId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)verifyDocument);
            localVarRequestBuilder.method("PUT", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }
}

