/*
 * Decompiled with CFR 0.152.
 */
package unit.java.sdk.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import jakarta.annotation.Nonnull;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Objects;
import java.util.StringJoiner;
import unit.java.sdk.JSON;
import unit.java.sdk.model.BookRepaymentAllOfAttributes;
import unit.java.sdk.model.BookRepaymentRelationships;
import unit.java.sdk.model.Repayment;

@JsonPropertyOrder(value={"attributes", "relationships"})
@JsonIgnoreProperties(value={"type"}, allowSetters=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type", visible=true)
public class BookRepayment
extends Repayment {
    public static final String JSON_PROPERTY_ATTRIBUTES = "attributes";
    private BookRepaymentAllOfAttributes attributes;
    public static final String JSON_PROPERTY_RELATIONSHIPS = "relationships";
    private BookRepaymentRelationships relationships;

    public BookRepayment attributes(BookRepaymentAllOfAttributes attributes) {
        this.attributes = attributes;
        return this;
    }

    @Nonnull
    @JsonProperty(value="attributes")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public BookRepaymentAllOfAttributes getAttributes() {
        return this.attributes;
    }

    @JsonProperty(value="attributes")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAttributes(BookRepaymentAllOfAttributes attributes) {
        this.attributes = attributes;
    }

    public BookRepayment relationships(BookRepaymentRelationships relationships) {
        this.relationships = relationships;
        return this;
    }

    @Nonnull
    @JsonProperty(value="relationships")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public BookRepaymentRelationships getRelationships() {
        return this.relationships;
    }

    @JsonProperty(value="relationships")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRelationships(BookRepaymentRelationships relationships) {
        this.relationships = relationships;
    }

    @Override
    public BookRepayment id(String id) {
        this.setId(id);
        return this;
    }

    @Override
    public BookRepayment type(Repayment.TypeEnum type) {
        this.setType(type);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BookRepayment bookRepayment = (BookRepayment)o;
        return Objects.equals(this.attributes, bookRepayment.attributes) && Objects.equals(this.relationships, bookRepayment.relationships) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.attributes, this.relationships, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BookRepayment {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    relationships: ").append(this.toIndentedString(this.relationships)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @Override
    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    @Override
    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getId() != null) {
            joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getType() != null) {
            joiner.add(String.format("%stype%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getType()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getAttributes() != null) {
            joiner.add(this.getAttributes().toUrlQueryString((String)prefix + JSON_PROPERTY_ATTRIBUTES + suffix));
        }
        if (this.getRelationships() != null) {
            joiner.add(this.getRelationships().toUrlQueryString((String)prefix + JSON_PROPERTY_RELATIONSHIPS + suffix));
        }
        return joiner.toString();
    }

    static {
        HashMap mappings = new HashMap();
        mappings.put("BookRepayment", BookRepayment.class);
        JSON.registerDiscriminator(BookRepayment.class, "type", mappings);
    }
}

