/*
 * Decompiled with CFR 0.152.
 */
package unit.java.sdk.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import jakarta.annotation.Nonnull;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Objects;
import java.util.StringJoiner;
import unit.java.sdk.JSON;
import unit.java.sdk.model.BusinessDebitCardAllOfAttributes;
import unit.java.sdk.model.Card;
import unit.java.sdk.model.CardRelationships;

@JsonPropertyOrder(value={"attributes", "relationships"})
@JsonIgnoreProperties(value={"type"}, allowSetters=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type", visible=true)
public class BusinessDebitCard
extends Card {
    public static final String JSON_PROPERTY_ATTRIBUTES = "attributes";
    private BusinessDebitCardAllOfAttributes attributes;
    public static final String JSON_PROPERTY_RELATIONSHIPS = "relationships";
    private CardRelationships relationships;

    public BusinessDebitCard attributes(BusinessDebitCardAllOfAttributes attributes) {
        this.attributes = attributes;
        return this;
    }

    @Nonnull
    @JsonProperty(value="attributes")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public BusinessDebitCardAllOfAttributes getAttributes() {
        return this.attributes;
    }

    @JsonProperty(value="attributes")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAttributes(BusinessDebitCardAllOfAttributes attributes) {
        this.attributes = attributes;
    }

    public BusinessDebitCard relationships(CardRelationships relationships) {
        this.relationships = relationships;
        return this;
    }

    @Nonnull
    @JsonProperty(value="relationships")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public CardRelationships getRelationships() {
        return this.relationships;
    }

    @JsonProperty(value="relationships")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRelationships(CardRelationships relationships) {
        this.relationships = relationships;
    }

    @Override
    public BusinessDebitCard type(Card.TypeEnum type) {
        this.setType(type);
        return this;
    }

    @Override
    public BusinessDebitCard id(String id) {
        this.setId(id);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BusinessDebitCard businessDebitCard = (BusinessDebitCard)o;
        return Objects.equals(this.attributes, businessDebitCard.attributes) && Objects.equals(this.relationships, businessDebitCard.relationships) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.attributes, this.relationships, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BusinessDebitCard {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    relationships: ").append(this.toIndentedString(this.relationships)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @Override
    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    @Override
    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getType() != null) {
            joiner.add(String.format("%stype%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getType()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getId() != null) {
            joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getAttributes() != null) {
            joiner.add(this.getAttributes().toUrlQueryString((String)prefix + JSON_PROPERTY_ATTRIBUTES + suffix));
        }
        if (this.getRelationships() != null) {
            joiner.add(this.getRelationships().toUrlQueryString((String)prefix + JSON_PROPERTY_RELATIONSHIPS + suffix));
        }
        return joiner.toString();
    }

    static {
        HashMap mappings = new HashMap();
        mappings.put("BusinessDebitCard", BusinessDebitCard.class);
        JSON.registerDiscriminator(BusinessDebitCard.class, "type", mappings);
    }
}

