/*
 * Decompiled with CFR 0.152.
 */
package unit.java.sdk.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Objects;
import java.util.StringJoiner;
import unit.java.sdk.JSON;
import unit.java.sdk.model.BusinessCreditCard;
import unit.java.sdk.model.BusinessDebitCard;
import unit.java.sdk.model.BusinessVirtualCreditCard;
import unit.java.sdk.model.BusinessVirtualDebitCard;
import unit.java.sdk.model.IndividualDebitCard;
import unit.java.sdk.model.IndividualVirtualDebitCard;

@JsonPropertyOrder(value={"type", "id"})
@JsonIgnoreProperties(value={"type"}, allowSetters=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type", visible=true)
@JsonSubTypes(value={@JsonSubTypes.Type(value=BusinessCreditCard.class, name="businessCreditCard"), @JsonSubTypes.Type(value=BusinessDebitCard.class, name="businessDebitCard"), @JsonSubTypes.Type(value=BusinessVirtualCreditCard.class, name="businessVirtualCreditCard"), @JsonSubTypes.Type(value=BusinessVirtualDebitCard.class, name="businessVirtualDebitCard"), @JsonSubTypes.Type(value=IndividualDebitCard.class, name="individualDebitCard"), @JsonSubTypes.Type(value=IndividualVirtualDebitCard.class, name="individualVirtualDebitCard")})
public class Card {
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;

    public Card type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nullable
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public Card id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Card card = (Card)o;
        return Objects.equals((Object)this.type, (Object)card.type) && Objects.equals(this.id, card.id);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.id});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Card {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getType() != null) {
            joiner.add(String.format("%stype%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getType()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getId() != null) {
            joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }

    static {
        HashMap mappings = new HashMap();
        mappings.put("businessCreditCard", BusinessCreditCard.class);
        mappings.put("businessDebitCard", BusinessDebitCard.class);
        mappings.put("businessVirtualCreditCard", BusinessVirtualCreditCard.class);
        mappings.put("businessVirtualDebitCard", BusinessVirtualDebitCard.class);
        mappings.put("individualDebitCard", IndividualDebitCard.class);
        mappings.put("individualVirtualDebitCard", IndividualVirtualDebitCard.class);
        mappings.put("Card", Card.class);
        JSON.registerDiscriminator(Card.class, JSON_PROPERTY_TYPE, mappings);
    }

    public static enum TypeEnum {
        BUSINESSDEBITCARD("businessDebitCard"),
        INDIVIDUALDEBITCARD("individualDebitCard"),
        BUSINESSVIRTUALDEBITCARD("businessVirtualDebitCard"),
        INDIVIDUALVIRTUALDEBITCARD("individualVirtualDebitCard"),
        BUSINESSCREDITCARD("businessCreditCard"),
        BUSINESSVIRTUALCREDITCARD("businessVirtualCreditCard");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

