/*
 * Decompiled with CFR 0.152.
 */
package unit.java.sdk.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import org.openapitools.jackson.nullable.JsonNullable;
import unit.java.sdk.model.CheckDepositCounterparty;
import unit.java.sdk.model.StatusEvent;

@JsonPropertyOrder(value={"createdAt", "settlementDate", "amount", "description", "status", "reason", "statusCreatedAt", "statusSetBy", "statusHistory", "reasonText", "checkNumber", "vendor", "counterparty", "tags"})
public class CheckDepositAttributes {
    public static final String JSON_PROPERTY_CREATED_AT = "createdAt";
    private OffsetDateTime createdAt;
    public static final String JSON_PROPERTY_SETTLEMENT_DATE = "settlementDate";
    private LocalDate settlementDate;
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private Integer amount;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status;
    public static final String JSON_PROPERTY_REASON = "reason";
    private JsonNullable<String> reason = JsonNullable.undefined();
    public static final String JSON_PROPERTY_STATUS_CREATED_AT = "statusCreatedAt";
    private OffsetDateTime statusCreatedAt;
    public static final String JSON_PROPERTY_STATUS_SET_BY = "statusSetBy";
    private String statusSetBy;
    public static final String JSON_PROPERTY_STATUS_HISTORY = "statusHistory";
    private List<StatusEvent> statusHistory = new ArrayList<StatusEvent>();
    public static final String JSON_PROPERTY_REASON_TEXT = "reasonText";
    private String reasonText;
    public static final String JSON_PROPERTY_CHECK_NUMBER = "checkNumber";
    private String checkNumber;
    public static final String JSON_PROPERTY_VENDOR = "vendor";
    private String vendor;
    public static final String JSON_PROPERTY_COUNTERPARTY = "counterparty";
    private CheckDepositCounterparty counterparty;
    public static final String JSON_PROPERTY_TAGS = "tags";
    private Map<String, String> tags = new HashMap<String, String>();

    public CheckDepositAttributes createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nonnull
    @JsonProperty(value="createdAt")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="createdAt")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public CheckDepositAttributes settlementDate(LocalDate settlementDate) {
        this.settlementDate = settlementDate;
        return this;
    }

    @Nullable
    @JsonProperty(value="settlementDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDate getSettlementDate() {
        return this.settlementDate;
    }

    @JsonProperty(value="settlementDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSettlementDate(LocalDate settlementDate) {
        this.settlementDate = settlementDate;
    }

    public CheckDepositAttributes amount(Integer amount) {
        this.amount = amount;
        return this;
    }

    @Nonnull
    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Integer getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAmount(Integer amount) {
        this.amount = amount;
    }

    public CheckDepositAttributes description(String description) {
        this.description = description;
        return this;
    }

    @Nonnull
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDescription(String description) {
        this.description = description;
    }

    public CheckDepositAttributes status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @Nonnull
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public CheckDepositAttributes reason(String reason) {
        this.reason = JsonNullable.of((Object)reason);
        return this;
    }

    @Nullable
    @JsonIgnore
    public String getReason() {
        return (String)this.reason.orElse(null);
    }

    @JsonProperty(value="reason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getReason_JsonNullable() {
        return this.reason;
    }

    @JsonProperty(value="reason")
    public void setReason_JsonNullable(JsonNullable<String> reason) {
        this.reason = reason;
    }

    public void setReason(String reason) {
        this.reason = JsonNullable.of((Object)reason);
    }

    public CheckDepositAttributes statusCreatedAt(OffsetDateTime statusCreatedAt) {
        this.statusCreatedAt = statusCreatedAt;
        return this;
    }

    @Nullable
    @JsonProperty(value="statusCreatedAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getStatusCreatedAt() {
        return this.statusCreatedAt;
    }

    @JsonProperty(value="statusCreatedAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatusCreatedAt(OffsetDateTime statusCreatedAt) {
        this.statusCreatedAt = statusCreatedAt;
    }

    public CheckDepositAttributes statusSetBy(String statusSetBy) {
        this.statusSetBy = statusSetBy;
        return this;
    }

    @Nullable
    @JsonProperty(value="statusSetBy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStatusSetBy() {
        return this.statusSetBy;
    }

    @JsonProperty(value="statusSetBy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatusSetBy(String statusSetBy) {
        this.statusSetBy = statusSetBy;
    }

    public CheckDepositAttributes statusHistory(List<StatusEvent> statusHistory) {
        this.statusHistory = statusHistory;
        return this;
    }

    public CheckDepositAttributes addStatusHistoryItem(StatusEvent statusHistoryItem) {
        if (this.statusHistory == null) {
            this.statusHistory = new ArrayList<StatusEvent>();
        }
        this.statusHistory.add(statusHistoryItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="statusHistory")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<StatusEvent> getStatusHistory() {
        return this.statusHistory;
    }

    @JsonProperty(value="statusHistory")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatusHistory(List<StatusEvent> statusHistory) {
        this.statusHistory = statusHistory;
    }

    public CheckDepositAttributes reasonText(String reasonText) {
        this.reasonText = reasonText;
        return this;
    }

    @Nullable
    @JsonProperty(value="reasonText")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReasonText() {
        return this.reasonText;
    }

    @JsonProperty(value="reasonText")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReasonText(String reasonText) {
        this.reasonText = reasonText;
    }

    public CheckDepositAttributes checkNumber(String checkNumber) {
        this.checkNumber = checkNumber;
        return this;
    }

    @Nullable
    @JsonProperty(value="checkNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCheckNumber() {
        return this.checkNumber;
    }

    @JsonProperty(value="checkNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCheckNumber(String checkNumber) {
        this.checkNumber = checkNumber;
    }

    public CheckDepositAttributes vendor(String vendor) {
        this.vendor = vendor;
        return this;
    }

    @Nullable
    @JsonProperty(value="vendor")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getVendor() {
        return this.vendor;
    }

    @JsonProperty(value="vendor")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    public CheckDepositAttributes counterparty(CheckDepositCounterparty counterparty) {
        this.counterparty = counterparty;
        return this;
    }

    @Nullable
    @JsonProperty(value="counterparty")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CheckDepositCounterparty getCounterparty() {
        return this.counterparty;
    }

    @JsonProperty(value="counterparty")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCounterparty(CheckDepositCounterparty counterparty) {
        this.counterparty = counterparty;
    }

    public CheckDepositAttributes tags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public CheckDepositAttributes putTagsItem(String key, String tagsItem) {
        if (this.tags == null) {
            this.tags = new HashMap<String, String>();
        }
        this.tags.put(key, tagsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getTags() {
        return this.tags;
    }

    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CheckDepositAttributes checkDepositAttributes = (CheckDepositAttributes)o;
        return Objects.equals(this.createdAt, checkDepositAttributes.createdAt) && Objects.equals(this.settlementDate, checkDepositAttributes.settlementDate) && Objects.equals(this.amount, checkDepositAttributes.amount) && Objects.equals(this.description, checkDepositAttributes.description) && Objects.equals((Object)this.status, (Object)checkDepositAttributes.status) && CheckDepositAttributes.equalsNullable(this.reason, checkDepositAttributes.reason) && Objects.equals(this.statusCreatedAt, checkDepositAttributes.statusCreatedAt) && Objects.equals(this.statusSetBy, checkDepositAttributes.statusSetBy) && Objects.equals(this.statusHistory, checkDepositAttributes.statusHistory) && Objects.equals(this.reasonText, checkDepositAttributes.reasonText) && Objects.equals(this.checkNumber, checkDepositAttributes.checkNumber) && Objects.equals(this.vendor, checkDepositAttributes.vendor) && Objects.equals(this.counterparty, checkDepositAttributes.counterparty) && Objects.equals(this.tags, checkDepositAttributes.tags);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.createdAt, this.settlementDate, this.amount, this.description, this.status, CheckDepositAttributes.hashCodeNullable(this.reason), this.statusCreatedAt, this.statusSetBy, this.statusHistory, this.reasonText, this.checkNumber, this.vendor, this.counterparty, this.tags});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CheckDepositAttributes {\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    settlementDate: ").append(this.toIndentedString(this.settlementDate)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    reason: ").append(this.toIndentedString(this.reason)).append("\n");
        sb.append("    statusCreatedAt: ").append(this.toIndentedString(this.statusCreatedAt)).append("\n");
        sb.append("    statusSetBy: ").append(this.toIndentedString(this.statusSetBy)).append("\n");
        sb.append("    statusHistory: ").append(this.toIndentedString(this.statusHistory)).append("\n");
        sb.append("    reasonText: ").append(this.toIndentedString(this.reasonText)).append("\n");
        sb.append("    checkNumber: ").append(this.toIndentedString(this.checkNumber)).append("\n");
        sb.append("    vendor: ").append(this.toIndentedString(this.vendor)).append("\n");
        sb.append("    counterparty: ").append(this.toIndentedString(this.counterparty)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getCreatedAt() != null) {
            joiner.add(String.format("%screatedAt%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getCreatedAt()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getSettlementDate() != null) {
            joiner.add(String.format("%ssettlementDate%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getSettlementDate()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getAmount() != null) {
            joiner.add(String.format("%samount%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getAmount()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getDescription() != null) {
            joiner.add(String.format("%sdescription%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getDescription()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getStatus() != null) {
            joiner.add(String.format("%sstatus%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getStatus()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getReason() != null) {
            joiner.add(String.format("%sreason%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getReason()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getStatusCreatedAt() != null) {
            joiner.add(String.format("%sstatusCreatedAt%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getStatusCreatedAt()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getStatusSetBy() != null) {
            joiner.add(String.format("%sstatusSetBy%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getStatusSetBy()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getStatusHistory() != null) {
            for (int i = 0; i < this.getStatusHistory().size(); ++i) {
                if (this.getStatusHistory().get(i) == null) continue;
                joiner.add(this.getStatusHistory().get(i).toUrlQueryString(String.format("%sstatusHistory%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getReasonText() != null) {
            joiner.add(String.format("%sreasonText%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getReasonText()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getCheckNumber() != null) {
            joiner.add(String.format("%scheckNumber%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getCheckNumber()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getVendor() != null) {
            joiner.add(String.format("%svendor%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getVendor()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getCounterparty() != null) {
            joiner.add(this.getCounterparty().toUrlQueryString((String)prefix + JSON_PROPERTY_COUNTERPARTY + suffix));
        }
        if (this.getTags() != null) {
            for (String _key : this.getTags().keySet()) {
                joiner.add(String.format("%stags%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix), this.getTags().get(_key), URLEncoder.encode(String.valueOf(this.getTags().get(_key)), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
            }
        }
        return joiner.toString();
    }

    public static enum StatusEnum {
        AWAITINGIMAGES("AwaitingImages"),
        AWAITINGFRONTIMAGE("AwaitingFrontImage"),
        AWAITINGBACKIMAGE("AwaitingBackImage"),
        PENDING("Pending"),
        PENDINGREVIEW("PendingReview"),
        AWAITINGCUSTOMERCONFIRMATION("AwaitingCustomerConfirmation"),
        REJECTED("Rejected"),
        CLEARING("Clearing"),
        SENT("Sent"),
        CANCELED("Canceled"),
        RETURNED("Returned");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

