/*
 * Decompiled with CFR 0.152.
 */
package unit.java.sdk.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"label", "url", "token", "contentType", "deliveryMode", "includeResources", "subscriptionType"})
public class CreateWebhookDataAttributes {
    public static final String JSON_PROPERTY_LABEL = "label";
    private String label;
    public static final String JSON_PROPERTY_URL = "url";
    private String url;
    public static final String JSON_PROPERTY_TOKEN = "token";
    private String token;
    public static final String JSON_PROPERTY_CONTENT_TYPE = "contentType";
    private ContentTypeEnum contentType;
    public static final String JSON_PROPERTY_DELIVERY_MODE = "deliveryMode";
    private String deliveryMode;
    public static final String JSON_PROPERTY_INCLUDE_RESOURCES = "includeResources";
    private Boolean includeResources;
    public static final String JSON_PROPERTY_SUBSCRIPTION_TYPE = "subscriptionType";
    private SubscriptionTypeEnum subscriptionType;

    public CreateWebhookDataAttributes label(String label) {
        this.label = label;
        return this;
    }

    @Nonnull
    @JsonProperty(value="label")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getLabel() {
        return this.label;
    }

    @JsonProperty(value="label")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLabel(String label) {
        this.label = label;
    }

    public CreateWebhookDataAttributes url(String url) {
        this.url = url;
        return this;
    }

    @Nonnull
    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getUrl() {
        return this.url;
    }

    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUrl(String url) {
        this.url = url;
    }

    public CreateWebhookDataAttributes token(String token) {
        this.token = token;
        return this;
    }

    @Nonnull
    @JsonProperty(value="token")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getToken() {
        return this.token;
    }

    @JsonProperty(value="token")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setToken(String token) {
        this.token = token;
    }

    public CreateWebhookDataAttributes contentType(ContentTypeEnum contentType) {
        this.contentType = contentType;
        return this;
    }

    @Nonnull
    @JsonProperty(value="contentType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ContentTypeEnum getContentType() {
        return this.contentType;
    }

    @JsonProperty(value="contentType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setContentType(ContentTypeEnum contentType) {
        this.contentType = contentType;
    }

    public CreateWebhookDataAttributes deliveryMode(String deliveryMode) {
        this.deliveryMode = deliveryMode;
        return this;
    }

    @Nonnull
    @JsonProperty(value="deliveryMode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDeliveryMode() {
        return this.deliveryMode;
    }

    @JsonProperty(value="deliveryMode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDeliveryMode(String deliveryMode) {
        this.deliveryMode = deliveryMode;
    }

    public CreateWebhookDataAttributes includeResources(Boolean includeResources) {
        this.includeResources = includeResources;
        return this;
    }

    @Nullable
    @JsonProperty(value="includeResources")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIncludeResources() {
        return this.includeResources;
    }

    @JsonProperty(value="includeResources")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIncludeResources(Boolean includeResources) {
        this.includeResources = includeResources;
    }

    public CreateWebhookDataAttributes subscriptionType(SubscriptionTypeEnum subscriptionType) {
        this.subscriptionType = subscriptionType;
        return this;
    }

    @Nullable
    @JsonProperty(value="subscriptionType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SubscriptionTypeEnum getSubscriptionType() {
        return this.subscriptionType;
    }

    @JsonProperty(value="subscriptionType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSubscriptionType(SubscriptionTypeEnum subscriptionType) {
        this.subscriptionType = subscriptionType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateWebhookDataAttributes createWebhookDataAttributes = (CreateWebhookDataAttributes)o;
        return Objects.equals(this.label, createWebhookDataAttributes.label) && Objects.equals(this.url, createWebhookDataAttributes.url) && Objects.equals(this.token, createWebhookDataAttributes.token) && Objects.equals((Object)this.contentType, (Object)createWebhookDataAttributes.contentType) && Objects.equals(this.deliveryMode, createWebhookDataAttributes.deliveryMode) && Objects.equals(this.includeResources, createWebhookDataAttributes.includeResources) && Objects.equals((Object)this.subscriptionType, (Object)createWebhookDataAttributes.subscriptionType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.label, this.url, this.token, this.contentType, this.deliveryMode, this.includeResources, this.subscriptionType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateWebhookDataAttributes {\n");
        sb.append("    label: ").append(this.toIndentedString(this.label)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    token: ").append(this.toIndentedString(this.token)).append("\n");
        sb.append("    contentType: ").append(this.toIndentedString((Object)this.contentType)).append("\n");
        sb.append("    deliveryMode: ").append(this.toIndentedString(this.deliveryMode)).append("\n");
        sb.append("    includeResources: ").append(this.toIndentedString(this.includeResources)).append("\n");
        sb.append("    subscriptionType: ").append(this.toIndentedString((Object)this.subscriptionType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getLabel() != null) {
            joiner.add(String.format("%slabel%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getLabel()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getUrl() != null) {
            joiner.add(String.format("%surl%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getUrl()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getToken() != null) {
            joiner.add(String.format("%stoken%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getToken()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getContentType() != null) {
            joiner.add(String.format("%scontentType%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getContentType()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getDeliveryMode() != null) {
            joiner.add(String.format("%sdeliveryMode%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getDeliveryMode()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getIncludeResources() != null) {
            joiner.add(String.format("%sincludeResources%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getIncludeResources()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getSubscriptionType() != null) {
            joiner.add(String.format("%ssubscriptionType%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getSubscriptionType()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }

    public static enum SubscriptionTypeEnum {
        ALL("All"),
        ONLYAUTHORIZATIONREQUEST("OnlyAuthorizationRequest");

        private String value;

        private SubscriptionTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SubscriptionTypeEnum fromValue(String value) {
            for (SubscriptionTypeEnum b : SubscriptionTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum ContentTypeEnum {
        JSON("Json"),
        JSONAPI("JsonAPI");

        private String value;

        private ContentTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ContentTypeEnum fromValue(String value) {
            for (ContentTypeEnum b : ContentTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

