/*
 * Decompiled with CFR 0.152.
 */
package unit.java.sdk.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Objects;
import java.util.StringJoiner;
import unit.java.sdk.JSON;
import unit.java.sdk.model.ResponseSchedule;

@JsonPropertyOrder(value={"startTime", "endTime", "dayOfMonth", "dayOfWeek", "totalNumberOfPayments"})
@JsonIgnoreProperties(value={"interval"}, allowSetters=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="interval", visible=true)
public class ResponseMonthlySchedule
extends ResponseSchedule {
    public static final String JSON_PROPERTY_START_TIME = "startTime";
    private LocalDate startTime;
    public static final String JSON_PROPERTY_END_TIME = "endTime";
    private LocalDate endTime;
    public static final String JSON_PROPERTY_DAY_OF_MONTH = "dayOfMonth";
    private Integer dayOfMonth;
    public static final String JSON_PROPERTY_DAY_OF_WEEK = "dayOfWeek";
    private DayOfWeekEnum dayOfWeek;
    public static final String JSON_PROPERTY_TOTAL_NUMBER_OF_PAYMENTS = "totalNumberOfPayments";
    private Integer totalNumberOfPayments;

    public ResponseMonthlySchedule startTime(LocalDate startTime) {
        this.startTime = startTime;
        return this;
    }

    @Nullable
    @JsonProperty(value="startTime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDate getStartTime() {
        return this.startTime;
    }

    @JsonProperty(value="startTime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStartTime(LocalDate startTime) {
        this.startTime = startTime;
    }

    public ResponseMonthlySchedule endTime(LocalDate endTime) {
        this.endTime = endTime;
        return this;
    }

    @Nullable
    @JsonProperty(value="endTime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDate getEndTime() {
        return this.endTime;
    }

    @JsonProperty(value="endTime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEndTime(LocalDate endTime) {
        this.endTime = endTime;
    }

    public ResponseMonthlySchedule dayOfMonth(Integer dayOfMonth) {
        this.dayOfMonth = dayOfMonth;
        return this;
    }

    @Nullable
    @JsonProperty(value="dayOfMonth")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getDayOfMonth() {
        return this.dayOfMonth;
    }

    @JsonProperty(value="dayOfMonth")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDayOfMonth(Integer dayOfMonth) {
        this.dayOfMonth = dayOfMonth;
    }

    public ResponseMonthlySchedule dayOfWeek(DayOfWeekEnum dayOfWeek) {
        this.dayOfWeek = dayOfWeek;
        return this;
    }

    @Nullable
    @JsonProperty(value="dayOfWeek")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DayOfWeekEnum getDayOfWeek() {
        return this.dayOfWeek;
    }

    @JsonProperty(value="dayOfWeek")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDayOfWeek(DayOfWeekEnum dayOfWeek) {
        this.dayOfWeek = dayOfWeek;
    }

    public ResponseMonthlySchedule totalNumberOfPayments(Integer totalNumberOfPayments) {
        this.totalNumberOfPayments = totalNumberOfPayments;
        return this;
    }

    @Nullable
    @JsonProperty(value="totalNumberOfPayments")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getTotalNumberOfPayments() {
        return this.totalNumberOfPayments;
    }

    @JsonProperty(value="totalNumberOfPayments")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalNumberOfPayments(Integer totalNumberOfPayments) {
        this.totalNumberOfPayments = totalNumberOfPayments;
    }

    @Override
    public ResponseMonthlySchedule interval(ResponseSchedule.IntervalEnum interval) {
        this.setInterval(interval);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResponseMonthlySchedule responseMonthlySchedule = (ResponseMonthlySchedule)o;
        return Objects.equals(this.startTime, responseMonthlySchedule.startTime) && Objects.equals(this.endTime, responseMonthlySchedule.endTime) && Objects.equals(this.dayOfMonth, responseMonthlySchedule.dayOfMonth) && Objects.equals((Object)this.dayOfWeek, (Object)responseMonthlySchedule.dayOfWeek) && Objects.equals(this.totalNumberOfPayments, responseMonthlySchedule.totalNumberOfPayments) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.startTime, this.endTime, this.dayOfMonth, this.dayOfWeek, this.totalNumberOfPayments, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ResponseMonthlySchedule {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    startTime: ").append(this.toIndentedString(this.startTime)).append("\n");
        sb.append("    endTime: ").append(this.toIndentedString(this.endTime)).append("\n");
        sb.append("    dayOfMonth: ").append(this.toIndentedString(this.dayOfMonth)).append("\n");
        sb.append("    dayOfWeek: ").append(this.toIndentedString((Object)this.dayOfWeek)).append("\n");
        sb.append("    totalNumberOfPayments: ").append(this.toIndentedString(this.totalNumberOfPayments)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @Override
    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    @Override
    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getInterval() != null) {
            joiner.add(String.format("%sinterval%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getInterval()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getStartTime() != null) {
            joiner.add(String.format("%sstartTime%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getStartTime()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getEndTime() != null) {
            joiner.add(String.format("%sendTime%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getEndTime()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getDayOfMonth() != null) {
            joiner.add(String.format("%sdayOfMonth%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getDayOfMonth()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getDayOfWeek() != null) {
            joiner.add(String.format("%sdayOfWeek%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getDayOfWeek()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getTotalNumberOfPayments() != null) {
            joiner.add(String.format("%stotalNumberOfPayments%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getTotalNumberOfPayments()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }

    static {
        HashMap mappings = new HashMap();
        mappings.put("ResponseMonthlySchedule", ResponseMonthlySchedule.class);
        JSON.registerDiscriminator(ResponseMonthlySchedule.class, "interval", mappings);
    }

    public static enum DayOfWeekEnum {
        SUNDAY("Sunday"),
        MONDAY("Monday"),
        TUESDAY("Tuesday"),
        WEDNESDAY("Wednesday"),
        THURSDAY("Thursday"),
        FRIDAY("Friday"),
        SATURDAY("Saturday");

        private String value;

        private DayOfWeekEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static DayOfWeekEnum fromValue(String value) {
            for (DayOfWeekEnum b : DayOfWeekEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

