/*
 * Decompiled with CFR 0.152.
 */
package unit.java.sdk.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"startTime", "endTime", "dayOfMonth", "nextScheduledAction", "totalNumberOfPayments", "interval"})
public class WeeklySchedule {
    public static final String JSON_PROPERTY_START_TIME = "startTime";
    private LocalDate startTime;
    public static final String JSON_PROPERTY_END_TIME = "endTime";
    private LocalDate endTime;
    public static final String JSON_PROPERTY_DAY_OF_MONTH = "dayOfMonth";
    private Integer dayOfMonth;
    public static final String JSON_PROPERTY_NEXT_SCHEDULED_ACTION = "nextScheduledAction";
    private LocalDate nextScheduledAction;
    public static final String JSON_PROPERTY_TOTAL_NUMBER_OF_PAYMENTS = "totalNumberOfPayments";
    private Integer totalNumberOfPayments;
    public static final String JSON_PROPERTY_INTERVAL = "interval";
    private IntervalEnum interval = IntervalEnum.WEEKLY;

    public WeeklySchedule startTime(LocalDate startTime) {
        this.startTime = startTime;
        return this;
    }

    @Nullable
    @JsonProperty(value="startTime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDate getStartTime() {
        return this.startTime;
    }

    @JsonProperty(value="startTime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStartTime(LocalDate startTime) {
        this.startTime = startTime;
    }

    public WeeklySchedule endTime(LocalDate endTime) {
        this.endTime = endTime;
        return this;
    }

    @Nullable
    @JsonProperty(value="endTime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDate getEndTime() {
        return this.endTime;
    }

    @JsonProperty(value="endTime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEndTime(LocalDate endTime) {
        this.endTime = endTime;
    }

    public WeeklySchedule dayOfMonth(Integer dayOfMonth) {
        this.dayOfMonth = dayOfMonth;
        return this;
    }

    @Nullable
    @JsonProperty(value="dayOfMonth")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getDayOfMonth() {
        return this.dayOfMonth;
    }

    @JsonProperty(value="dayOfMonth")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDayOfMonth(Integer dayOfMonth) {
        this.dayOfMonth = dayOfMonth;
    }

    public WeeklySchedule nextScheduledAction(LocalDate nextScheduledAction) {
        this.nextScheduledAction = nextScheduledAction;
        return this;
    }

    @Nonnull
    @JsonProperty(value="nextScheduledAction")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LocalDate getNextScheduledAction() {
        return this.nextScheduledAction;
    }

    @JsonProperty(value="nextScheduledAction")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setNextScheduledAction(LocalDate nextScheduledAction) {
        this.nextScheduledAction = nextScheduledAction;
    }

    public WeeklySchedule totalNumberOfPayments(Integer totalNumberOfPayments) {
        this.totalNumberOfPayments = totalNumberOfPayments;
        return this;
    }

    @Nullable
    @JsonProperty(value="totalNumberOfPayments")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getTotalNumberOfPayments() {
        return this.totalNumberOfPayments;
    }

    @JsonProperty(value="totalNumberOfPayments")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalNumberOfPayments(Integer totalNumberOfPayments) {
        this.totalNumberOfPayments = totalNumberOfPayments;
    }

    public WeeklySchedule interval(IntervalEnum interval) {
        this.interval = interval;
        return this;
    }

    @Nonnull
    @JsonProperty(value="interval")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public IntervalEnum getInterval() {
        return this.interval;
    }

    @JsonProperty(value="interval")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setInterval(IntervalEnum interval) {
        this.interval = interval;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WeeklySchedule weeklySchedule = (WeeklySchedule)o;
        return Objects.equals(this.startTime, weeklySchedule.startTime) && Objects.equals(this.endTime, weeklySchedule.endTime) && Objects.equals(this.dayOfMonth, weeklySchedule.dayOfMonth) && Objects.equals(this.nextScheduledAction, weeklySchedule.nextScheduledAction) && Objects.equals(this.totalNumberOfPayments, weeklySchedule.totalNumberOfPayments) && Objects.equals((Object)this.interval, (Object)weeklySchedule.interval);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.startTime, this.endTime, this.dayOfMonth, this.nextScheduledAction, this.totalNumberOfPayments, this.interval});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WeeklySchedule {\n");
        sb.append("    startTime: ").append(this.toIndentedString(this.startTime)).append("\n");
        sb.append("    endTime: ").append(this.toIndentedString(this.endTime)).append("\n");
        sb.append("    dayOfMonth: ").append(this.toIndentedString(this.dayOfMonth)).append("\n");
        sb.append("    nextScheduledAction: ").append(this.toIndentedString(this.nextScheduledAction)).append("\n");
        sb.append("    totalNumberOfPayments: ").append(this.toIndentedString(this.totalNumberOfPayments)).append("\n");
        sb.append("    interval: ").append(this.toIndentedString((Object)this.interval)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getStartTime() != null) {
            joiner.add(String.format("%sstartTime%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getStartTime()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getEndTime() != null) {
            joiner.add(String.format("%sendTime%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getEndTime()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getDayOfMonth() != null) {
            joiner.add(String.format("%sdayOfMonth%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getDayOfMonth()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getNextScheduledAction() != null) {
            joiner.add(String.format("%snextScheduledAction%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getNextScheduledAction()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getTotalNumberOfPayments() != null) {
            joiner.add(String.format("%stotalNumberOfPayments%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getTotalNumberOfPayments()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getInterval() != null) {
            joiner.add(String.format("%sinterval%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getInterval()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }

    public static enum IntervalEnum {
        WEEKLY("Weekly");

        private String value;

        private IntervalEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static IntervalEnum fromValue(String value) {
            for (IntervalEnum b : IntervalEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

