/*
 * Unit OpenAPI specifications
 * An OpenAPI specifications for unit-sdk clients
 *
 * The version of the OpenAPI document: 0.2.2
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package unit.java.sdk.model;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;
import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openapitools.jackson.nullable.JsonNullable;
import unit.java.sdk.model.Address;
import unit.java.sdk.model.ApplicationStatus;
import unit.java.sdk.model.BeneficialOwner;
import unit.java.sdk.model.BusinessAnnualRevenue;
import unit.java.sdk.model.BusinessNumberOfEmployees;
import unit.java.sdk.model.BusinessVertical;
import unit.java.sdk.model.CashFlow;
import unit.java.sdk.model.Contact;
import unit.java.sdk.model.EntityType;
import unit.java.sdk.model.Industry;
import unit.java.sdk.model.Officer;
import unit.java.sdk.model.Phone;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


import unit.java.sdk.ApiClient;
/**
 * BusinessApplicationAllOfAttributes
 */
@JsonPropertyOrder({
  BusinessApplicationAllOfAttributes.JSON_PROPERTY_CREATED_AT,
  BusinessApplicationAllOfAttributes.JSON_PROPERTY_UPDATED_AT,
  BusinessApplicationAllOfAttributes.JSON_PROPERTY_STATUS,
  BusinessApplicationAllOfAttributes.JSON_PROPERTY_MESSAGE,
  BusinessApplicationAllOfAttributes.JSON_PROPERTY_EVALUATION_OUTCOME,
  BusinessApplicationAllOfAttributes.JSON_PROPERTY_EVALUATION_ID,
  BusinessApplicationAllOfAttributes.JSON_PROPERTY_EVALUATION_ENTITY_ID,
  BusinessApplicationAllOfAttributes.JSON_PROPERTY_NAME,
  BusinessApplicationAllOfAttributes.JSON_PROPERTY_DBA,
  BusinessApplicationAllOfAttributes.JSON_PROPERTY_EIN,
  BusinessApplicationAllOfAttributes.JSON_PROPERTY_ENTITY_TYPE,
  BusinessApplicationAllOfAttributes.JSON_PROPERTY_DATE_OF_INCORPORATION,
  BusinessApplicationAllOfAttributes.JSON_PROPERTY_STATE_OF_INCORPORATION,
  BusinessApplicationAllOfAttributes.JSON_PROPERTY_PURPOSE,
  BusinessApplicationAllOfAttributes.JSON_PROPERTY_PHONE,
  BusinessApplicationAllOfAttributes.JSON_PROPERTY_ADDRESS,
  BusinessApplicationAllOfAttributes.JSON_PROPERTY_CONTACT,
  BusinessApplicationAllOfAttributes.JSON_PROPERTY_OFFICER,
  BusinessApplicationAllOfAttributes.JSON_PROPERTY_IP,
  BusinessApplicationAllOfAttributes.JSON_PROPERTY_WEBSITE,
  BusinessApplicationAllOfAttributes.JSON_PROPERTY_BENEFICIAL_OWNERS,
  BusinessApplicationAllOfAttributes.JSON_PROPERTY_DECISION_METHOD,
  BusinessApplicationAllOfAttributes.JSON_PROPERTY_DECISION_USER_ID,
  BusinessApplicationAllOfAttributes.JSON_PROPERTY_DECISION_REASON,
  BusinessApplicationAllOfAttributes.JSON_PROPERTY_DECISION_DATE_TIME,
  BusinessApplicationAllOfAttributes.JSON_PROPERTY_TAGS,
  BusinessApplicationAllOfAttributes.JSON_PROPERTY_RISK_RATE,
  BusinessApplicationAllOfAttributes.JSON_PROPERTY_EVALUATION_FLAGS,
  BusinessApplicationAllOfAttributes.JSON_PROPERTY_IP_LOCATION_DETAILS,
  BusinessApplicationAllOfAttributes.JSON_PROPERTY_PHONE_LOCATION_DETAILS,
  BusinessApplicationAllOfAttributes.JSON_PROPERTY_ARCHIVED,
  BusinessApplicationAllOfAttributes.JSON_PROPERTY_INDUSTRY,
  BusinessApplicationAllOfAttributes.JSON_PROPERTY_ANNUAL_REVENUE,
  BusinessApplicationAllOfAttributes.JSON_PROPERTY_NUMBER_OF_EMPLOYEES,
  BusinessApplicationAllOfAttributes.JSON_PROPERTY_CASH_FLOW,
  BusinessApplicationAllOfAttributes.JSON_PROPERTY_YEAR_OF_INCORPORATION,
  BusinessApplicationAllOfAttributes.JSON_PROPERTY_COUNTRIES_OF_OPERATION,
  BusinessApplicationAllOfAttributes.JSON_PROPERTY_STOCK_SYMBOL,
  BusinessApplicationAllOfAttributes.JSON_PROPERTY_BUSINESS_VERTICAL
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.9.0")
public class BusinessApplicationAllOfAttributes {
  public static final String JSON_PROPERTY_CREATED_AT = "createdAt";
  private OffsetDateTime createdAt;

  public static final String JSON_PROPERTY_UPDATED_AT = "updatedAt";
  private OffsetDateTime updatedAt;

  public static final String JSON_PROPERTY_STATUS = "status";
  private ApplicationStatus status;

  public static final String JSON_PROPERTY_MESSAGE = "message";
  private String message;

  public static final String JSON_PROPERTY_EVALUATION_OUTCOME = "evaluationOutcome";
  private String evaluationOutcome;

  public static final String JSON_PROPERTY_EVALUATION_ID = "evaluationId";
  private String evaluationId;

  public static final String JSON_PROPERTY_EVALUATION_ENTITY_ID = "evaluationEntityId";
  private String evaluationEntityId;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_DBA = "dba";
  private JsonNullable<String> dba = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_EIN = "ein";
  private String ein;

  public static final String JSON_PROPERTY_ENTITY_TYPE = "entityType";
  private EntityType entityType;

  public static final String JSON_PROPERTY_DATE_OF_INCORPORATION = "dateOfIncorporation";
  private LocalDate dateOfIncorporation;

  public static final String JSON_PROPERTY_STATE_OF_INCORPORATION = "stateOfIncorporation";
  private String stateOfIncorporation;

  public static final String JSON_PROPERTY_PURPOSE = "purpose";
  private String purpose;

  public static final String JSON_PROPERTY_PHONE = "phone";
  private Phone phone;

  public static final String JSON_PROPERTY_ADDRESS = "address";
  private Address address;

  public static final String JSON_PROPERTY_CONTACT = "contact";
  private Contact contact;

  public static final String JSON_PROPERTY_OFFICER = "officer";
  private Officer officer;

  public static final String JSON_PROPERTY_IP = "ip";
  private String ip;

  public static final String JSON_PROPERTY_WEBSITE = "website";
  private String website;

  public static final String JSON_PROPERTY_BENEFICIAL_OWNERS = "beneficialOwners";
  private List<BeneficialOwner> beneficialOwners = new ArrayList<>();

  /**
   * Gets or Sets decisionMethod
   */
  public enum DecisionMethodEnum {
    MANUALLY("Manually"),
    
    AUTOMATICALLY("Automatically");

    private String value;

    DecisionMethodEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static DecisionMethodEnum fromValue(String value) {
      for (DecisionMethodEnum b : DecisionMethodEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_DECISION_METHOD = "decisionMethod";
  private DecisionMethodEnum decisionMethod;

  public static final String JSON_PROPERTY_DECISION_USER_ID = "decisionUserId";
  private String decisionUserId;

  public static final String JSON_PROPERTY_DECISION_REASON = "decisionReason";
  private String decisionReason;

  public static final String JSON_PROPERTY_DECISION_DATE_TIME = "decisionDateTime";
  private OffsetDateTime decisionDateTime;

  public static final String JSON_PROPERTY_TAGS = "tags";
  private Map<String, String> tags = new HashMap<>();

  /**
   * Gets or Sets riskRate
   */
  public enum RiskRateEnum {
    LOW("low"),
    
    MEDIUM("medium"),
    
    HIGH("high");

    private String value;

    RiskRateEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static RiskRateEnum fromValue(String value) {
      for (RiskRateEnum b : RiskRateEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_RISK_RATE = "riskRate";
  private RiskRateEnum riskRate;

  public static final String JSON_PROPERTY_EVALUATION_FLAGS = "evaluationFlags";
  private List<String> evaluationFlags = new ArrayList<>();

  public static final String JSON_PROPERTY_IP_LOCATION_DETAILS = "ipLocationDetails";
  private Object ipLocationDetails;

  public static final String JSON_PROPERTY_PHONE_LOCATION_DETAILS = "phoneLocationDetails";
  private Object phoneLocationDetails;

  public static final String JSON_PROPERTY_ARCHIVED = "archived";
  private Boolean archived;

  public static final String JSON_PROPERTY_INDUSTRY = "industry";
  private Industry industry;

  public static final String JSON_PROPERTY_ANNUAL_REVENUE = "annualRevenue";
  private BusinessAnnualRevenue annualRevenue;

  public static final String JSON_PROPERTY_NUMBER_OF_EMPLOYEES = "numberOfEmployees";
  private BusinessNumberOfEmployees numberOfEmployees;

  public static final String JSON_PROPERTY_CASH_FLOW = "cashFlow";
  private CashFlow cashFlow;

  public static final String JSON_PROPERTY_YEAR_OF_INCORPORATION = "yearOfIncorporation";
  private String yearOfIncorporation;

  public static final String JSON_PROPERTY_COUNTRIES_OF_OPERATION = "countriesOfOperation";
  private List<String> countriesOfOperation = new ArrayList<>();

  public static final String JSON_PROPERTY_STOCK_SYMBOL = "stockSymbol";
  private String stockSymbol;

  public static final String JSON_PROPERTY_BUSINESS_VERTICAL = "businessVertical";
  private BusinessVertical businessVertical;

  public BusinessApplicationAllOfAttributes() { 
  }

  public BusinessApplicationAllOfAttributes createdAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
    return this;
  }

  /**
   * Get createdAt
   * @return createdAt
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }


  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }


  public BusinessApplicationAllOfAttributes updatedAt(OffsetDateTime updatedAt) {
    this.updatedAt = updatedAt;
    return this;
  }

  /**
   * Get updatedAt
   * @return updatedAt
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_UPDATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public OffsetDateTime getUpdatedAt() {
    return updatedAt;
  }


  @JsonProperty(JSON_PROPERTY_UPDATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUpdatedAt(OffsetDateTime updatedAt) {
    this.updatedAt = updatedAt;
  }


  public BusinessApplicationAllOfAttributes status(ApplicationStatus status) {
    this.status = status;
    return this;
  }

  /**
   * Get status
   * @return status
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public ApplicationStatus getStatus() {
    return status;
  }


  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setStatus(ApplicationStatus status) {
    this.status = status;
  }


  public BusinessApplicationAllOfAttributes message(String message) {
    this.message = message;
    return this;
  }

  /**
   * Get message
   * @return message
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getMessage() {
    return message;
  }


  @JsonProperty(JSON_PROPERTY_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMessage(String message) {
    this.message = message;
  }


  public BusinessApplicationAllOfAttributes evaluationOutcome(String evaluationOutcome) {
    this.evaluationOutcome = evaluationOutcome;
    return this;
  }

  /**
   * Get evaluationOutcome
   * @return evaluationOutcome
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_EVALUATION_OUTCOME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getEvaluationOutcome() {
    return evaluationOutcome;
  }


  @JsonProperty(JSON_PROPERTY_EVALUATION_OUTCOME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEvaluationOutcome(String evaluationOutcome) {
    this.evaluationOutcome = evaluationOutcome;
  }


  public BusinessApplicationAllOfAttributes evaluationId(String evaluationId) {
    this.evaluationId = evaluationId;
    return this;
  }

  /**
   * Get evaluationId
   * @return evaluationId
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_EVALUATION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getEvaluationId() {
    return evaluationId;
  }


  @JsonProperty(JSON_PROPERTY_EVALUATION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEvaluationId(String evaluationId) {
    this.evaluationId = evaluationId;
  }


  public BusinessApplicationAllOfAttributes evaluationEntityId(String evaluationEntityId) {
    this.evaluationEntityId = evaluationEntityId;
    return this;
  }

  /**
   * Get evaluationEntityId
   * @return evaluationEntityId
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_EVALUATION_ENTITY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getEvaluationEntityId() {
    return evaluationEntityId;
  }


  @JsonProperty(JSON_PROPERTY_EVALUATION_ENTITY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEvaluationEntityId(String evaluationEntityId) {
    this.evaluationEntityId = evaluationEntityId;
  }


  public BusinessApplicationAllOfAttributes name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
    this.name = name;
  }


  public BusinessApplicationAllOfAttributes dba(String dba) {
    this.dba = JsonNullable.<String>of(dba);
    return this;
  }

  /**
   * Get dba
   * @return dba
   */
  @jakarta.annotation.Nullable
  @JsonIgnore
  public String getDba() {
        return dba.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_DBA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getDba_JsonNullable() {
    return dba;
  }
  
  @JsonProperty(JSON_PROPERTY_DBA)
  public void setDba_JsonNullable(JsonNullable<String> dba) {
    this.dba = dba;
  }

  public void setDba(String dba) {
    this.dba = JsonNullable.<String>of(dba);
  }


  public BusinessApplicationAllOfAttributes ein(String ein) {
    this.ein = ein;
    return this;
  }

  /**
   * Get ein
   * @return ein
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_EIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getEin() {
    return ein;
  }


  @JsonProperty(JSON_PROPERTY_EIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEin(String ein) {
    this.ein = ein;
  }


  public BusinessApplicationAllOfAttributes entityType(EntityType entityType) {
    this.entityType = entityType;
    return this;
  }

  /**
   * Get entityType
   * @return entityType
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_ENTITY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public EntityType getEntityType() {
    return entityType;
  }


  @JsonProperty(JSON_PROPERTY_ENTITY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEntityType(EntityType entityType) {
    this.entityType = entityType;
  }


  public BusinessApplicationAllOfAttributes dateOfIncorporation(LocalDate dateOfIncorporation) {
    this.dateOfIncorporation = dateOfIncorporation;
    return this;
  }

  /**
   * Get dateOfIncorporation
   * @return dateOfIncorporation
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DATE_OF_INCORPORATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public LocalDate getDateOfIncorporation() {
    return dateOfIncorporation;
  }


  @JsonProperty(JSON_PROPERTY_DATE_OF_INCORPORATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDateOfIncorporation(LocalDate dateOfIncorporation) {
    this.dateOfIncorporation = dateOfIncorporation;
  }


  public BusinessApplicationAllOfAttributes stateOfIncorporation(String stateOfIncorporation) {
    this.stateOfIncorporation = stateOfIncorporation;
    return this;
  }

  /**
   * Get stateOfIncorporation
   * @return stateOfIncorporation
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_STATE_OF_INCORPORATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getStateOfIncorporation() {
    return stateOfIncorporation;
  }


  @JsonProperty(JSON_PROPERTY_STATE_OF_INCORPORATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setStateOfIncorporation(String stateOfIncorporation) {
    this.stateOfIncorporation = stateOfIncorporation;
  }


  public BusinessApplicationAllOfAttributes purpose(String purpose) {
    this.purpose = purpose;
    return this;
  }

  /**
   * Get purpose
   * @return purpose
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PURPOSE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getPurpose() {
    return purpose;
  }


  @JsonProperty(JSON_PROPERTY_PURPOSE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPurpose(String purpose) {
    this.purpose = purpose;
  }


  public BusinessApplicationAllOfAttributes phone(Phone phone) {
    this.phone = phone;
    return this;
  }

  /**
   * Get phone
   * @return phone
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PHONE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Phone getPhone() {
    return phone;
  }


  @JsonProperty(JSON_PROPERTY_PHONE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPhone(Phone phone) {
    this.phone = phone;
  }


  public BusinessApplicationAllOfAttributes address(Address address) {
    this.address = address;
    return this;
  }

  /**
   * Get address
   * @return address
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Address getAddress() {
    return address;
  }


  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAddress(Address address) {
    this.address = address;
  }


  public BusinessApplicationAllOfAttributes contact(Contact contact) {
    this.contact = contact;
    return this;
  }

  /**
   * Get contact
   * @return contact
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_CONTACT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public Contact getContact() {
    return contact;
  }


  @JsonProperty(JSON_PROPERTY_CONTACT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setContact(Contact contact) {
    this.contact = contact;
  }


  public BusinessApplicationAllOfAttributes officer(Officer officer) {
    this.officer = officer;
    return this;
  }

  /**
   * Get officer
   * @return officer
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_OFFICER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public Officer getOfficer() {
    return officer;
  }


  @JsonProperty(JSON_PROPERTY_OFFICER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setOfficer(Officer officer) {
    this.officer = officer;
  }


  public BusinessApplicationAllOfAttributes ip(String ip) {
    this.ip = ip;
    return this;
  }

  /**
   * Get ip
   * @return ip
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_IP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getIp() {
    return ip;
  }


  @JsonProperty(JSON_PROPERTY_IP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIp(String ip) {
    this.ip = ip;
  }


  public BusinessApplicationAllOfAttributes website(String website) {
    this.website = website;
    return this;
  }

  /**
   * Get website
   * @return website
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_WEBSITE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getWebsite() {
    return website;
  }


  @JsonProperty(JSON_PROPERTY_WEBSITE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWebsite(String website) {
    this.website = website;
  }


  public BusinessApplicationAllOfAttributes beneficialOwners(List<BeneficialOwner> beneficialOwners) {
    this.beneficialOwners = beneficialOwners;
    return this;
  }

  public BusinessApplicationAllOfAttributes addBeneficialOwnersItem(BeneficialOwner beneficialOwnersItem) {
    if (this.beneficialOwners == null) {
      this.beneficialOwners = new ArrayList<>();
    }
    this.beneficialOwners.add(beneficialOwnersItem);
    return this;
  }

  /**
   * Get beneficialOwners
   * @return beneficialOwners
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_BENEFICIAL_OWNERS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public List<BeneficialOwner> getBeneficialOwners() {
    return beneficialOwners;
  }


  @JsonProperty(JSON_PROPERTY_BENEFICIAL_OWNERS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setBeneficialOwners(List<BeneficialOwner> beneficialOwners) {
    this.beneficialOwners = beneficialOwners;
  }


  public BusinessApplicationAllOfAttributes decisionMethod(DecisionMethodEnum decisionMethod) {
    this.decisionMethod = decisionMethod;
    return this;
  }

  /**
   * Get decisionMethod
   * @return decisionMethod
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DECISION_METHOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public DecisionMethodEnum getDecisionMethod() {
    return decisionMethod;
  }


  @JsonProperty(JSON_PROPERTY_DECISION_METHOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDecisionMethod(DecisionMethodEnum decisionMethod) {
    this.decisionMethod = decisionMethod;
  }


  public BusinessApplicationAllOfAttributes decisionUserId(String decisionUserId) {
    this.decisionUserId = decisionUserId;
    return this;
  }

  /**
   * Get decisionUserId
   * @return decisionUserId
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DECISION_USER_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getDecisionUserId() {
    return decisionUserId;
  }


  @JsonProperty(JSON_PROPERTY_DECISION_USER_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDecisionUserId(String decisionUserId) {
    this.decisionUserId = decisionUserId;
  }


  public BusinessApplicationAllOfAttributes decisionReason(String decisionReason) {
    this.decisionReason = decisionReason;
    return this;
  }

  /**
   * Get decisionReason
   * @return decisionReason
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DECISION_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getDecisionReason() {
    return decisionReason;
  }


  @JsonProperty(JSON_PROPERTY_DECISION_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDecisionReason(String decisionReason) {
    this.decisionReason = decisionReason;
  }


  public BusinessApplicationAllOfAttributes decisionDateTime(OffsetDateTime decisionDateTime) {
    this.decisionDateTime = decisionDateTime;
    return this;
  }

  /**
   * Get decisionDateTime
   * @return decisionDateTime
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DECISION_DATE_TIME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public OffsetDateTime getDecisionDateTime() {
    return decisionDateTime;
  }


  @JsonProperty(JSON_PROPERTY_DECISION_DATE_TIME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDecisionDateTime(OffsetDateTime decisionDateTime) {
    this.decisionDateTime = decisionDateTime;
  }


  public BusinessApplicationAllOfAttributes tags(Map<String, String> tags) {
    this.tags = tags;
    return this;
  }

  public BusinessApplicationAllOfAttributes putTagsItem(String key, String tagsItem) {
    if (this.tags == null) {
      this.tags = new HashMap<>();
    }
    this.tags.put(key, tagsItem);
    return this;
  }

  /**
   * Get tags
   * @return tags
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TAGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Map<String, String> getTags() {
    return tags;
  }


  @JsonProperty(JSON_PROPERTY_TAGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTags(Map<String, String> tags) {
    this.tags = tags;
  }


  public BusinessApplicationAllOfAttributes riskRate(RiskRateEnum riskRate) {
    this.riskRate = riskRate;
    return this;
  }

  /**
   * Get riskRate
   * @return riskRate
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_RISK_RATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public RiskRateEnum getRiskRate() {
    return riskRate;
  }


  @JsonProperty(JSON_PROPERTY_RISK_RATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRiskRate(RiskRateEnum riskRate) {
    this.riskRate = riskRate;
  }


  public BusinessApplicationAllOfAttributes evaluationFlags(List<String> evaluationFlags) {
    this.evaluationFlags = evaluationFlags;
    return this;
  }

  public BusinessApplicationAllOfAttributes addEvaluationFlagsItem(String evaluationFlagsItem) {
    if (this.evaluationFlags == null) {
      this.evaluationFlags = new ArrayList<>();
    }
    this.evaluationFlags.add(evaluationFlagsItem);
    return this;
  }

  /**
   * Get evaluationFlags
   * @return evaluationFlags
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_EVALUATION_FLAGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<String> getEvaluationFlags() {
    return evaluationFlags;
  }


  @JsonProperty(JSON_PROPERTY_EVALUATION_FLAGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEvaluationFlags(List<String> evaluationFlags) {
    this.evaluationFlags = evaluationFlags;
  }


  public BusinessApplicationAllOfAttributes ipLocationDetails(Object ipLocationDetails) {
    this.ipLocationDetails = ipLocationDetails;
    return this;
  }

  /**
   * Get ipLocationDetails
   * @return ipLocationDetails
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_IP_LOCATION_DETAILS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Object getIpLocationDetails() {
    return ipLocationDetails;
  }


  @JsonProperty(JSON_PROPERTY_IP_LOCATION_DETAILS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIpLocationDetails(Object ipLocationDetails) {
    this.ipLocationDetails = ipLocationDetails;
  }


  public BusinessApplicationAllOfAttributes phoneLocationDetails(Object phoneLocationDetails) {
    this.phoneLocationDetails = phoneLocationDetails;
    return this;
  }

  /**
   * Get phoneLocationDetails
   * @return phoneLocationDetails
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PHONE_LOCATION_DETAILS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Object getPhoneLocationDetails() {
    return phoneLocationDetails;
  }


  @JsonProperty(JSON_PROPERTY_PHONE_LOCATION_DETAILS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPhoneLocationDetails(Object phoneLocationDetails) {
    this.phoneLocationDetails = phoneLocationDetails;
  }


  public BusinessApplicationAllOfAttributes archived(Boolean archived) {
    this.archived = archived;
    return this;
  }

  /**
   * Get archived
   * @return archived
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ARCHIVED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getArchived() {
    return archived;
  }


  @JsonProperty(JSON_PROPERTY_ARCHIVED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setArchived(Boolean archived) {
    this.archived = archived;
  }


  public BusinessApplicationAllOfAttributes industry(Industry industry) {
    this.industry = industry;
    return this;
  }

  /**
   * Get industry
   * @return industry
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_INDUSTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Industry getIndustry() {
    return industry;
  }


  @JsonProperty(JSON_PROPERTY_INDUSTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIndustry(Industry industry) {
    this.industry = industry;
  }


  public BusinessApplicationAllOfAttributes annualRevenue(BusinessAnnualRevenue annualRevenue) {
    this.annualRevenue = annualRevenue;
    return this;
  }

  /**
   * Get annualRevenue
   * @return annualRevenue
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ANNUAL_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public BusinessAnnualRevenue getAnnualRevenue() {
    return annualRevenue;
  }


  @JsonProperty(JSON_PROPERTY_ANNUAL_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAnnualRevenue(BusinessAnnualRevenue annualRevenue) {
    this.annualRevenue = annualRevenue;
  }


  public BusinessApplicationAllOfAttributes numberOfEmployees(BusinessNumberOfEmployees numberOfEmployees) {
    this.numberOfEmployees = numberOfEmployees;
    return this;
  }

  /**
   * Get numberOfEmployees
   * @return numberOfEmployees
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_NUMBER_OF_EMPLOYEES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public BusinessNumberOfEmployees getNumberOfEmployees() {
    return numberOfEmployees;
  }


  @JsonProperty(JSON_PROPERTY_NUMBER_OF_EMPLOYEES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNumberOfEmployees(BusinessNumberOfEmployees numberOfEmployees) {
    this.numberOfEmployees = numberOfEmployees;
  }


  public BusinessApplicationAllOfAttributes cashFlow(CashFlow cashFlow) {
    this.cashFlow = cashFlow;
    return this;
  }

  /**
   * Get cashFlow
   * @return cashFlow
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CASH_FLOW)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public CashFlow getCashFlow() {
    return cashFlow;
  }


  @JsonProperty(JSON_PROPERTY_CASH_FLOW)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCashFlow(CashFlow cashFlow) {
    this.cashFlow = cashFlow;
  }


  public BusinessApplicationAllOfAttributes yearOfIncorporation(String yearOfIncorporation) {
    this.yearOfIncorporation = yearOfIncorporation;
    return this;
  }

  /**
   * Get yearOfIncorporation
   * @return yearOfIncorporation
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_YEAR_OF_INCORPORATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getYearOfIncorporation() {
    return yearOfIncorporation;
  }


  @JsonProperty(JSON_PROPERTY_YEAR_OF_INCORPORATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setYearOfIncorporation(String yearOfIncorporation) {
    this.yearOfIncorporation = yearOfIncorporation;
  }


  public BusinessApplicationAllOfAttributes countriesOfOperation(List<String> countriesOfOperation) {
    this.countriesOfOperation = countriesOfOperation;
    return this;
  }

  public BusinessApplicationAllOfAttributes addCountriesOfOperationItem(String countriesOfOperationItem) {
    if (this.countriesOfOperation == null) {
      this.countriesOfOperation = new ArrayList<>();
    }
    this.countriesOfOperation.add(countriesOfOperationItem);
    return this;
  }

  /**
   * Get countriesOfOperation
   * @return countriesOfOperation
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_COUNTRIES_OF_OPERATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<String> getCountriesOfOperation() {
    return countriesOfOperation;
  }


  @JsonProperty(JSON_PROPERTY_COUNTRIES_OF_OPERATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCountriesOfOperation(List<String> countriesOfOperation) {
    this.countriesOfOperation = countriesOfOperation;
  }


  public BusinessApplicationAllOfAttributes stockSymbol(String stockSymbol) {
    this.stockSymbol = stockSymbol;
    return this;
  }

  /**
   * Get stockSymbol
   * @return stockSymbol
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_STOCK_SYMBOL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getStockSymbol() {
    return stockSymbol;
  }


  @JsonProperty(JSON_PROPERTY_STOCK_SYMBOL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStockSymbol(String stockSymbol) {
    this.stockSymbol = stockSymbol;
  }


  public BusinessApplicationAllOfAttributes businessVertical(BusinessVertical businessVertical) {
    this.businessVertical = businessVertical;
    return this;
  }

  /**
   * Get businessVertical
   * @return businessVertical
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_BUSINESS_VERTICAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public BusinessVertical getBusinessVertical() {
    return businessVertical;
  }


  @JsonProperty(JSON_PROPERTY_BUSINESS_VERTICAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBusinessVertical(BusinessVertical businessVertical) {
    this.businessVertical = businessVertical;
  }


  /**
   * Return true if this BusinessApplication_allOf_attributes object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BusinessApplicationAllOfAttributes businessApplicationAllOfAttributes = (BusinessApplicationAllOfAttributes) o;
    return Objects.equals(this.createdAt, businessApplicationAllOfAttributes.createdAt) &&
        Objects.equals(this.updatedAt, businessApplicationAllOfAttributes.updatedAt) &&
        Objects.equals(this.status, businessApplicationAllOfAttributes.status) &&
        Objects.equals(this.message, businessApplicationAllOfAttributes.message) &&
        Objects.equals(this.evaluationOutcome, businessApplicationAllOfAttributes.evaluationOutcome) &&
        Objects.equals(this.evaluationId, businessApplicationAllOfAttributes.evaluationId) &&
        Objects.equals(this.evaluationEntityId, businessApplicationAllOfAttributes.evaluationEntityId) &&
        Objects.equals(this.name, businessApplicationAllOfAttributes.name) &&
        equalsNullable(this.dba, businessApplicationAllOfAttributes.dba) &&
        Objects.equals(this.ein, businessApplicationAllOfAttributes.ein) &&
        Objects.equals(this.entityType, businessApplicationAllOfAttributes.entityType) &&
        Objects.equals(this.dateOfIncorporation, businessApplicationAllOfAttributes.dateOfIncorporation) &&
        Objects.equals(this.stateOfIncorporation, businessApplicationAllOfAttributes.stateOfIncorporation) &&
        Objects.equals(this.purpose, businessApplicationAllOfAttributes.purpose) &&
        Objects.equals(this.phone, businessApplicationAllOfAttributes.phone) &&
        Objects.equals(this.address, businessApplicationAllOfAttributes.address) &&
        Objects.equals(this.contact, businessApplicationAllOfAttributes.contact) &&
        Objects.equals(this.officer, businessApplicationAllOfAttributes.officer) &&
        Objects.equals(this.ip, businessApplicationAllOfAttributes.ip) &&
        Objects.equals(this.website, businessApplicationAllOfAttributes.website) &&
        Objects.equals(this.beneficialOwners, businessApplicationAllOfAttributes.beneficialOwners) &&
        Objects.equals(this.decisionMethod, businessApplicationAllOfAttributes.decisionMethod) &&
        Objects.equals(this.decisionUserId, businessApplicationAllOfAttributes.decisionUserId) &&
        Objects.equals(this.decisionReason, businessApplicationAllOfAttributes.decisionReason) &&
        Objects.equals(this.decisionDateTime, businessApplicationAllOfAttributes.decisionDateTime) &&
        Objects.equals(this.tags, businessApplicationAllOfAttributes.tags) &&
        Objects.equals(this.riskRate, businessApplicationAllOfAttributes.riskRate) &&
        Objects.equals(this.evaluationFlags, businessApplicationAllOfAttributes.evaluationFlags) &&
        Objects.equals(this.ipLocationDetails, businessApplicationAllOfAttributes.ipLocationDetails) &&
        Objects.equals(this.phoneLocationDetails, businessApplicationAllOfAttributes.phoneLocationDetails) &&
        Objects.equals(this.archived, businessApplicationAllOfAttributes.archived) &&
        Objects.equals(this.industry, businessApplicationAllOfAttributes.industry) &&
        Objects.equals(this.annualRevenue, businessApplicationAllOfAttributes.annualRevenue) &&
        Objects.equals(this.numberOfEmployees, businessApplicationAllOfAttributes.numberOfEmployees) &&
        Objects.equals(this.cashFlow, businessApplicationAllOfAttributes.cashFlow) &&
        Objects.equals(this.yearOfIncorporation, businessApplicationAllOfAttributes.yearOfIncorporation) &&
        Objects.equals(this.countriesOfOperation, businessApplicationAllOfAttributes.countriesOfOperation) &&
        Objects.equals(this.stockSymbol, businessApplicationAllOfAttributes.stockSymbol) &&
        Objects.equals(this.businessVertical, businessApplicationAllOfAttributes.businessVertical);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(createdAt, updatedAt, status, message, evaluationOutcome, evaluationId, evaluationEntityId, name, hashCodeNullable(dba), ein, entityType, dateOfIncorporation, stateOfIncorporation, purpose, phone, address, contact, officer, ip, website, beneficialOwners, decisionMethod, decisionUserId, decisionReason, decisionDateTime, tags, riskRate, evaluationFlags, ipLocationDetails, phoneLocationDetails, archived, industry, annualRevenue, numberOfEmployees, cashFlow, yearOfIncorporation, countriesOfOperation, stockSymbol, businessVertical);
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BusinessApplicationAllOfAttributes {\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    updatedAt: ").append(toIndentedString(updatedAt)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    evaluationOutcome: ").append(toIndentedString(evaluationOutcome)).append("\n");
    sb.append("    evaluationId: ").append(toIndentedString(evaluationId)).append("\n");
    sb.append("    evaluationEntityId: ").append(toIndentedString(evaluationEntityId)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    dba: ").append(toIndentedString(dba)).append("\n");
    sb.append("    ein: ").append(toIndentedString(ein)).append("\n");
    sb.append("    entityType: ").append(toIndentedString(entityType)).append("\n");
    sb.append("    dateOfIncorporation: ").append(toIndentedString(dateOfIncorporation)).append("\n");
    sb.append("    stateOfIncorporation: ").append(toIndentedString(stateOfIncorporation)).append("\n");
    sb.append("    purpose: ").append(toIndentedString(purpose)).append("\n");
    sb.append("    phone: ").append(toIndentedString(phone)).append("\n");
    sb.append("    address: ").append(toIndentedString(address)).append("\n");
    sb.append("    contact: ").append(toIndentedString(contact)).append("\n");
    sb.append("    officer: ").append(toIndentedString(officer)).append("\n");
    sb.append("    ip: ").append(toIndentedString(ip)).append("\n");
    sb.append("    website: ").append(toIndentedString(website)).append("\n");
    sb.append("    beneficialOwners: ").append(toIndentedString(beneficialOwners)).append("\n");
    sb.append("    decisionMethod: ").append(toIndentedString(decisionMethod)).append("\n");
    sb.append("    decisionUserId: ").append(toIndentedString(decisionUserId)).append("\n");
    sb.append("    decisionReason: ").append(toIndentedString(decisionReason)).append("\n");
    sb.append("    decisionDateTime: ").append(toIndentedString(decisionDateTime)).append("\n");
    sb.append("    tags: ").append(toIndentedString(tags)).append("\n");
    sb.append("    riskRate: ").append(toIndentedString(riskRate)).append("\n");
    sb.append("    evaluationFlags: ").append(toIndentedString(evaluationFlags)).append("\n");
    sb.append("    ipLocationDetails: ").append(toIndentedString(ipLocationDetails)).append("\n");
    sb.append("    phoneLocationDetails: ").append(toIndentedString(phoneLocationDetails)).append("\n");
    sb.append("    archived: ").append(toIndentedString(archived)).append("\n");
    sb.append("    industry: ").append(toIndentedString(industry)).append("\n");
    sb.append("    annualRevenue: ").append(toIndentedString(annualRevenue)).append("\n");
    sb.append("    numberOfEmployees: ").append(toIndentedString(numberOfEmployees)).append("\n");
    sb.append("    cashFlow: ").append(toIndentedString(cashFlow)).append("\n");
    sb.append("    yearOfIncorporation: ").append(toIndentedString(yearOfIncorporation)).append("\n");
    sb.append("    countriesOfOperation: ").append(toIndentedString(countriesOfOperation)).append("\n");
    sb.append("    stockSymbol: ").append(toIndentedString(stockSymbol)).append("\n");
    sb.append("    businessVertical: ").append(toIndentedString(businessVertical)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `createdAt` to the URL query string
    if (getCreatedAt() != null) {
      joiner.add(String.format("%screatedAt%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getCreatedAt()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `updatedAt` to the URL query string
    if (getUpdatedAt() != null) {
      joiner.add(String.format("%supdatedAt%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getUpdatedAt()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `status` to the URL query string
    if (getStatus() != null) {
      joiner.add(String.format("%sstatus%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getStatus()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `message` to the URL query string
    if (getMessage() != null) {
      joiner.add(String.format("%smessage%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getMessage()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `evaluationOutcome` to the URL query string
    if (getEvaluationOutcome() != null) {
      joiner.add(String.format("%sevaluationOutcome%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getEvaluationOutcome()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `evaluationId` to the URL query string
    if (getEvaluationId() != null) {
      joiner.add(String.format("%sevaluationId%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getEvaluationId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `evaluationEntityId` to the URL query string
    if (getEvaluationEntityId() != null) {
      joiner.add(String.format("%sevaluationEntityId%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getEvaluationEntityId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `name` to the URL query string
    if (getName() != null) {
      joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `dba` to the URL query string
    if (getDba() != null) {
      joiner.add(String.format("%sdba%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getDba()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `ein` to the URL query string
    if (getEin() != null) {
      joiner.add(String.format("%sein%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getEin()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `entityType` to the URL query string
    if (getEntityType() != null) {
      joiner.add(String.format("%sentityType%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getEntityType()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `dateOfIncorporation` to the URL query string
    if (getDateOfIncorporation() != null) {
      joiner.add(String.format("%sdateOfIncorporation%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getDateOfIncorporation()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `stateOfIncorporation` to the URL query string
    if (getStateOfIncorporation() != null) {
      joiner.add(String.format("%sstateOfIncorporation%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getStateOfIncorporation()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `purpose` to the URL query string
    if (getPurpose() != null) {
      joiner.add(String.format("%spurpose%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getPurpose()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `phone` to the URL query string
    if (getPhone() != null) {
      joiner.add(getPhone().toUrlQueryString(prefix + "phone" + suffix));
    }

    // add `address` to the URL query string
    if (getAddress() != null) {
      joiner.add(getAddress().toUrlQueryString(prefix + "address" + suffix));
    }

    // add `contact` to the URL query string
    if (getContact() != null) {
      joiner.add(getContact().toUrlQueryString(prefix + "contact" + suffix));
    }

    // add `officer` to the URL query string
    if (getOfficer() != null) {
      joiner.add(getOfficer().toUrlQueryString(prefix + "officer" + suffix));
    }

    // add `ip` to the URL query string
    if (getIp() != null) {
      joiner.add(String.format("%sip%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getIp()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `website` to the URL query string
    if (getWebsite() != null) {
      joiner.add(String.format("%swebsite%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getWebsite()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `beneficialOwners` to the URL query string
    if (getBeneficialOwners() != null) {
      for (int i = 0; i < getBeneficialOwners().size(); i++) {
        if (getBeneficialOwners().get(i) != null) {
          joiner.add(getBeneficialOwners().get(i).toUrlQueryString(String.format("%sbeneficialOwners%s%s", prefix, suffix,
          "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    // add `decisionMethod` to the URL query string
    if (getDecisionMethod() != null) {
      joiner.add(String.format("%sdecisionMethod%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getDecisionMethod()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `decisionUserId` to the URL query string
    if (getDecisionUserId() != null) {
      joiner.add(String.format("%sdecisionUserId%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getDecisionUserId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `decisionReason` to the URL query string
    if (getDecisionReason() != null) {
      joiner.add(String.format("%sdecisionReason%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getDecisionReason()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `decisionDateTime` to the URL query string
    if (getDecisionDateTime() != null) {
      joiner.add(String.format("%sdecisionDateTime%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getDecisionDateTime()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `tags` to the URL query string
    if (getTags() != null) {
      for (String _key : getTags().keySet()) {
        joiner.add(String.format("%stags%s%s=%s", prefix, suffix,
            "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix),
            getTags().get(_key), URLEncoder.encode(ApiClient.valueToString(getTags().get(_key)), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
      }
    }

    // add `riskRate` to the URL query string
    if (getRiskRate() != null) {
      joiner.add(String.format("%sriskRate%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getRiskRate()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `evaluationFlags` to the URL query string
    if (getEvaluationFlags() != null) {
      for (int i = 0; i < getEvaluationFlags().size(); i++) {
        joiner.add(String.format("%sevaluationFlags%s%s=%s", prefix, suffix,
            "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
            URLEncoder.encode(ApiClient.valueToString(getEvaluationFlags().get(i)), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
      }
    }

    // add `ipLocationDetails` to the URL query string
    if (getIpLocationDetails() != null) {
      joiner.add(String.format("%sipLocationDetails%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getIpLocationDetails()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `phoneLocationDetails` to the URL query string
    if (getPhoneLocationDetails() != null) {
      joiner.add(String.format("%sphoneLocationDetails%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getPhoneLocationDetails()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `archived` to the URL query string
    if (getArchived() != null) {
      joiner.add(String.format("%sarchived%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getArchived()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `industry` to the URL query string
    if (getIndustry() != null) {
      joiner.add(String.format("%sindustry%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getIndustry()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `annualRevenue` to the URL query string
    if (getAnnualRevenue() != null) {
      joiner.add(String.format("%sannualRevenue%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getAnnualRevenue()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `numberOfEmployees` to the URL query string
    if (getNumberOfEmployees() != null) {
      joiner.add(String.format("%snumberOfEmployees%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getNumberOfEmployees()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `cashFlow` to the URL query string
    if (getCashFlow() != null) {
      joiner.add(String.format("%scashFlow%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getCashFlow()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `yearOfIncorporation` to the URL query string
    if (getYearOfIncorporation() != null) {
      joiner.add(String.format("%syearOfIncorporation%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getYearOfIncorporation()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `countriesOfOperation` to the URL query string
    if (getCountriesOfOperation() != null) {
      for (int i = 0; i < getCountriesOfOperation().size(); i++) {
        joiner.add(String.format("%scountriesOfOperation%s%s=%s", prefix, suffix,
            "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
            URLEncoder.encode(ApiClient.valueToString(getCountriesOfOperation().get(i)), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
      }
    }

    // add `stockSymbol` to the URL query string
    if (getStockSymbol() != null) {
      joiner.add(String.format("%sstockSymbol%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getStockSymbol()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `businessVertical` to the URL query string
    if (getBusinessVertical() != null) {
      joiner.add(String.format("%sbusinessVertical%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getBusinessVertical()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    return joiner.toString();
  }
}

