/*
 * Unit OpenAPI specifications
 * An OpenAPI specifications for unit-sdk clients
 *
 * The version of the OpenAPI document: 0.2.2
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package unit.java.sdk.model;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;
import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


import unit.java.sdk.ApiClient;
/**
 * CreateWebhookRequestDataAttributes
 */
@JsonPropertyOrder({
  CreateWebhookRequestDataAttributes.JSON_PROPERTY_LABEL,
  CreateWebhookRequestDataAttributes.JSON_PROPERTY_URL,
  CreateWebhookRequestDataAttributes.JSON_PROPERTY_TOKEN,
  CreateWebhookRequestDataAttributes.JSON_PROPERTY_CONTENT_TYPE,
  CreateWebhookRequestDataAttributes.JSON_PROPERTY_DELIVERY_MODE,
  CreateWebhookRequestDataAttributes.JSON_PROPERTY_INCLUDE_RESOURCES,
  CreateWebhookRequestDataAttributes.JSON_PROPERTY_SUBSCRIPTION_TYPE
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.9.0")
public class CreateWebhookRequestDataAttributes {
  public static final String JSON_PROPERTY_LABEL = "label";
  private String label;

  public static final String JSON_PROPERTY_URL = "url";
  private String url;

  public static final String JSON_PROPERTY_TOKEN = "token";
  private String token;

  /**
   * Gets or Sets contentType
   */
  public enum ContentTypeEnum {
    JSON("Json"),
    
    JSON_API("JsonAPI");

    private String value;

    ContentTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ContentTypeEnum fromValue(String value) {
      for (ContentTypeEnum b : ContentTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_CONTENT_TYPE = "contentType";
  private ContentTypeEnum contentType;

  public static final String JSON_PROPERTY_DELIVERY_MODE = "deliveryMode";
  private String deliveryMode;

  public static final String JSON_PROPERTY_INCLUDE_RESOURCES = "includeResources";
  private Boolean includeResources;

  /**
   * Gets or Sets subscriptionType
   */
  public enum SubscriptionTypeEnum {
    ALL("All"),
    
    ONLY_AUTHORIZATION_REQUEST("OnlyAuthorizationRequest");

    private String value;

    SubscriptionTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static SubscriptionTypeEnum fromValue(String value) {
      for (SubscriptionTypeEnum b : SubscriptionTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_SUBSCRIPTION_TYPE = "subscriptionType";
  private SubscriptionTypeEnum subscriptionType;

  public CreateWebhookRequestDataAttributes() { 
  }

  public CreateWebhookRequestDataAttributes label(String label) {
    this.label = label;
    return this;
  }

  /**
   * Get label
   * @return label
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_LABEL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getLabel() {
    return label;
  }


  @JsonProperty(JSON_PROPERTY_LABEL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setLabel(String label) {
    this.label = label;
  }


  public CreateWebhookRequestDataAttributes url(String url) {
    this.url = url;
    return this;
  }

  /**
   * Get url
   * @return url
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getUrl() {
    return url;
  }


  @JsonProperty(JSON_PROPERTY_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setUrl(String url) {
    this.url = url;
  }


  public CreateWebhookRequestDataAttributes token(String token) {
    this.token = token;
    return this;
  }

  /**
   * Get token
   * @return token
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_TOKEN)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getToken() {
    return token;
  }


  @JsonProperty(JSON_PROPERTY_TOKEN)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setToken(String token) {
    this.token = token;
  }


  public CreateWebhookRequestDataAttributes contentType(ContentTypeEnum contentType) {
    this.contentType = contentType;
    return this;
  }

  /**
   * Get contentType
   * @return contentType
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_CONTENT_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public ContentTypeEnum getContentType() {
    return contentType;
  }


  @JsonProperty(JSON_PROPERTY_CONTENT_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setContentType(ContentTypeEnum contentType) {
    this.contentType = contentType;
  }


  public CreateWebhookRequestDataAttributes deliveryMode(String deliveryMode) {
    this.deliveryMode = deliveryMode;
    return this;
  }

  /**
   * Get deliveryMode
   * @return deliveryMode
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_DELIVERY_MODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getDeliveryMode() {
    return deliveryMode;
  }


  @JsonProperty(JSON_PROPERTY_DELIVERY_MODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDeliveryMode(String deliveryMode) {
    this.deliveryMode = deliveryMode;
  }


  public CreateWebhookRequestDataAttributes includeResources(Boolean includeResources) {
    this.includeResources = includeResources;
    return this;
  }

  /**
   * Get includeResources
   * @return includeResources
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_INCLUDE_RESOURCES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getIncludeResources() {
    return includeResources;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_RESOURCES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeResources(Boolean includeResources) {
    this.includeResources = includeResources;
  }


  public CreateWebhookRequestDataAttributes subscriptionType(SubscriptionTypeEnum subscriptionType) {
    this.subscriptionType = subscriptionType;
    return this;
  }

  /**
   * Get subscriptionType
   * @return subscriptionType
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SUBSCRIPTION_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public SubscriptionTypeEnum getSubscriptionType() {
    return subscriptionType;
  }


  @JsonProperty(JSON_PROPERTY_SUBSCRIPTION_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSubscriptionType(SubscriptionTypeEnum subscriptionType) {
    this.subscriptionType = subscriptionType;
  }


  /**
   * Return true if this Create_Webhook_Request_data_attributes object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CreateWebhookRequestDataAttributes createWebhookRequestDataAttributes = (CreateWebhookRequestDataAttributes) o;
    return Objects.equals(this.label, createWebhookRequestDataAttributes.label) &&
        Objects.equals(this.url, createWebhookRequestDataAttributes.url) &&
        Objects.equals(this.token, createWebhookRequestDataAttributes.token) &&
        Objects.equals(this.contentType, createWebhookRequestDataAttributes.contentType) &&
        Objects.equals(this.deliveryMode, createWebhookRequestDataAttributes.deliveryMode) &&
        Objects.equals(this.includeResources, createWebhookRequestDataAttributes.includeResources) &&
        Objects.equals(this.subscriptionType, createWebhookRequestDataAttributes.subscriptionType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(label, url, token, contentType, deliveryMode, includeResources, subscriptionType);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreateWebhookRequestDataAttributes {\n");
    sb.append("    label: ").append(toIndentedString(label)).append("\n");
    sb.append("    url: ").append(toIndentedString(url)).append("\n");
    sb.append("    token: ").append(toIndentedString(token)).append("\n");
    sb.append("    contentType: ").append(toIndentedString(contentType)).append("\n");
    sb.append("    deliveryMode: ").append(toIndentedString(deliveryMode)).append("\n");
    sb.append("    includeResources: ").append(toIndentedString(includeResources)).append("\n");
    sb.append("    subscriptionType: ").append(toIndentedString(subscriptionType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `label` to the URL query string
    if (getLabel() != null) {
      joiner.add(String.format("%slabel%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getLabel()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `url` to the URL query string
    if (getUrl() != null) {
      joiner.add(String.format("%surl%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getUrl()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `token` to the URL query string
    if (getToken() != null) {
      joiner.add(String.format("%stoken%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getToken()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `contentType` to the URL query string
    if (getContentType() != null) {
      joiner.add(String.format("%scontentType%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getContentType()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `deliveryMode` to the URL query string
    if (getDeliveryMode() != null) {
      joiner.add(String.format("%sdeliveryMode%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getDeliveryMode()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `includeResources` to the URL query string
    if (getIncludeResources() != null) {
      joiner.add(String.format("%sincludeResources%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getIncludeResources()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `subscriptionType` to the URL query string
    if (getSubscriptionType() != null) {
      joiner.add(String.format("%ssubscriptionType%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getSubscriptionType()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    return joiner.toString();
  }
}

