/*
 * Unit OpenAPI specifications
 * An OpenAPI specifications for unit-sdk clients
 *
 * The version of the OpenAPI document: 0.2.2
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package unit.java.sdk.model;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;
import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openapitools.jackson.nullable.JsonNullable;
import unit.java.sdk.model.Address;
import unit.java.sdk.model.AnnualIncome;
import unit.java.sdk.model.ApplicationStatus;
import unit.java.sdk.model.BusinessVertical;
import unit.java.sdk.model.FullName;
import unit.java.sdk.model.Industry;
import unit.java.sdk.model.Occupation;
import unit.java.sdk.model.Phone;
import unit.java.sdk.model.PowerOfAttorneyAgent;
import unit.java.sdk.model.SoleProprietorshipAnnualRevenue;
import unit.java.sdk.model.SoleProprietorshipNumberOfEmployees;
import unit.java.sdk.model.SourceOfIncome;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


import unit.java.sdk.ApiClient;
/**
 * IndividualApplicationAllOfAttributes
 */
@JsonPropertyOrder({
  IndividualApplicationAllOfAttributes.JSON_PROPERTY_CREATED_AT,
  IndividualApplicationAllOfAttributes.JSON_PROPERTY_UPDATED_AT,
  IndividualApplicationAllOfAttributes.JSON_PROPERTY_STATUS,
  IndividualApplicationAllOfAttributes.JSON_PROPERTY_MESSAGE,
  IndividualApplicationAllOfAttributes.JSON_PROPERTY_EVALUATION_OUTCOME,
  IndividualApplicationAllOfAttributes.JSON_PROPERTY_EVALUATION_ID,
  IndividualApplicationAllOfAttributes.JSON_PROPERTY_EVALUATION_ENTITY_ID,
  IndividualApplicationAllOfAttributes.JSON_PROPERTY_FULL_NAME,
  IndividualApplicationAllOfAttributes.JSON_PROPERTY_EMAIL,
  IndividualApplicationAllOfAttributes.JSON_PROPERTY_PHONE,
  IndividualApplicationAllOfAttributes.JSON_PROPERTY_SSN,
  IndividualApplicationAllOfAttributes.JSON_PROPERTY_PASSPORT,
  IndividualApplicationAllOfAttributes.JSON_PROPERTY_NATIONALITY,
  IndividualApplicationAllOfAttributes.JSON_PROPERTY_MATRICULA_CONSULAR,
  IndividualApplicationAllOfAttributes.JSON_PROPERTY_ADDRESS,
  IndividualApplicationAllOfAttributes.JSON_PROPERTY_DATE_OF_BIRTH,
  IndividualApplicationAllOfAttributes.JSON_PROPERTY_DBA,
  IndividualApplicationAllOfAttributes.JSON_PROPERTY_EIN,
  IndividualApplicationAllOfAttributes.JSON_PROPERTY_IP,
  IndividualApplicationAllOfAttributes.JSON_PROPERTY_SOLE_PROPRIETORSHIP,
  IndividualApplicationAllOfAttributes.JSON_PROPERTY_DECISION_METHOD,
  IndividualApplicationAllOfAttributes.JSON_PROPERTY_DECISION_USER_ID,
  IndividualApplicationAllOfAttributes.JSON_PROPERTY_DECISION_REASON,
  IndividualApplicationAllOfAttributes.JSON_PROPERTY_DECISION_DATE_TIME,
  IndividualApplicationAllOfAttributes.JSON_PROPERTY_TAGS,
  IndividualApplicationAllOfAttributes.JSON_PROPERTY_RISK_RATE,
  IndividualApplicationAllOfAttributes.JSON_PROPERTY_EVALUATION_FLAGS,
  IndividualApplicationAllOfAttributes.JSON_PROPERTY_EVALUATION_SCORES,
  IndividualApplicationAllOfAttributes.JSON_PROPERTY_IP_LOCATION_DETAILS,
  IndividualApplicationAllOfAttributes.JSON_PROPERTY_PHONE_LOCATION_DETAILS,
  IndividualApplicationAllOfAttributes.JSON_PROPERTY_MASKED_S_S_N,
  IndividualApplicationAllOfAttributes.JSON_PROPERTY_MASKED_PASSPORT,
  IndividualApplicationAllOfAttributes.JSON_PROPERTY_MASKED_MATRICULA_CONSULAR,
  IndividualApplicationAllOfAttributes.JSON_PROPERTY_JWT_SUBJECT,
  IndividualApplicationAllOfAttributes.JSON_PROPERTY_ARCHIVED,
  IndividualApplicationAllOfAttributes.JSON_PROPERTY_POWER_OF_ATTORNEY_AGENT,
  IndividualApplicationAllOfAttributes.JSON_PROPERTY_INDUSTRY,
  IndividualApplicationAllOfAttributes.JSON_PROPERTY_ID_THEFT_SCORE,
  IndividualApplicationAllOfAttributes.JSON_PROPERTY_OCCUPATION,
  IndividualApplicationAllOfAttributes.JSON_PROPERTY_ANNUAL_INCOME,
  IndividualApplicationAllOfAttributes.JSON_PROPERTY_SOURCE_OF_INCOME,
  IndividualApplicationAllOfAttributes.JSON_PROPERTY_ANNUAL_REVENUE,
  IndividualApplicationAllOfAttributes.JSON_PROPERTY_NUMBER_OF_EMPLOYEES,
  IndividualApplicationAllOfAttributes.JSON_PROPERTY_BUSINESS_VERTICAL,
  IndividualApplicationAllOfAttributes.JSON_PROPERTY_WEBSITE
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.9.0")
public class IndividualApplicationAllOfAttributes {
  public static final String JSON_PROPERTY_CREATED_AT = "createdAt";
  private OffsetDateTime createdAt;

  public static final String JSON_PROPERTY_UPDATED_AT = "updatedAt";
  private OffsetDateTime updatedAt;

  public static final String JSON_PROPERTY_STATUS = "status";
  private ApplicationStatus status;

  public static final String JSON_PROPERTY_MESSAGE = "message";
  private String message;

  public static final String JSON_PROPERTY_EVALUATION_OUTCOME = "evaluationOutcome";
  private String evaluationOutcome;

  public static final String JSON_PROPERTY_EVALUATION_ID = "evaluationId";
  private String evaluationId;

  public static final String JSON_PROPERTY_EVALUATION_ENTITY_ID = "evaluationEntityId";
  private String evaluationEntityId;

  public static final String JSON_PROPERTY_FULL_NAME = "fullName";
  private FullName fullName;

  public static final String JSON_PROPERTY_EMAIL = "email";
  private String email;

  public static final String JSON_PROPERTY_PHONE = "phone";
  private Phone phone;

  public static final String JSON_PROPERTY_SSN = "ssn";
  private String ssn;

  public static final String JSON_PROPERTY_PASSPORT = "passport";
  private String passport;

  public static final String JSON_PROPERTY_NATIONALITY = "nationality";
  private String nationality;

  public static final String JSON_PROPERTY_MATRICULA_CONSULAR = "matriculaConsular";
  private String matriculaConsular;

  public static final String JSON_PROPERTY_ADDRESS = "address";
  private Address address;

  public static final String JSON_PROPERTY_DATE_OF_BIRTH = "dateOfBirth";
  private LocalDate dateOfBirth;

  public static final String JSON_PROPERTY_DBA = "dba";
  private String dba;

  public static final String JSON_PROPERTY_EIN = "ein";
  private String ein;

  public static final String JSON_PROPERTY_IP = "ip";
  private String ip;

  public static final String JSON_PROPERTY_SOLE_PROPRIETORSHIP = "soleProprietorship";
  private Boolean soleProprietorship;

  /**
   * Gets or Sets decisionMethod
   */
  public enum DecisionMethodEnum {
    MANUALLY("Manually"),
    
    AUTOMATICALLY("Automatically");

    private String value;

    DecisionMethodEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static DecisionMethodEnum fromValue(String value) {
      for (DecisionMethodEnum b : DecisionMethodEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_DECISION_METHOD = "decisionMethod";
  private DecisionMethodEnum decisionMethod;

  public static final String JSON_PROPERTY_DECISION_USER_ID = "decisionUserId";
  private String decisionUserId;

  public static final String JSON_PROPERTY_DECISION_REASON = "decisionReason";
  private String decisionReason;

  public static final String JSON_PROPERTY_DECISION_DATE_TIME = "decisionDateTime";
  private OffsetDateTime decisionDateTime;

  public static final String JSON_PROPERTY_TAGS = "tags";
  private Map<String, String> tags = new HashMap<>();

  /**
   * Gets or Sets riskRate
   */
  public enum RiskRateEnum {
    LOW("low"),
    
    MEDIUM("medium"),
    
    HIGH("high");

    private String value;

    RiskRateEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static RiskRateEnum fromValue(String value) {
      for (RiskRateEnum b : RiskRateEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_RISK_RATE = "riskRate";
  private RiskRateEnum riskRate;

  public static final String JSON_PROPERTY_EVALUATION_FLAGS = "evaluationFlags";
  private List<String> evaluationFlags = new ArrayList<>();

  public static final String JSON_PROPERTY_EVALUATION_SCORES = "evaluationScores";
  private Object evaluationScores;

  public static final String JSON_PROPERTY_IP_LOCATION_DETAILS = "ipLocationDetails";
  private Object ipLocationDetails;

  public static final String JSON_PROPERTY_PHONE_LOCATION_DETAILS = "phoneLocationDetails";
  private Object phoneLocationDetails;

  public static final String JSON_PROPERTY_MASKED_S_S_N = "maskedSSN";
  private String maskedSSN;

  public static final String JSON_PROPERTY_MASKED_PASSPORT = "maskedPassport";
  private String maskedPassport;

  public static final String JSON_PROPERTY_MASKED_MATRICULA_CONSULAR = "maskedMatriculaConsular";
  private String maskedMatriculaConsular;

  public static final String JSON_PROPERTY_JWT_SUBJECT = "jwtSubject";
  private JsonNullable<String> jwtSubject = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_ARCHIVED = "archived";
  private Boolean archived;

  public static final String JSON_PROPERTY_POWER_OF_ATTORNEY_AGENT = "powerOfAttorneyAgent";
  private PowerOfAttorneyAgent powerOfAttorneyAgent;

  public static final String JSON_PROPERTY_INDUSTRY = "industry";
  private Industry industry;

  public static final String JSON_PROPERTY_ID_THEFT_SCORE = "idTheftScore";
  private Integer idTheftScore;

  public static final String JSON_PROPERTY_OCCUPATION = "occupation";
  private Occupation occupation;

  public static final String JSON_PROPERTY_ANNUAL_INCOME = "annualIncome";
  private AnnualIncome annualIncome;

  public static final String JSON_PROPERTY_SOURCE_OF_INCOME = "sourceOfIncome";
  private SourceOfIncome sourceOfIncome;

  public static final String JSON_PROPERTY_ANNUAL_REVENUE = "annualRevenue";
  private SoleProprietorshipAnnualRevenue annualRevenue;

  public static final String JSON_PROPERTY_NUMBER_OF_EMPLOYEES = "numberOfEmployees";
  private SoleProprietorshipNumberOfEmployees numberOfEmployees;

  public static final String JSON_PROPERTY_BUSINESS_VERTICAL = "businessVertical";
  private BusinessVertical businessVertical;

  public static final String JSON_PROPERTY_WEBSITE = "website";
  private String website;

  public IndividualApplicationAllOfAttributes() { 
  }

  public IndividualApplicationAllOfAttributes createdAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
    return this;
  }

  /**
   * Get createdAt
   * @return createdAt
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }


  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }


  public IndividualApplicationAllOfAttributes updatedAt(OffsetDateTime updatedAt) {
    this.updatedAt = updatedAt;
    return this;
  }

  /**
   * Get updatedAt
   * @return updatedAt
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_UPDATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public OffsetDateTime getUpdatedAt() {
    return updatedAt;
  }


  @JsonProperty(JSON_PROPERTY_UPDATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUpdatedAt(OffsetDateTime updatedAt) {
    this.updatedAt = updatedAt;
  }


  public IndividualApplicationAllOfAttributes status(ApplicationStatus status) {
    this.status = status;
    return this;
  }

  /**
   * Get status
   * @return status
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public ApplicationStatus getStatus() {
    return status;
  }


  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setStatus(ApplicationStatus status) {
    this.status = status;
  }


  public IndividualApplicationAllOfAttributes message(String message) {
    this.message = message;
    return this;
  }

  /**
   * Get message
   * @return message
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getMessage() {
    return message;
  }


  @JsonProperty(JSON_PROPERTY_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMessage(String message) {
    this.message = message;
  }


  public IndividualApplicationAllOfAttributes evaluationOutcome(String evaluationOutcome) {
    this.evaluationOutcome = evaluationOutcome;
    return this;
  }

  /**
   * Get evaluationOutcome
   * @return evaluationOutcome
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_EVALUATION_OUTCOME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getEvaluationOutcome() {
    return evaluationOutcome;
  }


  @JsonProperty(JSON_PROPERTY_EVALUATION_OUTCOME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEvaluationOutcome(String evaluationOutcome) {
    this.evaluationOutcome = evaluationOutcome;
  }


  public IndividualApplicationAllOfAttributes evaluationId(String evaluationId) {
    this.evaluationId = evaluationId;
    return this;
  }

  /**
   * Get evaluationId
   * @return evaluationId
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_EVALUATION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getEvaluationId() {
    return evaluationId;
  }


  @JsonProperty(JSON_PROPERTY_EVALUATION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEvaluationId(String evaluationId) {
    this.evaluationId = evaluationId;
  }


  public IndividualApplicationAllOfAttributes evaluationEntityId(String evaluationEntityId) {
    this.evaluationEntityId = evaluationEntityId;
    return this;
  }

  /**
   * Get evaluationEntityId
   * @return evaluationEntityId
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_EVALUATION_ENTITY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getEvaluationEntityId() {
    return evaluationEntityId;
  }


  @JsonProperty(JSON_PROPERTY_EVALUATION_ENTITY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEvaluationEntityId(String evaluationEntityId) {
    this.evaluationEntityId = evaluationEntityId;
  }


  public IndividualApplicationAllOfAttributes fullName(FullName fullName) {
    this.fullName = fullName;
    return this;
  }

  /**
   * Get fullName
   * @return fullName
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_FULL_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public FullName getFullName() {
    return fullName;
  }


  @JsonProperty(JSON_PROPERTY_FULL_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setFullName(FullName fullName) {
    this.fullName = fullName;
  }


  public IndividualApplicationAllOfAttributes email(String email) {
    this.email = email;
    return this;
  }

  /**
   * Get email
   * @return email
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_EMAIL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getEmail() {
    return email;
  }


  @JsonProperty(JSON_PROPERTY_EMAIL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEmail(String email) {
    this.email = email;
  }


  public IndividualApplicationAllOfAttributes phone(Phone phone) {
    this.phone = phone;
    return this;
  }

  /**
   * Get phone
   * @return phone
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PHONE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Phone getPhone() {
    return phone;
  }


  @JsonProperty(JSON_PROPERTY_PHONE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPhone(Phone phone) {
    this.phone = phone;
  }


  public IndividualApplicationAllOfAttributes ssn(String ssn) {
    this.ssn = ssn;
    return this;
  }

  /**
   * Get ssn
   * @return ssn
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SSN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getSsn() {
    return ssn;
  }


  @JsonProperty(JSON_PROPERTY_SSN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSsn(String ssn) {
    this.ssn = ssn;
  }


  public IndividualApplicationAllOfAttributes passport(String passport) {
    this.passport = passport;
    return this;
  }

  /**
   * Get passport
   * @return passport
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PASSPORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getPassport() {
    return passport;
  }


  @JsonProperty(JSON_PROPERTY_PASSPORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPassport(String passport) {
    this.passport = passport;
  }


  public IndividualApplicationAllOfAttributes nationality(String nationality) {
    this.nationality = nationality;
    return this;
  }

  /**
   * Get nationality
   * @return nationality
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_NATIONALITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getNationality() {
    return nationality;
  }


  @JsonProperty(JSON_PROPERTY_NATIONALITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNationality(String nationality) {
    this.nationality = nationality;
  }


  public IndividualApplicationAllOfAttributes matriculaConsular(String matriculaConsular) {
    this.matriculaConsular = matriculaConsular;
    return this;
  }

  /**
   * Get matriculaConsular
   * @return matriculaConsular
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_MATRICULA_CONSULAR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getMatriculaConsular() {
    return matriculaConsular;
  }


  @JsonProperty(JSON_PROPERTY_MATRICULA_CONSULAR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMatriculaConsular(String matriculaConsular) {
    this.matriculaConsular = matriculaConsular;
  }


  public IndividualApplicationAllOfAttributes address(Address address) {
    this.address = address;
    return this;
  }

  /**
   * Get address
   * @return address
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Address getAddress() {
    return address;
  }


  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAddress(Address address) {
    this.address = address;
  }


  public IndividualApplicationAllOfAttributes dateOfBirth(LocalDate dateOfBirth) {
    this.dateOfBirth = dateOfBirth;
    return this;
  }

  /**
   * Get dateOfBirth
   * @return dateOfBirth
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DATE_OF_BIRTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public LocalDate getDateOfBirth() {
    return dateOfBirth;
  }


  @JsonProperty(JSON_PROPERTY_DATE_OF_BIRTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDateOfBirth(LocalDate dateOfBirth) {
    this.dateOfBirth = dateOfBirth;
  }


  public IndividualApplicationAllOfAttributes dba(String dba) {
    this.dba = dba;
    return this;
  }

  /**
   * Get dba
   * @return dba
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DBA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getDba() {
    return dba;
  }


  @JsonProperty(JSON_PROPERTY_DBA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDba(String dba) {
    this.dba = dba;
  }


  public IndividualApplicationAllOfAttributes ein(String ein) {
    this.ein = ein;
    return this;
  }

  /**
   * Get ein
   * @return ein
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_EIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getEin() {
    return ein;
  }


  @JsonProperty(JSON_PROPERTY_EIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEin(String ein) {
    this.ein = ein;
  }


  public IndividualApplicationAllOfAttributes ip(String ip) {
    this.ip = ip;
    return this;
  }

  /**
   * Get ip
   * @return ip
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_IP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getIp() {
    return ip;
  }


  @JsonProperty(JSON_PROPERTY_IP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIp(String ip) {
    this.ip = ip;
  }


  public IndividualApplicationAllOfAttributes soleProprietorship(Boolean soleProprietorship) {
    this.soleProprietorship = soleProprietorship;
    return this;
  }

  /**
   * Get soleProprietorship
   * @return soleProprietorship
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SOLE_PROPRIETORSHIP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getSoleProprietorship() {
    return soleProprietorship;
  }


  @JsonProperty(JSON_PROPERTY_SOLE_PROPRIETORSHIP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSoleProprietorship(Boolean soleProprietorship) {
    this.soleProprietorship = soleProprietorship;
  }


  public IndividualApplicationAllOfAttributes decisionMethod(DecisionMethodEnum decisionMethod) {
    this.decisionMethod = decisionMethod;
    return this;
  }

  /**
   * Get decisionMethod
   * @return decisionMethod
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DECISION_METHOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public DecisionMethodEnum getDecisionMethod() {
    return decisionMethod;
  }


  @JsonProperty(JSON_PROPERTY_DECISION_METHOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDecisionMethod(DecisionMethodEnum decisionMethod) {
    this.decisionMethod = decisionMethod;
  }


  public IndividualApplicationAllOfAttributes decisionUserId(String decisionUserId) {
    this.decisionUserId = decisionUserId;
    return this;
  }

  /**
   * Get decisionUserId
   * @return decisionUserId
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DECISION_USER_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getDecisionUserId() {
    return decisionUserId;
  }


  @JsonProperty(JSON_PROPERTY_DECISION_USER_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDecisionUserId(String decisionUserId) {
    this.decisionUserId = decisionUserId;
  }


  public IndividualApplicationAllOfAttributes decisionReason(String decisionReason) {
    this.decisionReason = decisionReason;
    return this;
  }

  /**
   * Get decisionReason
   * @return decisionReason
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DECISION_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getDecisionReason() {
    return decisionReason;
  }


  @JsonProperty(JSON_PROPERTY_DECISION_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDecisionReason(String decisionReason) {
    this.decisionReason = decisionReason;
  }


  public IndividualApplicationAllOfAttributes decisionDateTime(OffsetDateTime decisionDateTime) {
    this.decisionDateTime = decisionDateTime;
    return this;
  }

  /**
   * Get decisionDateTime
   * @return decisionDateTime
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DECISION_DATE_TIME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public OffsetDateTime getDecisionDateTime() {
    return decisionDateTime;
  }


  @JsonProperty(JSON_PROPERTY_DECISION_DATE_TIME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDecisionDateTime(OffsetDateTime decisionDateTime) {
    this.decisionDateTime = decisionDateTime;
  }


  public IndividualApplicationAllOfAttributes tags(Map<String, String> tags) {
    this.tags = tags;
    return this;
  }

  public IndividualApplicationAllOfAttributes putTagsItem(String key, String tagsItem) {
    if (this.tags == null) {
      this.tags = new HashMap<>();
    }
    this.tags.put(key, tagsItem);
    return this;
  }

  /**
   * Get tags
   * @return tags
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TAGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Map<String, String> getTags() {
    return tags;
  }


  @JsonProperty(JSON_PROPERTY_TAGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTags(Map<String, String> tags) {
    this.tags = tags;
  }


  public IndividualApplicationAllOfAttributes riskRate(RiskRateEnum riskRate) {
    this.riskRate = riskRate;
    return this;
  }

  /**
   * Get riskRate
   * @return riskRate
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_RISK_RATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public RiskRateEnum getRiskRate() {
    return riskRate;
  }


  @JsonProperty(JSON_PROPERTY_RISK_RATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRiskRate(RiskRateEnum riskRate) {
    this.riskRate = riskRate;
  }


  public IndividualApplicationAllOfAttributes evaluationFlags(List<String> evaluationFlags) {
    this.evaluationFlags = evaluationFlags;
    return this;
  }

  public IndividualApplicationAllOfAttributes addEvaluationFlagsItem(String evaluationFlagsItem) {
    if (this.evaluationFlags == null) {
      this.evaluationFlags = new ArrayList<>();
    }
    this.evaluationFlags.add(evaluationFlagsItem);
    return this;
  }

  /**
   * Get evaluationFlags
   * @return evaluationFlags
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_EVALUATION_FLAGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<String> getEvaluationFlags() {
    return evaluationFlags;
  }


  @JsonProperty(JSON_PROPERTY_EVALUATION_FLAGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEvaluationFlags(List<String> evaluationFlags) {
    this.evaluationFlags = evaluationFlags;
  }


  public IndividualApplicationAllOfAttributes evaluationScores(Object evaluationScores) {
    this.evaluationScores = evaluationScores;
    return this;
  }

  /**
   * Get evaluationScores
   * @return evaluationScores
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_EVALUATION_SCORES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Object getEvaluationScores() {
    return evaluationScores;
  }


  @JsonProperty(JSON_PROPERTY_EVALUATION_SCORES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEvaluationScores(Object evaluationScores) {
    this.evaluationScores = evaluationScores;
  }


  public IndividualApplicationAllOfAttributes ipLocationDetails(Object ipLocationDetails) {
    this.ipLocationDetails = ipLocationDetails;
    return this;
  }

  /**
   * Get ipLocationDetails
   * @return ipLocationDetails
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_IP_LOCATION_DETAILS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Object getIpLocationDetails() {
    return ipLocationDetails;
  }


  @JsonProperty(JSON_PROPERTY_IP_LOCATION_DETAILS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIpLocationDetails(Object ipLocationDetails) {
    this.ipLocationDetails = ipLocationDetails;
  }


  public IndividualApplicationAllOfAttributes phoneLocationDetails(Object phoneLocationDetails) {
    this.phoneLocationDetails = phoneLocationDetails;
    return this;
  }

  /**
   * Get phoneLocationDetails
   * @return phoneLocationDetails
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PHONE_LOCATION_DETAILS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Object getPhoneLocationDetails() {
    return phoneLocationDetails;
  }


  @JsonProperty(JSON_PROPERTY_PHONE_LOCATION_DETAILS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPhoneLocationDetails(Object phoneLocationDetails) {
    this.phoneLocationDetails = phoneLocationDetails;
  }


  public IndividualApplicationAllOfAttributes maskedSSN(String maskedSSN) {
    this.maskedSSN = maskedSSN;
    return this;
  }

  /**
   * Get maskedSSN
   * @return maskedSSN
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_MASKED_S_S_N)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getMaskedSSN() {
    return maskedSSN;
  }


  @JsonProperty(JSON_PROPERTY_MASKED_S_S_N)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaskedSSN(String maskedSSN) {
    this.maskedSSN = maskedSSN;
  }


  public IndividualApplicationAllOfAttributes maskedPassport(String maskedPassport) {
    this.maskedPassport = maskedPassport;
    return this;
  }

  /**
   * Get maskedPassport
   * @return maskedPassport
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_MASKED_PASSPORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getMaskedPassport() {
    return maskedPassport;
  }


  @JsonProperty(JSON_PROPERTY_MASKED_PASSPORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaskedPassport(String maskedPassport) {
    this.maskedPassport = maskedPassport;
  }


  public IndividualApplicationAllOfAttributes maskedMatriculaConsular(String maskedMatriculaConsular) {
    this.maskedMatriculaConsular = maskedMatriculaConsular;
    return this;
  }

  /**
   * Get maskedMatriculaConsular
   * @return maskedMatriculaConsular
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_MASKED_MATRICULA_CONSULAR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getMaskedMatriculaConsular() {
    return maskedMatriculaConsular;
  }


  @JsonProperty(JSON_PROPERTY_MASKED_MATRICULA_CONSULAR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaskedMatriculaConsular(String maskedMatriculaConsular) {
    this.maskedMatriculaConsular = maskedMatriculaConsular;
  }


  public IndividualApplicationAllOfAttributes jwtSubject(String jwtSubject) {
    this.jwtSubject = JsonNullable.<String>of(jwtSubject);
    return this;
  }

  /**
   * Get jwtSubject
   * @return jwtSubject
   */
  @jakarta.annotation.Nullable
  @JsonIgnore
  public String getJwtSubject() {
        return jwtSubject.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_JWT_SUBJECT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getJwtSubject_JsonNullable() {
    return jwtSubject;
  }
  
  @JsonProperty(JSON_PROPERTY_JWT_SUBJECT)
  public void setJwtSubject_JsonNullable(JsonNullable<String> jwtSubject) {
    this.jwtSubject = jwtSubject;
  }

  public void setJwtSubject(String jwtSubject) {
    this.jwtSubject = JsonNullable.<String>of(jwtSubject);
  }


  public IndividualApplicationAllOfAttributes archived(Boolean archived) {
    this.archived = archived;
    return this;
  }

  /**
   * Get archived
   * @return archived
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ARCHIVED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getArchived() {
    return archived;
  }


  @JsonProperty(JSON_PROPERTY_ARCHIVED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setArchived(Boolean archived) {
    this.archived = archived;
  }


  public IndividualApplicationAllOfAttributes powerOfAttorneyAgent(PowerOfAttorneyAgent powerOfAttorneyAgent) {
    this.powerOfAttorneyAgent = powerOfAttorneyAgent;
    return this;
  }

  /**
   * Get powerOfAttorneyAgent
   * @return powerOfAttorneyAgent
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_POWER_OF_ATTORNEY_AGENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public PowerOfAttorneyAgent getPowerOfAttorneyAgent() {
    return powerOfAttorneyAgent;
  }


  @JsonProperty(JSON_PROPERTY_POWER_OF_ATTORNEY_AGENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPowerOfAttorneyAgent(PowerOfAttorneyAgent powerOfAttorneyAgent) {
    this.powerOfAttorneyAgent = powerOfAttorneyAgent;
  }


  public IndividualApplicationAllOfAttributes industry(Industry industry) {
    this.industry = industry;
    return this;
  }

  /**
   * Get industry
   * @return industry
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_INDUSTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Industry getIndustry() {
    return industry;
  }


  @JsonProperty(JSON_PROPERTY_INDUSTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIndustry(Industry industry) {
    this.industry = industry;
  }


  public IndividualApplicationAllOfAttributes idTheftScore(Integer idTheftScore) {
    this.idTheftScore = idTheftScore;
    return this;
  }

  /**
   * Get idTheftScore
   * @return idTheftScore
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ID_THEFT_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Integer getIdTheftScore() {
    return idTheftScore;
  }


  @JsonProperty(JSON_PROPERTY_ID_THEFT_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIdTheftScore(Integer idTheftScore) {
    this.idTheftScore = idTheftScore;
  }


  public IndividualApplicationAllOfAttributes occupation(Occupation occupation) {
    this.occupation = occupation;
    return this;
  }

  /**
   * Get occupation
   * @return occupation
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_OCCUPATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Occupation getOccupation() {
    return occupation;
  }


  @JsonProperty(JSON_PROPERTY_OCCUPATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOccupation(Occupation occupation) {
    this.occupation = occupation;
  }


  public IndividualApplicationAllOfAttributes annualIncome(AnnualIncome annualIncome) {
    this.annualIncome = annualIncome;
    return this;
  }

  /**
   * Get annualIncome
   * @return annualIncome
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ANNUAL_INCOME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public AnnualIncome getAnnualIncome() {
    return annualIncome;
  }


  @JsonProperty(JSON_PROPERTY_ANNUAL_INCOME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAnnualIncome(AnnualIncome annualIncome) {
    this.annualIncome = annualIncome;
  }


  public IndividualApplicationAllOfAttributes sourceOfIncome(SourceOfIncome sourceOfIncome) {
    this.sourceOfIncome = sourceOfIncome;
    return this;
  }

  /**
   * Get sourceOfIncome
   * @return sourceOfIncome
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SOURCE_OF_INCOME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public SourceOfIncome getSourceOfIncome() {
    return sourceOfIncome;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_OF_INCOME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceOfIncome(SourceOfIncome sourceOfIncome) {
    this.sourceOfIncome = sourceOfIncome;
  }


  public IndividualApplicationAllOfAttributes annualRevenue(SoleProprietorshipAnnualRevenue annualRevenue) {
    this.annualRevenue = annualRevenue;
    return this;
  }

  /**
   * Get annualRevenue
   * @return annualRevenue
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ANNUAL_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public SoleProprietorshipAnnualRevenue getAnnualRevenue() {
    return annualRevenue;
  }


  @JsonProperty(JSON_PROPERTY_ANNUAL_REVENUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAnnualRevenue(SoleProprietorshipAnnualRevenue annualRevenue) {
    this.annualRevenue = annualRevenue;
  }


  public IndividualApplicationAllOfAttributes numberOfEmployees(SoleProprietorshipNumberOfEmployees numberOfEmployees) {
    this.numberOfEmployees = numberOfEmployees;
    return this;
  }

  /**
   * Get numberOfEmployees
   * @return numberOfEmployees
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_NUMBER_OF_EMPLOYEES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public SoleProprietorshipNumberOfEmployees getNumberOfEmployees() {
    return numberOfEmployees;
  }


  @JsonProperty(JSON_PROPERTY_NUMBER_OF_EMPLOYEES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNumberOfEmployees(SoleProprietorshipNumberOfEmployees numberOfEmployees) {
    this.numberOfEmployees = numberOfEmployees;
  }


  public IndividualApplicationAllOfAttributes businessVertical(BusinessVertical businessVertical) {
    this.businessVertical = businessVertical;
    return this;
  }

  /**
   * Get businessVertical
   * @return businessVertical
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_BUSINESS_VERTICAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public BusinessVertical getBusinessVertical() {
    return businessVertical;
  }


  @JsonProperty(JSON_PROPERTY_BUSINESS_VERTICAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBusinessVertical(BusinessVertical businessVertical) {
    this.businessVertical = businessVertical;
  }


  public IndividualApplicationAllOfAttributes website(String website) {
    this.website = website;
    return this;
  }

  /**
   * Get website
   * @return website
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_WEBSITE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getWebsite() {
    return website;
  }


  @JsonProperty(JSON_PROPERTY_WEBSITE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWebsite(String website) {
    this.website = website;
  }


  /**
   * Return true if this IndividualApplication_allOf_attributes object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    IndividualApplicationAllOfAttributes individualApplicationAllOfAttributes = (IndividualApplicationAllOfAttributes) o;
    return Objects.equals(this.createdAt, individualApplicationAllOfAttributes.createdAt) &&
        Objects.equals(this.updatedAt, individualApplicationAllOfAttributes.updatedAt) &&
        Objects.equals(this.status, individualApplicationAllOfAttributes.status) &&
        Objects.equals(this.message, individualApplicationAllOfAttributes.message) &&
        Objects.equals(this.evaluationOutcome, individualApplicationAllOfAttributes.evaluationOutcome) &&
        Objects.equals(this.evaluationId, individualApplicationAllOfAttributes.evaluationId) &&
        Objects.equals(this.evaluationEntityId, individualApplicationAllOfAttributes.evaluationEntityId) &&
        Objects.equals(this.fullName, individualApplicationAllOfAttributes.fullName) &&
        Objects.equals(this.email, individualApplicationAllOfAttributes.email) &&
        Objects.equals(this.phone, individualApplicationAllOfAttributes.phone) &&
        Objects.equals(this.ssn, individualApplicationAllOfAttributes.ssn) &&
        Objects.equals(this.passport, individualApplicationAllOfAttributes.passport) &&
        Objects.equals(this.nationality, individualApplicationAllOfAttributes.nationality) &&
        Objects.equals(this.matriculaConsular, individualApplicationAllOfAttributes.matriculaConsular) &&
        Objects.equals(this.address, individualApplicationAllOfAttributes.address) &&
        Objects.equals(this.dateOfBirth, individualApplicationAllOfAttributes.dateOfBirth) &&
        Objects.equals(this.dba, individualApplicationAllOfAttributes.dba) &&
        Objects.equals(this.ein, individualApplicationAllOfAttributes.ein) &&
        Objects.equals(this.ip, individualApplicationAllOfAttributes.ip) &&
        Objects.equals(this.soleProprietorship, individualApplicationAllOfAttributes.soleProprietorship) &&
        Objects.equals(this.decisionMethod, individualApplicationAllOfAttributes.decisionMethod) &&
        Objects.equals(this.decisionUserId, individualApplicationAllOfAttributes.decisionUserId) &&
        Objects.equals(this.decisionReason, individualApplicationAllOfAttributes.decisionReason) &&
        Objects.equals(this.decisionDateTime, individualApplicationAllOfAttributes.decisionDateTime) &&
        Objects.equals(this.tags, individualApplicationAllOfAttributes.tags) &&
        Objects.equals(this.riskRate, individualApplicationAllOfAttributes.riskRate) &&
        Objects.equals(this.evaluationFlags, individualApplicationAllOfAttributes.evaluationFlags) &&
        Objects.equals(this.evaluationScores, individualApplicationAllOfAttributes.evaluationScores) &&
        Objects.equals(this.ipLocationDetails, individualApplicationAllOfAttributes.ipLocationDetails) &&
        Objects.equals(this.phoneLocationDetails, individualApplicationAllOfAttributes.phoneLocationDetails) &&
        Objects.equals(this.maskedSSN, individualApplicationAllOfAttributes.maskedSSN) &&
        Objects.equals(this.maskedPassport, individualApplicationAllOfAttributes.maskedPassport) &&
        Objects.equals(this.maskedMatriculaConsular, individualApplicationAllOfAttributes.maskedMatriculaConsular) &&
        equalsNullable(this.jwtSubject, individualApplicationAllOfAttributes.jwtSubject) &&
        Objects.equals(this.archived, individualApplicationAllOfAttributes.archived) &&
        Objects.equals(this.powerOfAttorneyAgent, individualApplicationAllOfAttributes.powerOfAttorneyAgent) &&
        Objects.equals(this.industry, individualApplicationAllOfAttributes.industry) &&
        Objects.equals(this.idTheftScore, individualApplicationAllOfAttributes.idTheftScore) &&
        Objects.equals(this.occupation, individualApplicationAllOfAttributes.occupation) &&
        Objects.equals(this.annualIncome, individualApplicationAllOfAttributes.annualIncome) &&
        Objects.equals(this.sourceOfIncome, individualApplicationAllOfAttributes.sourceOfIncome) &&
        Objects.equals(this.annualRevenue, individualApplicationAllOfAttributes.annualRevenue) &&
        Objects.equals(this.numberOfEmployees, individualApplicationAllOfAttributes.numberOfEmployees) &&
        Objects.equals(this.businessVertical, individualApplicationAllOfAttributes.businessVertical) &&
        Objects.equals(this.website, individualApplicationAllOfAttributes.website);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(createdAt, updatedAt, status, message, evaluationOutcome, evaluationId, evaluationEntityId, fullName, email, phone, ssn, passport, nationality, matriculaConsular, address, dateOfBirth, dba, ein, ip, soleProprietorship, decisionMethod, decisionUserId, decisionReason, decisionDateTime, tags, riskRate, evaluationFlags, evaluationScores, ipLocationDetails, phoneLocationDetails, maskedSSN, maskedPassport, maskedMatriculaConsular, hashCodeNullable(jwtSubject), archived, powerOfAttorneyAgent, industry, idTheftScore, occupation, annualIncome, sourceOfIncome, annualRevenue, numberOfEmployees, businessVertical, website);
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class IndividualApplicationAllOfAttributes {\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    updatedAt: ").append(toIndentedString(updatedAt)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    evaluationOutcome: ").append(toIndentedString(evaluationOutcome)).append("\n");
    sb.append("    evaluationId: ").append(toIndentedString(evaluationId)).append("\n");
    sb.append("    evaluationEntityId: ").append(toIndentedString(evaluationEntityId)).append("\n");
    sb.append("    fullName: ").append(toIndentedString(fullName)).append("\n");
    sb.append("    email: ").append(toIndentedString(email)).append("\n");
    sb.append("    phone: ").append(toIndentedString(phone)).append("\n");
    sb.append("    ssn: ").append(toIndentedString(ssn)).append("\n");
    sb.append("    passport: ").append(toIndentedString(passport)).append("\n");
    sb.append("    nationality: ").append(toIndentedString(nationality)).append("\n");
    sb.append("    matriculaConsular: ").append(toIndentedString(matriculaConsular)).append("\n");
    sb.append("    address: ").append(toIndentedString(address)).append("\n");
    sb.append("    dateOfBirth: ").append(toIndentedString(dateOfBirth)).append("\n");
    sb.append("    dba: ").append(toIndentedString(dba)).append("\n");
    sb.append("    ein: ").append(toIndentedString(ein)).append("\n");
    sb.append("    ip: ").append(toIndentedString(ip)).append("\n");
    sb.append("    soleProprietorship: ").append(toIndentedString(soleProprietorship)).append("\n");
    sb.append("    decisionMethod: ").append(toIndentedString(decisionMethod)).append("\n");
    sb.append("    decisionUserId: ").append(toIndentedString(decisionUserId)).append("\n");
    sb.append("    decisionReason: ").append(toIndentedString(decisionReason)).append("\n");
    sb.append("    decisionDateTime: ").append(toIndentedString(decisionDateTime)).append("\n");
    sb.append("    tags: ").append(toIndentedString(tags)).append("\n");
    sb.append("    riskRate: ").append(toIndentedString(riskRate)).append("\n");
    sb.append("    evaluationFlags: ").append(toIndentedString(evaluationFlags)).append("\n");
    sb.append("    evaluationScores: ").append(toIndentedString(evaluationScores)).append("\n");
    sb.append("    ipLocationDetails: ").append(toIndentedString(ipLocationDetails)).append("\n");
    sb.append("    phoneLocationDetails: ").append(toIndentedString(phoneLocationDetails)).append("\n");
    sb.append("    maskedSSN: ").append(toIndentedString(maskedSSN)).append("\n");
    sb.append("    maskedPassport: ").append(toIndentedString(maskedPassport)).append("\n");
    sb.append("    maskedMatriculaConsular: ").append(toIndentedString(maskedMatriculaConsular)).append("\n");
    sb.append("    jwtSubject: ").append(toIndentedString(jwtSubject)).append("\n");
    sb.append("    archived: ").append(toIndentedString(archived)).append("\n");
    sb.append("    powerOfAttorneyAgent: ").append(toIndentedString(powerOfAttorneyAgent)).append("\n");
    sb.append("    industry: ").append(toIndentedString(industry)).append("\n");
    sb.append("    idTheftScore: ").append(toIndentedString(idTheftScore)).append("\n");
    sb.append("    occupation: ").append(toIndentedString(occupation)).append("\n");
    sb.append("    annualIncome: ").append(toIndentedString(annualIncome)).append("\n");
    sb.append("    sourceOfIncome: ").append(toIndentedString(sourceOfIncome)).append("\n");
    sb.append("    annualRevenue: ").append(toIndentedString(annualRevenue)).append("\n");
    sb.append("    numberOfEmployees: ").append(toIndentedString(numberOfEmployees)).append("\n");
    sb.append("    businessVertical: ").append(toIndentedString(businessVertical)).append("\n");
    sb.append("    website: ").append(toIndentedString(website)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `createdAt` to the URL query string
    if (getCreatedAt() != null) {
      joiner.add(String.format("%screatedAt%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getCreatedAt()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `updatedAt` to the URL query string
    if (getUpdatedAt() != null) {
      joiner.add(String.format("%supdatedAt%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getUpdatedAt()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `status` to the URL query string
    if (getStatus() != null) {
      joiner.add(String.format("%sstatus%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getStatus()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `message` to the URL query string
    if (getMessage() != null) {
      joiner.add(String.format("%smessage%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getMessage()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `evaluationOutcome` to the URL query string
    if (getEvaluationOutcome() != null) {
      joiner.add(String.format("%sevaluationOutcome%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getEvaluationOutcome()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `evaluationId` to the URL query string
    if (getEvaluationId() != null) {
      joiner.add(String.format("%sevaluationId%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getEvaluationId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `evaluationEntityId` to the URL query string
    if (getEvaluationEntityId() != null) {
      joiner.add(String.format("%sevaluationEntityId%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getEvaluationEntityId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `fullName` to the URL query string
    if (getFullName() != null) {
      joiner.add(getFullName().toUrlQueryString(prefix + "fullName" + suffix));
    }

    // add `email` to the URL query string
    if (getEmail() != null) {
      joiner.add(String.format("%semail%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getEmail()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `phone` to the URL query string
    if (getPhone() != null) {
      joiner.add(getPhone().toUrlQueryString(prefix + "phone" + suffix));
    }

    // add `ssn` to the URL query string
    if (getSsn() != null) {
      joiner.add(String.format("%sssn%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getSsn()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `passport` to the URL query string
    if (getPassport() != null) {
      joiner.add(String.format("%spassport%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getPassport()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `nationality` to the URL query string
    if (getNationality() != null) {
      joiner.add(String.format("%snationality%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getNationality()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `matriculaConsular` to the URL query string
    if (getMatriculaConsular() != null) {
      joiner.add(String.format("%smatriculaConsular%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getMatriculaConsular()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `address` to the URL query string
    if (getAddress() != null) {
      joiner.add(getAddress().toUrlQueryString(prefix + "address" + suffix));
    }

    // add `dateOfBirth` to the URL query string
    if (getDateOfBirth() != null) {
      joiner.add(String.format("%sdateOfBirth%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getDateOfBirth()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `dba` to the URL query string
    if (getDba() != null) {
      joiner.add(String.format("%sdba%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getDba()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `ein` to the URL query string
    if (getEin() != null) {
      joiner.add(String.format("%sein%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getEin()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `ip` to the URL query string
    if (getIp() != null) {
      joiner.add(String.format("%sip%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getIp()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `soleProprietorship` to the URL query string
    if (getSoleProprietorship() != null) {
      joiner.add(String.format("%ssoleProprietorship%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getSoleProprietorship()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `decisionMethod` to the URL query string
    if (getDecisionMethod() != null) {
      joiner.add(String.format("%sdecisionMethod%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getDecisionMethod()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `decisionUserId` to the URL query string
    if (getDecisionUserId() != null) {
      joiner.add(String.format("%sdecisionUserId%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getDecisionUserId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `decisionReason` to the URL query string
    if (getDecisionReason() != null) {
      joiner.add(String.format("%sdecisionReason%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getDecisionReason()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `decisionDateTime` to the URL query string
    if (getDecisionDateTime() != null) {
      joiner.add(String.format("%sdecisionDateTime%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getDecisionDateTime()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `tags` to the URL query string
    if (getTags() != null) {
      for (String _key : getTags().keySet()) {
        joiner.add(String.format("%stags%s%s=%s", prefix, suffix,
            "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix),
            getTags().get(_key), URLEncoder.encode(ApiClient.valueToString(getTags().get(_key)), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
      }
    }

    // add `riskRate` to the URL query string
    if (getRiskRate() != null) {
      joiner.add(String.format("%sriskRate%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getRiskRate()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `evaluationFlags` to the URL query string
    if (getEvaluationFlags() != null) {
      for (int i = 0; i < getEvaluationFlags().size(); i++) {
        joiner.add(String.format("%sevaluationFlags%s%s=%s", prefix, suffix,
            "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
            URLEncoder.encode(ApiClient.valueToString(getEvaluationFlags().get(i)), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
      }
    }

    // add `evaluationScores` to the URL query string
    if (getEvaluationScores() != null) {
      joiner.add(String.format("%sevaluationScores%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getEvaluationScores()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `ipLocationDetails` to the URL query string
    if (getIpLocationDetails() != null) {
      joiner.add(String.format("%sipLocationDetails%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getIpLocationDetails()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `phoneLocationDetails` to the URL query string
    if (getPhoneLocationDetails() != null) {
      joiner.add(String.format("%sphoneLocationDetails%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getPhoneLocationDetails()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `maskedSSN` to the URL query string
    if (getMaskedSSN() != null) {
      joiner.add(String.format("%smaskedSSN%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getMaskedSSN()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `maskedPassport` to the URL query string
    if (getMaskedPassport() != null) {
      joiner.add(String.format("%smaskedPassport%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getMaskedPassport()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `maskedMatriculaConsular` to the URL query string
    if (getMaskedMatriculaConsular() != null) {
      joiner.add(String.format("%smaskedMatriculaConsular%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getMaskedMatriculaConsular()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `jwtSubject` to the URL query string
    if (getJwtSubject() != null) {
      joiner.add(String.format("%sjwtSubject%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getJwtSubject()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `archived` to the URL query string
    if (getArchived() != null) {
      joiner.add(String.format("%sarchived%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getArchived()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `powerOfAttorneyAgent` to the URL query string
    if (getPowerOfAttorneyAgent() != null) {
      joiner.add(getPowerOfAttorneyAgent().toUrlQueryString(prefix + "powerOfAttorneyAgent" + suffix));
    }

    // add `industry` to the URL query string
    if (getIndustry() != null) {
      joiner.add(String.format("%sindustry%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getIndustry()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `idTheftScore` to the URL query string
    if (getIdTheftScore() != null) {
      joiner.add(String.format("%sidTheftScore%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getIdTheftScore()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `occupation` to the URL query string
    if (getOccupation() != null) {
      joiner.add(String.format("%soccupation%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getOccupation()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `annualIncome` to the URL query string
    if (getAnnualIncome() != null) {
      joiner.add(String.format("%sannualIncome%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getAnnualIncome()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `sourceOfIncome` to the URL query string
    if (getSourceOfIncome() != null) {
      joiner.add(String.format("%ssourceOfIncome%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getSourceOfIncome()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `annualRevenue` to the URL query string
    if (getAnnualRevenue() != null) {
      joiner.add(String.format("%sannualRevenue%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getAnnualRevenue()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `numberOfEmployees` to the URL query string
    if (getNumberOfEmployees() != null) {
      joiner.add(String.format("%snumberOfEmployees%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getNumberOfEmployees()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `businessVertical` to the URL query string
    if (getBusinessVertical() != null) {
      joiner.add(String.format("%sbusinessVertical%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getBusinessVertical()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `website` to the URL query string
    if (getWebsite() != null) {
      joiner.add(String.format("%swebsite%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getWebsite()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    return joiner.toString();
  }
}

