/*
 * Unit OpenAPI specifications
 * An OpenAPI specifications for unit-sdk clients
 *
 * The version of the OpenAPI document: 0.2.2
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package unit.java.sdk.model;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;
import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.LocalDate;
import java.util.Arrays;
import unit.java.sdk.model.MonthlySchedule;
import unit.java.sdk.model.WeeklySchedule;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

import com.fasterxml.jackson.core.type.TypeReference;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import unit.java.sdk.JSON;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.9.0")
@JsonDeserialize(using = Schedule.ScheduleDeserializer.class)
@JsonSerialize(using = Schedule.ScheduleSerializer.class)
public class Schedule extends AbstractOpenApiSchema {
    private static final Logger log = Logger.getLogger(Schedule.class.getName());

    public static class ScheduleSerializer extends StdSerializer<Schedule> {
        public ScheduleSerializer(Class<Schedule> t) {
            super(t);
        }

        public ScheduleSerializer() {
            this(null);
        }

        @Override
        public void serialize(Schedule value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeObject(value.getActualInstance());
        }
    }

    public static class ScheduleDeserializer extends StdDeserializer<Schedule> {
        public ScheduleDeserializer() {
            this(Schedule.class);
        }

        public ScheduleDeserializer(Class<?> vc) {
            super(vc);
        }

        @Override
        public Schedule deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode tree = jp.readValueAsTree();
            Object deserialized = null;
            boolean typeCoercion = ctxt.isEnabled(MapperFeature.ALLOW_COERCION_OF_SCALARS);
            int match = 0;
            JsonToken token = tree.traverse(jp.getCodec()).nextToken();
            // deserialize MonthlySchedule
            try {
                boolean attemptParsing = true;
                // ensure that we respect type coercion as set on the client ObjectMapper
                if (MonthlySchedule.class.equals(Integer.class) || MonthlySchedule.class.equals(Long.class) || MonthlySchedule.class.equals(Float.class) || MonthlySchedule.class.equals(Double.class) || MonthlySchedule.class.equals(Boolean.class) || MonthlySchedule.class.equals(String.class)) {
                    attemptParsing = typeCoercion;
                    if (!attemptParsing) {
                        attemptParsing |= ((MonthlySchedule.class.equals(Integer.class) || MonthlySchedule.class.equals(Long.class)) && token == JsonToken.VALUE_NUMBER_INT);
                        attemptParsing |= ((MonthlySchedule.class.equals(Float.class) || MonthlySchedule.class.equals(Double.class)) && token == JsonToken.VALUE_NUMBER_FLOAT);
                        attemptParsing |= (MonthlySchedule.class.equals(Boolean.class) && (token == JsonToken.VALUE_FALSE || token == JsonToken.VALUE_TRUE));
                        attemptParsing |= (MonthlySchedule.class.equals(String.class) && token == JsonToken.VALUE_STRING);
                    }
                }
                if (attemptParsing) {
                    deserialized = tree.traverse(jp.getCodec()).readValueAs(MonthlySchedule.class);
                    // TODO: there is no validation against JSON schema constraints
                    // (min, max, enum, pattern...), this does not perform a strict JSON
                    // validation, which means the 'match' count may be higher than it should be.
                    match++;
                    log.log(Level.FINER, "Input data matches schema 'MonthlySchedule'");
                }
            } catch (Exception e) {
                // deserialization failed, continue
                log.log(Level.FINER, "Input data does not match schema 'MonthlySchedule'", e);
            }

            // deserialize WeeklySchedule
            try {
                boolean attemptParsing = true;
                // ensure that we respect type coercion as set on the client ObjectMapper
                if (WeeklySchedule.class.equals(Integer.class) || WeeklySchedule.class.equals(Long.class) || WeeklySchedule.class.equals(Float.class) || WeeklySchedule.class.equals(Double.class) || WeeklySchedule.class.equals(Boolean.class) || WeeklySchedule.class.equals(String.class)) {
                    attemptParsing = typeCoercion;
                    if (!attemptParsing) {
                        attemptParsing |= ((WeeklySchedule.class.equals(Integer.class) || WeeklySchedule.class.equals(Long.class)) && token == JsonToken.VALUE_NUMBER_INT);
                        attemptParsing |= ((WeeklySchedule.class.equals(Float.class) || WeeklySchedule.class.equals(Double.class)) && token == JsonToken.VALUE_NUMBER_FLOAT);
                        attemptParsing |= (WeeklySchedule.class.equals(Boolean.class) && (token == JsonToken.VALUE_FALSE || token == JsonToken.VALUE_TRUE));
                        attemptParsing |= (WeeklySchedule.class.equals(String.class) && token == JsonToken.VALUE_STRING);
                    }
                }
                if (attemptParsing) {
                    deserialized = tree.traverse(jp.getCodec()).readValueAs(WeeklySchedule.class);
                    // TODO: there is no validation against JSON schema constraints
                    // (min, max, enum, pattern...), this does not perform a strict JSON
                    // validation, which means the 'match' count may be higher than it should be.
                    match++;
                    log.log(Level.FINER, "Input data matches schema 'WeeklySchedule'");
                }
            } catch (Exception e) {
                // deserialization failed, continue
                log.log(Level.FINER, "Input data does not match schema 'WeeklySchedule'", e);
            }

            if (match == 1) {
                Schedule ret = new Schedule();
                ret.setActualInstance(deserialized);
                return ret;
            }
            throw new IOException(String.format("Failed deserialization for Schedule: %d classes match result, expected 1", match));
        }

        /**
         * Handle deserialization of the 'null' value.
         */
        @Override
        public Schedule getNullValue(DeserializationContext ctxt) throws JsonMappingException {
            throw new JsonMappingException(ctxt.getParser(), "Schedule cannot be null");
        }
    }

    // store a list of schema names defined in oneOf
    public static final Map<String, Class<?>> schemas = new HashMap<>();

    public Schedule() {
        super("oneOf", Boolean.FALSE);
    }

    public Schedule(MonthlySchedule o) {
        super("oneOf", Boolean.FALSE);
        setActualInstance(o);
    }

    public Schedule(WeeklySchedule o) {
        super("oneOf", Boolean.FALSE);
        setActualInstance(o);
    }

    static {
        schemas.put("MonthlySchedule", MonthlySchedule.class);
        schemas.put("WeeklySchedule", WeeklySchedule.class);
        JSON.registerDescendants(Schedule.class, Collections.unmodifiableMap(schemas));
        // Initialize and register the discriminator mappings.
        Map<String, Class<?>> mappings = new HashMap<String, Class<?>>();
        mappings.put("Monthly", MonthlySchedule.class);
        mappings.put("Weekly", WeeklySchedule.class);
        mappings.put("MonthlySchedule", MonthlySchedule.class);
        mappings.put("WeeklySchedule", WeeklySchedule.class);
        mappings.put("Schedule", Schedule.class);
        JSON.registerDiscriminator(Schedule.class, "interval", mappings);
    }

    @Override
    public Map<String, Class<?>> getSchemas() {
        return Schedule.schemas;
    }

    /**
     * Set the instance that matches the oneOf child schema, check
     * the instance parameter is valid against the oneOf child schemas:
     * MonthlySchedule, WeeklySchedule
     *
     * It could be an instance of the 'oneOf' schemas.
     * The oneOf child schemas may themselves be a composed schema (allOf, anyOf, oneOf).
     */
    @Override
    public void setActualInstance(Object instance) {
        if (JSON.isInstanceOf(MonthlySchedule.class, instance, new HashSet<Class<?>>())) {
            super.setActualInstance(instance);
            return;
        }

        if (JSON.isInstanceOf(WeeklySchedule.class, instance, new HashSet<Class<?>>())) {
            super.setActualInstance(instance);
            return;
        }

        throw new RuntimeException("Invalid instance type. Must be MonthlySchedule, WeeklySchedule");
    }

    /**
     * Get the actual instance, which can be the following:
     * MonthlySchedule, WeeklySchedule
     *
     * @return The actual instance (MonthlySchedule, WeeklySchedule)
     */
    @Override
    public Object getActualInstance() {
        return super.getActualInstance();
    }

    /**
     * Get the actual instance of `MonthlySchedule`. If the actual instance is not `MonthlySchedule`,
     * the ClassCastException will be thrown.
     *
     * @return The actual instance of `MonthlySchedule`
     * @throws ClassCastException if the instance is not `MonthlySchedule`
     */
    public MonthlySchedule getMonthlySchedule() throws ClassCastException {
        return (MonthlySchedule)super.getActualInstance();
    }

    /**
     * Get the actual instance of `WeeklySchedule`. If the actual instance is not `WeeklySchedule`,
     * the ClassCastException will be thrown.
     *
     * @return The actual instance of `WeeklySchedule`
     * @throws ClassCastException if the instance is not `WeeklySchedule`
     */
    public WeeklySchedule getWeeklySchedule() throws ClassCastException {
        return (WeeklySchedule)super.getActualInstance();
    }



  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    if (getActualInstance() instanceof WeeklySchedule) {
        if (getActualInstance() != null) {
          joiner.add(((WeeklySchedule)getActualInstance()).toUrlQueryString(prefix + "one_of_0" + suffix));
        }
        return joiner.toString();
    }
    if (getActualInstance() instanceof MonthlySchedule) {
        if (getActualInstance() != null) {
          joiner.add(((MonthlySchedule)getActualInstance()).toUrlQueryString(prefix + "one_of_1" + suffix));
        }
        return joiner.toString();
    }
    return null;
  }

}

