/*
 * Unit OpenAPI specifications
 * An OpenAPI specifications for unit-sdk clients
 *
 * The version of the OpenAPI document: 0.2.3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package unit.java.sdk.api;

import unit.java.sdk.ApiClient;
import unit.java.sdk.ApiException;
import unit.java.sdk.ApiResponse;
import unit.java.sdk.Pair;

import unit.java.sdk.model.AddAccountOwnersRequest;
import unit.java.sdk.model.AddAuthorizedUsersRequest;
import unit.java.sdk.model.ApproveAuthorizationRequest;
import unit.java.sdk.model.ApproveCheckPaymentRequest;
import unit.java.sdk.model.ArchiveCustomerRequest;
import unit.java.sdk.model.AtmLocation;
import unit.java.sdk.model.CancelApplicationRequest;
import unit.java.sdk.model.CloseAccountRequest;
import unit.java.sdk.model.ConfirmCheckDepositRequest;
import unit.java.sdk.model.CreateACHReceivedPaymentTransactionRequest;
import unit.java.sdk.model.CreateAccountRequest;
import unit.java.sdk.model.CreateApiTokenRequest;
import unit.java.sdk.model.CreateApplicationFormRequest;
import unit.java.sdk.model.CreateApplicationRequest;
import unit.java.sdk.model.CreateAtmDepositSimulationRequest;
import unit.java.sdk.model.CreateCardRequest;
import unit.java.sdk.model.CreateCheckDepositRequest;
import unit.java.sdk.model.CreateCheckPaymentRequest;
import unit.java.sdk.model.CreateCounterpartyRequest;
import unit.java.sdk.model.CreateCustomerTokenRequest;
import unit.java.sdk.model.CreateCustomerTokenVerificationRequest;
import unit.java.sdk.model.CreateFeeRequest;
import unit.java.sdk.model.CreateIncomingAchPaymentRequest;
import unit.java.sdk.model.CreatePaymentRequest;
import unit.java.sdk.model.CreateRecurringPaymentRequest;
import unit.java.sdk.model.CreateRecurringRepaymentRequest;
import unit.java.sdk.model.CreateRepaymentRequest;
import unit.java.sdk.model.CreateRewardRequest;
import unit.java.sdk.model.CreateStopPaymentRequest;
import unit.java.sdk.model.CreateWebhookRequest;
import unit.java.sdk.model.DeclineAuthorizationRequest;
import unit.java.sdk.model.DefaultContentType;
import unit.java.sdk.model.Dispute;
import java.io.File;
import unit.java.sdk.model.FreezeAccountRequest;
import unit.java.sdk.model.GenerateBarcodeRequest;
import unit.java.sdk.model.GetAccountBalanceHistoryFilterParameter;
import unit.java.sdk.model.GetAccountsListFilterParameter;
import unit.java.sdk.model.GetApplicationFormsListFilterParameter;
import unit.java.sdk.model.GetApplicationsListFilterParameter;
import unit.java.sdk.model.GetAtmLocationsListFilterParameter;
import unit.java.sdk.model.GetAuthorizationRequestsListFilterParameter;
import unit.java.sdk.model.GetAuthorizationsListFilterParameter;
import unit.java.sdk.model.GetCardsListFilterParameter;
import unit.java.sdk.model.GetCashDepositStoreLocationsListFilterParameter;
import unit.java.sdk.model.GetCheckDepositsListFilterParameter;
import unit.java.sdk.model.GetCheckPaymentsListFilterParameter;
import unit.java.sdk.model.GetCounterpartiesListFilterParameter;
import unit.java.sdk.model.GetCustomersListFilterParameter;
import unit.java.sdk.model.GetDisputesListFilterParameter;
import unit.java.sdk.model.GetEventsListFilterParameter;
import unit.java.sdk.model.GetPaymentsListFilterParameter;
import unit.java.sdk.model.GetReceivedPaymentsListFilterParameter;
import unit.java.sdk.model.GetRecurringPaymentsListFilterParameter;
import unit.java.sdk.model.GetRecurringRepaymentsListFilterParameter;
import unit.java.sdk.model.GetRepaymentsListFilterParameter;
import unit.java.sdk.model.GetRewardsListFilterParameter;
import unit.java.sdk.model.GetStatementsListFilterParameter;
import unit.java.sdk.model.GetStopPaymentsListFilterParameter;
import unit.java.sdk.model.GetTaxFormsListFilterParameter;
import unit.java.sdk.model.GetTransactionsListFilterParameter;
import unit.java.sdk.model.GetWebhooksListFilterParameter;
import unit.java.sdk.model.ListPageParameters;
import unit.java.sdk.model.RemoveAccountOwnersRequest;
import unit.java.sdk.model.RemoveAuthorizedUsersRequest;
import unit.java.sdk.model.ReplaceCardRequest;
import unit.java.sdk.model.ReturnCheckPaymentRequest;
import unit.java.sdk.model.ReturnReceivedACHTransactionRequest;
import unit.java.sdk.model.ReverseFeeRequest;
import unit.java.sdk.model.StopPaymentListResponse;
import unit.java.sdk.model.StopPaymentResponse;
import unit.java.sdk.model.UnitAccountBalanceHistoryResponse;
import unit.java.sdk.model.UnitAccountResponse;
import unit.java.sdk.model.UnitAccountResponseWithIncluded;
import unit.java.sdk.model.UnitAccountsListResponse;
import unit.java.sdk.model.UnitApiTokenResponse;
import unit.java.sdk.model.UnitApplicationFormResponse;
import unit.java.sdk.model.UnitApplicationFormResponseWithIncluded;
import unit.java.sdk.model.UnitApplicationFormsListResponse;
import unit.java.sdk.model.UnitApplicationResponseWithIncluded;
import unit.java.sdk.model.UnitAuthorizationRequestResponse;
import unit.java.sdk.model.UnitAuthorizationRequestsResponse;
import unit.java.sdk.model.UnitAuthorizationResponse;
import unit.java.sdk.model.UnitBackCheckDepositResponse;
import unit.java.sdk.model.UnitBeneficialOwnerResponse;
import unit.java.sdk.model.UnitCancelApplicationResponse;
import unit.java.sdk.model.UnitCardLimitsResponse;
import unit.java.sdk.model.UnitCardResponse;
import unit.java.sdk.model.UnitCardResponseWithIncluded;
import unit.java.sdk.model.UnitCardsListReponse;
import unit.java.sdk.model.UnitCashDepositBarcodeResponse;
import unit.java.sdk.model.UnitCheckDepositResponse;
import unit.java.sdk.model.UnitCheckPaymentResponse;
import unit.java.sdk.model.UnitCounterpartiesListResponse;
import unit.java.sdk.model.UnitCounterpartyBalanceResponse;
import unit.java.sdk.model.UnitCounterpartyResponse;
import unit.java.sdk.model.UnitCreateApplicationResponse;
import unit.java.sdk.model.UnitCustomerResponse;
import unit.java.sdk.model.UnitCustomerTokenResponse;
import unit.java.sdk.model.UnitCustomerTokenVerificationResponse;
import unit.java.sdk.model.UnitCustomersListResponse;
import unit.java.sdk.model.UnitDepositAccountResponse;
import unit.java.sdk.model.UnitDepositProductsResponse;
import unit.java.sdk.model.UnitDisputeResponse;
import unit.java.sdk.model.UnitDocumentResponse;
import unit.java.sdk.model.UnitErrorInner;
import unit.java.sdk.model.UnitEventListResponse;
import unit.java.sdk.model.UnitEventResponse;
import unit.java.sdk.model.UnitFeeResponse;
import unit.java.sdk.model.UnitFeeReversalResponse;
import unit.java.sdk.model.UnitFrontCheckDepositResponse;
import unit.java.sdk.model.UnitGetAccountLimitsResponse;
import unit.java.sdk.model.UnitInstitutionResponse;
import unit.java.sdk.model.UnitListApplicationsResponse;
import unit.java.sdk.model.UnitListAuthorizationRequestsResponse;
import unit.java.sdk.model.UnitListAuthorizationsResponse;
import unit.java.sdk.model.UnitListCheckDepositResponse;
import unit.java.sdk.model.UnitListCheckPaymentsResponse;
import unit.java.sdk.model.UnitListDocumentsResponse;
import unit.java.sdk.model.UnitOrgApiTokensListResponse;
import unit.java.sdk.model.UnitPaymentResponse;
import unit.java.sdk.model.UnitPaymentResponseWithIncluded;
import unit.java.sdk.model.UnitPaymentsListResponse;
import unit.java.sdk.model.UnitPinStatusResponse;
import unit.java.sdk.model.UnitReceivedPaymentListResponse;
import unit.java.sdk.model.UnitReceivedPaymentResponse;
import unit.java.sdk.model.UnitReceivedPaymentResponseWithIncluded;
import unit.java.sdk.model.UnitRecurringPaymentListResponse;
import unit.java.sdk.model.UnitRecurringPaymentResponse;
import unit.java.sdk.model.UnitRecurringRepaymentResponse;
import unit.java.sdk.model.UnitRecurringRepaymentsListResponse;
import unit.java.sdk.model.UnitRepaymentInformationResponse;
import unit.java.sdk.model.UnitRepaymentResponse;
import unit.java.sdk.model.UnitRepaymentsListResponse;
import unit.java.sdk.model.UnitReturnedReceivedAchTransactionResponse;
import unit.java.sdk.model.UnitRewardResponse;
import unit.java.sdk.model.UnitRewardsListResponse;
import unit.java.sdk.model.UnitStatementsResponse;
import unit.java.sdk.model.UnitStoreLocationsListResponse;
import unit.java.sdk.model.UnitTaxFormResponse;
import unit.java.sdk.model.UnitTaxFormsListResponse;
import unit.java.sdk.model.UnitTransactionResponse;
import unit.java.sdk.model.UnitTransactionResponseWithIncludedResource;
import unit.java.sdk.model.UnitTransactionsListResponse;
import unit.java.sdk.model.UnitWebhookResponse;
import unit.java.sdk.model.UnitWebhooksListResponse;
import unit.java.sdk.model.UpdateAccountRequest;
import unit.java.sdk.model.UpdateApplicationRequest;
import unit.java.sdk.model.UpdateBusinessBeneficialOwnerRequest;
import unit.java.sdk.model.UpdateCardRequest;
import unit.java.sdk.model.UpdateCheckDepositRequest;
import unit.java.sdk.model.UpdateCounterpartyRequest;
import unit.java.sdk.model.UpdateCustomerRequest;
import unit.java.sdk.model.UpdatePaymentRequest;
import unit.java.sdk.model.UpdateReceivedPaymentRequest;
import unit.java.sdk.model.UpdateStopPaymentRequest;
import unit.java.sdk.model.UpdateTransactionRequest;
import unit.java.sdk.model.UpdateWebhookRequest;
import unit.java.sdk.model.UploadApplicationDocumentContentType;
import unit.java.sdk.model.VerifyDocument;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;

import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;

import java.io.InputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.http.HttpRequest;
import java.nio.channels.Channels;
import java.nio.channels.Pipe;
import java.nio.charset.StandardCharsets;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;

import java.util.ArrayList;
import java.util.StringJoiner;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.9.0")
public class UnitApi {
  private final HttpClient memberVarHttpClient;
  private final ObjectMapper memberVarObjectMapper;
  private final String memberVarBaseUri;
  private final Consumer<HttpRequest.Builder> memberVarInterceptor;
  private final Duration memberVarReadTimeout;
  private final Consumer<HttpResponse<InputStream>> memberVarResponseInterceptor;
  private final Consumer<HttpResponse<String>> memberVarAsyncResponseInterceptor;

  public UnitApi() {
    this(new ApiClient());
  }

  public UnitApi(ApiClient apiClient) {
    memberVarHttpClient = apiClient.getHttpClient();
    memberVarObjectMapper = apiClient.getObjectMapper();
    memberVarBaseUri = apiClient.getBaseUri();
    memberVarInterceptor = apiClient.getRequestInterceptor();
    memberVarReadTimeout = apiClient.getReadTimeout();
    memberVarResponseInterceptor = apiClient.getResponseInterceptor();
    memberVarAsyncResponseInterceptor = apiClient.getAsyncResponseInterceptor();
  }

  protected ApiException getApiException(String operationId, HttpResponse<InputStream> response) throws IOException {
    String body = response.body() == null ? null : new String(response.body().readAllBytes());
    String message = formatExceptionMessage(operationId, response.statusCode(), body);
    return new ApiException(response.statusCode(), message, response.headers(), body);
  }

  private String formatExceptionMessage(String operationId, int statusCode, String body) {
    if (body == null || body.isEmpty()) {
      body = "[no body]";
    }
    return operationId + " call failed with: " + statusCode + " - " + body;
  }

  /**
   * Create Atm Deposit Simulation
   * Activate Card Simulation via API
   * @param cardId ID of the card to activate (required)
   * @throws ApiException if fails to make API call
   */
  public void activateCardSimulation(String cardId) throws ApiException {
    activateCardSimulationWithHttpInfo(cardId);
  }

  /**
   * Create Atm Deposit Simulation
   * Activate Card Simulation via API
   * @param cardId ID of the card to activate (required)
   * @return ApiResponse&lt;Void&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<Void> activateCardSimulationWithHttpInfo(String cardId) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = activateCardSimulationRequestBuilder(cardId);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("activateCardSimulation", localVarResponse);
        }
        return new ApiResponse<Void>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          null
        );
      } finally {
        // Drain the InputStream
        while (localVarResponse.body().read() != -1) {
            // Ignore
        }
        localVarResponse.body().close();
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder activateCardSimulationRequestBuilder(String cardId) throws ApiException {
    // verify the required parameter 'cardId' is set
    if (cardId == null) {
      throw new ApiException(400, "Missing the required parameter 'cardId' when calling activateCardSimulation");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/sandbox/cards/{cardId}/activate"
        .replace("{cardId}", ApiClient.urlEncode(cardId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Accept", "application/json");

    localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Activate Account Control Agreement by Id
   * Activate Control Agreement for Account via API 
   * @param accountId ID of the account (required)
   * @return UnitAccountResponse
   * @throws ApiException if fails to make API call
   */
  public UnitAccountResponse activateControlAgreementForAccount(String accountId) throws ApiException {
    ApiResponse<UnitAccountResponse> localVarResponse = activateControlAgreementForAccountWithHttpInfo(accountId);
    return localVarResponse.getData();
  }

  /**
   * Activate Account Control Agreement by Id
   * Activate Control Agreement for Account via API 
   * @param accountId ID of the account (required)
   * @return ApiResponse&lt;UnitAccountResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitAccountResponse> activateControlAgreementForAccountWithHttpInfo(String accountId) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = activateControlAgreementForAccountRequestBuilder(accountId);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("activateControlAgreementForAccount", localVarResponse);
        }
        return new ApiResponse<UnitAccountResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitAccountResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder activateControlAgreementForAccountRequestBuilder(String accountId) throws ApiException {
    // verify the required parameter 'accountId' is set
    if (accountId == null) {
      throw new ApiException(400, "Missing the required parameter 'accountId' when calling activateControlAgreementForAccount");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/accounts/{accountId}/activate-daca"
        .replace("{accountId}", ApiClient.urlEncode(accountId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Add Owners to Account by Id
   * Add Owners to Account via API 
   * @param accountId ID of the account to add owners to (required)
   * @param addAccountOwnersRequest Add Account Owners Request (required)
   * @return UnitDepositAccountResponse
   * @throws ApiException if fails to make API call
   */
  public UnitDepositAccountResponse addAccountOwners(String accountId, AddAccountOwnersRequest addAccountOwnersRequest) throws ApiException {
    ApiResponse<UnitDepositAccountResponse> localVarResponse = addAccountOwnersWithHttpInfo(accountId, addAccountOwnersRequest);
    return localVarResponse.getData();
  }

  /**
   * Add Owners to Account by Id
   * Add Owners to Account via API 
   * @param accountId ID of the account to add owners to (required)
   * @param addAccountOwnersRequest Add Account Owners Request (required)
   * @return ApiResponse&lt;UnitDepositAccountResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitDepositAccountResponse> addAccountOwnersWithHttpInfo(String accountId, AddAccountOwnersRequest addAccountOwnersRequest) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = addAccountOwnersRequestBuilder(accountId, addAccountOwnersRequest);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("addAccountOwners", localVarResponse);
        }
        return new ApiResponse<UnitDepositAccountResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitDepositAccountResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder addAccountOwnersRequestBuilder(String accountId, AddAccountOwnersRequest addAccountOwnersRequest) throws ApiException {
    // verify the required parameter 'accountId' is set
    if (accountId == null) {
      throw new ApiException(400, "Missing the required parameter 'accountId' when calling addAccountOwners");
    }
    // verify the required parameter 'addAccountOwnersRequest' is set
    if (addAccountOwnersRequest == null) {
      throw new ApiException(400, "Missing the required parameter 'addAccountOwnersRequest' when calling addAccountOwners");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/accounts/{accountId}/relationships/customers"
        .replace("{accountId}", ApiClient.urlEncode(accountId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Content-Type", "application/vnd.api+json");
    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(addAccountOwnersRequest);
      localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
    } catch (IOException e) {
      throw new ApiException(e);
    }
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Add Authorized Users by Id
   * Add Authorized Users via API
   * @param customerId ID of the customer to add authorized users to (required)
   * @param addAuthorizedUsersRequest Add Authorized Users Request (required)
   * @return UnitCustomerResponse
   * @throws ApiException if fails to make API call
   */
  public UnitCustomerResponse addAuthorizedUsers(String customerId, AddAuthorizedUsersRequest addAuthorizedUsersRequest) throws ApiException {
    ApiResponse<UnitCustomerResponse> localVarResponse = addAuthorizedUsersWithHttpInfo(customerId, addAuthorizedUsersRequest);
    return localVarResponse.getData();
  }

  /**
   * Add Authorized Users by Id
   * Add Authorized Users via API
   * @param customerId ID of the customer to add authorized users to (required)
   * @param addAuthorizedUsersRequest Add Authorized Users Request (required)
   * @return ApiResponse&lt;UnitCustomerResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitCustomerResponse> addAuthorizedUsersWithHttpInfo(String customerId, AddAuthorizedUsersRequest addAuthorizedUsersRequest) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = addAuthorizedUsersRequestBuilder(customerId, addAuthorizedUsersRequest);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("addAuthorizedUsers", localVarResponse);
        }
        return new ApiResponse<UnitCustomerResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitCustomerResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder addAuthorizedUsersRequestBuilder(String customerId, AddAuthorizedUsersRequest addAuthorizedUsersRequest) throws ApiException {
    // verify the required parameter 'customerId' is set
    if (customerId == null) {
      throw new ApiException(400, "Missing the required parameter 'customerId' when calling addAuthorizedUsers");
    }
    // verify the required parameter 'addAuthorizedUsersRequest' is set
    if (addAuthorizedUsersRequest == null) {
      throw new ApiException(400, "Missing the required parameter 'addAuthorizedUsersRequest' when calling addAuthorizedUsers");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/customers/{customerId}/authorized-users"
        .replace("{customerId}", ApiClient.urlEncode(customerId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Content-Type", "application/vnd.api+json");
    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(addAuthorizedUsersRequest);
      localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
    } catch (IOException e) {
      throw new ApiException(e);
    }
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Advance Received Payment by Id
   * Advance a Received Payment via API 
   * @param paymentId ID of the payment to advance (required)
   * @return UnitReceivedPaymentResponse
   * @throws ApiException if fails to make API call
   */
  public UnitReceivedPaymentResponse advanceReceivedPayment(String paymentId) throws ApiException {
    ApiResponse<UnitReceivedPaymentResponse> localVarResponse = advanceReceivedPaymentWithHttpInfo(paymentId);
    return localVarResponse.getData();
  }

  /**
   * Advance Received Payment by Id
   * Advance a Received Payment via API 
   * @param paymentId ID of the payment to advance (required)
   * @return ApiResponse&lt;UnitReceivedPaymentResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitReceivedPaymentResponse> advanceReceivedPaymentWithHttpInfo(String paymentId) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = advanceReceivedPaymentRequestBuilder(paymentId);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("advanceReceivedPayment", localVarResponse);
        }
        return new ApiResponse<UnitReceivedPaymentResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitReceivedPaymentResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder advanceReceivedPaymentRequestBuilder(String paymentId) throws ApiException {
    // verify the required parameter 'paymentId' is set
    if (paymentId == null) {
      throw new ApiException(400, "Missing the required parameter 'paymentId' when calling advanceReceivedPayment");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/received-payments/{paymentId}/advance"
        .replace("{paymentId}", ApiClient.urlEncode(paymentId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Approve Authorization Request by Id
   * Approve a Authorization Request via API 
   * @param authorizationId ID of the authorization request to approve (required)
   * @param approveAuthorizationRequest Approve Authorization Request (required)
   * @return UnitAuthorizationRequestResponse
   * @throws ApiException if fails to make API call
   */
  public UnitAuthorizationRequestResponse approveAuthorizationRequest(String authorizationId, ApproveAuthorizationRequest approveAuthorizationRequest) throws ApiException {
    ApiResponse<UnitAuthorizationRequestResponse> localVarResponse = approveAuthorizationRequestWithHttpInfo(authorizationId, approveAuthorizationRequest);
    return localVarResponse.getData();
  }

  /**
   * Approve Authorization Request by Id
   * Approve a Authorization Request via API 
   * @param authorizationId ID of the authorization request to approve (required)
   * @param approveAuthorizationRequest Approve Authorization Request (required)
   * @return ApiResponse&lt;UnitAuthorizationRequestResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitAuthorizationRequestResponse> approveAuthorizationRequestWithHttpInfo(String authorizationId, ApproveAuthorizationRequest approveAuthorizationRequest) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = approveAuthorizationRequestRequestBuilder(authorizationId, approveAuthorizationRequest);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("approveAuthorizationRequest", localVarResponse);
        }
        return new ApiResponse<UnitAuthorizationRequestResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitAuthorizationRequestResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder approveAuthorizationRequestRequestBuilder(String authorizationId, ApproveAuthorizationRequest approveAuthorizationRequest) throws ApiException {
    // verify the required parameter 'authorizationId' is set
    if (authorizationId == null) {
      throw new ApiException(400, "Missing the required parameter 'authorizationId' when calling approveAuthorizationRequest");
    }
    // verify the required parameter 'approveAuthorizationRequest' is set
    if (approveAuthorizationRequest == null) {
      throw new ApiException(400, "Missing the required parameter 'approveAuthorizationRequest' when calling approveAuthorizationRequest");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/authorization-requests/{authorizationId}/approve"
        .replace("{authorizationId}", ApiClient.urlEncode(authorizationId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Content-Type", "application/vnd.api+json");
    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(approveAuthorizationRequest);
      localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
    } catch (IOException e) {
      throw new ApiException(e);
    }
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Approve Check Payment by Id
   * Approve a Check Payment via API 
   * @param checkPaymentId ID of the check payment to approve (required)
   * @param approveCheckPaymentRequest Approve Check Payment Request (required)
   * @return UnitCheckPaymentResponse
   * @throws ApiException if fails to make API call
   */
  public UnitCheckPaymentResponse approveCheckPayment(String checkPaymentId, ApproveCheckPaymentRequest approveCheckPaymentRequest) throws ApiException {
    ApiResponse<UnitCheckPaymentResponse> localVarResponse = approveCheckPaymentWithHttpInfo(checkPaymentId, approveCheckPaymentRequest);
    return localVarResponse.getData();
  }

  /**
   * Approve Check Payment by Id
   * Approve a Check Payment via API 
   * @param checkPaymentId ID of the check payment to approve (required)
   * @param approveCheckPaymentRequest Approve Check Payment Request (required)
   * @return ApiResponse&lt;UnitCheckPaymentResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitCheckPaymentResponse> approveCheckPaymentWithHttpInfo(String checkPaymentId, ApproveCheckPaymentRequest approveCheckPaymentRequest) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = approveCheckPaymentRequestBuilder(checkPaymentId, approveCheckPaymentRequest);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("approveCheckPayment", localVarResponse);
        }
        return new ApiResponse<UnitCheckPaymentResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitCheckPaymentResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder approveCheckPaymentRequestBuilder(String checkPaymentId, ApproveCheckPaymentRequest approveCheckPaymentRequest) throws ApiException {
    // verify the required parameter 'checkPaymentId' is set
    if (checkPaymentId == null) {
      throw new ApiException(400, "Missing the required parameter 'checkPaymentId' when calling approveCheckPayment");
    }
    // verify the required parameter 'approveCheckPaymentRequest' is set
    if (approveCheckPaymentRequest == null) {
      throw new ApiException(400, "Missing the required parameter 'approveCheckPaymentRequest' when calling approveCheckPayment");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/check-payments/{checkPaymentId}/approve"
        .replace("{checkPaymentId}", ApiClient.urlEncode(checkPaymentId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Content-Type", "application/vnd.api+json");
    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(approveCheckPaymentRequest);
      localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
    } catch (IOException e) {
      throw new ApiException(e);
    }
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Archive Customer by Id
   * Archive a Customer via API 
   * @param customerId ID of the customer to archive (required)
   * @param archiveCustomerRequest Archive Customer Request (required)
   * @return UnitCustomerResponse
   * @throws ApiException if fails to make API call
   */
  public UnitCustomerResponse archiveCustomer(String customerId, ArchiveCustomerRequest archiveCustomerRequest) throws ApiException {
    ApiResponse<UnitCustomerResponse> localVarResponse = archiveCustomerWithHttpInfo(customerId, archiveCustomerRequest);
    return localVarResponse.getData();
  }

  /**
   * Archive Customer by Id
   * Archive a Customer via API 
   * @param customerId ID of the customer to archive (required)
   * @param archiveCustomerRequest Archive Customer Request (required)
   * @return ApiResponse&lt;UnitCustomerResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitCustomerResponse> archiveCustomerWithHttpInfo(String customerId, ArchiveCustomerRequest archiveCustomerRequest) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = archiveCustomerRequestBuilder(customerId, archiveCustomerRequest);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("archiveCustomer", localVarResponse);
        }
        return new ApiResponse<UnitCustomerResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitCustomerResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder archiveCustomerRequestBuilder(String customerId, ArchiveCustomerRequest archiveCustomerRequest) throws ApiException {
    // verify the required parameter 'customerId' is set
    if (customerId == null) {
      throw new ApiException(400, "Missing the required parameter 'customerId' when calling archiveCustomer");
    }
    // verify the required parameter 'archiveCustomerRequest' is set
    if (archiveCustomerRequest == null) {
      throw new ApiException(400, "Missing the required parameter 'archiveCustomerRequest' when calling archiveCustomer");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/customers/{customerId}/archive"
        .replace("{customerId}", ApiClient.urlEncode(customerId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Content-Type", "application/vnd.api+json");
    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(archiveCustomerRequest);
      localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
    } catch (IOException e) {
      throw new ApiException(e);
    }
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Cancel Application by Id
   * Cancel a Application via API 
   * @param applicationId ID of the application to get (required)
   * @param cancelApplicationRequest Cancel Application Request (required)
   * @return UnitCancelApplicationResponse
   * @throws ApiException if fails to make API call
   */
  public UnitCancelApplicationResponse cancelApplication(String applicationId, CancelApplicationRequest cancelApplicationRequest) throws ApiException {
    ApiResponse<UnitCancelApplicationResponse> localVarResponse = cancelApplicationWithHttpInfo(applicationId, cancelApplicationRequest);
    return localVarResponse.getData();
  }

  /**
   * Cancel Application by Id
   * Cancel a Application via API 
   * @param applicationId ID of the application to get (required)
   * @param cancelApplicationRequest Cancel Application Request (required)
   * @return ApiResponse&lt;UnitCancelApplicationResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitCancelApplicationResponse> cancelApplicationWithHttpInfo(String applicationId, CancelApplicationRequest cancelApplicationRequest) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = cancelApplicationRequestBuilder(applicationId, cancelApplicationRequest);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("cancelApplication", localVarResponse);
        }
        return new ApiResponse<UnitCancelApplicationResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitCancelApplicationResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder cancelApplicationRequestBuilder(String applicationId, CancelApplicationRequest cancelApplicationRequest) throws ApiException {
    // verify the required parameter 'applicationId' is set
    if (applicationId == null) {
      throw new ApiException(400, "Missing the required parameter 'applicationId' when calling cancelApplication");
    }
    // verify the required parameter 'cancelApplicationRequest' is set
    if (cancelApplicationRequest == null) {
      throw new ApiException(400, "Missing the required parameter 'cancelApplicationRequest' when calling cancelApplication");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/applications/{applicationId}/cancel"
        .replace("{applicationId}", ApiClient.urlEncode(applicationId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Content-Type", "application/vnd.api+json");
    localVarRequestBuilder.header("Accept", "application/vnd.api+json");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(cancelApplicationRequest);
      localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
    } catch (IOException e) {
      throw new ApiException(e);
    }
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Cancel Check Payment by Id
   * Cancel a Check Payment via API 
   * @param checkPaymentId ID of the check payment to cancel (required)
   * @return UnitCheckPaymentResponse
   * @throws ApiException if fails to make API call
   */
  public UnitCheckPaymentResponse cancelCheckPayment(String checkPaymentId) throws ApiException {
    ApiResponse<UnitCheckPaymentResponse> localVarResponse = cancelCheckPaymentWithHttpInfo(checkPaymentId);
    return localVarResponse.getData();
  }

  /**
   * Cancel Check Payment by Id
   * Cancel a Check Payment via API 
   * @param checkPaymentId ID of the check payment to cancel (required)
   * @return ApiResponse&lt;UnitCheckPaymentResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitCheckPaymentResponse> cancelCheckPaymentWithHttpInfo(String checkPaymentId) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = cancelCheckPaymentRequestBuilder(checkPaymentId);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("cancelCheckPayment", localVarResponse);
        }
        return new ApiResponse<UnitCheckPaymentResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitCheckPaymentResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder cancelCheckPaymentRequestBuilder(String checkPaymentId) throws ApiException {
    // verify the required parameter 'checkPaymentId' is set
    if (checkPaymentId == null) {
      throw new ApiException(400, "Missing the required parameter 'checkPaymentId' when calling cancelCheckPayment");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/check-payments/{checkPaymentId}/cancel"
        .replace("{checkPaymentId}", ApiClient.urlEncode(checkPaymentId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Cancel a Payment by Id
   * Cancel a Payment via API 
   * @param paymentId ID of the payment to cancel (required)
   * @param body Pass empty object in order for content-type to be aquired correctly (required)
   * @return UnitPaymentResponse
   * @throws ApiException if fails to make API call
   */
  public UnitPaymentResponse cancelPayment(String paymentId, Object body) throws ApiException {
    ApiResponse<UnitPaymentResponse> localVarResponse = cancelPaymentWithHttpInfo(paymentId, body);
    return localVarResponse.getData();
  }

  /**
   * Cancel a Payment by Id
   * Cancel a Payment via API 
   * @param paymentId ID of the payment to cancel (required)
   * @param body Pass empty object in order for content-type to be aquired correctly (required)
   * @return ApiResponse&lt;UnitPaymentResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitPaymentResponse> cancelPaymentWithHttpInfo(String paymentId, Object body) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = cancelPaymentRequestBuilder(paymentId, body);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("cancelPayment", localVarResponse);
        }
        return new ApiResponse<UnitPaymentResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitPaymentResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder cancelPaymentRequestBuilder(String paymentId, Object body) throws ApiException {
    // verify the required parameter 'paymentId' is set
    if (paymentId == null) {
      throw new ApiException(400, "Missing the required parameter 'paymentId' when calling cancelPayment");
    }
    // verify the required parameter 'body' is set
    if (body == null) {
      throw new ApiException(400, "Missing the required parameter 'body' when calling cancelPayment");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/payments/{paymentId}/cancel"
        .replace("{paymentId}", ApiClient.urlEncode(paymentId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Content-Type", "application/vnd.api+json");
    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(body);
      localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
    } catch (IOException e) {
      throw new ApiException(e);
    }
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Close an Account by Id
   * Close an Account via API 
   * @param accountId ID of the account to close (required)
   * @param closeAccountRequest Close Account Request (required)
   * @return UnitAccountResponse
   * @throws ApiException if fails to make API call
   */
  public UnitAccountResponse closeAccount(String accountId, CloseAccountRequest closeAccountRequest) throws ApiException {
    ApiResponse<UnitAccountResponse> localVarResponse = closeAccountWithHttpInfo(accountId, closeAccountRequest);
    return localVarResponse.getData();
  }

  /**
   * Close an Account by Id
   * Close an Account via API 
   * @param accountId ID of the account to close (required)
   * @param closeAccountRequest Close Account Request (required)
   * @return ApiResponse&lt;UnitAccountResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitAccountResponse> closeAccountWithHttpInfo(String accountId, CloseAccountRequest closeAccountRequest) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = closeAccountRequestBuilder(accountId, closeAccountRequest);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("closeAccount", localVarResponse);
        }
        return new ApiResponse<UnitAccountResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitAccountResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder closeAccountRequestBuilder(String accountId, CloseAccountRequest closeAccountRequest) throws ApiException {
    // verify the required parameter 'accountId' is set
    if (accountId == null) {
      throw new ApiException(400, "Missing the required parameter 'accountId' when calling closeAccount");
    }
    // verify the required parameter 'closeAccountRequest' is set
    if (closeAccountRequest == null) {
      throw new ApiException(400, "Missing the required parameter 'closeAccountRequest' when calling closeAccount");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/accounts/{accountId}/close"
        .replace("{accountId}", ApiClient.urlEncode(accountId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Content-Type", "application/vnd.api+json");
    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(closeAccountRequest);
      localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
    } catch (IOException e) {
      throw new ApiException(e);
    }
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Close a Card
   * Close a Card via API 
   * @param cardId ID of the card to close (required)
   * @return UnitCardResponse
   * @throws ApiException if fails to make API call
   */
  public UnitCardResponse closeCard(String cardId) throws ApiException {
    ApiResponse<UnitCardResponse> localVarResponse = closeCardWithHttpInfo(cardId);
    return localVarResponse.getData();
  }

  /**
   * Close a Card
   * Close a Card via API 
   * @param cardId ID of the card to close (required)
   * @return ApiResponse&lt;UnitCardResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitCardResponse> closeCardWithHttpInfo(String cardId) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = closeCardRequestBuilder(cardId);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("closeCard", localVarResponse);
        }
        return new ApiResponse<UnitCardResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitCardResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder closeCardRequestBuilder(String cardId) throws ApiException {
    // verify the required parameter 'cardId' is set
    if (cardId == null) {
      throw new ApiException(400, "Missing the required parameter 'cardId' when calling closeCard");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/cards/{cardId}/close"
        .replace("{cardId}", ApiClient.urlEncode(cardId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Confirm by Id
   * Confirm a Check Deposit from API 
   * @param checkDepositId ID of the check deposit to confirm (required)
   * @param confirmCheckDepositRequest  (required)
   * @return UnitCheckDepositResponse
   * @throws ApiException if fails to make API call
   */
  public UnitCheckDepositResponse confirmCheckDeposit(String checkDepositId, ConfirmCheckDepositRequest confirmCheckDepositRequest) throws ApiException {
    ApiResponse<UnitCheckDepositResponse> localVarResponse = confirmCheckDepositWithHttpInfo(checkDepositId, confirmCheckDepositRequest);
    return localVarResponse.getData();
  }

  /**
   * Confirm by Id
   * Confirm a Check Deposit from API 
   * @param checkDepositId ID of the check deposit to confirm (required)
   * @param confirmCheckDepositRequest  (required)
   * @return ApiResponse&lt;UnitCheckDepositResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitCheckDepositResponse> confirmCheckDepositWithHttpInfo(String checkDepositId, ConfirmCheckDepositRequest confirmCheckDepositRequest) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = confirmCheckDepositRequestBuilder(checkDepositId, confirmCheckDepositRequest);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("confirmCheckDeposit", localVarResponse);
        }
        return new ApiResponse<UnitCheckDepositResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitCheckDepositResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder confirmCheckDepositRequestBuilder(String checkDepositId, ConfirmCheckDepositRequest confirmCheckDepositRequest) throws ApiException {
    // verify the required parameter 'checkDepositId' is set
    if (checkDepositId == null) {
      throw new ApiException(400, "Missing the required parameter 'checkDepositId' when calling confirmCheckDeposit");
    }
    // verify the required parameter 'confirmCheckDepositRequest' is set
    if (confirmCheckDepositRequest == null) {
      throw new ApiException(400, "Missing the required parameter 'confirmCheckDepositRequest' when calling confirmCheckDeposit");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/check-deposits/{checkDepositId}/confirm"
        .replace("{checkDepositId}", ApiClient.urlEncode(checkDepositId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Content-Type", "application/vnd.api+json");
    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(confirmCheckDepositRequest);
      localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
    } catch (IOException e) {
      throw new ApiException(e);
    }
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Create ACH Received Payment Transaction Simulation
   * Create ACH Received Payment Transaction Simulation via API 
   * @param createACHReceivedPaymentTransactionRequest Create ACH Received Payment Transaction Simulation Request (required)
   * @return UnitReceivedPaymentResponse
   * @throws ApiException if fails to make API call
   */
  public UnitReceivedPaymentResponse createACHReceivedPaymentTransactionSimulation(CreateACHReceivedPaymentTransactionRequest createACHReceivedPaymentTransactionRequest) throws ApiException {
    ApiResponse<UnitReceivedPaymentResponse> localVarResponse = createACHReceivedPaymentTransactionSimulationWithHttpInfo(createACHReceivedPaymentTransactionRequest);
    return localVarResponse.getData();
  }

  /**
   * Create ACH Received Payment Transaction Simulation
   * Create ACH Received Payment Transaction Simulation via API 
   * @param createACHReceivedPaymentTransactionRequest Create ACH Received Payment Transaction Simulation Request (required)
   * @return ApiResponse&lt;UnitReceivedPaymentResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitReceivedPaymentResponse> createACHReceivedPaymentTransactionSimulationWithHttpInfo(CreateACHReceivedPaymentTransactionRequest createACHReceivedPaymentTransactionRequest) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = createACHReceivedPaymentTransactionSimulationRequestBuilder(createACHReceivedPaymentTransactionRequest);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("createACHReceivedPaymentTransactionSimulation", localVarResponse);
        }
        return new ApiResponse<UnitReceivedPaymentResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitReceivedPaymentResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder createACHReceivedPaymentTransactionSimulationRequestBuilder(CreateACHReceivedPaymentTransactionRequest createACHReceivedPaymentTransactionRequest) throws ApiException {
    // verify the required parameter 'createACHReceivedPaymentTransactionRequest' is set
    if (createACHReceivedPaymentTransactionRequest == null) {
      throw new ApiException(400, "Missing the required parameter 'createACHReceivedPaymentTransactionRequest' when calling createACHReceivedPaymentTransactionSimulation");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/sandbox/received-payments";

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Content-Type", "application/vnd.api+json");
    localVarRequestBuilder.header("Accept", "application/vnd.api+json");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(createACHReceivedPaymentTransactionRequest);
      localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
    } catch (IOException e) {
      throw new ApiException(e);
    }
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Create Account
   * Create Account via API 
   * @param createAccountRequest Create Account Request (required)
   * @return UnitAccountResponse
   * @throws ApiException if fails to make API call
   */
  public UnitAccountResponse createAccount(CreateAccountRequest createAccountRequest) throws ApiException {
    ApiResponse<UnitAccountResponse> localVarResponse = createAccountWithHttpInfo(createAccountRequest);
    return localVarResponse.getData();
  }

  /**
   * Create Account
   * Create Account via API 
   * @param createAccountRequest Create Account Request (required)
   * @return ApiResponse&lt;UnitAccountResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitAccountResponse> createAccountWithHttpInfo(CreateAccountRequest createAccountRequest) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = createAccountRequestBuilder(createAccountRequest);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("createAccount", localVarResponse);
        }
        return new ApiResponse<UnitAccountResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitAccountResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder createAccountRequestBuilder(CreateAccountRequest createAccountRequest) throws ApiException {
    // verify the required parameter 'createAccountRequest' is set
    if (createAccountRequest == null) {
      throw new ApiException(400, "Missing the required parameter 'createAccountRequest' when calling createAccount");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/accounts";

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Content-Type", "application/vnd.api+json");
    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(createAccountRequest);
      localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
    } catch (IOException e) {
      throw new ApiException(e);
    }
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Create Org API Token
   * Create an Org API Token via API 
   * @param userId ID of the user to create token for (required)
   * @param createApiTokenRequest Create Org API Token Request (required)
   * @return UnitApiTokenResponse
   * @throws ApiException if fails to make API call
   */
  public UnitApiTokenResponse createApiToken(String userId, CreateApiTokenRequest createApiTokenRequest) throws ApiException {
    ApiResponse<UnitApiTokenResponse> localVarResponse = createApiTokenWithHttpInfo(userId, createApiTokenRequest);
    return localVarResponse.getData();
  }

  /**
   * Create Org API Token
   * Create an Org API Token via API 
   * @param userId ID of the user to create token for (required)
   * @param createApiTokenRequest Create Org API Token Request (required)
   * @return ApiResponse&lt;UnitApiTokenResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitApiTokenResponse> createApiTokenWithHttpInfo(String userId, CreateApiTokenRequest createApiTokenRequest) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = createApiTokenRequestBuilder(userId, createApiTokenRequest);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("createApiToken", localVarResponse);
        }
        return new ApiResponse<UnitApiTokenResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitApiTokenResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder createApiTokenRequestBuilder(String userId, CreateApiTokenRequest createApiTokenRequest) throws ApiException {
    // verify the required parameter 'userId' is set
    if (userId == null) {
      throw new ApiException(400, "Missing the required parameter 'userId' when calling createApiToken");
    }
    // verify the required parameter 'createApiTokenRequest' is set
    if (createApiTokenRequest == null) {
      throw new ApiException(400, "Missing the required parameter 'createApiTokenRequest' when calling createApiToken");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/users/{userId}/api-tokens"
        .replace("{userId}", ApiClient.urlEncode(userId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Content-Type", "application/vnd.api+json");
    localVarRequestBuilder.header("Accept", "application/vnd.api+json");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(createApiTokenRequest);
      localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
    } catch (IOException e) {
      throw new ApiException(e);
    }
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Create Application
   * Create an Application via API 
   * @param createApplicationRequest Create Application Request (required)
   * @return UnitCreateApplicationResponse
   * @throws ApiException if fails to make API call
   */
  public UnitCreateApplicationResponse createApplication(CreateApplicationRequest createApplicationRequest) throws ApiException {
    ApiResponse<UnitCreateApplicationResponse> localVarResponse = createApplicationWithHttpInfo(createApplicationRequest);
    return localVarResponse.getData();
  }

  /**
   * Create Application
   * Create an Application via API 
   * @param createApplicationRequest Create Application Request (required)
   * @return ApiResponse&lt;UnitCreateApplicationResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitCreateApplicationResponse> createApplicationWithHttpInfo(CreateApplicationRequest createApplicationRequest) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = createApplicationRequestBuilder(createApplicationRequest);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("createApplication", localVarResponse);
        }
        return new ApiResponse<UnitCreateApplicationResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitCreateApplicationResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder createApplicationRequestBuilder(CreateApplicationRequest createApplicationRequest) throws ApiException {
    // verify the required parameter 'createApplicationRequest' is set
    if (createApplicationRequest == null) {
      throw new ApiException(400, "Missing the required parameter 'createApplicationRequest' when calling createApplication");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/applications";

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Content-Type", "application/vnd.api+json");
    localVarRequestBuilder.header("Accept", "application/vnd.api+json");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(createApplicationRequest);
      localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
    } catch (IOException e) {
      throw new ApiException(e);
    }
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Create an application document
   * Create an application document via API
   * @param applicationId ID of the application to create a file for (required)
   * @param contentType A workaround to properly assign the content type for the request body while providing no body, just set the one possible enum value (required)
   * @return UnitDocumentResponse
   * @throws ApiException if fails to make API call
   */
  public UnitDocumentResponse createApplicationDocument(String applicationId, DefaultContentType contentType) throws ApiException {
    ApiResponse<UnitDocumentResponse> localVarResponse = createApplicationDocumentWithHttpInfo(applicationId, contentType);
    return localVarResponse.getData();
  }

  /**
   * Create an application document
   * Create an application document via API
   * @param applicationId ID of the application to create a file for (required)
   * @param contentType A workaround to properly assign the content type for the request body while providing no body, just set the one possible enum value (required)
   * @return ApiResponse&lt;UnitDocumentResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitDocumentResponse> createApplicationDocumentWithHttpInfo(String applicationId, DefaultContentType contentType) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = createApplicationDocumentRequestBuilder(applicationId, contentType);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("createApplicationDocument", localVarResponse);
        }
        return new ApiResponse<UnitDocumentResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitDocumentResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder createApplicationDocumentRequestBuilder(String applicationId, DefaultContentType contentType) throws ApiException {
    // verify the required parameter 'applicationId' is set
    if (applicationId == null) {
      throw new ApiException(400, "Missing the required parameter 'applicationId' when calling createApplicationDocument");
    }
    // verify the required parameter 'contentType' is set
    if (contentType == null) {
      throw new ApiException(400, "Missing the required parameter 'contentType' when calling createApplicationDocument");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/applications/{applicationId}/documents"
        .replace("{applicationId}", ApiClient.urlEncode(applicationId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    if (contentType != null) {
      localVarRequestBuilder.header("Content-Type", contentType.toString());
    }
    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Create Application Form
   * Create an Application Form via API 
   * @param createApplicationFormRequest Create Application Form Request (required)
   * @return UnitApplicationFormResponse
   * @throws ApiException if fails to make API call
   */
  public UnitApplicationFormResponse createApplicationForm(CreateApplicationFormRequest createApplicationFormRequest) throws ApiException {
    ApiResponse<UnitApplicationFormResponse> localVarResponse = createApplicationFormWithHttpInfo(createApplicationFormRequest);
    return localVarResponse.getData();
  }

  /**
   * Create Application Form
   * Create an Application Form via API 
   * @param createApplicationFormRequest Create Application Form Request (required)
   * @return ApiResponse&lt;UnitApplicationFormResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitApplicationFormResponse> createApplicationFormWithHttpInfo(CreateApplicationFormRequest createApplicationFormRequest) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = createApplicationFormRequestBuilder(createApplicationFormRequest);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("createApplicationForm", localVarResponse);
        }
        return new ApiResponse<UnitApplicationFormResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitApplicationFormResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder createApplicationFormRequestBuilder(CreateApplicationFormRequest createApplicationFormRequest) throws ApiException {
    // verify the required parameter 'createApplicationFormRequest' is set
    if (createApplicationFormRequest == null) {
      throw new ApiException(400, "Missing the required parameter 'createApplicationFormRequest' when calling createApplicationForm");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/application-forms";

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Content-Type", "application/vnd.api+json");
    localVarRequestBuilder.header("Accept", "application/vnd.api+json");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(createApplicationFormRequest);
      localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
    } catch (IOException e) {
      throw new ApiException(e);
    }
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Create Atm Deposit Simulation
   * Create Atm Deposit Simulation via API 
   * @param createAtmDepositSimulationRequest Create Atm Deposit Simulation Request (required)
   * @return UnitDepositAccountResponse
   * @throws ApiException if fails to make API call
   */
  public UnitDepositAccountResponse createAtmDepositSimulation(CreateAtmDepositSimulationRequest createAtmDepositSimulationRequest) throws ApiException {
    ApiResponse<UnitDepositAccountResponse> localVarResponse = createAtmDepositSimulationWithHttpInfo(createAtmDepositSimulationRequest);
    return localVarResponse.getData();
  }

  /**
   * Create Atm Deposit Simulation
   * Create Atm Deposit Simulation via API 
   * @param createAtmDepositSimulationRequest Create Atm Deposit Simulation Request (required)
   * @return ApiResponse&lt;UnitDepositAccountResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitDepositAccountResponse> createAtmDepositSimulationWithHttpInfo(CreateAtmDepositSimulationRequest createAtmDepositSimulationRequest) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = createAtmDepositSimulationRequestBuilder(createAtmDepositSimulationRequest);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("createAtmDepositSimulation", localVarResponse);
        }
        return new ApiResponse<UnitDepositAccountResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitDepositAccountResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder createAtmDepositSimulationRequestBuilder(CreateAtmDepositSimulationRequest createAtmDepositSimulationRequest) throws ApiException {
    // verify the required parameter 'createAtmDepositSimulationRequest' is set
    if (createAtmDepositSimulationRequest == null) {
      throw new ApiException(400, "Missing the required parameter 'createAtmDepositSimulationRequest' when calling createAtmDepositSimulation");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/sandbox/atm-deposits";

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Content-Type", "application/vnd.api+json");
    localVarRequestBuilder.header("Accept", "application/vnd.api+json");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(createAtmDepositSimulationRequest);
      localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
    } catch (IOException e) {
      throw new ApiException(e);
    }
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Create a Card
   * Create a Card via API 
   * @param createCardRequest Create Card Request (required)
   * @return UnitCardResponse
   * @throws ApiException if fails to make API call
   */
  public UnitCardResponse createCard(CreateCardRequest createCardRequest) throws ApiException {
    ApiResponse<UnitCardResponse> localVarResponse = createCardWithHttpInfo(createCardRequest);
    return localVarResponse.getData();
  }

  /**
   * Create a Card
   * Create a Card via API 
   * @param createCardRequest Create Card Request (required)
   * @return ApiResponse&lt;UnitCardResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitCardResponse> createCardWithHttpInfo(CreateCardRequest createCardRequest) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = createCardRequestBuilder(createCardRequest);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("createCard", localVarResponse);
        }
        return new ApiResponse<UnitCardResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitCardResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder createCardRequestBuilder(CreateCardRequest createCardRequest) throws ApiException {
    // verify the required parameter 'createCardRequest' is set
    if (createCardRequest == null) {
      throw new ApiException(400, "Missing the required parameter 'createCardRequest' when calling createCard");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/cards";

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Content-Type", "application/vnd.api+json");
    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(createCardRequest);
      localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
    } catch (IOException e) {
      throw new ApiException(e);
    }
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Create Check Deposit
   * Create a Check Deposit via API 
   * @param createCheckDepositRequest Create Check Deposit Request (required)
   * @return UnitCheckDepositResponse
   * @throws ApiException if fails to make API call
   */
  public UnitCheckDepositResponse createCheckDeposit(CreateCheckDepositRequest createCheckDepositRequest) throws ApiException {
    ApiResponse<UnitCheckDepositResponse> localVarResponse = createCheckDepositWithHttpInfo(createCheckDepositRequest);
    return localVarResponse.getData();
  }

  /**
   * Create Check Deposit
   * Create a Check Deposit via API 
   * @param createCheckDepositRequest Create Check Deposit Request (required)
   * @return ApiResponse&lt;UnitCheckDepositResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitCheckDepositResponse> createCheckDepositWithHttpInfo(CreateCheckDepositRequest createCheckDepositRequest) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = createCheckDepositRequestBuilder(createCheckDepositRequest);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("createCheckDeposit", localVarResponse);
        }
        return new ApiResponse<UnitCheckDepositResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitCheckDepositResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder createCheckDepositRequestBuilder(CreateCheckDepositRequest createCheckDepositRequest) throws ApiException {
    // verify the required parameter 'createCheckDepositRequest' is set
    if (createCheckDepositRequest == null) {
      throw new ApiException(400, "Missing the required parameter 'createCheckDepositRequest' when calling createCheckDeposit");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/check-deposits";

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Content-Type", "application/vnd.api+json");
    localVarRequestBuilder.header("Accept", "application/vnd.api+json");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(createCheckDepositRequest);
      localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
    } catch (IOException e) {
      throw new ApiException(e);
    }
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Create Check Payment
   * Create Check Payment via API 
   * @param createCheckPaymentRequest Create Check Payment Request (required)
   * @return UnitCheckPaymentResponse
   * @throws ApiException if fails to make API call
   */
  public UnitCheckPaymentResponse createCheckPayment(CreateCheckPaymentRequest createCheckPaymentRequest) throws ApiException {
    ApiResponse<UnitCheckPaymentResponse> localVarResponse = createCheckPaymentWithHttpInfo(createCheckPaymentRequest);
    return localVarResponse.getData();
  }

  /**
   * Create Check Payment
   * Create Check Payment via API 
   * @param createCheckPaymentRequest Create Check Payment Request (required)
   * @return ApiResponse&lt;UnitCheckPaymentResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitCheckPaymentResponse> createCheckPaymentWithHttpInfo(CreateCheckPaymentRequest createCheckPaymentRequest) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = createCheckPaymentRequestBuilder(createCheckPaymentRequest);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("createCheckPayment", localVarResponse);
        }
        return new ApiResponse<UnitCheckPaymentResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitCheckPaymentResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder createCheckPaymentRequestBuilder(CreateCheckPaymentRequest createCheckPaymentRequest) throws ApiException {
    // verify the required parameter 'createCheckPaymentRequest' is set
    if (createCheckPaymentRequest == null) {
      throw new ApiException(400, "Missing the required parameter 'createCheckPaymentRequest' when calling createCheckPayment");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/check-payments";

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Content-Type", "application/vnd.api+json");
    localVarRequestBuilder.header("Accept", "application/vnd.api+json");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(createCheckPaymentRequest);
      localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
    } catch (IOException e) {
      throw new ApiException(e);
    }
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Create Counterparty
   * Create a counterparty via API 
   * @param createCounterpartyRequest Create Counterparty Request (required)
   * @return UnitCounterpartyResponse
   * @throws ApiException if fails to make API call
   */
  public UnitCounterpartyResponse createCounterparty(CreateCounterpartyRequest createCounterpartyRequest) throws ApiException {
    ApiResponse<UnitCounterpartyResponse> localVarResponse = createCounterpartyWithHttpInfo(createCounterpartyRequest);
    return localVarResponse.getData();
  }

  /**
   * Create Counterparty
   * Create a counterparty via API 
   * @param createCounterpartyRequest Create Counterparty Request (required)
   * @return ApiResponse&lt;UnitCounterpartyResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitCounterpartyResponse> createCounterpartyWithHttpInfo(CreateCounterpartyRequest createCounterpartyRequest) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = createCounterpartyRequestBuilder(createCounterpartyRequest);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("createCounterparty", localVarResponse);
        }
        return new ApiResponse<UnitCounterpartyResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitCounterpartyResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder createCounterpartyRequestBuilder(CreateCounterpartyRequest createCounterpartyRequest) throws ApiException {
    // verify the required parameter 'createCounterpartyRequest' is set
    if (createCounterpartyRequest == null) {
      throw new ApiException(400, "Missing the required parameter 'createCounterpartyRequest' when calling createCounterparty");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/counterparties";

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Content-Type", "application/vnd.api+json");
    localVarRequestBuilder.header("Accept", "application/vnd.api+json");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(createCounterpartyRequest);
      localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
    } catch (IOException e) {
      throw new ApiException(e);
    }
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Create Customer Token
   * Create a Customer Token via API 
   * @param customerId ID of the customer to create token for (required)
   * @param createCustomerTokenRequest Create Customer Token Request (required)
   * @return UnitCustomerTokenResponse
   * @throws ApiException if fails to make API call
   */
  public UnitCustomerTokenResponse createCustomerToken(String customerId, CreateCustomerTokenRequest createCustomerTokenRequest) throws ApiException {
    ApiResponse<UnitCustomerTokenResponse> localVarResponse = createCustomerTokenWithHttpInfo(customerId, createCustomerTokenRequest);
    return localVarResponse.getData();
  }

  /**
   * Create Customer Token
   * Create a Customer Token via API 
   * @param customerId ID of the customer to create token for (required)
   * @param createCustomerTokenRequest Create Customer Token Request (required)
   * @return ApiResponse&lt;UnitCustomerTokenResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitCustomerTokenResponse> createCustomerTokenWithHttpInfo(String customerId, CreateCustomerTokenRequest createCustomerTokenRequest) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = createCustomerTokenRequestBuilder(customerId, createCustomerTokenRequest);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("createCustomerToken", localVarResponse);
        }
        return new ApiResponse<UnitCustomerTokenResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitCustomerTokenResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder createCustomerTokenRequestBuilder(String customerId, CreateCustomerTokenRequest createCustomerTokenRequest) throws ApiException {
    // verify the required parameter 'customerId' is set
    if (customerId == null) {
      throw new ApiException(400, "Missing the required parameter 'customerId' when calling createCustomerToken");
    }
    // verify the required parameter 'createCustomerTokenRequest' is set
    if (createCustomerTokenRequest == null) {
      throw new ApiException(400, "Missing the required parameter 'createCustomerTokenRequest' when calling createCustomerToken");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/customers/{customerId}/token"
        .replace("{customerId}", ApiClient.urlEncode(customerId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Content-Type", "application/vnd.api+json");
    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(createCustomerTokenRequest);
      localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
    } catch (IOException e) {
      throw new ApiException(e);
    }
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Create Customer Token Verification
   * Create a Customer Token Verification via API 
   * @param customerId ID of the customer to create token for (required)
   * @param createCustomerTokenVerificationRequest Create Customer Token Verification Request (required)
   * @return UnitCustomerTokenVerificationResponse
   * @throws ApiException if fails to make API call
   */
  public UnitCustomerTokenVerificationResponse createCustomerTokenVerification(String customerId, CreateCustomerTokenVerificationRequest createCustomerTokenVerificationRequest) throws ApiException {
    ApiResponse<UnitCustomerTokenVerificationResponse> localVarResponse = createCustomerTokenVerificationWithHttpInfo(customerId, createCustomerTokenVerificationRequest);
    return localVarResponse.getData();
  }

  /**
   * Create Customer Token Verification
   * Create a Customer Token Verification via API 
   * @param customerId ID of the customer to create token for (required)
   * @param createCustomerTokenVerificationRequest Create Customer Token Verification Request (required)
   * @return ApiResponse&lt;UnitCustomerTokenVerificationResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitCustomerTokenVerificationResponse> createCustomerTokenVerificationWithHttpInfo(String customerId, CreateCustomerTokenVerificationRequest createCustomerTokenVerificationRequest) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = createCustomerTokenVerificationRequestBuilder(customerId, createCustomerTokenVerificationRequest);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("createCustomerTokenVerification", localVarResponse);
        }
        return new ApiResponse<UnitCustomerTokenVerificationResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitCustomerTokenVerificationResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder createCustomerTokenVerificationRequestBuilder(String customerId, CreateCustomerTokenVerificationRequest createCustomerTokenVerificationRequest) throws ApiException {
    // verify the required parameter 'customerId' is set
    if (customerId == null) {
      throw new ApiException(400, "Missing the required parameter 'customerId' when calling createCustomerTokenVerification");
    }
    // verify the required parameter 'createCustomerTokenVerificationRequest' is set
    if (createCustomerTokenVerificationRequest == null) {
      throw new ApiException(400, "Missing the required parameter 'createCustomerTokenVerificationRequest' when calling createCustomerTokenVerification");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/customers/{customerId}/token/verification"
        .replace("{customerId}", ApiClient.urlEncode(customerId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Content-Type", "application/vnd.api+json");
    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(createCustomerTokenVerificationRequest);
      localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
    } catch (IOException e) {
      throw new ApiException(e);
    }
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Create Fee
   * Create a Fee via API 
   * @param createFeeRequest Create Fee Request (required)
   * @return UnitFeeResponse
   * @throws ApiException if fails to make API call
   */
  public UnitFeeResponse createFee(CreateFeeRequest createFeeRequest) throws ApiException {
    ApiResponse<UnitFeeResponse> localVarResponse = createFeeWithHttpInfo(createFeeRequest);
    return localVarResponse.getData();
  }

  /**
   * Create Fee
   * Create a Fee via API 
   * @param createFeeRequest Create Fee Request (required)
   * @return ApiResponse&lt;UnitFeeResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitFeeResponse> createFeeWithHttpInfo(CreateFeeRequest createFeeRequest) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = createFeeRequestBuilder(createFeeRequest);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("createFee", localVarResponse);
        }
        return new ApiResponse<UnitFeeResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitFeeResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder createFeeRequestBuilder(CreateFeeRequest createFeeRequest) throws ApiException {
    // verify the required parameter 'createFeeRequest' is set
    if (createFeeRequest == null) {
      throw new ApiException(400, "Missing the required parameter 'createFeeRequest' when calling createFee");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/fees";

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Content-Type", "application/vnd.api+json");
    localVarRequestBuilder.header("Accept", "application/vnd.api+json");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(createFeeRequest);
      localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
    } catch (IOException e) {
      throw new ApiException(e);
    }
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Create Incoming ACH Payment Simulation
   * Create Incoming ACH Payment Simulation via API 
   * @param createIncomingAchPaymentRequest Create Incoming ACH Payment Simulation Request (required)
   * @return UnitReceivedPaymentResponse
   * @throws ApiException if fails to make API call
   */
  public UnitReceivedPaymentResponse createIncomingAchPaymentSimulation(CreateIncomingAchPaymentRequest createIncomingAchPaymentRequest) throws ApiException {
    ApiResponse<UnitReceivedPaymentResponse> localVarResponse = createIncomingAchPaymentSimulationWithHttpInfo(createIncomingAchPaymentRequest);
    return localVarResponse.getData();
  }

  /**
   * Create Incoming ACH Payment Simulation
   * Create Incoming ACH Payment Simulation via API 
   * @param createIncomingAchPaymentRequest Create Incoming ACH Payment Simulation Request (required)
   * @return ApiResponse&lt;UnitReceivedPaymentResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitReceivedPaymentResponse> createIncomingAchPaymentSimulationWithHttpInfo(CreateIncomingAchPaymentRequest createIncomingAchPaymentRequest) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = createIncomingAchPaymentSimulationRequestBuilder(createIncomingAchPaymentRequest);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("createIncomingAchPaymentSimulation", localVarResponse);
        }
        return new ApiResponse<UnitReceivedPaymentResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitReceivedPaymentResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder createIncomingAchPaymentSimulationRequestBuilder(CreateIncomingAchPaymentRequest createIncomingAchPaymentRequest) throws ApiException {
    // verify the required parameter 'createIncomingAchPaymentRequest' is set
    if (createIncomingAchPaymentRequest == null) {
      throw new ApiException(400, "Missing the required parameter 'createIncomingAchPaymentRequest' when calling createIncomingAchPaymentSimulation");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/sandbox/received-ach-payment";

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Content-Type", "application/vnd.api+json");
    localVarRequestBuilder.header("Accept", "application/vnd.api+json");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(createIncomingAchPaymentRequest);
      localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
    } catch (IOException e) {
      throw new ApiException(e);
    }
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Create a Payment
   * Create a Payment via API 
   * @param createPaymentRequest Create Payment Request (required)
   * @return UnitPaymentResponse
   * @throws ApiException if fails to make API call
   */
  public UnitPaymentResponse createPayment(CreatePaymentRequest createPaymentRequest) throws ApiException {
    ApiResponse<UnitPaymentResponse> localVarResponse = createPaymentWithHttpInfo(createPaymentRequest);
    return localVarResponse.getData();
  }

  /**
   * Create a Payment
   * Create a Payment via API 
   * @param createPaymentRequest Create Payment Request (required)
   * @return ApiResponse&lt;UnitPaymentResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitPaymentResponse> createPaymentWithHttpInfo(CreatePaymentRequest createPaymentRequest) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = createPaymentRequestBuilder(createPaymentRequest);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("createPayment", localVarResponse);
        }
        return new ApiResponse<UnitPaymentResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitPaymentResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder createPaymentRequestBuilder(CreatePaymentRequest createPaymentRequest) throws ApiException {
    // verify the required parameter 'createPaymentRequest' is set
    if (createPaymentRequest == null) {
      throw new ApiException(400, "Missing the required parameter 'createPaymentRequest' when calling createPayment");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/payments";

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Content-Type", "application/vnd.api+json");
    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(createPaymentRequest);
      localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
    } catch (IOException e) {
      throw new ApiException(e);
    }
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Create Recurring Payment
   * Create a Recurring Payment via API 
   * @param createRecurringPaymentRequest Create Recurring Payment Request (required)
   * @return UnitRecurringPaymentResponse
   * @throws ApiException if fails to make API call
   */
  public UnitRecurringPaymentResponse createRecurringPayment(CreateRecurringPaymentRequest createRecurringPaymentRequest) throws ApiException {
    ApiResponse<UnitRecurringPaymentResponse> localVarResponse = createRecurringPaymentWithHttpInfo(createRecurringPaymentRequest);
    return localVarResponse.getData();
  }

  /**
   * Create Recurring Payment
   * Create a Recurring Payment via API 
   * @param createRecurringPaymentRequest Create Recurring Payment Request (required)
   * @return ApiResponse&lt;UnitRecurringPaymentResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitRecurringPaymentResponse> createRecurringPaymentWithHttpInfo(CreateRecurringPaymentRequest createRecurringPaymentRequest) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = createRecurringPaymentRequestBuilder(createRecurringPaymentRequest);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("createRecurringPayment", localVarResponse);
        }
        return new ApiResponse<UnitRecurringPaymentResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitRecurringPaymentResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder createRecurringPaymentRequestBuilder(CreateRecurringPaymentRequest createRecurringPaymentRequest) throws ApiException {
    // verify the required parameter 'createRecurringPaymentRequest' is set
    if (createRecurringPaymentRequest == null) {
      throw new ApiException(400, "Missing the required parameter 'createRecurringPaymentRequest' when calling createRecurringPayment");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/recurring-payments";

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Content-Type", "application/vnd.api+json");
    localVarRequestBuilder.header("Accept", "application/vnd.api+json");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(createRecurringPaymentRequest);
      localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
    } catch (IOException e) {
      throw new ApiException(e);
    }
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Create a Recurring Repayment
   * Create a Recurring Repayment via API
   * @param createRecurringRepaymentRequest Create a Recurring Repayment Request (required)
   * @return UnitRecurringRepaymentResponse
   * @throws ApiException if fails to make API call
   */
  public UnitRecurringRepaymentResponse createRecurringRepayment(CreateRecurringRepaymentRequest createRecurringRepaymentRequest) throws ApiException {
    ApiResponse<UnitRecurringRepaymentResponse> localVarResponse = createRecurringRepaymentWithHttpInfo(createRecurringRepaymentRequest);
    return localVarResponse.getData();
  }

  /**
   * Create a Recurring Repayment
   * Create a Recurring Repayment via API
   * @param createRecurringRepaymentRequest Create a Recurring Repayment Request (required)
   * @return ApiResponse&lt;UnitRecurringRepaymentResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitRecurringRepaymentResponse> createRecurringRepaymentWithHttpInfo(CreateRecurringRepaymentRequest createRecurringRepaymentRequest) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = createRecurringRepaymentRequestBuilder(createRecurringRepaymentRequest);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("createRecurringRepayment", localVarResponse);
        }
        return new ApiResponse<UnitRecurringRepaymentResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitRecurringRepaymentResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder createRecurringRepaymentRequestBuilder(CreateRecurringRepaymentRequest createRecurringRepaymentRequest) throws ApiException {
    // verify the required parameter 'createRecurringRepaymentRequest' is set
    if (createRecurringRepaymentRequest == null) {
      throw new ApiException(400, "Missing the required parameter 'createRecurringRepaymentRequest' when calling createRecurringRepayment");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/recurring-repayments";

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Content-Type", "application/vnd.api+json");
    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(createRecurringRepaymentRequest);
      localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
    } catch (IOException e) {
      throw new ApiException(e);
    }
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Create a Repayment
   * Create a Repayment via API 
   * @param createRepaymentRequest Create a Repayment Request (required)
   * @return UnitRepaymentResponse
   * @throws ApiException if fails to make API call
   */
  public UnitRepaymentResponse createRepayment(CreateRepaymentRequest createRepaymentRequest) throws ApiException {
    ApiResponse<UnitRepaymentResponse> localVarResponse = createRepaymentWithHttpInfo(createRepaymentRequest);
    return localVarResponse.getData();
  }

  /**
   * Create a Repayment
   * Create a Repayment via API 
   * @param createRepaymentRequest Create a Repayment Request (required)
   * @return ApiResponse&lt;UnitRepaymentResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitRepaymentResponse> createRepaymentWithHttpInfo(CreateRepaymentRequest createRepaymentRequest) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = createRepaymentRequestBuilder(createRepaymentRequest);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("createRepayment", localVarResponse);
        }
        return new ApiResponse<UnitRepaymentResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitRepaymentResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder createRepaymentRequestBuilder(CreateRepaymentRequest createRepaymentRequest) throws ApiException {
    // verify the required parameter 'createRepaymentRequest' is set
    if (createRepaymentRequest == null) {
      throw new ApiException(400, "Missing the required parameter 'createRepaymentRequest' when calling createRepayment");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/repayments";

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Content-Type", "application/vnd.api+json");
    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(createRepaymentRequest);
      localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
    } catch (IOException e) {
      throw new ApiException(e);
    }
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Create Reward
   * Create a Reward via API 
   * @param createRewardRequest Create Reward Request (required)
   * @return UnitRewardResponse
   * @throws ApiException if fails to make API call
   */
  public UnitRewardResponse createReward(CreateRewardRequest createRewardRequest) throws ApiException {
    ApiResponse<UnitRewardResponse> localVarResponse = createRewardWithHttpInfo(createRewardRequest);
    return localVarResponse.getData();
  }

  /**
   * Create Reward
   * Create a Reward via API 
   * @param createRewardRequest Create Reward Request (required)
   * @return ApiResponse&lt;UnitRewardResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitRewardResponse> createRewardWithHttpInfo(CreateRewardRequest createRewardRequest) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = createRewardRequestBuilder(createRewardRequest);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("createReward", localVarResponse);
        }
        return new ApiResponse<UnitRewardResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitRewardResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder createRewardRequestBuilder(CreateRewardRequest createRewardRequest) throws ApiException {
    // verify the required parameter 'createRewardRequest' is set
    if (createRewardRequest == null) {
      throw new ApiException(400, "Missing the required parameter 'createRewardRequest' when calling createReward");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/rewards";

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Content-Type", "application/vnd.api+json");
    localVarRequestBuilder.header("Accept", "application/vnd.api+json");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(createRewardRequest);
      localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
    } catch (IOException e) {
      throw new ApiException(e);
    }
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Create Stop Payment
   * 
   * @param createStopPaymentRequest  (required)
   * @return StopPaymentResponse
   * @throws ApiException if fails to make API call
   */
  public StopPaymentResponse createStopPayment(CreateStopPaymentRequest createStopPaymentRequest) throws ApiException {
    ApiResponse<StopPaymentResponse> localVarResponse = createStopPaymentWithHttpInfo(createStopPaymentRequest);
    return localVarResponse.getData();
  }

  /**
   * Create Stop Payment
   * 
   * @param createStopPaymentRequest  (required)
   * @return ApiResponse&lt;StopPaymentResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<StopPaymentResponse> createStopPaymentWithHttpInfo(CreateStopPaymentRequest createStopPaymentRequest) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = createStopPaymentRequestBuilder(createStopPaymentRequest);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("createStopPayment", localVarResponse);
        }
        return new ApiResponse<StopPaymentResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<StopPaymentResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder createStopPaymentRequestBuilder(CreateStopPaymentRequest createStopPaymentRequest) throws ApiException {
    // verify the required parameter 'createStopPaymentRequest' is set
    if (createStopPaymentRequest == null) {
      throw new ApiException(400, "Missing the required parameter 'createStopPaymentRequest' when calling createStopPayment");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/stop-payments";

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Content-Type", "application/json");
    localVarRequestBuilder.header("Accept", "application/json");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(createStopPaymentRequest);
      localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
    } catch (IOException e) {
      throw new ApiException(e);
    }
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Create Webhook
   * Create a Webhook via API 
   * @param createWebhookRequest Create Webhook Request Body (required)
   * @return UnitWebhookResponse
   * @throws ApiException if fails to make API call
   */
  public UnitWebhookResponse createWebhook(CreateWebhookRequest createWebhookRequest) throws ApiException {
    ApiResponse<UnitWebhookResponse> localVarResponse = createWebhookWithHttpInfo(createWebhookRequest);
    return localVarResponse.getData();
  }

  /**
   * Create Webhook
   * Create a Webhook via API 
   * @param createWebhookRequest Create Webhook Request Body (required)
   * @return ApiResponse&lt;UnitWebhookResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitWebhookResponse> createWebhookWithHttpInfo(CreateWebhookRequest createWebhookRequest) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = createWebhookRequestBuilder(createWebhookRequest);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("createWebhook", localVarResponse);
        }
        return new ApiResponse<UnitWebhookResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitWebhookResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder createWebhookRequestBuilder(CreateWebhookRequest createWebhookRequest) throws ApiException {
    // verify the required parameter 'createWebhookRequest' is set
    if (createWebhookRequest == null) {
      throw new ApiException(400, "Missing the required parameter 'createWebhookRequest' when calling createWebhook");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/webhooks";

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Content-Type", "application/vnd.api+json");
    localVarRequestBuilder.header("Accept", "application/vnd.api+json");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(createWebhookRequest);
      localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
    } catch (IOException e) {
      throw new ApiException(e);
    }
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Deactivate Account Control Agreement by Id
   * Deactivate Control Agreement for Account via API
   * @param accountId ID of the account (required)
   * @return UnitAccountResponse
   * @throws ApiException if fails to make API call
   */
  public UnitAccountResponse deactivateControlAgreementForAccount(String accountId) throws ApiException {
    ApiResponse<UnitAccountResponse> localVarResponse = deactivateControlAgreementForAccountWithHttpInfo(accountId);
    return localVarResponse.getData();
  }

  /**
   * Deactivate Account Control Agreement by Id
   * Deactivate Control Agreement for Account via API
   * @param accountId ID of the account (required)
   * @return ApiResponse&lt;UnitAccountResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitAccountResponse> deactivateControlAgreementForAccountWithHttpInfo(String accountId) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = deactivateControlAgreementForAccountRequestBuilder(accountId);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("deactivateControlAgreementForAccount", localVarResponse);
        }
        return new ApiResponse<UnitAccountResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitAccountResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder deactivateControlAgreementForAccountRequestBuilder(String accountId) throws ApiException {
    // verify the required parameter 'accountId' is set
    if (accountId == null) {
      throw new ApiException(400, "Missing the required parameter 'accountId' when calling deactivateControlAgreementForAccount");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/accounts/{accountId}/deactivate-daca"
        .replace("{accountId}", ApiClient.urlEncode(accountId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Decline Authorization Request
   * Decline Authorization Request via API 
   * @param authorizationId ID of the authorization request to decline (required)
   * @param declineAuthorizationRequest Decline Authorization Request (required)
   * @return UnitAuthorizationRequestResponse
   * @throws ApiException if fails to make API call
   */
  public UnitAuthorizationRequestResponse declineAuthorizationRequest(String authorizationId, DeclineAuthorizationRequest declineAuthorizationRequest) throws ApiException {
    ApiResponse<UnitAuthorizationRequestResponse> localVarResponse = declineAuthorizationRequestWithHttpInfo(authorizationId, declineAuthorizationRequest);
    return localVarResponse.getData();
  }

  /**
   * Decline Authorization Request
   * Decline Authorization Request via API 
   * @param authorizationId ID of the authorization request to decline (required)
   * @param declineAuthorizationRequest Decline Authorization Request (required)
   * @return ApiResponse&lt;UnitAuthorizationRequestResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitAuthorizationRequestResponse> declineAuthorizationRequestWithHttpInfo(String authorizationId, DeclineAuthorizationRequest declineAuthorizationRequest) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = declineAuthorizationRequestRequestBuilder(authorizationId, declineAuthorizationRequest);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("declineAuthorizationRequest", localVarResponse);
        }
        return new ApiResponse<UnitAuthorizationRequestResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitAuthorizationRequestResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder declineAuthorizationRequestRequestBuilder(String authorizationId, DeclineAuthorizationRequest declineAuthorizationRequest) throws ApiException {
    // verify the required parameter 'authorizationId' is set
    if (authorizationId == null) {
      throw new ApiException(400, "Missing the required parameter 'authorizationId' when calling declineAuthorizationRequest");
    }
    // verify the required parameter 'declineAuthorizationRequest' is set
    if (declineAuthorizationRequest == null) {
      throw new ApiException(400, "Missing the required parameter 'declineAuthorizationRequest' when calling declineAuthorizationRequest");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/authorization-requests/{authorizationId}/decline"
        .replace("{authorizationId}", ApiClient.urlEncode(authorizationId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Content-Type", "application/vnd.api+json");
    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(declineAuthorizationRequest);
      localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
    } catch (IOException e) {
      throw new ApiException(e);
    }
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Delete Counterparty by Id
   * Delete Counterparty via API 
   * @param counterpartyId ID of the counterparty to delete (required)
   * @throws ApiException if fails to make API call
   */
  public void deleteCounterparty(String counterpartyId) throws ApiException {
    deleteCounterpartyWithHttpInfo(counterpartyId);
  }

  /**
   * Delete Counterparty by Id
   * Delete Counterparty via API 
   * @param counterpartyId ID of the counterparty to delete (required)
   * @return ApiResponse&lt;Void&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<Void> deleteCounterpartyWithHttpInfo(String counterpartyId) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = deleteCounterpartyRequestBuilder(counterpartyId);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("deleteCounterparty", localVarResponse);
        }
        return new ApiResponse<Void>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          null
        );
      } finally {
        // Drain the InputStream
        while (localVarResponse.body().read() != -1) {
            // Ignore
        }
        localVarResponse.body().close();
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder deleteCounterpartyRequestBuilder(String counterpartyId) throws ApiException {
    // verify the required parameter 'counterpartyId' is set
    if (counterpartyId == null) {
      throw new ApiException(400, "Missing the required parameter 'counterpartyId' when calling deleteCounterparty");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/counterparties/{counterpartyId}"
        .replace("{counterpartyId}", ApiClient.urlEncode(counterpartyId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Accept", "application/json");

    localVarRequestBuilder.method("DELETE", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Get Reward by Id
   * Get a Reward from API 
   * @param userId ID of the user to revoke token (required)
   * @param tokenId ID of the token to revoke (required)
   * @return UnitApiTokenResponse
   * @throws ApiException if fails to make API call
   */
  public UnitApiTokenResponse deleteToken(String userId, String tokenId) throws ApiException {
    ApiResponse<UnitApiTokenResponse> localVarResponse = deleteTokenWithHttpInfo(userId, tokenId);
    return localVarResponse.getData();
  }

  /**
   * Get Reward by Id
   * Get a Reward from API 
   * @param userId ID of the user to revoke token (required)
   * @param tokenId ID of the token to revoke (required)
   * @return ApiResponse&lt;UnitApiTokenResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitApiTokenResponse> deleteTokenWithHttpInfo(String userId, String tokenId) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = deleteTokenRequestBuilder(userId, tokenId);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("deleteToken", localVarResponse);
        }
        return new ApiResponse<UnitApiTokenResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitApiTokenResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder deleteTokenRequestBuilder(String userId, String tokenId) throws ApiException {
    // verify the required parameter 'userId' is set
    if (userId == null) {
      throw new ApiException(400, "Missing the required parameter 'userId' when calling deleteToken");
    }
    // verify the required parameter 'tokenId' is set
    if (tokenId == null) {
      throw new ApiException(400, "Missing the required parameter 'tokenId' when calling deleteToken");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/users/{userId}/api-tokens/{tokenId}"
        .replace("{userId}", ApiClient.urlEncode(userId.toString()))
        .replace("{tokenId}", ApiClient.urlEncode(tokenId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    localVarRequestBuilder.method("DELETE", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Disable Recurring Payment
   * Disable Recurring Payment via API 
   * @param paymentId ID of the payment to disable (required)
   * @param body Pass empty object in order for content-type to be aquired correctly (required)
   * @return UnitRecurringPaymentResponse
   * @throws ApiException if fails to make API call
   */
  public UnitRecurringPaymentResponse disableRecurringPayment(String paymentId, Object body) throws ApiException {
    ApiResponse<UnitRecurringPaymentResponse> localVarResponse = disableRecurringPaymentWithHttpInfo(paymentId, body);
    return localVarResponse.getData();
  }

  /**
   * Disable Recurring Payment
   * Disable Recurring Payment via API 
   * @param paymentId ID of the payment to disable (required)
   * @param body Pass empty object in order for content-type to be aquired correctly (required)
   * @return ApiResponse&lt;UnitRecurringPaymentResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitRecurringPaymentResponse> disableRecurringPaymentWithHttpInfo(String paymentId, Object body) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = disableRecurringPaymentRequestBuilder(paymentId, body);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("disableRecurringPayment", localVarResponse);
        }
        return new ApiResponse<UnitRecurringPaymentResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitRecurringPaymentResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder disableRecurringPaymentRequestBuilder(String paymentId, Object body) throws ApiException {
    // verify the required parameter 'paymentId' is set
    if (paymentId == null) {
      throw new ApiException(400, "Missing the required parameter 'paymentId' when calling disableRecurringPayment");
    }
    // verify the required parameter 'body' is set
    if (body == null) {
      throw new ApiException(400, "Missing the required parameter 'body' when calling disableRecurringPayment");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/recurring-payments/{paymentId}/disable"
        .replace("{paymentId}", ApiClient.urlEncode(paymentId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Content-Type", "application/vnd.api+json");
    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(body);
      localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
    } catch (IOException e) {
      throw new ApiException(e);
    }
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Disable Recurring Repayment by Id
   * Disable a Recurring Repayment
   * @param recurringRepaymentId ID of the recurring repayment to disable (required)
   * @param body Pass empty object in order for content-type to be aquired correctly (required)
   * @param include  (optional)
   * @return UnitRecurringRepaymentResponse
   * @throws ApiException if fails to make API call
   */
  public UnitRecurringRepaymentResponse disableRecurringRepayment(String recurringRepaymentId, Object body, String include) throws ApiException {
    ApiResponse<UnitRecurringRepaymentResponse> localVarResponse = disableRecurringRepaymentWithHttpInfo(recurringRepaymentId, body, include);
    return localVarResponse.getData();
  }

  /**
   * Disable Recurring Repayment by Id
   * Disable a Recurring Repayment
   * @param recurringRepaymentId ID of the recurring repayment to disable (required)
   * @param body Pass empty object in order for content-type to be aquired correctly (required)
   * @param include  (optional)
   * @return ApiResponse&lt;UnitRecurringRepaymentResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitRecurringRepaymentResponse> disableRecurringRepaymentWithHttpInfo(String recurringRepaymentId, Object body, String include) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = disableRecurringRepaymentRequestBuilder(recurringRepaymentId, body, include);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("disableRecurringRepayment", localVarResponse);
        }
        return new ApiResponse<UnitRecurringRepaymentResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitRecurringRepaymentResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder disableRecurringRepaymentRequestBuilder(String recurringRepaymentId, Object body, String include) throws ApiException {
    // verify the required parameter 'recurringRepaymentId' is set
    if (recurringRepaymentId == null) {
      throw new ApiException(400, "Missing the required parameter 'recurringRepaymentId' when calling disableRecurringRepayment");
    }
    // verify the required parameter 'body' is set
    if (body == null) {
      throw new ApiException(400, "Missing the required parameter 'body' when calling disableRecurringRepayment");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/recurring-repayments/{recurringRepaymentId}/disable"
        .replace("{recurringRepaymentId}", ApiClient.urlEncode(recurringRepaymentId.toString()));

    List<Pair> localVarQueryParams = new ArrayList<>();
    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    localVarQueryParameterBaseName = "include";
    localVarQueryParams.addAll(ApiClient.parameterToPairs("include", include));

    if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
      StringJoiner queryJoiner = new StringJoiner("&");
      localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + '=' + p.getValue()));
      if (localVarQueryStringJoiner.length() != 0) {
        queryJoiner.add(localVarQueryStringJoiner.toString());
      }
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath + '?' + queryJoiner.toString()));
    } else {
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));
    }

    localVarRequestBuilder.header("Content-Type", "application/vnd.api+json");
    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(body);
      localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
    } catch (IOException e) {
      throw new ApiException(e);
    }
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Disable a stop payment
   * 
   * @param stopPaymentId ID of the stop payment (required)
   * @return StopPaymentResponse
   * @throws ApiException if fails to make API call
   */
  public StopPaymentResponse disableStopPayment(String stopPaymentId) throws ApiException {
    ApiResponse<StopPaymentResponse> localVarResponse = disableStopPaymentWithHttpInfo(stopPaymentId);
    return localVarResponse.getData();
  }

  /**
   * Disable a stop payment
   * 
   * @param stopPaymentId ID of the stop payment (required)
   * @return ApiResponse&lt;StopPaymentResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<StopPaymentResponse> disableStopPaymentWithHttpInfo(String stopPaymentId) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = disableStopPaymentRequestBuilder(stopPaymentId);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("disableStopPayment", localVarResponse);
        }
        return new ApiResponse<StopPaymentResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<StopPaymentResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder disableStopPaymentRequestBuilder(String stopPaymentId) throws ApiException {
    // verify the required parameter 'stopPaymentId' is set
    if (stopPaymentId == null) {
      throw new ApiException(400, "Missing the required parameter 'stopPaymentId' when calling disableStopPayment");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/stop-payments/{stopPaymentId}/disable"
        .replace("{stopPaymentId}", ApiClient.urlEncode(stopPaymentId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Accept", "application/json");

    localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Disable a Webhook
   * Disable a Webhook via API 
   * @param webhookId ID of the webhook to disable (required)
   * @return UnitWebhookResponse
   * @throws ApiException if fails to make API call
   */
  public UnitWebhookResponse disableWebhook(String webhookId) throws ApiException {
    ApiResponse<UnitWebhookResponse> localVarResponse = disableWebhookWithHttpInfo(webhookId);
    return localVarResponse.getData();
  }

  /**
   * Disable a Webhook
   * Disable a Webhook via API 
   * @param webhookId ID of the webhook to disable (required)
   * @return ApiResponse&lt;UnitWebhookResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitWebhookResponse> disableWebhookWithHttpInfo(String webhookId) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = disableWebhookRequestBuilder(webhookId);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("disableWebhook", localVarResponse);
        }
        return new ApiResponse<UnitWebhookResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitWebhookResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder disableWebhookRequestBuilder(String webhookId) throws ApiException {
    // verify the required parameter 'webhookId' is set
    if (webhookId == null) {
      throw new ApiException(400, "Missing the required parameter 'webhookId' when calling disableWebhook");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/webhooks/{webhookId}/disable"
        .replace("{webhookId}", ApiClient.urlEncode(webhookId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Download a Document - Back Side
   * Download a Document - Back Side via API
   * @param applicationId ID of the application (required)
   * @param documentId ID of the document to download (required)
   * @return File
   * @throws ApiException if fails to make API call
   */
  public InputStream downloadApplicationBackSideDocument(String applicationId, String documentId) throws ApiException {
    ApiResponse<InputStream> localVarResponse = downloadApplicationBackSideDocumentWithHttpInfo(applicationId, documentId);
    return localVarResponse.getData();
  }

  /**
   * Download a Document - Back Side
   * Download a Document - Back Side via API
   * @param applicationId ID of the application (required)
   * @param documentId ID of the document to download (required)
   * @return ApiResponse&lt;File&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<InputStream> downloadApplicationBackSideDocumentWithHttpInfo(String applicationId, String documentId) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = downloadApplicationBackSideDocumentRequestBuilder(applicationId, documentId);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("downloadApplicationBackSideDocument", localVarResponse);
        }
        return new ApiResponse<InputStream>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : localVarResponse.body()
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder downloadApplicationBackSideDocumentRequestBuilder(String applicationId, String documentId) throws ApiException {
    // verify the required parameter 'applicationId' is set
    if (applicationId == null) {
      throw new ApiException(400, "Missing the required parameter 'applicationId' when calling downloadApplicationBackSideDocument");
    }
    // verify the required parameter 'documentId' is set
    if (documentId == null) {
      throw new ApiException(400, "Missing the required parameter 'documentId' when calling downloadApplicationBackSideDocument");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/applications/{applicationId}/documents/{documentId}/download/back"
        .replace("{applicationId}", ApiClient.urlEncode(applicationId.toString()))
        .replace("{documentId}", ApiClient.urlEncode(documentId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Accept", "application/octet-stream");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Download a Document
   * Download a Document via API 
   * @param applicationId ID of the application (required)
   * @param documentId ID of the document to download (required)
   * @return File
   * @throws ApiException if fails to make API call
   */
  public InputStream downloadApplicationDocument(String applicationId, String documentId) throws ApiException {
    ApiResponse<InputStream> localVarResponse = downloadApplicationDocumentWithHttpInfo(applicationId, documentId);
    return localVarResponse.getData();
  }

  /**
   * Download a Document
   * Download a Document via API 
   * @param applicationId ID of the application (required)
   * @param documentId ID of the document to download (required)
   * @return ApiResponse&lt;File&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<InputStream> downloadApplicationDocumentWithHttpInfo(String applicationId, String documentId) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = downloadApplicationDocumentRequestBuilder(applicationId, documentId);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("downloadApplicationDocument", localVarResponse);
        }
        return new ApiResponse<InputStream>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : localVarResponse.body()
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder downloadApplicationDocumentRequestBuilder(String applicationId, String documentId) throws ApiException {
    // verify the required parameter 'applicationId' is set
    if (applicationId == null) {
      throw new ApiException(400, "Missing the required parameter 'applicationId' when calling downloadApplicationDocument");
    }
    // verify the required parameter 'documentId' is set
    if (documentId == null) {
      throw new ApiException(400, "Missing the required parameter 'documentId' when calling downloadApplicationDocument");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/applications/{applicationId}/documents/{documentId}/download"
        .replace("{applicationId}", ApiClient.urlEncode(applicationId.toString()))
        .replace("{documentId}", ApiClient.urlEncode(documentId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Accept", "application/octet-stream");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Enable Recurring Payment
   * Enable Recurring Payment via API 
   * @param paymentId ID of the payment to enable (required)
   * @param body Pass empty object in order for content-type to be aquired correctly (required)
   * @return UnitRecurringPaymentResponse
   * @throws ApiException if fails to make API call
   */
  public UnitRecurringPaymentResponse enableRecurringPayment(String paymentId, Object body) throws ApiException {
    ApiResponse<UnitRecurringPaymentResponse> localVarResponse = enableRecurringPaymentWithHttpInfo(paymentId, body);
    return localVarResponse.getData();
  }

  /**
   * Enable Recurring Payment
   * Enable Recurring Payment via API 
   * @param paymentId ID of the payment to enable (required)
   * @param body Pass empty object in order for content-type to be aquired correctly (required)
   * @return ApiResponse&lt;UnitRecurringPaymentResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitRecurringPaymentResponse> enableRecurringPaymentWithHttpInfo(String paymentId, Object body) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = enableRecurringPaymentRequestBuilder(paymentId, body);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("enableRecurringPayment", localVarResponse);
        }
        return new ApiResponse<UnitRecurringPaymentResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitRecurringPaymentResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder enableRecurringPaymentRequestBuilder(String paymentId, Object body) throws ApiException {
    // verify the required parameter 'paymentId' is set
    if (paymentId == null) {
      throw new ApiException(400, "Missing the required parameter 'paymentId' when calling enableRecurringPayment");
    }
    // verify the required parameter 'body' is set
    if (body == null) {
      throw new ApiException(400, "Missing the required parameter 'body' when calling enableRecurringPayment");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/recurring-payments/{paymentId}/enable"
        .replace("{paymentId}", ApiClient.urlEncode(paymentId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Content-Type", "application/vnd.api+json");
    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(body);
      localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
    } catch (IOException e) {
      throw new ApiException(e);
    }
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Enable Recurring Repayment by Id
   * Enable a Recurring Repayment
   * @param recurringRepaymentId ID of the recurring repayment to enable (required)
   * @param body Pass empty object in order for content-type to be aquired correctly (required)
   * @param include  (optional)
   * @return UnitRecurringRepaymentResponse
   * @throws ApiException if fails to make API call
   */
  public UnitRecurringRepaymentResponse enableRecurringRepayment(String recurringRepaymentId, Object body, String include) throws ApiException {
    ApiResponse<UnitRecurringRepaymentResponse> localVarResponse = enableRecurringRepaymentWithHttpInfo(recurringRepaymentId, body, include);
    return localVarResponse.getData();
  }

  /**
   * Enable Recurring Repayment by Id
   * Enable a Recurring Repayment
   * @param recurringRepaymentId ID of the recurring repayment to enable (required)
   * @param body Pass empty object in order for content-type to be aquired correctly (required)
   * @param include  (optional)
   * @return ApiResponse&lt;UnitRecurringRepaymentResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitRecurringRepaymentResponse> enableRecurringRepaymentWithHttpInfo(String recurringRepaymentId, Object body, String include) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = enableRecurringRepaymentRequestBuilder(recurringRepaymentId, body, include);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("enableRecurringRepayment", localVarResponse);
        }
        return new ApiResponse<UnitRecurringRepaymentResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitRecurringRepaymentResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder enableRecurringRepaymentRequestBuilder(String recurringRepaymentId, Object body, String include) throws ApiException {
    // verify the required parameter 'recurringRepaymentId' is set
    if (recurringRepaymentId == null) {
      throw new ApiException(400, "Missing the required parameter 'recurringRepaymentId' when calling enableRecurringRepayment");
    }
    // verify the required parameter 'body' is set
    if (body == null) {
      throw new ApiException(400, "Missing the required parameter 'body' when calling enableRecurringRepayment");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/recurring-repayments/{recurringRepaymentId}/enable"
        .replace("{recurringRepaymentId}", ApiClient.urlEncode(recurringRepaymentId.toString()));

    List<Pair> localVarQueryParams = new ArrayList<>();
    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    localVarQueryParameterBaseName = "include";
    localVarQueryParams.addAll(ApiClient.parameterToPairs("include", include));

    if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
      StringJoiner queryJoiner = new StringJoiner("&");
      localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + '=' + p.getValue()));
      if (localVarQueryStringJoiner.length() != 0) {
        queryJoiner.add(localVarQueryStringJoiner.toString());
      }
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath + '?' + queryJoiner.toString()));
    } else {
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));
    }

    localVarRequestBuilder.header("Content-Type", "application/vnd.api+json");
    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(body);
      localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
    } catch (IOException e) {
      throw new ApiException(e);
    }
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Enable Webhook
   * Enable a Webhook via API 
   * @param webhookId ID of the webhook to enable (required)
   * @return UnitWebhookResponse
   * @throws ApiException if fails to make API call
   */
  public UnitWebhookResponse enableWebhook(String webhookId) throws ApiException {
    ApiResponse<UnitWebhookResponse> localVarResponse = enableWebhookWithHttpInfo(webhookId);
    return localVarResponse.getData();
  }

  /**
   * Enable Webhook
   * Enable a Webhook via API 
   * @param webhookId ID of the webhook to enable (required)
   * @return ApiResponse&lt;UnitWebhookResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitWebhookResponse> enableWebhookWithHttpInfo(String webhookId) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = enableWebhookRequestBuilder(webhookId);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("enableWebhook", localVarResponse);
        }
        return new ApiResponse<UnitWebhookResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitWebhookResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder enableWebhookRequestBuilder(String webhookId) throws ApiException {
    // verify the required parameter 'webhookId' is set
    if (webhookId == null) {
      throw new ApiException(400, "Missing the required parameter 'webhookId' when calling enableWebhook");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/webhooks/{webhookId}/enable"
        .replace("{webhookId}", ApiClient.urlEncode(webhookId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Enter Account Control Agreement by Id
   * Enter Control Agreement for Account via API 
   * @param accountId ID of the account (required)
   * @return UnitAccountResponse
   * @throws ApiException if fails to make API call
   */
  public UnitAccountResponse enterControlAgreementForAccount(String accountId) throws ApiException {
    ApiResponse<UnitAccountResponse> localVarResponse = enterControlAgreementForAccountWithHttpInfo(accountId);
    return localVarResponse.getData();
  }

  /**
   * Enter Account Control Agreement by Id
   * Enter Control Agreement for Account via API 
   * @param accountId ID of the account (required)
   * @return ApiResponse&lt;UnitAccountResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitAccountResponse> enterControlAgreementForAccountWithHttpInfo(String accountId) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = enterControlAgreementForAccountRequestBuilder(accountId);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("enterControlAgreementForAccount", localVarResponse);
        }
        return new ApiResponse<UnitAccountResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitAccountResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder enterControlAgreementForAccountRequestBuilder(String accountId) throws ApiException {
    // verify the required parameter 'accountId' is set
    if (accountId == null) {
      throw new ApiException(400, "Missing the required parameter 'accountId' when calling enterControlAgreementForAccount");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/accounts/{accountId}/enter-daca"
        .replace("{accountId}", ApiClient.urlEncode(accountId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Fire Event by Id
   * Fire an Event via API 
   * @param eventId ID of the event to fire (required)
   * @return UnitEventResponse
   * @throws ApiException if fails to make API call
   */
  public UnitEventResponse fireEvent(String eventId) throws ApiException {
    ApiResponse<UnitEventResponse> localVarResponse = fireEventWithHttpInfo(eventId);
    return localVarResponse.getData();
  }

  /**
   * Fire Event by Id
   * Fire an Event via API 
   * @param eventId ID of the event to fire (required)
   * @return ApiResponse&lt;UnitEventResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitEventResponse> fireEventWithHttpInfo(String eventId) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = fireEventRequestBuilder(eventId);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("fireEvent", localVarResponse);
        }
        return new ApiResponse<UnitEventResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitEventResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder fireEventRequestBuilder(String eventId) throws ApiException {
    // verify the required parameter 'eventId' is set
    if (eventId == null) {
      throw new ApiException(400, "Missing the required parameter 'eventId' when calling fireEvent");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/events/{eventId}"
        .replace("{eventId}", ApiClient.urlEncode(eventId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Freeze Account by Id
   * Freeze Account via API 
   * @param accountId ID of the account to freeze (required)
   * @param freezeAccountRequest Freeze Account Request (required)
   * @return UnitAccountResponse
   * @throws ApiException if fails to make API call
   */
  public UnitAccountResponse freezeAccount(String accountId, FreezeAccountRequest freezeAccountRequest) throws ApiException {
    ApiResponse<UnitAccountResponse> localVarResponse = freezeAccountWithHttpInfo(accountId, freezeAccountRequest);
    return localVarResponse.getData();
  }

  /**
   * Freeze Account by Id
   * Freeze Account via API 
   * @param accountId ID of the account to freeze (required)
   * @param freezeAccountRequest Freeze Account Request (required)
   * @return ApiResponse&lt;UnitAccountResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitAccountResponse> freezeAccountWithHttpInfo(String accountId, FreezeAccountRequest freezeAccountRequest) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = freezeAccountRequestBuilder(accountId, freezeAccountRequest);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("freezeAccount", localVarResponse);
        }
        return new ApiResponse<UnitAccountResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitAccountResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder freezeAccountRequestBuilder(String accountId, FreezeAccountRequest freezeAccountRequest) throws ApiException {
    // verify the required parameter 'accountId' is set
    if (accountId == null) {
      throw new ApiException(400, "Missing the required parameter 'accountId' when calling freezeAccount");
    }
    // verify the required parameter 'freezeAccountRequest' is set
    if (freezeAccountRequest == null) {
      throw new ApiException(400, "Missing the required parameter 'freezeAccountRequest' when calling freezeAccount");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/accounts/{accountId}/freeze"
        .replace("{accountId}", ApiClient.urlEncode(accountId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Content-Type", "application/vnd.api+json");
    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(freezeAccountRequest);
      localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
    } catch (IOException e) {
      throw new ApiException(e);
    }
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Freeze a Card
   * Freeze a Card via API 
   * @param cardId ID of the card to freeze (required)
   * @return UnitCardResponse
   * @throws ApiException if fails to make API call
   */
  public UnitCardResponse freezeCard(String cardId) throws ApiException {
    ApiResponse<UnitCardResponse> localVarResponse = freezeCardWithHttpInfo(cardId);
    return localVarResponse.getData();
  }

  /**
   * Freeze a Card
   * Freeze a Card via API 
   * @param cardId ID of the card to freeze (required)
   * @return ApiResponse&lt;UnitCardResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitCardResponse> freezeCardWithHttpInfo(String cardId) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = freezeCardRequestBuilder(cardId);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("freezeCard", localVarResponse);
        }
        return new ApiResponse<UnitCardResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitCardResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder freezeCardRequestBuilder(String cardId) throws ApiException {
    // verify the required parameter 'cardId' is set
    if (cardId == null) {
      throw new ApiException(400, "Missing the required parameter 'cardId' when calling freezeCard");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/cards/{cardId}/freeze"
        .replace("{cardId}", ApiClient.urlEncode(cardId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Generate Cash Deposit Barcode
   * Generate Cash Deposit Barcode via API 
   * @param generateBarcodeRequest Generate Cash Deposit Barcode Request (required)
   * @return UnitCashDepositBarcodeResponse
   * @throws ApiException if fails to make API call
   */
  public UnitCashDepositBarcodeResponse generateBarcode(GenerateBarcodeRequest generateBarcodeRequest) throws ApiException {
    ApiResponse<UnitCashDepositBarcodeResponse> localVarResponse = generateBarcodeWithHttpInfo(generateBarcodeRequest);
    return localVarResponse.getData();
  }

  /**
   * Generate Cash Deposit Barcode
   * Generate Cash Deposit Barcode via API 
   * @param generateBarcodeRequest Generate Cash Deposit Barcode Request (required)
   * @return ApiResponse&lt;UnitCashDepositBarcodeResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitCashDepositBarcodeResponse> generateBarcodeWithHttpInfo(GenerateBarcodeRequest generateBarcodeRequest) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = generateBarcodeRequestBuilder(generateBarcodeRequest);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("generateBarcode", localVarResponse);
        }
        return new ApiResponse<UnitCashDepositBarcodeResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitCashDepositBarcodeResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder generateBarcodeRequestBuilder(GenerateBarcodeRequest generateBarcodeRequest) throws ApiException {
    // verify the required parameter 'generateBarcodeRequest' is set
    if (generateBarcodeRequest == null) {
      throw new ApiException(400, "Missing the required parameter 'generateBarcodeRequest' when calling generateBarcode");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/cash-deposits/barcodes";

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Content-Type", "application/vnd.api+json");
    localVarRequestBuilder.header("Accept", "application/vnd.api+json");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(generateBarcodeRequest);
      localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
    } catch (IOException e) {
      throw new ApiException(e);
    }
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Get Account by Id
   * Get an Account from API 
   * @param accountId ID of the account to get (required)
   * @param include  (optional)
   * @return UnitAccountResponseWithIncluded
   * @throws ApiException if fails to make API call
   */
  public UnitAccountResponseWithIncluded getAccount(String accountId, String include) throws ApiException {
    ApiResponse<UnitAccountResponseWithIncluded> localVarResponse = getAccountWithHttpInfo(accountId, include);
    return localVarResponse.getData();
  }

  /**
   * Get Account by Id
   * Get an Account from API 
   * @param accountId ID of the account to get (required)
   * @param include  (optional)
   * @return ApiResponse&lt;UnitAccountResponseWithIncluded&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitAccountResponseWithIncluded> getAccountWithHttpInfo(String accountId, String include) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = getAccountRequestBuilder(accountId, include);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("getAccount", localVarResponse);
        }
        return new ApiResponse<UnitAccountResponseWithIncluded>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitAccountResponseWithIncluded>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder getAccountRequestBuilder(String accountId, String include) throws ApiException {
    // verify the required parameter 'accountId' is set
    if (accountId == null) {
      throw new ApiException(400, "Missing the required parameter 'accountId' when calling getAccount");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/accounts/{accountId}"
        .replace("{accountId}", ApiClient.urlEncode(accountId.toString()));

    List<Pair> localVarQueryParams = new ArrayList<>();
    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    localVarQueryParameterBaseName = "include";
    localVarQueryParams.addAll(ApiClient.parameterToPairs("include", include));

    if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
      StringJoiner queryJoiner = new StringJoiner("&");
      localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + '=' + p.getValue()));
      if (localVarQueryStringJoiner.length() != 0) {
        queryJoiner.add(localVarQueryStringJoiner.toString());
      }
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath + '?' + queryJoiner.toString()));
    } else {
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));
    }

    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Get Account Balance History
   * Get Account Balance History List from API 
   * @param page  (optional)
   * @param filter  (optional)
   * @return UnitAccountBalanceHistoryResponse
   * @throws ApiException if fails to make API call
   */
  public UnitAccountBalanceHistoryResponse getAccountBalanceHistory(ListPageParameters page, GetAccountBalanceHistoryFilterParameter filter) throws ApiException {
    ApiResponse<UnitAccountBalanceHistoryResponse> localVarResponse = getAccountBalanceHistoryWithHttpInfo(page, filter);
    return localVarResponse.getData();
  }

  /**
   * Get Account Balance History
   * Get Account Balance History List from API 
   * @param page  (optional)
   * @param filter  (optional)
   * @return ApiResponse&lt;UnitAccountBalanceHistoryResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitAccountBalanceHistoryResponse> getAccountBalanceHistoryWithHttpInfo(ListPageParameters page, GetAccountBalanceHistoryFilterParameter filter) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = getAccountBalanceHistoryRequestBuilder(page, filter);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("getAccountBalanceHistory", localVarResponse);
        }
        return new ApiResponse<UnitAccountBalanceHistoryResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitAccountBalanceHistoryResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder getAccountBalanceHistoryRequestBuilder(ListPageParameters page, GetAccountBalanceHistoryFilterParameter filter) throws ApiException {

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/account-end-of-day";

    List<Pair> localVarQueryParams = new ArrayList<>();
    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    localVarQueryParameterBaseName = "page";
    if (page != null) {
      String queryString = page.toUrlQueryString("page");
      if (!queryString.isBlank()) {
        localVarQueryStringJoiner.add(queryString);
      }
    }
    localVarQueryParameterBaseName = "filter";
    if (filter != null) {
      String queryString = filter.toUrlQueryString("filter");
      if (!queryString.isBlank()) {
        localVarQueryStringJoiner.add(queryString);
      }
    }

    if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
      StringJoiner queryJoiner = new StringJoiner("&");
      localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + '=' + p.getValue()));
      if (localVarQueryStringJoiner.length() != 0) {
        queryJoiner.add(localVarQueryStringJoiner.toString());
      }
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath + '?' + queryJoiner.toString()));
    } else {
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));
    }

    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Get Account Limits by Id
   * Get Account Limits from API 
   * @param accountId ID of the account to get (required)
   * @return UnitGetAccountLimitsResponse
   * @throws ApiException if fails to make API call
   */
  public UnitGetAccountLimitsResponse getAccountLimits(String accountId) throws ApiException {
    ApiResponse<UnitGetAccountLimitsResponse> localVarResponse = getAccountLimitsWithHttpInfo(accountId);
    return localVarResponse.getData();
  }

  /**
   * Get Account Limits by Id
   * Get Account Limits from API 
   * @param accountId ID of the account to get (required)
   * @return ApiResponse&lt;UnitGetAccountLimitsResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitGetAccountLimitsResponse> getAccountLimitsWithHttpInfo(String accountId) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = getAccountLimitsRequestBuilder(accountId);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("getAccountLimits", localVarResponse);
        }
        return new ApiResponse<UnitGetAccountLimitsResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitGetAccountLimitsResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder getAccountLimitsRequestBuilder(String accountId) throws ApiException {
    // verify the required parameter 'accountId' is set
    if (accountId == null) {
      throw new ApiException(400, "Missing the required parameter 'accountId' when calling getAccountLimits");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/accounts/{accountId}/limits"
        .replace("{accountId}", ApiClient.urlEncode(accountId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Get List Accounts
   * Get List Accounts from API 
   * @param page  (optional)
   * @param filter  (optional)
   * @param include  (optional)
   * @return UnitAccountsListResponse
   * @throws ApiException if fails to make API call
   */
  public UnitAccountsListResponse getAccountsList(ListPageParameters page, GetAccountsListFilterParameter filter, String include) throws ApiException {
    ApiResponse<UnitAccountsListResponse> localVarResponse = getAccountsListWithHttpInfo(page, filter, include);
    return localVarResponse.getData();
  }

  /**
   * Get List Accounts
   * Get List Accounts from API 
   * @param page  (optional)
   * @param filter  (optional)
   * @param include  (optional)
   * @return ApiResponse&lt;UnitAccountsListResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitAccountsListResponse> getAccountsListWithHttpInfo(ListPageParameters page, GetAccountsListFilterParameter filter, String include) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = getAccountsListRequestBuilder(page, filter, include);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("getAccountsList", localVarResponse);
        }
        return new ApiResponse<UnitAccountsListResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitAccountsListResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder getAccountsListRequestBuilder(ListPageParameters page, GetAccountsListFilterParameter filter, String include) throws ApiException {

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/accounts";

    List<Pair> localVarQueryParams = new ArrayList<>();
    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    localVarQueryParameterBaseName = "page";
    if (page != null) {
      String queryString = page.toUrlQueryString("page");
      if (!queryString.isBlank()) {
        localVarQueryStringJoiner.add(queryString);
      }
    }
    localVarQueryParameterBaseName = "filter";
    if (filter != null) {
      String queryString = filter.toUrlQueryString("filter");
      if (!queryString.isBlank()) {
        localVarQueryStringJoiner.add(queryString);
      }
    }
    localVarQueryParameterBaseName = "include";
    localVarQueryParams.addAll(ApiClient.parameterToPairs("include", include));

    if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
      StringJoiner queryJoiner = new StringJoiner("&");
      localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + '=' + p.getValue()));
      if (localVarQueryStringJoiner.length() != 0) {
        queryJoiner.add(localVarQueryStringJoiner.toString());
      }
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath + '?' + queryJoiner.toString()));
    } else {
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));
    }

    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Get List Org API Tokens
   * Get List Org API Tokens from API 
   * @param userId ID of the user to revoke token (required)
   * @return UnitOrgApiTokensListResponse
   * @throws ApiException if fails to make API call
   */
  public UnitOrgApiTokensListResponse getApiTokensList(String userId) throws ApiException {
    ApiResponse<UnitOrgApiTokensListResponse> localVarResponse = getApiTokensListWithHttpInfo(userId);
    return localVarResponse.getData();
  }

  /**
   * Get List Org API Tokens
   * Get List Org API Tokens from API 
   * @param userId ID of the user to revoke token (required)
   * @return ApiResponse&lt;UnitOrgApiTokensListResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitOrgApiTokensListResponse> getApiTokensListWithHttpInfo(String userId) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = getApiTokensListRequestBuilder(userId);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("getApiTokensList", localVarResponse);
        }
        return new ApiResponse<UnitOrgApiTokensListResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitOrgApiTokensListResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder getApiTokensListRequestBuilder(String userId) throws ApiException {
    // verify the required parameter 'userId' is set
    if (userId == null) {
      throw new ApiException(400, "Missing the required parameter 'userId' when calling getApiTokensList");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/users/{userId}/api-tokens"
        .replace("{userId}", ApiClient.urlEncode(userId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Get Application by Id
   * Get an Application from API 
   * @param applicationId ID of the application to get (required)
   * @param included  (optional)
   * @return UnitApplicationResponseWithIncluded
   * @throws ApiException if fails to make API call
   */
  public UnitApplicationResponseWithIncluded getApplication(String applicationId, String included) throws ApiException {
    ApiResponse<UnitApplicationResponseWithIncluded> localVarResponse = getApplicationWithHttpInfo(applicationId, included);
    return localVarResponse.getData();
  }

  /**
   * Get Application by Id
   * Get an Application from API 
   * @param applicationId ID of the application to get (required)
   * @param included  (optional)
   * @return ApiResponse&lt;UnitApplicationResponseWithIncluded&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitApplicationResponseWithIncluded> getApplicationWithHttpInfo(String applicationId, String included) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = getApplicationRequestBuilder(applicationId, included);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("getApplication", localVarResponse);
        }
        return new ApiResponse<UnitApplicationResponseWithIncluded>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitApplicationResponseWithIncluded>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder getApplicationRequestBuilder(String applicationId, String included) throws ApiException {
    // verify the required parameter 'applicationId' is set
    if (applicationId == null) {
      throw new ApiException(400, "Missing the required parameter 'applicationId' when calling getApplication");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/applications/{applicationId}"
        .replace("{applicationId}", ApiClient.urlEncode(applicationId.toString()));

    List<Pair> localVarQueryParams = new ArrayList<>();
    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    localVarQueryParameterBaseName = "included";
    localVarQueryParams.addAll(ApiClient.parameterToPairs("included", included));

    if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
      StringJoiner queryJoiner = new StringJoiner("&");
      localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + '=' + p.getValue()));
      if (localVarQueryStringJoiner.length() != 0) {
        queryJoiner.add(localVarQueryStringJoiner.toString());
      }
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath + '?' + queryJoiner.toString()));
    } else {
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));
    }

    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Get List of Documents
   * Get List of Documents via API 
   * @param applicationId ID of the application to get documents for (required)
   * @return UnitListDocumentsResponse
   * @throws ApiException if fails to make API call
   */
  public UnitListDocumentsResponse getApplicationDocuments(String applicationId) throws ApiException {
    ApiResponse<UnitListDocumentsResponse> localVarResponse = getApplicationDocumentsWithHttpInfo(applicationId);
    return localVarResponse.getData();
  }

  /**
   * Get List of Documents
   * Get List of Documents via API 
   * @param applicationId ID of the application to get documents for (required)
   * @return ApiResponse&lt;UnitListDocumentsResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitListDocumentsResponse> getApplicationDocumentsWithHttpInfo(String applicationId) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = getApplicationDocumentsRequestBuilder(applicationId);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("getApplicationDocuments", localVarResponse);
        }
        return new ApiResponse<UnitListDocumentsResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitListDocumentsResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder getApplicationDocumentsRequestBuilder(String applicationId) throws ApiException {
    // verify the required parameter 'applicationId' is set
    if (applicationId == null) {
      throw new ApiException(400, "Missing the required parameter 'applicationId' when calling getApplicationDocuments");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/applications/{applicationId}/documents"
        .replace("{applicationId}", ApiClient.urlEncode(applicationId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Get ApplicationForm by Id
   * Get an Application Form from API 
   * @param applicationFormId ID of the application form to get (required)
   * @param included  (optional)
   * @return UnitApplicationFormResponseWithIncluded
   * @throws ApiException if fails to make API call
   */
  public UnitApplicationFormResponseWithIncluded getApplicationForm(String applicationFormId, String included) throws ApiException {
    ApiResponse<UnitApplicationFormResponseWithIncluded> localVarResponse = getApplicationFormWithHttpInfo(applicationFormId, included);
    return localVarResponse.getData();
  }

  /**
   * Get ApplicationForm by Id
   * Get an Application Form from API 
   * @param applicationFormId ID of the application form to get (required)
   * @param included  (optional)
   * @return ApiResponse&lt;UnitApplicationFormResponseWithIncluded&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitApplicationFormResponseWithIncluded> getApplicationFormWithHttpInfo(String applicationFormId, String included) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = getApplicationFormRequestBuilder(applicationFormId, included);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("getApplicationForm", localVarResponse);
        }
        return new ApiResponse<UnitApplicationFormResponseWithIncluded>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitApplicationFormResponseWithIncluded>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder getApplicationFormRequestBuilder(String applicationFormId, String included) throws ApiException {
    // verify the required parameter 'applicationFormId' is set
    if (applicationFormId == null) {
      throw new ApiException(400, "Missing the required parameter 'applicationFormId' when calling getApplicationForm");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/application-forms/{applicationFormId}"
        .replace("{applicationFormId}", ApiClient.urlEncode(applicationFormId.toString()));

    List<Pair> localVarQueryParams = new ArrayList<>();
    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    localVarQueryParameterBaseName = "included";
    localVarQueryParams.addAll(ApiClient.parameterToPairs("included", included));

    if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
      StringJoiner queryJoiner = new StringJoiner("&");
      localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + '=' + p.getValue()));
      if (localVarQueryStringJoiner.length() != 0) {
        queryJoiner.add(localVarQueryStringJoiner.toString());
      }
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath + '?' + queryJoiner.toString()));
    } else {
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));
    }

    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Get List Application Forms
   * Get List Application Forms from API 
   * @param page  (optional)
   * @param filter  (optional)
   * @param sort  (optional)
   * @return UnitApplicationFormsListResponse
   * @throws ApiException if fails to make API call
   */
  public UnitApplicationFormsListResponse getApplicationFormsList(ListPageParameters page, GetApplicationFormsListFilterParameter filter, String sort) throws ApiException {
    ApiResponse<UnitApplicationFormsListResponse> localVarResponse = getApplicationFormsListWithHttpInfo(page, filter, sort);
    return localVarResponse.getData();
  }

  /**
   * Get List Application Forms
   * Get List Application Forms from API 
   * @param page  (optional)
   * @param filter  (optional)
   * @param sort  (optional)
   * @return ApiResponse&lt;UnitApplicationFormsListResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitApplicationFormsListResponse> getApplicationFormsListWithHttpInfo(ListPageParameters page, GetApplicationFormsListFilterParameter filter, String sort) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = getApplicationFormsListRequestBuilder(page, filter, sort);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("getApplicationFormsList", localVarResponse);
        }
        return new ApiResponse<UnitApplicationFormsListResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitApplicationFormsListResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder getApplicationFormsListRequestBuilder(ListPageParameters page, GetApplicationFormsListFilterParameter filter, String sort) throws ApiException {

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/application-forms";

    List<Pair> localVarQueryParams = new ArrayList<>();
    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    localVarQueryParameterBaseName = "page";
    if (page != null) {
      String queryString = page.toUrlQueryString("page");
      if (!queryString.isBlank()) {
        localVarQueryStringJoiner.add(queryString);
      }
    }
    localVarQueryParameterBaseName = "filter";
    if (filter != null) {
      String queryString = filter.toUrlQueryString("filter");
      if (!queryString.isBlank()) {
        localVarQueryStringJoiner.add(queryString);
      }
    }
    localVarQueryParameterBaseName = "sort";
    localVarQueryParams.addAll(ApiClient.parameterToPairs("sort", sort));

    if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
      StringJoiner queryJoiner = new StringJoiner("&");
      localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + '=' + p.getValue()));
      if (localVarQueryStringJoiner.length() != 0) {
        queryJoiner.add(localVarQueryStringJoiner.toString());
      }
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath + '?' + queryJoiner.toString()));
    } else {
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));
    }

    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Get List Application
   * Get List Applications from API 
   * @param page  (optional)
   * @param filter  (optional)
   * @param sort  (optional)
   * @return UnitListApplicationsResponse
   * @throws ApiException if fails to make API call
   */
  public UnitListApplicationsResponse getApplicationsList(ListPageParameters page, GetApplicationsListFilterParameter filter, String sort) throws ApiException {
    ApiResponse<UnitListApplicationsResponse> localVarResponse = getApplicationsListWithHttpInfo(page, filter, sort);
    return localVarResponse.getData();
  }

  /**
   * Get List Application
   * Get List Applications from API 
   * @param page  (optional)
   * @param filter  (optional)
   * @param sort  (optional)
   * @return ApiResponse&lt;UnitListApplicationsResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitListApplicationsResponse> getApplicationsListWithHttpInfo(ListPageParameters page, GetApplicationsListFilterParameter filter, String sort) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = getApplicationsListRequestBuilder(page, filter, sort);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("getApplicationsList", localVarResponse);
        }
        return new ApiResponse<UnitListApplicationsResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitListApplicationsResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder getApplicationsListRequestBuilder(ListPageParameters page, GetApplicationsListFilterParameter filter, String sort) throws ApiException {

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/applications";

    List<Pair> localVarQueryParams = new ArrayList<>();
    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    localVarQueryParameterBaseName = "page";
    if (page != null) {
      String queryString = page.toUrlQueryString("page");
      if (!queryString.isBlank()) {
        localVarQueryStringJoiner.add(queryString);
      }
    }
    localVarQueryParameterBaseName = "filter";
    if (filter != null) {
      String queryString = filter.toUrlQueryString("filter");
      if (!queryString.isBlank()) {
        localVarQueryStringJoiner.add(queryString);
      }
    }
    localVarQueryParameterBaseName = "sort";
    localVarQueryParams.addAll(ApiClient.parameterToPairs("sort", sort));

    if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
      StringJoiner queryJoiner = new StringJoiner("&");
      localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + '=' + p.getValue()));
      if (localVarQueryStringJoiner.length() != 0) {
        queryJoiner.add(localVarQueryStringJoiner.toString());
      }
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath + '?' + queryJoiner.toString()));
    } else {
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));
    }

    localVarRequestBuilder.header("Accept", "application/vnd.api+json, application/vnd.api+json; charset=utf-8");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Get List of ATM Locations
   * Get List ATM Locations from API 
   * @param filter  (optional)
   * @return List&lt;AtmLocation&gt;
   * @throws ApiException if fails to make API call
   */
  public List<AtmLocation> getAtmLocationsList(GetAtmLocationsListFilterParameter filter) throws ApiException {
    ApiResponse<List<AtmLocation>> localVarResponse = getAtmLocationsListWithHttpInfo(filter);
    return localVarResponse.getData();
  }

  /**
   * Get List of ATM Locations
   * Get List ATM Locations from API 
   * @param filter  (optional)
   * @return ApiResponse&lt;List&lt;AtmLocation&gt;&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<List<AtmLocation>> getAtmLocationsListWithHttpInfo(GetAtmLocationsListFilterParameter filter) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = getAtmLocationsListRequestBuilder(filter);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("getAtmLocationsList", localVarResponse);
        }
        return new ApiResponse<List<AtmLocation>>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<List<AtmLocation>>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder getAtmLocationsListRequestBuilder(GetAtmLocationsListFilterParameter filter) throws ApiException {

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/atm-locations";

    List<Pair> localVarQueryParams = new ArrayList<>();
    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    localVarQueryParameterBaseName = "filter";
    if (filter != null) {
      String queryString = filter.toUrlQueryString("filter");
      if (!queryString.isBlank()) {
        localVarQueryStringJoiner.add(queryString);
      }
    }

    if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
      StringJoiner queryJoiner = new StringJoiner("&");
      localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + '=' + p.getValue()));
      if (localVarQueryStringJoiner.length() != 0) {
        queryJoiner.add(localVarQueryStringJoiner.toString());
      }
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath + '?' + queryJoiner.toString()));
    } else {
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));
    }

    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Get Authorization by Id
   * Get a Authorization from API 
   * @param authorizationId ID of the authorization to get (required)
   * @param includeNoneAuthorized  (optional)
   * @return UnitAuthorizationResponse
   * @throws ApiException if fails to make API call
   */
  public UnitAuthorizationResponse getAuthorization(String authorizationId, Boolean includeNoneAuthorized) throws ApiException {
    ApiResponse<UnitAuthorizationResponse> localVarResponse = getAuthorizationWithHttpInfo(authorizationId, includeNoneAuthorized);
    return localVarResponse.getData();
  }

  /**
   * Get Authorization by Id
   * Get a Authorization from API 
   * @param authorizationId ID of the authorization to get (required)
   * @param includeNoneAuthorized  (optional)
   * @return ApiResponse&lt;UnitAuthorizationResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitAuthorizationResponse> getAuthorizationWithHttpInfo(String authorizationId, Boolean includeNoneAuthorized) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = getAuthorizationRequestBuilder(authorizationId, includeNoneAuthorized);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("getAuthorization", localVarResponse);
        }
        return new ApiResponse<UnitAuthorizationResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitAuthorizationResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder getAuthorizationRequestBuilder(String authorizationId, Boolean includeNoneAuthorized) throws ApiException {
    // verify the required parameter 'authorizationId' is set
    if (authorizationId == null) {
      throw new ApiException(400, "Missing the required parameter 'authorizationId' when calling getAuthorization");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/authorizations/{authorizationId}"
        .replace("{authorizationId}", ApiClient.urlEncode(authorizationId.toString()));

    List<Pair> localVarQueryParams = new ArrayList<>();
    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    localVarQueryParameterBaseName = "includeNoneAuthorized";
    localVarQueryParams.addAll(ApiClient.parameterToPairs("includeNoneAuthorized", includeNoneAuthorized));

    if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
      StringJoiner queryJoiner = new StringJoiner("&");
      localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + '=' + p.getValue()));
      if (localVarQueryStringJoiner.length() != 0) {
        queryJoiner.add(localVarQueryStringJoiner.toString());
      }
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath + '?' + queryJoiner.toString()));
    } else {
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));
    }

    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Get Authorization Request by Id
   * Get a Authorization Request from API 
   * @param authorizationId ID of the authorization request to get (required)
   * @return UnitAuthorizationRequestsResponse
   * @throws ApiException if fails to make API call
   */
  public UnitAuthorizationRequestsResponse getAuthorizationRequest(String authorizationId) throws ApiException {
    ApiResponse<UnitAuthorizationRequestsResponse> localVarResponse = getAuthorizationRequestWithHttpInfo(authorizationId);
    return localVarResponse.getData();
  }

  /**
   * Get Authorization Request by Id
   * Get a Authorization Request from API 
   * @param authorizationId ID of the authorization request to get (required)
   * @return ApiResponse&lt;UnitAuthorizationRequestsResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitAuthorizationRequestsResponse> getAuthorizationRequestWithHttpInfo(String authorizationId) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = getAuthorizationRequestRequestBuilder(authorizationId);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("getAuthorizationRequest", localVarResponse);
        }
        return new ApiResponse<UnitAuthorizationRequestsResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitAuthorizationRequestsResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder getAuthorizationRequestRequestBuilder(String authorizationId) throws ApiException {
    // verify the required parameter 'authorizationId' is set
    if (authorizationId == null) {
      throw new ApiException(400, "Missing the required parameter 'authorizationId' when calling getAuthorizationRequest");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/authorization-requests/{authorizationId}"
        .replace("{authorizationId}", ApiClient.urlEncode(authorizationId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Get List Authorization Requests
   * Get List Authorization Requests from API 
   * @param page  (optional)
   * @param filter  (optional)
   * @return UnitListAuthorizationRequestsResponse
   * @throws ApiException if fails to make API call
   */
  public UnitListAuthorizationRequestsResponse getAuthorizationRequestsList(ListPageParameters page, GetAuthorizationRequestsListFilterParameter filter) throws ApiException {
    ApiResponse<UnitListAuthorizationRequestsResponse> localVarResponse = getAuthorizationRequestsListWithHttpInfo(page, filter);
    return localVarResponse.getData();
  }

  /**
   * Get List Authorization Requests
   * Get List Authorization Requests from API 
   * @param page  (optional)
   * @param filter  (optional)
   * @return ApiResponse&lt;UnitListAuthorizationRequestsResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitListAuthorizationRequestsResponse> getAuthorizationRequestsListWithHttpInfo(ListPageParameters page, GetAuthorizationRequestsListFilterParameter filter) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = getAuthorizationRequestsListRequestBuilder(page, filter);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("getAuthorizationRequestsList", localVarResponse);
        }
        return new ApiResponse<UnitListAuthorizationRequestsResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitListAuthorizationRequestsResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder getAuthorizationRequestsListRequestBuilder(ListPageParameters page, GetAuthorizationRequestsListFilterParameter filter) throws ApiException {

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/authorization-requests";

    List<Pair> localVarQueryParams = new ArrayList<>();
    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    localVarQueryParameterBaseName = "page";
    if (page != null) {
      String queryString = page.toUrlQueryString("page");
      if (!queryString.isBlank()) {
        localVarQueryStringJoiner.add(queryString);
      }
    }
    localVarQueryParameterBaseName = "filter";
    if (filter != null) {
      String queryString = filter.toUrlQueryString("filter");
      if (!queryString.isBlank()) {
        localVarQueryStringJoiner.add(queryString);
      }
    }

    if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
      StringJoiner queryJoiner = new StringJoiner("&");
      localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + '=' + p.getValue()));
      if (localVarQueryStringJoiner.length() != 0) {
        queryJoiner.add(localVarQueryStringJoiner.toString());
      }
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath + '?' + queryJoiner.toString()));
    } else {
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));
    }

    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Get List authorizations
   * Get List Authorizations from API 
   * @param page  (optional)
   * @param filter  (optional)
   * @param sort  (optional)
   * @return UnitListAuthorizationsResponse
   * @throws ApiException if fails to make API call
   */
  public UnitListAuthorizationsResponse getAuthorizationsList(ListPageParameters page, GetAuthorizationsListFilterParameter filter, String sort) throws ApiException {
    ApiResponse<UnitListAuthorizationsResponse> localVarResponse = getAuthorizationsListWithHttpInfo(page, filter, sort);
    return localVarResponse.getData();
  }

  /**
   * Get List authorizations
   * Get List Authorizations from API 
   * @param page  (optional)
   * @param filter  (optional)
   * @param sort  (optional)
   * @return ApiResponse&lt;UnitListAuthorizationsResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitListAuthorizationsResponse> getAuthorizationsListWithHttpInfo(ListPageParameters page, GetAuthorizationsListFilterParameter filter, String sort) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = getAuthorizationsListRequestBuilder(page, filter, sort);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("getAuthorizationsList", localVarResponse);
        }
        return new ApiResponse<UnitListAuthorizationsResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitListAuthorizationsResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder getAuthorizationsListRequestBuilder(ListPageParameters page, GetAuthorizationsListFilterParameter filter, String sort) throws ApiException {

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/authorizations";

    List<Pair> localVarQueryParams = new ArrayList<>();
    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    localVarQueryParameterBaseName = "page";
    if (page != null) {
      String queryString = page.toUrlQueryString("page");
      if (!queryString.isBlank()) {
        localVarQueryStringJoiner.add(queryString);
      }
    }
    localVarQueryParameterBaseName = "filter";
    if (filter != null) {
      String queryString = filter.toUrlQueryString("filter");
      if (!queryString.isBlank()) {
        localVarQueryStringJoiner.add(queryString);
      }
    }
    localVarQueryParameterBaseName = "sort";
    localVarQueryParams.addAll(ApiClient.parameterToPairs("sort", sort));

    if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
      StringJoiner queryJoiner = new StringJoiner("&");
      localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + '=' + p.getValue()));
      if (localVarQueryStringJoiner.length() != 0) {
        queryJoiner.add(localVarQueryStringJoiner.toString());
      }
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath + '?' + queryJoiner.toString()));
    } else {
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));
    }

    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Get Back Check Deposit Image by Id
   * Get Back Check Deposit Image from API 
   * @param checkDepositId ID of the check deposit to get (required)
   * @return UnitBackCheckDepositResponse
   * @throws ApiException if fails to make API call
   */
  public UnitBackCheckDepositResponse getBackCheckDeposit(String checkDepositId) throws ApiException {
    ApiResponse<UnitBackCheckDepositResponse> localVarResponse = getBackCheckDepositWithHttpInfo(checkDepositId);
    return localVarResponse.getData();
  }

  /**
   * Get Back Check Deposit Image by Id
   * Get Back Check Deposit Image from API 
   * @param checkDepositId ID of the check deposit to get (required)
   * @return ApiResponse&lt;UnitBackCheckDepositResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitBackCheckDepositResponse> getBackCheckDepositWithHttpInfo(String checkDepositId) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = getBackCheckDepositRequestBuilder(checkDepositId);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("getBackCheckDeposit", localVarResponse);
        }
        return new ApiResponse<UnitBackCheckDepositResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitBackCheckDepositResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder getBackCheckDepositRequestBuilder(String checkDepositId) throws ApiException {
    // verify the required parameter 'checkDepositId' is set
    if (checkDepositId == null) {
      throw new ApiException(400, "Missing the required parameter 'checkDepositId' when calling getBackCheckDeposit");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/check-deposits/{checkDepositId}/back"
        .replace("{checkDepositId}", ApiClient.urlEncode(checkDepositId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Get Barcode Image By Barcode Number
   * Get Barcode Image By Barcode Number from API 
   * @param barcodeNumber  (required)
   * @return File
   * @throws ApiException if fails to make API call
   */
  public InputStream getBarcodeImage(String barcodeNumber) throws ApiException {
    ApiResponse<InputStream> localVarResponse = getBarcodeImageWithHttpInfo(barcodeNumber);
    return localVarResponse.getData();
  }

  /**
   * Get Barcode Image By Barcode Number
   * Get Barcode Image By Barcode Number from API 
   * @param barcodeNumber  (required)
   * @return ApiResponse&lt;File&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<InputStream> getBarcodeImageWithHttpInfo(String barcodeNumber) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = getBarcodeImageRequestBuilder(barcodeNumber);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("getBarcodeImage", localVarResponse);
        }
        return new ApiResponse<InputStream>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : localVarResponse.body()
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder getBarcodeImageRequestBuilder(String barcodeNumber) throws ApiException {
    // verify the required parameter 'barcodeNumber' is set
    if (barcodeNumber == null) {
      throw new ApiException(400, "Missing the required parameter 'barcodeNumber' when calling getBarcodeImage");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/cash-deposits/barcodes/{barcodeNumber}/image"
        .replace("{barcodeNumber}", ApiClient.urlEncode(barcodeNumber.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Accept", "image/png");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Get Card by Id
   * Get a Card from API 
   * @param cardId ID of the card to get (required)
   * @param included  (optional)
   * @return UnitCardResponseWithIncluded
   * @throws ApiException if fails to make API call
   */
  public UnitCardResponseWithIncluded getCard(String cardId, String included) throws ApiException {
    ApiResponse<UnitCardResponseWithIncluded> localVarResponse = getCardWithHttpInfo(cardId, included);
    return localVarResponse.getData();
  }

  /**
   * Get Card by Id
   * Get a Card from API 
   * @param cardId ID of the card to get (required)
   * @param included  (optional)
   * @return ApiResponse&lt;UnitCardResponseWithIncluded&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitCardResponseWithIncluded> getCardWithHttpInfo(String cardId, String included) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = getCardRequestBuilder(cardId, included);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("getCard", localVarResponse);
        }
        return new ApiResponse<UnitCardResponseWithIncluded>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitCardResponseWithIncluded>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder getCardRequestBuilder(String cardId, String included) throws ApiException {
    // verify the required parameter 'cardId' is set
    if (cardId == null) {
      throw new ApiException(400, "Missing the required parameter 'cardId' when calling getCard");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/cards/{cardId}"
        .replace("{cardId}", ApiClient.urlEncode(cardId.toString()));

    List<Pair> localVarQueryParams = new ArrayList<>();
    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    localVarQueryParameterBaseName = "included";
    localVarQueryParams.addAll(ApiClient.parameterToPairs("included", included));

    if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
      StringJoiner queryJoiner = new StringJoiner("&");
      localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + '=' + p.getValue()));
      if (localVarQueryStringJoiner.length() != 0) {
        queryJoiner.add(localVarQueryStringJoiner.toString());
      }
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath + '?' + queryJoiner.toString()));
    } else {
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));
    }

    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Get Card Limit by Id
   * Get a Card Limits from API 
   * @param cardId ID of the card to get (required)
   * @return UnitCardLimitsResponse
   * @throws ApiException if fails to make API call
   */
  public UnitCardLimitsResponse getCardLimits(String cardId) throws ApiException {
    ApiResponse<UnitCardLimitsResponse> localVarResponse = getCardLimitsWithHttpInfo(cardId);
    return localVarResponse.getData();
  }

  /**
   * Get Card Limit by Id
   * Get a Card Limits from API 
   * @param cardId ID of the card to get (required)
   * @return ApiResponse&lt;UnitCardLimitsResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitCardLimitsResponse> getCardLimitsWithHttpInfo(String cardId) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = getCardLimitsRequestBuilder(cardId);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("getCardLimits", localVarResponse);
        }
        return new ApiResponse<UnitCardLimitsResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitCardLimitsResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder getCardLimitsRequestBuilder(String cardId) throws ApiException {
    // verify the required parameter 'cardId' is set
    if (cardId == null) {
      throw new ApiException(400, "Missing the required parameter 'cardId' when calling getCardLimits");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/cards/{cardId}/limits"
        .replace("{cardId}", ApiClient.urlEncode(cardId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Get Card PIN Status
   * Get Card PIN Status via API 
   * @param cardId ID of the card to get PIN status (required)
   * @return UnitPinStatusResponse
   * @throws ApiException if fails to make API call
   */
  public UnitPinStatusResponse getCardPinStatus(String cardId) throws ApiException {
    ApiResponse<UnitPinStatusResponse> localVarResponse = getCardPinStatusWithHttpInfo(cardId);
    return localVarResponse.getData();
  }

  /**
   * Get Card PIN Status
   * Get Card PIN Status via API 
   * @param cardId ID of the card to get PIN status (required)
   * @return ApiResponse&lt;UnitPinStatusResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitPinStatusResponse> getCardPinStatusWithHttpInfo(String cardId) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = getCardPinStatusRequestBuilder(cardId);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("getCardPinStatus", localVarResponse);
        }
        return new ApiResponse<UnitPinStatusResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitPinStatusResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder getCardPinStatusRequestBuilder(String cardId) throws ApiException {
    // verify the required parameter 'cardId' is set
    if (cardId == null) {
      throw new ApiException(400, "Missing the required parameter 'cardId' when calling getCardPinStatus");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/cards/{cardId}/secure-data/pin/status"
        .replace("{cardId}", ApiClient.urlEncode(cardId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Get List of Cards
   * Get List of Cards from API 
   * @param page  (optional)
   * @param filter  (optional)
   * @param include  (optional)
   * @param sort  (optional)
   * @return UnitCardsListReponse
   * @throws ApiException if fails to make API call
   */
  public UnitCardsListReponse getCardsList(ListPageParameters page, GetCardsListFilterParameter filter, String include, String sort) throws ApiException {
    ApiResponse<UnitCardsListReponse> localVarResponse = getCardsListWithHttpInfo(page, filter, include, sort);
    return localVarResponse.getData();
  }

  /**
   * Get List of Cards
   * Get List of Cards from API 
   * @param page  (optional)
   * @param filter  (optional)
   * @param include  (optional)
   * @param sort  (optional)
   * @return ApiResponse&lt;UnitCardsListReponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitCardsListReponse> getCardsListWithHttpInfo(ListPageParameters page, GetCardsListFilterParameter filter, String include, String sort) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = getCardsListRequestBuilder(page, filter, include, sort);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("getCardsList", localVarResponse);
        }
        return new ApiResponse<UnitCardsListReponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitCardsListReponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder getCardsListRequestBuilder(ListPageParameters page, GetCardsListFilterParameter filter, String include, String sort) throws ApiException {

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/cards";

    List<Pair> localVarQueryParams = new ArrayList<>();
    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    localVarQueryParameterBaseName = "page";
    if (page != null) {
      String queryString = page.toUrlQueryString("page");
      if (!queryString.isBlank()) {
        localVarQueryStringJoiner.add(queryString);
      }
    }
    localVarQueryParameterBaseName = "filter";
    if (filter != null) {
      String queryString = filter.toUrlQueryString("filter");
      if (!queryString.isBlank()) {
        localVarQueryStringJoiner.add(queryString);
      }
    }
    localVarQueryParameterBaseName = "include";
    localVarQueryParams.addAll(ApiClient.parameterToPairs("include", include));
    localVarQueryParameterBaseName = "sort";
    localVarQueryParams.addAll(ApiClient.parameterToPairs("sort", sort));

    if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
      StringJoiner queryJoiner = new StringJoiner("&");
      localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + '=' + p.getValue()));
      if (localVarQueryStringJoiner.length() != 0) {
        queryJoiner.add(localVarQueryStringJoiner.toString());
      }
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath + '?' + queryJoiner.toString()));
    } else {
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));
    }

    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Get Cash Deposit Store Locations List By Coordinates
   * Get Cash Deposit Store Locations List By Coordinates from API 
   * @param page  (optional)
   * @param filter  (optional)
   * @return UnitStoreLocationsListResponse
   * @throws ApiException if fails to make API call
   */
  public UnitStoreLocationsListResponse getCashDepositStoreLocationsList(ListPageParameters page, GetCashDepositStoreLocationsListFilterParameter filter) throws ApiException {
    ApiResponse<UnitStoreLocationsListResponse> localVarResponse = getCashDepositStoreLocationsListWithHttpInfo(page, filter);
    return localVarResponse.getData();
  }

  /**
   * Get Cash Deposit Store Locations List By Coordinates
   * Get Cash Deposit Store Locations List By Coordinates from API 
   * @param page  (optional)
   * @param filter  (optional)
   * @return ApiResponse&lt;UnitStoreLocationsListResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitStoreLocationsListResponse> getCashDepositStoreLocationsListWithHttpInfo(ListPageParameters page, GetCashDepositStoreLocationsListFilterParameter filter) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = getCashDepositStoreLocationsListRequestBuilder(page, filter);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("getCashDepositStoreLocationsList", localVarResponse);
        }
        return new ApiResponse<UnitStoreLocationsListResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitStoreLocationsListResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder getCashDepositStoreLocationsListRequestBuilder(ListPageParameters page, GetCashDepositStoreLocationsListFilterParameter filter) throws ApiException {

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/store-locations";

    List<Pair> localVarQueryParams = new ArrayList<>();
    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    localVarQueryParameterBaseName = "page";
    if (page != null) {
      String queryString = page.toUrlQueryString("page");
      if (!queryString.isBlank()) {
        localVarQueryStringJoiner.add(queryString);
      }
    }
    localVarQueryParameterBaseName = "filter";
    if (filter != null) {
      String queryString = filter.toUrlQueryString("filter");
      if (!queryString.isBlank()) {
        localVarQueryStringJoiner.add(queryString);
      }
    }

    if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
      StringJoiner queryJoiner = new StringJoiner("&");
      localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + '=' + p.getValue()));
      if (localVarQueryStringJoiner.length() != 0) {
        queryJoiner.add(localVarQueryStringJoiner.toString());
      }
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath + '?' + queryJoiner.toString()));
    } else {
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));
    }

    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Get Check Deposit by Id
   * Get a Check Deposit from API 
   * @param checkDepositId ID of the check deposit to get (required)
   * @return UnitCheckDepositResponse
   * @throws ApiException if fails to make API call
   */
  public UnitCheckDepositResponse getCheckDeposit(String checkDepositId) throws ApiException {
    ApiResponse<UnitCheckDepositResponse> localVarResponse = getCheckDepositWithHttpInfo(checkDepositId);
    return localVarResponse.getData();
  }

  /**
   * Get Check Deposit by Id
   * Get a Check Deposit from API 
   * @param checkDepositId ID of the check deposit to get (required)
   * @return ApiResponse&lt;UnitCheckDepositResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitCheckDepositResponse> getCheckDepositWithHttpInfo(String checkDepositId) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = getCheckDepositRequestBuilder(checkDepositId);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("getCheckDeposit", localVarResponse);
        }
        return new ApiResponse<UnitCheckDepositResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitCheckDepositResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder getCheckDepositRequestBuilder(String checkDepositId) throws ApiException {
    // verify the required parameter 'checkDepositId' is set
    if (checkDepositId == null) {
      throw new ApiException(400, "Missing the required parameter 'checkDepositId' when calling getCheckDeposit");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/check-deposits/{checkDepositId}"
        .replace("{checkDepositId}", ApiClient.urlEncode(checkDepositId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Get List Check Deposits
   * Get List Check Deposits from API 
   * @param page  (optional)
   * @param filter  (optional)
   * @param sort  (optional)
   * @param include  (optional)
   * @return UnitListCheckDepositResponse
   * @throws ApiException if fails to make API call
   */
  public UnitListCheckDepositResponse getCheckDepositsList(ListPageParameters page, GetCheckDepositsListFilterParameter filter, String sort, String include) throws ApiException {
    ApiResponse<UnitListCheckDepositResponse> localVarResponse = getCheckDepositsListWithHttpInfo(page, filter, sort, include);
    return localVarResponse.getData();
  }

  /**
   * Get List Check Deposits
   * Get List Check Deposits from API 
   * @param page  (optional)
   * @param filter  (optional)
   * @param sort  (optional)
   * @param include  (optional)
   * @return ApiResponse&lt;UnitListCheckDepositResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitListCheckDepositResponse> getCheckDepositsListWithHttpInfo(ListPageParameters page, GetCheckDepositsListFilterParameter filter, String sort, String include) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = getCheckDepositsListRequestBuilder(page, filter, sort, include);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("getCheckDepositsList", localVarResponse);
        }
        return new ApiResponse<UnitListCheckDepositResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitListCheckDepositResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder getCheckDepositsListRequestBuilder(ListPageParameters page, GetCheckDepositsListFilterParameter filter, String sort, String include) throws ApiException {

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/check-deposits";

    List<Pair> localVarQueryParams = new ArrayList<>();
    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    localVarQueryParameterBaseName = "page";
    if (page != null) {
      String queryString = page.toUrlQueryString("page");
      if (!queryString.isBlank()) {
        localVarQueryStringJoiner.add(queryString);
      }
    }
    localVarQueryParameterBaseName = "filter";
    if (filter != null) {
      String queryString = filter.toUrlQueryString("filter");
      if (!queryString.isBlank()) {
        localVarQueryStringJoiner.add(queryString);
      }
    }
    localVarQueryParameterBaseName = "sort";
    localVarQueryParams.addAll(ApiClient.parameterToPairs("sort", sort));
    localVarQueryParameterBaseName = "include";
    localVarQueryParams.addAll(ApiClient.parameterToPairs("include", include));

    if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
      StringJoiner queryJoiner = new StringJoiner("&");
      localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + '=' + p.getValue()));
      if (localVarQueryStringJoiner.length() != 0) {
        queryJoiner.add(localVarQueryStringJoiner.toString());
      }
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath + '?' + queryJoiner.toString()));
    } else {
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));
    }

    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Get Check Payment by Id
   * Get a Check Payment from API 
   * @param checkPaymentId ID of the check payment to get (required)
   * @return UnitCheckPaymentResponse
   * @throws ApiException if fails to make API call
   */
  public UnitCheckPaymentResponse getCheckPayment(String checkPaymentId) throws ApiException {
    ApiResponse<UnitCheckPaymentResponse> localVarResponse = getCheckPaymentWithHttpInfo(checkPaymentId);
    return localVarResponse.getData();
  }

  /**
   * Get Check Payment by Id
   * Get a Check Payment from API 
   * @param checkPaymentId ID of the check payment to get (required)
   * @return ApiResponse&lt;UnitCheckPaymentResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitCheckPaymentResponse> getCheckPaymentWithHttpInfo(String checkPaymentId) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = getCheckPaymentRequestBuilder(checkPaymentId);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("getCheckPayment", localVarResponse);
        }
        return new ApiResponse<UnitCheckPaymentResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitCheckPaymentResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder getCheckPaymentRequestBuilder(String checkPaymentId) throws ApiException {
    // verify the required parameter 'checkPaymentId' is set
    if (checkPaymentId == null) {
      throw new ApiException(400, "Missing the required parameter 'checkPaymentId' when calling getCheckPayment");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/check-payments/{checkPaymentId}"
        .replace("{checkPaymentId}", ApiClient.urlEncode(checkPaymentId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Get back image
   * Get back image via API 
   * @param checkPaymentId ID of the check payment (required)
   * @return File
   * @throws ApiException if fails to make API call
   */
  public InputStream getCheckPaymentBack(String checkPaymentId) throws ApiException {
    ApiResponse<InputStream> localVarResponse = getCheckPaymentBackWithHttpInfo(checkPaymentId);
    return localVarResponse.getData();
  }

  /**
   * Get back image
   * Get back image via API 
   * @param checkPaymentId ID of the check payment (required)
   * @return ApiResponse&lt;File&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<InputStream> getCheckPaymentBackWithHttpInfo(String checkPaymentId) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = getCheckPaymentBackRequestBuilder(checkPaymentId);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("getCheckPaymentBack", localVarResponse);
        }
        return new ApiResponse<InputStream>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : localVarResponse.body()
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder getCheckPaymentBackRequestBuilder(String checkPaymentId) throws ApiException {
    // verify the required parameter 'checkPaymentId' is set
    if (checkPaymentId == null) {
      throw new ApiException(400, "Missing the required parameter 'checkPaymentId' when calling getCheckPaymentBack");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/check-payments/{checkPaymentId}/back"
        .replace("{checkPaymentId}", ApiClient.urlEncode(checkPaymentId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Accept", "image/png");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Get front image
   * Get front image via API 
   * @param checkPaymentId ID of the check payment (required)
   * @return File
   * @throws ApiException if fails to make API call
   */
  public InputStream getCheckPaymentFront(String checkPaymentId) throws ApiException {
    ApiResponse<InputStream> localVarResponse = getCheckPaymentFrontWithHttpInfo(checkPaymentId);
    return localVarResponse.getData();
  }

  /**
   * Get front image
   * Get front image via API 
   * @param checkPaymentId ID of the check payment (required)
   * @return ApiResponse&lt;File&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<InputStream> getCheckPaymentFrontWithHttpInfo(String checkPaymentId) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = getCheckPaymentFrontRequestBuilder(checkPaymentId);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("getCheckPaymentFront", localVarResponse);
        }
        return new ApiResponse<InputStream>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : localVarResponse.body()
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder getCheckPaymentFrontRequestBuilder(String checkPaymentId) throws ApiException {
    // verify the required parameter 'checkPaymentId' is set
    if (checkPaymentId == null) {
      throw new ApiException(400, "Missing the required parameter 'checkPaymentId' when calling getCheckPaymentFront");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/check-payments/{checkPaymentId}/front"
        .replace("{checkPaymentId}", ApiClient.urlEncode(checkPaymentId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Accept", "image/png");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Get List Check Payments
   * Get List Check Payments from API 
   * @param page  (optional)
   * @param filter  (optional)
   * @param sort  (optional)
   * @param include  (optional)
   * @return UnitListCheckPaymentsResponse
   * @throws ApiException if fails to make API call
   */
  public UnitListCheckPaymentsResponse getCheckPaymentsList(ListPageParameters page, GetCheckPaymentsListFilterParameter filter, String sort, String include) throws ApiException {
    ApiResponse<UnitListCheckPaymentsResponse> localVarResponse = getCheckPaymentsListWithHttpInfo(page, filter, sort, include);
    return localVarResponse.getData();
  }

  /**
   * Get List Check Payments
   * Get List Check Payments from API 
   * @param page  (optional)
   * @param filter  (optional)
   * @param sort  (optional)
   * @param include  (optional)
   * @return ApiResponse&lt;UnitListCheckPaymentsResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitListCheckPaymentsResponse> getCheckPaymentsListWithHttpInfo(ListPageParameters page, GetCheckPaymentsListFilterParameter filter, String sort, String include) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = getCheckPaymentsListRequestBuilder(page, filter, sort, include);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("getCheckPaymentsList", localVarResponse);
        }
        return new ApiResponse<UnitListCheckPaymentsResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitListCheckPaymentsResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder getCheckPaymentsListRequestBuilder(ListPageParameters page, GetCheckPaymentsListFilterParameter filter, String sort, String include) throws ApiException {

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/check-payments";

    List<Pair> localVarQueryParams = new ArrayList<>();
    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    localVarQueryParameterBaseName = "page";
    if (page != null) {
      String queryString = page.toUrlQueryString("page");
      if (!queryString.isBlank()) {
        localVarQueryStringJoiner.add(queryString);
      }
    }
    localVarQueryParameterBaseName = "filter";
    localVarQueryParams.addAll(ApiClient.parameterToPairs("accountId", filter.getAccountId()));
    localVarQueryParams.addAll(ApiClient.parameterToPairs("customerId", filter.getCustomerId()));
    localVarQueryParams.addAll(ApiClient.parameterToPairs("multi", "status", filter.getStatus()));
    localVarQueryParams.addAll(ApiClient.parameterToPairs("tags", filter.getTags()));
    localVarQueryParams.addAll(ApiClient.parameterToPairs("since", filter.getSince()));
    localVarQueryParams.addAll(ApiClient.parameterToPairs("until", filter.getUntil()));
    localVarQueryParams.addAll(ApiClient.parameterToPairs("fromAmount", filter.getFromAmount()));
    localVarQueryParams.addAll(ApiClient.parameterToPairs("toAmount", filter.getToAmount()));
    localVarQueryParams.addAll(ApiClient.parameterToPairs("checkNumber", filter.getCheckNumber()));
    localVarQueryParameterBaseName = "sort";
    localVarQueryParams.addAll(ApiClient.parameterToPairs("sort", sort));
    localVarQueryParameterBaseName = "include";
    localVarQueryParams.addAll(ApiClient.parameterToPairs("include", include));

    if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
      StringJoiner queryJoiner = new StringJoiner("&");
      localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + '=' + p.getValue()));
      if (localVarQueryStringJoiner.length() != 0) {
        queryJoiner.add(localVarQueryStringJoiner.toString());
      }
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath + '?' + queryJoiner.toString()));
    } else {
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));
    }

    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Get Counterparties List
   * Get Counterparties List from API 
   * @param page  (optional)
   * @param filter  (optional)
   * @param sort  (optional)
   * @return UnitCounterpartiesListResponse
   * @throws ApiException if fails to make API call
   */
  public UnitCounterpartiesListResponse getCounterpartiesList(ListPageParameters page, GetCounterpartiesListFilterParameter filter, String sort) throws ApiException {
    ApiResponse<UnitCounterpartiesListResponse> localVarResponse = getCounterpartiesListWithHttpInfo(page, filter, sort);
    return localVarResponse.getData();
  }

  /**
   * Get Counterparties List
   * Get Counterparties List from API 
   * @param page  (optional)
   * @param filter  (optional)
   * @param sort  (optional)
   * @return ApiResponse&lt;UnitCounterpartiesListResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitCounterpartiesListResponse> getCounterpartiesListWithHttpInfo(ListPageParameters page, GetCounterpartiesListFilterParameter filter, String sort) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = getCounterpartiesListRequestBuilder(page, filter, sort);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("getCounterpartiesList", localVarResponse);
        }
        return new ApiResponse<UnitCounterpartiesListResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitCounterpartiesListResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder getCounterpartiesListRequestBuilder(ListPageParameters page, GetCounterpartiesListFilterParameter filter, String sort) throws ApiException {

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/counterparties";

    List<Pair> localVarQueryParams = new ArrayList<>();
    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    localVarQueryParameterBaseName = "page";
    if (page != null) {
      String queryString = page.toUrlQueryString("page");
      if (!queryString.isBlank()) {
        localVarQueryStringJoiner.add(queryString);
      }
    }
    localVarQueryParameterBaseName = "filter";
    if (filter != null) {
      String queryString = filter.toUrlQueryString("filter");
      if (!queryString.isBlank()) {
        localVarQueryStringJoiner.add(queryString);
      }
    }
    localVarQueryParameterBaseName = "sort";
    localVarQueryParams.addAll(ApiClient.parameterToPairs("sort", sort));

    if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
      StringJoiner queryJoiner = new StringJoiner("&");
      localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + '=' + p.getValue()));
      if (localVarQueryStringJoiner.length() != 0) {
        queryJoiner.add(localVarQueryStringJoiner.toString());
      }
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath + '?' + queryJoiner.toString()));
    } else {
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));
    }

    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Get Counterparty by Id
   * Get a Counterparty from API 
   * @param counterpartyId ID of the counterparty to get (required)
   * @return UnitCounterpartyResponse
   * @throws ApiException if fails to make API call
   */
  public UnitCounterpartyResponse getCounterparty(String counterpartyId) throws ApiException {
    ApiResponse<UnitCounterpartyResponse> localVarResponse = getCounterpartyWithHttpInfo(counterpartyId);
    return localVarResponse.getData();
  }

  /**
   * Get Counterparty by Id
   * Get a Counterparty from API 
   * @param counterpartyId ID of the counterparty to get (required)
   * @return ApiResponse&lt;UnitCounterpartyResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitCounterpartyResponse> getCounterpartyWithHttpInfo(String counterpartyId) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = getCounterpartyRequestBuilder(counterpartyId);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("getCounterparty", localVarResponse);
        }
        return new ApiResponse<UnitCounterpartyResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitCounterpartyResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder getCounterpartyRequestBuilder(String counterpartyId) throws ApiException {
    // verify the required parameter 'counterpartyId' is set
    if (counterpartyId == null) {
      throw new ApiException(400, "Missing the required parameter 'counterpartyId' when calling getCounterparty");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/counterparties/{counterpartyId}"
        .replace("{counterpartyId}", ApiClient.urlEncode(counterpartyId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Get Counterparty Balance
   * Get Recurring Payment from API 
   * @param counterpartyId ID of the counterparty to get (required)
   * @return UnitCounterpartyBalanceResponse
   * @throws ApiException if fails to make API call
   */
  public UnitCounterpartyBalanceResponse getCounterpartyBalance(String counterpartyId) throws ApiException {
    ApiResponse<UnitCounterpartyBalanceResponse> localVarResponse = getCounterpartyBalanceWithHttpInfo(counterpartyId);
    return localVarResponse.getData();
  }

  /**
   * Get Counterparty Balance
   * Get Recurring Payment from API 
   * @param counterpartyId ID of the counterparty to get (required)
   * @return ApiResponse&lt;UnitCounterpartyBalanceResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitCounterpartyBalanceResponse> getCounterpartyBalanceWithHttpInfo(String counterpartyId) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = getCounterpartyBalanceRequestBuilder(counterpartyId);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("getCounterpartyBalance", localVarResponse);
        }
        return new ApiResponse<UnitCounterpartyBalanceResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitCounterpartyBalanceResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder getCounterpartyBalanceRequestBuilder(String counterpartyId) throws ApiException {
    // verify the required parameter 'counterpartyId' is set
    if (counterpartyId == null) {
      throw new ApiException(400, "Missing the required parameter 'counterpartyId' when calling getCounterpartyBalance");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/counterparties/{counterpartyId}/balance"
        .replace("{counterpartyId}", ApiClient.urlEncode(counterpartyId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Get Customer by Id
   * Get a Customer from API 
   * @param customerId ID of the customer to get (required)
   * @return UnitCustomerResponse
   * @throws ApiException if fails to make API call
   */
  public UnitCustomerResponse getCustomer(String customerId) throws ApiException {
    ApiResponse<UnitCustomerResponse> localVarResponse = getCustomerWithHttpInfo(customerId);
    return localVarResponse.getData();
  }

  /**
   * Get Customer by Id
   * Get a Customer from API 
   * @param customerId ID of the customer to get (required)
   * @return ApiResponse&lt;UnitCustomerResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitCustomerResponse> getCustomerWithHttpInfo(String customerId) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = getCustomerRequestBuilder(customerId);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("getCustomer", localVarResponse);
        }
        return new ApiResponse<UnitCustomerResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitCustomerResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder getCustomerRequestBuilder(String customerId) throws ApiException {
    // verify the required parameter 'customerId' is set
    if (customerId == null) {
      throw new ApiException(400, "Missing the required parameter 'customerId' when calling getCustomer");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/customers/{customerId}"
        .replace("{customerId}", ApiClient.urlEncode(customerId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Get Customers List
   * Get Customers List from API 
   * @param page  (optional)
   * @param filter  (optional)
   * @param sort  (optional)
   * @return UnitCustomersListResponse
   * @throws ApiException if fails to make API call
   */
  public UnitCustomersListResponse getCustomersList(ListPageParameters page, GetCustomersListFilterParameter filter, String sort) throws ApiException {
    ApiResponse<UnitCustomersListResponse> localVarResponse = getCustomersListWithHttpInfo(page, filter, sort);
    return localVarResponse.getData();
  }

  /**
   * Get Customers List
   * Get Customers List from API 
   * @param page  (optional)
   * @param filter  (optional)
   * @param sort  (optional)
   * @return ApiResponse&lt;UnitCustomersListResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitCustomersListResponse> getCustomersListWithHttpInfo(ListPageParameters page, GetCustomersListFilterParameter filter, String sort) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = getCustomersListRequestBuilder(page, filter, sort);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("getCustomersList", localVarResponse);
        }
        return new ApiResponse<UnitCustomersListResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitCustomersListResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder getCustomersListRequestBuilder(ListPageParameters page, GetCustomersListFilterParameter filter, String sort) throws ApiException {

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/customers";

    List<Pair> localVarQueryParams = new ArrayList<>();
    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    localVarQueryParameterBaseName = "page";
    if (page != null) {
      String queryString = page.toUrlQueryString("page");
      if (!queryString.isBlank()) {
        localVarQueryStringJoiner.add(queryString);
      }
    }
    localVarQueryParameterBaseName = "filter";
    if (filter != null) {
      String queryString = filter.toUrlQueryString("filter");
      if (!queryString.isBlank()) {
        localVarQueryStringJoiner.add(queryString);
      }
    }
    localVarQueryParameterBaseName = "sort";
    localVarQueryParams.addAll(ApiClient.parameterToPairs("sort", sort));

    if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
      StringJoiner queryJoiner = new StringJoiner("&");
      localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + '=' + p.getValue()));
      if (localVarQueryStringJoiner.length() != 0) {
        queryJoiner.add(localVarQueryStringJoiner.toString());
      }
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath + '?' + queryJoiner.toString()));
    } else {
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));
    }

    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Get Deposit Products
   * Retrieve the list of available deposit products compatible to the account.
   * @param accountId ID of the account to get deposit products for (required)
   * @return UnitDepositProductsResponse
   * @throws ApiException if fails to make API call
   */
  public UnitDepositProductsResponse getDepositProductsList(String accountId) throws ApiException {
    ApiResponse<UnitDepositProductsResponse> localVarResponse = getDepositProductsListWithHttpInfo(accountId);
    return localVarResponse.getData();
  }

  /**
   * Get Deposit Products
   * Retrieve the list of available deposit products compatible to the account.
   * @param accountId ID of the account to get deposit products for (required)
   * @return ApiResponse&lt;UnitDepositProductsResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitDepositProductsResponse> getDepositProductsListWithHttpInfo(String accountId) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = getDepositProductsListRequestBuilder(accountId);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("getDepositProductsList", localVarResponse);
        }
        return new ApiResponse<UnitDepositProductsResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitDepositProductsResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder getDepositProductsListRequestBuilder(String accountId) throws ApiException {
    // verify the required parameter 'accountId' is set
    if (accountId == null) {
      throw new ApiException(400, "Missing the required parameter 'accountId' when calling getDepositProductsList");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/accounts/{accountId}/deposit-products"
        .replace("{accountId}", ApiClient.urlEncode(accountId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Get Dispute by Id
   * Get a Dispute from API 
   * @param disputeId ID of the dispute to get (required)
   * @return UnitDisputeResponse
   * @throws ApiException if fails to make API call
   */
  public UnitDisputeResponse getDispute(String disputeId) throws ApiException {
    ApiResponse<UnitDisputeResponse> localVarResponse = getDisputeWithHttpInfo(disputeId);
    return localVarResponse.getData();
  }

  /**
   * Get Dispute by Id
   * Get a Dispute from API 
   * @param disputeId ID of the dispute to get (required)
   * @return ApiResponse&lt;UnitDisputeResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitDisputeResponse> getDisputeWithHttpInfo(String disputeId) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = getDisputeRequestBuilder(disputeId);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("getDispute", localVarResponse);
        }
        return new ApiResponse<UnitDisputeResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitDisputeResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder getDisputeRequestBuilder(String disputeId) throws ApiException {
    // verify the required parameter 'disputeId' is set
    if (disputeId == null) {
      throw new ApiException(400, "Missing the required parameter 'disputeId' when calling getDispute");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/disputes/{disputeId}"
        .replace("{disputeId}", ApiClient.urlEncode(disputeId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Get List Disputes
   * Get List Disputes from API 
   * @param page  (optional)
   * @param filter  (optional)
   * @return List&lt;Dispute&gt;
   * @throws ApiException if fails to make API call
   */
  public List<Dispute> getDisputesList(ListPageParameters page, GetDisputesListFilterParameter filter) throws ApiException {
    ApiResponse<List<Dispute>> localVarResponse = getDisputesListWithHttpInfo(page, filter);
    return localVarResponse.getData();
  }

  /**
   * Get List Disputes
   * Get List Disputes from API 
   * @param page  (optional)
   * @param filter  (optional)
   * @return ApiResponse&lt;List&lt;Dispute&gt;&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<List<Dispute>> getDisputesListWithHttpInfo(ListPageParameters page, GetDisputesListFilterParameter filter) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = getDisputesListRequestBuilder(page, filter);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("getDisputesList", localVarResponse);
        }
        return new ApiResponse<List<Dispute>>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<List<Dispute>>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder getDisputesListRequestBuilder(ListPageParameters page, GetDisputesListFilterParameter filter) throws ApiException {

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/disputes";

    List<Pair> localVarQueryParams = new ArrayList<>();
    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    localVarQueryParameterBaseName = "page";
    if (page != null) {
      String queryString = page.toUrlQueryString("page");
      if (!queryString.isBlank()) {
        localVarQueryStringJoiner.add(queryString);
      }
    }
    localVarQueryParameterBaseName = "filter";
    if (filter != null) {
      String queryString = filter.toUrlQueryString("filter");
      if (!queryString.isBlank()) {
        localVarQueryStringJoiner.add(queryString);
      }
    }

    if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
      StringJoiner queryJoiner = new StringJoiner("&");
      localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + '=' + p.getValue()));
      if (localVarQueryStringJoiner.length() != 0) {
        queryJoiner.add(localVarQueryStringJoiner.toString());
      }
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath + '?' + queryJoiner.toString()));
    } else {
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));
    }

    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Get Event by Id
   * Get an Event from API 
   * @param eventId ID of the event to get (required)
   * @return UnitEventResponse
   * @throws ApiException if fails to make API call
   */
  public UnitEventResponse getEvent(String eventId) throws ApiException {
    ApiResponse<UnitEventResponse> localVarResponse = getEventWithHttpInfo(eventId);
    return localVarResponse.getData();
  }

  /**
   * Get Event by Id
   * Get an Event from API 
   * @param eventId ID of the event to get (required)
   * @return ApiResponse&lt;UnitEventResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitEventResponse> getEventWithHttpInfo(String eventId) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = getEventRequestBuilder(eventId);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("getEvent", localVarResponse);
        }
        return new ApiResponse<UnitEventResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitEventResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder getEventRequestBuilder(String eventId) throws ApiException {
    // verify the required parameter 'eventId' is set
    if (eventId == null) {
      throw new ApiException(400, "Missing the required parameter 'eventId' when calling getEvent");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/events/{eventId}"
        .replace("{eventId}", ApiClient.urlEncode(eventId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Get Events List
   * Get Events List from API 
   * @param page  (optional)
   * @param filter  (optional)
   * @return UnitEventListResponse
   * @throws ApiException if fails to make API call
   */
  public UnitEventListResponse getEventsList(ListPageParameters page, GetEventsListFilterParameter filter) throws ApiException {
    ApiResponse<UnitEventListResponse> localVarResponse = getEventsListWithHttpInfo(page, filter);
    return localVarResponse.getData();
  }

  /**
   * Get Events List
   * Get Events List from API 
   * @param page  (optional)
   * @param filter  (optional)
   * @return ApiResponse&lt;UnitEventListResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitEventListResponse> getEventsListWithHttpInfo(ListPageParameters page, GetEventsListFilterParameter filter) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = getEventsListRequestBuilder(page, filter);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("getEventsList", localVarResponse);
        }
        return new ApiResponse<UnitEventListResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitEventListResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder getEventsListRequestBuilder(ListPageParameters page, GetEventsListFilterParameter filter) throws ApiException {

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/events";

    List<Pair> localVarQueryParams = new ArrayList<>();
    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    localVarQueryParameterBaseName = "page";
    if (page != null) {
      String queryString = page.toUrlQueryString("page");
      if (!queryString.isBlank()) {
        localVarQueryStringJoiner.add(queryString);
      }
    }
    localVarQueryParameterBaseName = "filter";
    if (filter != null) {
      String queryString = filter.toUrlQueryString("filter");
      if (!queryString.isBlank()) {
        localVarQueryStringJoiner.add(queryString);
      }
    }

    if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
      StringJoiner queryJoiner = new StringJoiner("&");
      localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + '=' + p.getValue()));
      if (localVarQueryStringJoiner.length() != 0) {
        queryJoiner.add(localVarQueryStringJoiner.toString());
      }
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath + '?' + queryJoiner.toString()));
    } else {
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));
    }

    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Get Front Check Deposit Image by Id
   * Get Front Check Deposit Image from API 
   * @param checkDepositId ID of the check deposit to get (required)
   * @return UnitFrontCheckDepositResponse
   * @throws ApiException if fails to make API call
   */
  public UnitFrontCheckDepositResponse getFrontCheckDeposit(String checkDepositId) throws ApiException {
    ApiResponse<UnitFrontCheckDepositResponse> localVarResponse = getFrontCheckDepositWithHttpInfo(checkDepositId);
    return localVarResponse.getData();
  }

  /**
   * Get Front Check Deposit Image by Id
   * Get Front Check Deposit Image from API 
   * @param checkDepositId ID of the check deposit to get (required)
   * @return ApiResponse&lt;UnitFrontCheckDepositResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitFrontCheckDepositResponse> getFrontCheckDepositWithHttpInfo(String checkDepositId) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = getFrontCheckDepositRequestBuilder(checkDepositId);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("getFrontCheckDeposit", localVarResponse);
        }
        return new ApiResponse<UnitFrontCheckDepositResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitFrontCheckDepositResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder getFrontCheckDepositRequestBuilder(String checkDepositId) throws ApiException {
    // verify the required parameter 'checkDepositId' is set
    if (checkDepositId == null) {
      throw new ApiException(400, "Missing the required parameter 'checkDepositId' when calling getFrontCheckDeposit");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/check-deposits/{checkDepositId}/front"
        .replace("{checkDepositId}", ApiClient.urlEncode(checkDepositId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Get Institution by Routing Number
   * Get an Institution from API 
   * @param routingNumber routingNumber of the institution to get (required)
   * @return UnitInstitutionResponse
   * @throws ApiException if fails to make API call
   */
  public UnitInstitutionResponse getInstitution(String routingNumber) throws ApiException {
    ApiResponse<UnitInstitutionResponse> localVarResponse = getInstitutionWithHttpInfo(routingNumber);
    return localVarResponse.getData();
  }

  /**
   * Get Institution by Routing Number
   * Get an Institution from API 
   * @param routingNumber routingNumber of the institution to get (required)
   * @return ApiResponse&lt;UnitInstitutionResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitInstitutionResponse> getInstitutionWithHttpInfo(String routingNumber) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = getInstitutionRequestBuilder(routingNumber);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("getInstitution", localVarResponse);
        }
        return new ApiResponse<UnitInstitutionResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitInstitutionResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder getInstitutionRequestBuilder(String routingNumber) throws ApiException {
    // verify the required parameter 'routingNumber' is set
    if (routingNumber == null) {
      throw new ApiException(400, "Missing the required parameter 'routingNumber' when calling getInstitution");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/institutions/{routingNumber}"
        .replace("{routingNumber}", ApiClient.urlEncode(routingNumber.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Get Payment by Id
   * Get a Payment from API 
   * @param paymentId ID of the payment to get (required)
   * @param included  (optional)
   * @return UnitPaymentResponseWithIncluded
   * @throws ApiException if fails to make API call
   */
  public UnitPaymentResponseWithIncluded getPayment(String paymentId, String included) throws ApiException {
    ApiResponse<UnitPaymentResponseWithIncluded> localVarResponse = getPaymentWithHttpInfo(paymentId, included);
    return localVarResponse.getData();
  }

  /**
   * Get Payment by Id
   * Get a Payment from API 
   * @param paymentId ID of the payment to get (required)
   * @param included  (optional)
   * @return ApiResponse&lt;UnitPaymentResponseWithIncluded&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitPaymentResponseWithIncluded> getPaymentWithHttpInfo(String paymentId, String included) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = getPaymentRequestBuilder(paymentId, included);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("getPayment", localVarResponse);
        }
        return new ApiResponse<UnitPaymentResponseWithIncluded>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitPaymentResponseWithIncluded>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder getPaymentRequestBuilder(String paymentId, String included) throws ApiException {
    // verify the required parameter 'paymentId' is set
    if (paymentId == null) {
      throw new ApiException(400, "Missing the required parameter 'paymentId' when calling getPayment");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/payments/{paymentId}"
        .replace("{paymentId}", ApiClient.urlEncode(paymentId.toString()));

    List<Pair> localVarQueryParams = new ArrayList<>();
    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    localVarQueryParameterBaseName = "included";
    localVarQueryParams.addAll(ApiClient.parameterToPairs("included", included));

    if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
      StringJoiner queryJoiner = new StringJoiner("&");
      localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + '=' + p.getValue()));
      if (localVarQueryStringJoiner.length() != 0) {
        queryJoiner.add(localVarQueryStringJoiner.toString());
      }
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath + '?' + queryJoiner.toString()));
    } else {
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));
    }

    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Get List Payments
   * Get List Payments from API 
   * @param page  (optional)
   * @param filter  (optional)
   * @param include  (optional)
   * @param sort  (optional)
   * @return UnitPaymentsListResponse
   * @throws ApiException if fails to make API call
   */
  public UnitPaymentsListResponse getPaymentsList(ListPageParameters page, GetPaymentsListFilterParameter filter, String include, String sort) throws ApiException {
    ApiResponse<UnitPaymentsListResponse> localVarResponse = getPaymentsListWithHttpInfo(page, filter, include, sort);
    return localVarResponse.getData();
  }

  /**
   * Get List Payments
   * Get List Payments from API 
   * @param page  (optional)
   * @param filter  (optional)
   * @param include  (optional)
   * @param sort  (optional)
   * @return ApiResponse&lt;UnitPaymentsListResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitPaymentsListResponse> getPaymentsListWithHttpInfo(ListPageParameters page, GetPaymentsListFilterParameter filter, String include, String sort) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = getPaymentsListRequestBuilder(page, filter, include, sort);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("getPaymentsList", localVarResponse);
        }
        return new ApiResponse<UnitPaymentsListResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitPaymentsListResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder getPaymentsListRequestBuilder(ListPageParameters page, GetPaymentsListFilterParameter filter, String include, String sort) throws ApiException {

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/payments";

    List<Pair> localVarQueryParams = new ArrayList<>();
    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    localVarQueryParameterBaseName = "page";
    if (page != null) {
      String queryString = page.toUrlQueryString("page");
      if (!queryString.isBlank()) {
        localVarQueryStringJoiner.add(queryString);
      }
    }
    localVarQueryParameterBaseName = "filter";
    if (filter != null) {
      String queryString = filter.toUrlQueryString("filter");
      if (!queryString.isBlank()) {
        localVarQueryStringJoiner.add(queryString);
      }
    }
    localVarQueryParameterBaseName = "include";
    localVarQueryParams.addAll(ApiClient.parameterToPairs("include", include));
    localVarQueryParameterBaseName = "sort";
    localVarQueryParams.addAll(ApiClient.parameterToPairs("sort", sort));

    if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
      StringJoiner queryJoiner = new StringJoiner("&");
      localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + '=' + p.getValue()));
      if (localVarQueryStringJoiner.length() != 0) {
        queryJoiner.add(localVarQueryStringJoiner.toString());
      }
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath + '?' + queryJoiner.toString()));
    } else {
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));
    }

    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Get Received Payment by Id
   * Get a Received Payment from API 
   * @param paymentId ID of the payment to get (required)
   * @param included  (optional)
   * @return UnitReceivedPaymentResponseWithIncluded
   * @throws ApiException if fails to make API call
   */
  public UnitReceivedPaymentResponseWithIncluded getReceivedPayment(String paymentId, String included) throws ApiException {
    ApiResponse<UnitReceivedPaymentResponseWithIncluded> localVarResponse = getReceivedPaymentWithHttpInfo(paymentId, included);
    return localVarResponse.getData();
  }

  /**
   * Get Received Payment by Id
   * Get a Received Payment from API 
   * @param paymentId ID of the payment to get (required)
   * @param included  (optional)
   * @return ApiResponse&lt;UnitReceivedPaymentResponseWithIncluded&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitReceivedPaymentResponseWithIncluded> getReceivedPaymentWithHttpInfo(String paymentId, String included) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = getReceivedPaymentRequestBuilder(paymentId, included);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("getReceivedPayment", localVarResponse);
        }
        return new ApiResponse<UnitReceivedPaymentResponseWithIncluded>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitReceivedPaymentResponseWithIncluded>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder getReceivedPaymentRequestBuilder(String paymentId, String included) throws ApiException {
    // verify the required parameter 'paymentId' is set
    if (paymentId == null) {
      throw new ApiException(400, "Missing the required parameter 'paymentId' when calling getReceivedPayment");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/received-payments/{paymentId}"
        .replace("{paymentId}", ApiClient.urlEncode(paymentId.toString()));

    List<Pair> localVarQueryParams = new ArrayList<>();
    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    localVarQueryParameterBaseName = "included";
    localVarQueryParams.addAll(ApiClient.parameterToPairs("included", included));

    if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
      StringJoiner queryJoiner = new StringJoiner("&");
      localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + '=' + p.getValue()));
      if (localVarQueryStringJoiner.length() != 0) {
        queryJoiner.add(localVarQueryStringJoiner.toString());
      }
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath + '?' + queryJoiner.toString()));
    } else {
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));
    }

    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Get Received Payments List
   * Get Received Payments from API 
   * @param page  (optional)
   * @param filter  (optional)
   * @param include  (optional)
   * @param sort  (optional)
   * @return UnitReceivedPaymentListResponse
   * @throws ApiException if fails to make API call
   */
  public UnitReceivedPaymentListResponse getReceivedPaymentsList(ListPageParameters page, GetReceivedPaymentsListFilterParameter filter, String include, String sort) throws ApiException {
    ApiResponse<UnitReceivedPaymentListResponse> localVarResponse = getReceivedPaymentsListWithHttpInfo(page, filter, include, sort);
    return localVarResponse.getData();
  }

  /**
   * Get Received Payments List
   * Get Received Payments from API 
   * @param page  (optional)
   * @param filter  (optional)
   * @param include  (optional)
   * @param sort  (optional)
   * @return ApiResponse&lt;UnitReceivedPaymentListResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitReceivedPaymentListResponse> getReceivedPaymentsListWithHttpInfo(ListPageParameters page, GetReceivedPaymentsListFilterParameter filter, String include, String sort) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = getReceivedPaymentsListRequestBuilder(page, filter, include, sort);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("getReceivedPaymentsList", localVarResponse);
        }
        return new ApiResponse<UnitReceivedPaymentListResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitReceivedPaymentListResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder getReceivedPaymentsListRequestBuilder(ListPageParameters page, GetReceivedPaymentsListFilterParameter filter, String include, String sort) throws ApiException {

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/received-payments";

    List<Pair> localVarQueryParams = new ArrayList<>();
    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    localVarQueryParameterBaseName = "page";
    if (page != null) {
      String queryString = page.toUrlQueryString("page");
      if (!queryString.isBlank()) {
        localVarQueryStringJoiner.add(queryString);
      }
    }
    localVarQueryParameterBaseName = "filter";
    if (filter != null) {
      String queryString = filter.toUrlQueryString("filter");
      if (!queryString.isBlank()) {
        localVarQueryStringJoiner.add(queryString);
      }
    }
    localVarQueryParameterBaseName = "include";
    localVarQueryParams.addAll(ApiClient.parameterToPairs("include", include));
    localVarQueryParameterBaseName = "sort";
    localVarQueryParams.addAll(ApiClient.parameterToPairs("sort", sort));

    if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
      StringJoiner queryJoiner = new StringJoiner("&");
      localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + '=' + p.getValue()));
      if (localVarQueryStringJoiner.length() != 0) {
        queryJoiner.add(localVarQueryStringJoiner.toString());
      }
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath + '?' + queryJoiner.toString()));
    } else {
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));
    }

    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Get Recurring Payment
   * Get Recurring Payment from API 
   * @param paymentId ID of the payment to get (required)
   * @return UnitRecurringPaymentResponse
   * @throws ApiException if fails to make API call
   */
  public UnitRecurringPaymentResponse getRecurringPayment(String paymentId) throws ApiException {
    ApiResponse<UnitRecurringPaymentResponse> localVarResponse = getRecurringPaymentWithHttpInfo(paymentId);
    return localVarResponse.getData();
  }

  /**
   * Get Recurring Payment
   * Get Recurring Payment from API 
   * @param paymentId ID of the payment to get (required)
   * @return ApiResponse&lt;UnitRecurringPaymentResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitRecurringPaymentResponse> getRecurringPaymentWithHttpInfo(String paymentId) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = getRecurringPaymentRequestBuilder(paymentId);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("getRecurringPayment", localVarResponse);
        }
        return new ApiResponse<UnitRecurringPaymentResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitRecurringPaymentResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder getRecurringPaymentRequestBuilder(String paymentId) throws ApiException {
    // verify the required parameter 'paymentId' is set
    if (paymentId == null) {
      throw new ApiException(400, "Missing the required parameter 'paymentId' when calling getRecurringPayment");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/recurring-payments/{paymentId}"
        .replace("{paymentId}", ApiClient.urlEncode(paymentId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Get Recurring Payments List
   * Get Recurring Payments List from API 
   * @param page  (optional)
   * @param filter  (optional)
   * @param sort  (optional)
   * @return UnitRecurringPaymentListResponse
   * @throws ApiException if fails to make API call
   */
  public UnitRecurringPaymentListResponse getRecurringPaymentsList(ListPageParameters page, GetRecurringPaymentsListFilterParameter filter, String sort) throws ApiException {
    ApiResponse<UnitRecurringPaymentListResponse> localVarResponse = getRecurringPaymentsListWithHttpInfo(page, filter, sort);
    return localVarResponse.getData();
  }

  /**
   * Get Recurring Payments List
   * Get Recurring Payments List from API 
   * @param page  (optional)
   * @param filter  (optional)
   * @param sort  (optional)
   * @return ApiResponse&lt;UnitRecurringPaymentListResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitRecurringPaymentListResponse> getRecurringPaymentsListWithHttpInfo(ListPageParameters page, GetRecurringPaymentsListFilterParameter filter, String sort) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = getRecurringPaymentsListRequestBuilder(page, filter, sort);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("getRecurringPaymentsList", localVarResponse);
        }
        return new ApiResponse<UnitRecurringPaymentListResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitRecurringPaymentListResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder getRecurringPaymentsListRequestBuilder(ListPageParameters page, GetRecurringPaymentsListFilterParameter filter, String sort) throws ApiException {

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/recurring-payments";

    List<Pair> localVarQueryParams = new ArrayList<>();
    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    localVarQueryParameterBaseName = "page";
    if (page != null) {
      String queryString = page.toUrlQueryString("page");
      if (!queryString.isBlank()) {
        localVarQueryStringJoiner.add(queryString);
      }
    }
    localVarQueryParameterBaseName = "filter";
    if (filter != null) {
      String queryString = filter.toUrlQueryString("filter");
      if (!queryString.isBlank()) {
        localVarQueryStringJoiner.add(queryString);
      }
    }
    localVarQueryParameterBaseName = "sort";
    localVarQueryParams.addAll(ApiClient.parameterToPairs("sort", sort));

    if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
      StringJoiner queryJoiner = new StringJoiner("&");
      localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + '=' + p.getValue()));
      if (localVarQueryStringJoiner.length() != 0) {
        queryJoiner.add(localVarQueryStringJoiner.toString());
      }
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath + '?' + queryJoiner.toString()));
    } else {
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));
    }

    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Get Recurring Repayment by Id
   * Get a Recurring Repayment from API 
   * @param recurringRepaymentId ID of the recurring repayment to get (required)
   * @param include  (optional)
   * @return UnitRecurringRepaymentResponse
   * @throws ApiException if fails to make API call
   */
  public UnitRecurringRepaymentResponse getRecurringRepayment(String recurringRepaymentId, String include) throws ApiException {
    ApiResponse<UnitRecurringRepaymentResponse> localVarResponse = getRecurringRepaymentWithHttpInfo(recurringRepaymentId, include);
    return localVarResponse.getData();
  }

  /**
   * Get Recurring Repayment by Id
   * Get a Recurring Repayment from API 
   * @param recurringRepaymentId ID of the recurring repayment to get (required)
   * @param include  (optional)
   * @return ApiResponse&lt;UnitRecurringRepaymentResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitRecurringRepaymentResponse> getRecurringRepaymentWithHttpInfo(String recurringRepaymentId, String include) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = getRecurringRepaymentRequestBuilder(recurringRepaymentId, include);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("getRecurringRepayment", localVarResponse);
        }
        return new ApiResponse<UnitRecurringRepaymentResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitRecurringRepaymentResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder getRecurringRepaymentRequestBuilder(String recurringRepaymentId, String include) throws ApiException {
    // verify the required parameter 'recurringRepaymentId' is set
    if (recurringRepaymentId == null) {
      throw new ApiException(400, "Missing the required parameter 'recurringRepaymentId' when calling getRecurringRepayment");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/recurring-repayments/{recurringRepaymentId}"
        .replace("{recurringRepaymentId}", ApiClient.urlEncode(recurringRepaymentId.toString()));

    List<Pair> localVarQueryParams = new ArrayList<>();
    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    localVarQueryParameterBaseName = "include";
    localVarQueryParams.addAll(ApiClient.parameterToPairs("include", include));

    if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
      StringJoiner queryJoiner = new StringJoiner("&");
      localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + '=' + p.getValue()));
      if (localVarQueryStringJoiner.length() != 0) {
        queryJoiner.add(localVarQueryStringJoiner.toString());
      }
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath + '?' + queryJoiner.toString()));
    } else {
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));
    }

    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Get List Recurring Repayments
   * Get List Recurring Repayments from API 
   * @param page  (optional)
   * @param filter  (optional)
   * @param sort  (optional)
   * @return UnitRecurringRepaymentsListResponse
   * @throws ApiException if fails to make API call
   */
  public UnitRecurringRepaymentsListResponse getRecurringRepaymentsList(ListPageParameters page, GetRecurringRepaymentsListFilterParameter filter, String sort) throws ApiException {
    ApiResponse<UnitRecurringRepaymentsListResponse> localVarResponse = getRecurringRepaymentsListWithHttpInfo(page, filter, sort);
    return localVarResponse.getData();
  }

  /**
   * Get List Recurring Repayments
   * Get List Recurring Repayments from API 
   * @param page  (optional)
   * @param filter  (optional)
   * @param sort  (optional)
   * @return ApiResponse&lt;UnitRecurringRepaymentsListResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitRecurringRepaymentsListResponse> getRecurringRepaymentsListWithHttpInfo(ListPageParameters page, GetRecurringRepaymentsListFilterParameter filter, String sort) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = getRecurringRepaymentsListRequestBuilder(page, filter, sort);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("getRecurringRepaymentsList", localVarResponse);
        }
        return new ApiResponse<UnitRecurringRepaymentsListResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitRecurringRepaymentsListResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder getRecurringRepaymentsListRequestBuilder(ListPageParameters page, GetRecurringRepaymentsListFilterParameter filter, String sort) throws ApiException {

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/recurring-repayments";

    List<Pair> localVarQueryParams = new ArrayList<>();
    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    localVarQueryParameterBaseName = "page";
    if (page != null) {
      String queryString = page.toUrlQueryString("page");
      if (!queryString.isBlank()) {
        localVarQueryStringJoiner.add(queryString);
      }
    }
    localVarQueryParameterBaseName = "filter";
    if (filter != null) {
      String queryString = filter.toUrlQueryString("filter");
      if (!queryString.isBlank()) {
        localVarQueryStringJoiner.add(queryString);
      }
    }
    localVarQueryParameterBaseName = "sort";
    localVarQueryParams.addAll(ApiClient.parameterToPairs("sort", sort));

    if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
      StringJoiner queryJoiner = new StringJoiner("&");
      localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + '=' + p.getValue()));
      if (localVarQueryStringJoiner.length() != 0) {
        queryJoiner.add(localVarQueryStringJoiner.toString());
      }
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath + '?' + queryJoiner.toString()));
    } else {
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));
    }

    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Get Repayment by Id
   * Get an Repayment from API 
   * @param repaymentId ID of the repayment to get (required)
   * @param include  (optional)
   * @return UnitRepaymentResponse
   * @throws ApiException if fails to make API call
   */
  public UnitRepaymentResponse getRepayment(String repaymentId, String include) throws ApiException {
    ApiResponse<UnitRepaymentResponse> localVarResponse = getRepaymentWithHttpInfo(repaymentId, include);
    return localVarResponse.getData();
  }

  /**
   * Get Repayment by Id
   * Get an Repayment from API 
   * @param repaymentId ID of the repayment to get (required)
   * @param include  (optional)
   * @return ApiResponse&lt;UnitRepaymentResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitRepaymentResponse> getRepaymentWithHttpInfo(String repaymentId, String include) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = getRepaymentRequestBuilder(repaymentId, include);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("getRepayment", localVarResponse);
        }
        return new ApiResponse<UnitRepaymentResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitRepaymentResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder getRepaymentRequestBuilder(String repaymentId, String include) throws ApiException {
    // verify the required parameter 'repaymentId' is set
    if (repaymentId == null) {
      throw new ApiException(400, "Missing the required parameter 'repaymentId' when calling getRepayment");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/repayments/{repaymentId}"
        .replace("{repaymentId}", ApiClient.urlEncode(repaymentId.toString()));

    List<Pair> localVarQueryParams = new ArrayList<>();
    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    localVarQueryParameterBaseName = "include";
    localVarQueryParams.addAll(ApiClient.parameterToPairs("include", include));

    if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
      StringJoiner queryJoiner = new StringJoiner("&");
      localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + '=' + p.getValue()));
      if (localVarQueryStringJoiner.length() != 0) {
        queryJoiner.add(localVarQueryStringJoiner.toString());
      }
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath + '?' + queryJoiner.toString()));
    } else {
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));
    }

    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Get Repayment Information
   * Retrieve the repayment information for a specific account via API
   * @param accountId ID of the account to get repayment information for (required)
   * @return UnitRepaymentInformationResponse
   * @throws ApiException if fails to make API call
   */
  public UnitRepaymentInformationResponse getRepaymentInformation(String accountId) throws ApiException {
    ApiResponse<UnitRepaymentInformationResponse> localVarResponse = getRepaymentInformationWithHttpInfo(accountId);
    return localVarResponse.getData();
  }

  /**
   * Get Repayment Information
   * Retrieve the repayment information for a specific account via API
   * @param accountId ID of the account to get repayment information for (required)
   * @return ApiResponse&lt;UnitRepaymentInformationResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitRepaymentInformationResponse> getRepaymentInformationWithHttpInfo(String accountId) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = getRepaymentInformationRequestBuilder(accountId);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("getRepaymentInformation", localVarResponse);
        }
        return new ApiResponse<UnitRepaymentInformationResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitRepaymentInformationResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder getRepaymentInformationRequestBuilder(String accountId) throws ApiException {
    // verify the required parameter 'accountId' is set
    if (accountId == null) {
      throw new ApiException(400, "Missing the required parameter 'accountId' when calling getRepaymentInformation");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/accounts/{accountId}/repayment-information"
        .replace("{accountId}", ApiClient.urlEncode(accountId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Get List Repayments
   * Get List Repayments from API 
   * @param page  (optional)
   * @param filter  (optional)
   * @return UnitRepaymentsListResponse
   * @throws ApiException if fails to make API call
   */
  public UnitRepaymentsListResponse getRepaymentsList(ListPageParameters page, GetRepaymentsListFilterParameter filter) throws ApiException {
    ApiResponse<UnitRepaymentsListResponse> localVarResponse = getRepaymentsListWithHttpInfo(page, filter);
    return localVarResponse.getData();
  }

  /**
   * Get List Repayments
   * Get List Repayments from API 
   * @param page  (optional)
   * @param filter  (optional)
   * @return ApiResponse&lt;UnitRepaymentsListResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitRepaymentsListResponse> getRepaymentsListWithHttpInfo(ListPageParameters page, GetRepaymentsListFilterParameter filter) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = getRepaymentsListRequestBuilder(page, filter);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("getRepaymentsList", localVarResponse);
        }
        return new ApiResponse<UnitRepaymentsListResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitRepaymentsListResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder getRepaymentsListRequestBuilder(ListPageParameters page, GetRepaymentsListFilterParameter filter) throws ApiException {

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/repayments";

    List<Pair> localVarQueryParams = new ArrayList<>();
    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    localVarQueryParameterBaseName = "page";
    if (page != null) {
      String queryString = page.toUrlQueryString("page");
      if (!queryString.isBlank()) {
        localVarQueryStringJoiner.add(queryString);
      }
    }
    localVarQueryParameterBaseName = "filter";
    if (filter != null) {
      String queryString = filter.toUrlQueryString("filter");
      if (!queryString.isBlank()) {
        localVarQueryStringJoiner.add(queryString);
      }
    }

    if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
      StringJoiner queryJoiner = new StringJoiner("&");
      localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + '=' + p.getValue()));
      if (localVarQueryStringJoiner.length() != 0) {
        queryJoiner.add(localVarQueryStringJoiner.toString());
      }
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath + '?' + queryJoiner.toString()));
    } else {
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));
    }

    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Get Reward by Id
   * Get a Reward from API 
   * @param rewardId ID of the reward to get (required)
   * @return UnitRewardResponse
   * @throws ApiException if fails to make API call
   */
  public UnitRewardResponse getReward(String rewardId) throws ApiException {
    ApiResponse<UnitRewardResponse> localVarResponse = getRewardWithHttpInfo(rewardId);
    return localVarResponse.getData();
  }

  /**
   * Get Reward by Id
   * Get a Reward from API 
   * @param rewardId ID of the reward to get (required)
   * @return ApiResponse&lt;UnitRewardResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitRewardResponse> getRewardWithHttpInfo(String rewardId) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = getRewardRequestBuilder(rewardId);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("getReward", localVarResponse);
        }
        return new ApiResponse<UnitRewardResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitRewardResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder getRewardRequestBuilder(String rewardId) throws ApiException {
    // verify the required parameter 'rewardId' is set
    if (rewardId == null) {
      throw new ApiException(400, "Missing the required parameter 'rewardId' when calling getReward");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/rewards/{rewardId}"
        .replace("{rewardId}", ApiClient.urlEncode(rewardId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Get Rewards List
   * Get Rewards List from API 
   * @param page  (optional)
   * @param filter  (optional)
   * @param sort  (optional)
   * @param include  (optional)
   * @return UnitRewardsListResponse
   * @throws ApiException if fails to make API call
   */
  public UnitRewardsListResponse getRewardsList(ListPageParameters page, GetRewardsListFilterParameter filter, String sort, String include) throws ApiException {
    ApiResponse<UnitRewardsListResponse> localVarResponse = getRewardsListWithHttpInfo(page, filter, sort, include);
    return localVarResponse.getData();
  }

  /**
   * Get Rewards List
   * Get Rewards List from API 
   * @param page  (optional)
   * @param filter  (optional)
   * @param sort  (optional)
   * @param include  (optional)
   * @return ApiResponse&lt;UnitRewardsListResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitRewardsListResponse> getRewardsListWithHttpInfo(ListPageParameters page, GetRewardsListFilterParameter filter, String sort, String include) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = getRewardsListRequestBuilder(page, filter, sort, include);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("getRewardsList", localVarResponse);
        }
        return new ApiResponse<UnitRewardsListResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitRewardsListResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder getRewardsListRequestBuilder(ListPageParameters page, GetRewardsListFilterParameter filter, String sort, String include) throws ApiException {

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/rewards";

    List<Pair> localVarQueryParams = new ArrayList<>();
    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    localVarQueryParameterBaseName = "page";
    if (page != null) {
      String queryString = page.toUrlQueryString("page");
      if (!queryString.isBlank()) {
        localVarQueryStringJoiner.add(queryString);
      }
    }
    localVarQueryParameterBaseName = "filter";
    if (filter != null) {
      String queryString = filter.toUrlQueryString("filter");
      if (!queryString.isBlank()) {
        localVarQueryStringJoiner.add(queryString);
      }
    }
    localVarQueryParameterBaseName = "sort";
    localVarQueryParams.addAll(ApiClient.parameterToPairs("sort", sort));
    localVarQueryParameterBaseName = "include";
    localVarQueryParams.addAll(ApiClient.parameterToPairs("include", include));

    if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
      StringJoiner queryJoiner = new StringJoiner("&");
      localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + '=' + p.getValue()));
      if (localVarQueryStringJoiner.length() != 0) {
        queryJoiner.add(localVarQueryStringJoiner.toString());
      }
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath + '?' + queryJoiner.toString()));
    } else {
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));
    }

    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Get Bank verification PDF
   * Get Get Bank verification PDF from API 
   * @param accountId ID of the account to get (required)
   * @return File
   * @throws ApiException if fails to make API call
   */
  public InputStream getStatementBankPdf(String accountId) throws ApiException {
    ApiResponse<InputStream> localVarResponse = getStatementBankPdfWithHttpInfo(accountId);
    return localVarResponse.getData();
  }

  /**
   * Get Bank verification PDF
   * Get Get Bank verification PDF from API 
   * @param accountId ID of the account to get (required)
   * @return ApiResponse&lt;File&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<InputStream> getStatementBankPdfWithHttpInfo(String accountId) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = getStatementBankPdfRequestBuilder(accountId);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("getStatementBankPdf", localVarResponse);
        }
        return new ApiResponse<InputStream>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : localVarResponse.body()
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder getStatementBankPdfRequestBuilder(String accountId) throws ApiException {
    // verify the required parameter 'accountId' is set
    if (accountId == null) {
      throw new ApiException(400, "Missing the required parameter 'accountId' when calling getStatementBankPdf");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/statements/{accountId}/bank/pdf"
        .replace("{accountId}", ApiClient.urlEncode(accountId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Accept", "application/pdf");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Get HTML Statement by Id
   * Get a HTML Statement from API 
   * @param statementId ID of the statement to get (required)
   * @return String
   * @throws ApiException if fails to make API call
   */
  public String getStatementHtml(String statementId) throws ApiException {
    ApiResponse<String> localVarResponse = getStatementHtmlWithHttpInfo(statementId);
    return localVarResponse.getData();
  }

  /**
   * Get HTML Statement by Id
   * Get a HTML Statement from API 
   * @param statementId ID of the statement to get (required)
   * @return ApiResponse&lt;String&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<String> getStatementHtmlWithHttpInfo(String statementId) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = getStatementHtmlRequestBuilder(statementId);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("getStatementHtml", localVarResponse);
        }
        return new ApiResponse<String>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : IOUtils.toString(localVarResponse.body(), StandardCharsets.UTF_8)
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder getStatementHtmlRequestBuilder(String statementId) throws ApiException {
    // verify the required parameter 'statementId' is set
    if (statementId == null) {
      throw new ApiException(400, "Missing the required parameter 'statementId' when calling getStatementHtml");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/statements/{statementId}/html"
        .replace("{statementId}", ApiClient.urlEncode(statementId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Accept", "text/html");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Get PDF Statement by Id
   * Get a PDF Statement from API 
   * @param statementId ID of the statement to get (required)
   * @return File
   * @throws ApiException if fails to make API call
   */
  public InputStream getStatementPdf(String statementId) throws ApiException {
    ApiResponse<InputStream> localVarResponse = getStatementPdfWithHttpInfo(statementId);
    return localVarResponse.getData();
  }

  /**
   * Get PDF Statement by Id
   * Get a PDF Statement from API 
   * @param statementId ID of the statement to get (required)
   * @return ApiResponse&lt;File&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<InputStream> getStatementPdfWithHttpInfo(String statementId) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = getStatementPdfRequestBuilder(statementId);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("getStatementPdf", localVarResponse);
        }
        return new ApiResponse<InputStream>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : localVarResponse.body()
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder getStatementPdfRequestBuilder(String statementId) throws ApiException {
    // verify the required parameter 'statementId' is set
    if (statementId == null) {
      throw new ApiException(400, "Missing the required parameter 'statementId' when calling getStatementPdf");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/statements/{statementId}/pdf"
        .replace("{statementId}", ApiClient.urlEncode(statementId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Accept", "application/pdf");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Get List Statements
   * Get List Statements from API 
   * @param page  (optional)
   * @param filter  (optional)
   * @param sort  (optional)
   * @return UnitStatementsResponse
   * @throws ApiException if fails to make API call
   */
  public UnitStatementsResponse getStatementsList(ListPageParameters page, GetStatementsListFilterParameter filter, String sort) throws ApiException {
    ApiResponse<UnitStatementsResponse> localVarResponse = getStatementsListWithHttpInfo(page, filter, sort);
    return localVarResponse.getData();
  }

  /**
   * Get List Statements
   * Get List Statements from API 
   * @param page  (optional)
   * @param filter  (optional)
   * @param sort  (optional)
   * @return ApiResponse&lt;UnitStatementsResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitStatementsResponse> getStatementsListWithHttpInfo(ListPageParameters page, GetStatementsListFilterParameter filter, String sort) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = getStatementsListRequestBuilder(page, filter, sort);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("getStatementsList", localVarResponse);
        }
        return new ApiResponse<UnitStatementsResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitStatementsResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder getStatementsListRequestBuilder(ListPageParameters page, GetStatementsListFilterParameter filter, String sort) throws ApiException {

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/statements";

    List<Pair> localVarQueryParams = new ArrayList<>();
    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    localVarQueryParameterBaseName = "page";
    if (page != null) {
      String queryString = page.toUrlQueryString("page");
      if (!queryString.isBlank()) {
        localVarQueryStringJoiner.add(queryString);
      }
    }
    localVarQueryParameterBaseName = "filter";
    if (filter != null) {
      String queryString = filter.toUrlQueryString("filter");
      if (!queryString.isBlank()) {
        localVarQueryStringJoiner.add(queryString);
      }
    }
    localVarQueryParameterBaseName = "sort";
    localVarQueryParams.addAll(ApiClient.parameterToPairs("sort", sort));

    if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
      StringJoiner queryJoiner = new StringJoiner("&");
      localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + '=' + p.getValue()));
      if (localVarQueryStringJoiner.length() != 0) {
        queryJoiner.add(localVarQueryStringJoiner.toString());
      }
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath + '?' + queryJoiner.toString()));
    } else {
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));
    }

    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Get details of a specific stop payment
   * 
   * @param stopPaymentId ID of the stop payment (required)
   * @return StopPaymentResponse
   * @throws ApiException if fails to make API call
   */
  public StopPaymentResponse getStopPayment(String stopPaymentId) throws ApiException {
    ApiResponse<StopPaymentResponse> localVarResponse = getStopPaymentWithHttpInfo(stopPaymentId);
    return localVarResponse.getData();
  }

  /**
   * Get details of a specific stop payment
   * 
   * @param stopPaymentId ID of the stop payment (required)
   * @return ApiResponse&lt;StopPaymentResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<StopPaymentResponse> getStopPaymentWithHttpInfo(String stopPaymentId) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = getStopPaymentRequestBuilder(stopPaymentId);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("getStopPayment", localVarResponse);
        }
        return new ApiResponse<StopPaymentResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<StopPaymentResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder getStopPaymentRequestBuilder(String stopPaymentId) throws ApiException {
    // verify the required parameter 'stopPaymentId' is set
    if (stopPaymentId == null) {
      throw new ApiException(400, "Missing the required parameter 'stopPaymentId' when calling getStopPayment");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/stop-payments/{stopPaymentId}"
        .replace("{stopPaymentId}", ApiClient.urlEncode(stopPaymentId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Accept", "application/json");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Get a list of stop payments
   * 
   * @param page  (optional)
   * @param filter  (optional)
   * @param sort  (optional)
   * @return StopPaymentListResponse
   * @throws ApiException if fails to make API call
   */
  public StopPaymentListResponse getStopPaymentsList(ListPageParameters page, GetStopPaymentsListFilterParameter filter, String sort) throws ApiException {
    ApiResponse<StopPaymentListResponse> localVarResponse = getStopPaymentsListWithHttpInfo(page, filter, sort);
    return localVarResponse.getData();
  }

  /**
   * Get a list of stop payments
   * 
   * @param page  (optional)
   * @param filter  (optional)
   * @param sort  (optional)
   * @return ApiResponse&lt;StopPaymentListResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<StopPaymentListResponse> getStopPaymentsListWithHttpInfo(ListPageParameters page, GetStopPaymentsListFilterParameter filter, String sort) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = getStopPaymentsListRequestBuilder(page, filter, sort);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("getStopPaymentsList", localVarResponse);
        }
        return new ApiResponse<StopPaymentListResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<StopPaymentListResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder getStopPaymentsListRequestBuilder(ListPageParameters page, GetStopPaymentsListFilterParameter filter, String sort) throws ApiException {

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/stop-payments";

    List<Pair> localVarQueryParams = new ArrayList<>();
    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    localVarQueryParameterBaseName = "page";
    if (page != null) {
      String queryString = page.toUrlQueryString("page");
      if (!queryString.isBlank()) {
        localVarQueryStringJoiner.add(queryString);
      }
    }
    localVarQueryParameterBaseName = "filter";
    localVarQueryParams.addAll(ApiClient.parameterToPairs("accountId", filter.getAccountId()));
    localVarQueryParams.addAll(ApiClient.parameterToPairs("customerId", filter.getCustomerId()));
    localVarQueryParams.addAll(ApiClient.parameterToPairs("multi", "status", filter.getStatus()));
    localVarQueryParams.addAll(ApiClient.parameterToPairs("tags", filter.getTags()));
    localVarQueryParams.addAll(ApiClient.parameterToPairs("since", filter.getSince()));
    localVarQueryParams.addAll(ApiClient.parameterToPairs("until", filter.getUntil()));
    localVarQueryParams.addAll(ApiClient.parameterToPairs("fromAmount", filter.getFromAmount()));
    localVarQueryParams.addAll(ApiClient.parameterToPairs("toAmount", filter.getToAmount()));
    localVarQueryParams.addAll(ApiClient.parameterToPairs("checkNumber", filter.getCheckNumber()));
    localVarQueryParameterBaseName = "sort";
    localVarQueryParams.addAll(ApiClient.parameterToPairs("sort", sort));

    if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
      StringJoiner queryJoiner = new StringJoiner("&");
      localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + '=' + p.getValue()));
      if (localVarQueryStringJoiner.length() != 0) {
        queryJoiner.add(localVarQueryStringJoiner.toString());
      }
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath + '?' + queryJoiner.toString()));
    } else {
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));
    }

    localVarRequestBuilder.header("Accept", "application/json");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Get Tax Form by Id
   * Get a Tax Form from API 
   * @param taxFormId ID of the reward to get (required)
   * @return UnitTaxFormResponse
   * @throws ApiException if fails to make API call
   */
  public UnitTaxFormResponse getTaxForm(String taxFormId) throws ApiException {
    ApiResponse<UnitTaxFormResponse> localVarResponse = getTaxFormWithHttpInfo(taxFormId);
    return localVarResponse.getData();
  }

  /**
   * Get Tax Form by Id
   * Get a Tax Form from API 
   * @param taxFormId ID of the reward to get (required)
   * @return ApiResponse&lt;UnitTaxFormResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitTaxFormResponse> getTaxFormWithHttpInfo(String taxFormId) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = getTaxFormRequestBuilder(taxFormId);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("getTaxForm", localVarResponse);
        }
        return new ApiResponse<UnitTaxFormResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitTaxFormResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder getTaxFormRequestBuilder(String taxFormId) throws ApiException {
    // verify the required parameter 'taxFormId' is set
    if (taxFormId == null) {
      throw new ApiException(400, "Missing the required parameter 'taxFormId' when calling getTaxForm");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/tax-forms/{taxFormId}"
        .replace("{taxFormId}", ApiClient.urlEncode(taxFormId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Get Tax Form pdf by Id
   * Get a Tax Form pdf from API 
   * @param taxFormId ID of the reward to get (required)
   * @return File
   * @throws ApiException if fails to make API call
   */
  public InputStream getTaxFormPdf(String taxFormId) throws ApiException {
    ApiResponse<InputStream> localVarResponse = getTaxFormPdfWithHttpInfo(taxFormId);
    return localVarResponse.getData();
  }

  /**
   * Get Tax Form pdf by Id
   * Get a Tax Form pdf from API 
   * @param taxFormId ID of the reward to get (required)
   * @return ApiResponse&lt;File&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<InputStream> getTaxFormPdfWithHttpInfo(String taxFormId) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = getTaxFormPdfRequestBuilder(taxFormId);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("getTaxFormPdf", localVarResponse);
        }
        return new ApiResponse<InputStream>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : localVarResponse.body()
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder getTaxFormPdfRequestBuilder(String taxFormId) throws ApiException {
    // verify the required parameter 'taxFormId' is set
    if (taxFormId == null) {
      throw new ApiException(400, "Missing the required parameter 'taxFormId' when calling getTaxFormPdf");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/tax-forms/{taxFormId}/pdf"
        .replace("{taxFormId}", ApiClient.urlEncode(taxFormId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Accept", "application/pdf");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Get Tax Forms List 
   * Get Tax Forms List from API 
   * @param page  (optional)
   * @param filter  (optional)
   * @return UnitTaxFormsListResponse
   * @throws ApiException if fails to make API call
   */
  public UnitTaxFormsListResponse getTaxFormsList(ListPageParameters page, GetTaxFormsListFilterParameter filter) throws ApiException {
    ApiResponse<UnitTaxFormsListResponse> localVarResponse = getTaxFormsListWithHttpInfo(page, filter);
    return localVarResponse.getData();
  }

  /**
   * Get Tax Forms List 
   * Get Tax Forms List from API 
   * @param page  (optional)
   * @param filter  (optional)
   * @return ApiResponse&lt;UnitTaxFormsListResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitTaxFormsListResponse> getTaxFormsListWithHttpInfo(ListPageParameters page, GetTaxFormsListFilterParameter filter) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = getTaxFormsListRequestBuilder(page, filter);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("getTaxFormsList", localVarResponse);
        }
        return new ApiResponse<UnitTaxFormsListResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitTaxFormsListResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder getTaxFormsListRequestBuilder(ListPageParameters page, GetTaxFormsListFilterParameter filter) throws ApiException {

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/tax-forms";

    List<Pair> localVarQueryParams = new ArrayList<>();
    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    localVarQueryParameterBaseName = "page";
    if (page != null) {
      String queryString = page.toUrlQueryString("page");
      if (!queryString.isBlank()) {
        localVarQueryStringJoiner.add(queryString);
      }
    }
    localVarQueryParameterBaseName = "filter";
    if (filter != null) {
      String queryString = filter.toUrlQueryString("filter");
      if (!queryString.isBlank()) {
        localVarQueryStringJoiner.add(queryString);
      }
    }

    if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
      StringJoiner queryJoiner = new StringJoiner("&");
      localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + '=' + p.getValue()));
      if (localVarQueryStringJoiner.length() != 0) {
        queryJoiner.add(localVarQueryStringJoiner.toString());
      }
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath + '?' + queryJoiner.toString()));
    } else {
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));
    }

    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Get Transaction by Id
   * Get a Transaction from API 
   * @param accountId ID of the account to get transaction from (required)
   * @param transactionId ID of the transaction (required)
   * @return UnitTransactionResponseWithIncludedResource
   * @throws ApiException if fails to make API call
   */
  public UnitTransactionResponseWithIncludedResource getTransaction(String accountId, String transactionId) throws ApiException {
    ApiResponse<UnitTransactionResponseWithIncludedResource> localVarResponse = getTransactionWithHttpInfo(accountId, transactionId);
    return localVarResponse.getData();
  }

  /**
   * Get Transaction by Id
   * Get a Transaction from API 
   * @param accountId ID of the account to get transaction from (required)
   * @param transactionId ID of the transaction (required)
   * @return ApiResponse&lt;UnitTransactionResponseWithIncludedResource&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitTransactionResponseWithIncludedResource> getTransactionWithHttpInfo(String accountId, String transactionId) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = getTransactionRequestBuilder(accountId, transactionId);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("getTransaction", localVarResponse);
        }
        return new ApiResponse<UnitTransactionResponseWithIncludedResource>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitTransactionResponseWithIncludedResource>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder getTransactionRequestBuilder(String accountId, String transactionId) throws ApiException {
    // verify the required parameter 'accountId' is set
    if (accountId == null) {
      throw new ApiException(400, "Missing the required parameter 'accountId' when calling getTransaction");
    }
    // verify the required parameter 'transactionId' is set
    if (transactionId == null) {
      throw new ApiException(400, "Missing the required parameter 'transactionId' when calling getTransaction");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/accounts/{accountId}/transactions/{transactionId}"
        .replace("{accountId}", ApiClient.urlEncode(accountId.toString()))
        .replace("{transactionId}", ApiClient.urlEncode(transactionId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Get List Transactions
   * Get List Transactions from API 
   * @param page  (optional)
   * @param filter  (optional)
   * @param sort  (optional)
   * @param include  (optional)
   * @return UnitTransactionsListResponse
   * @throws ApiException if fails to make API call
   */
  public UnitTransactionsListResponse getTransactionsList(ListPageParameters page, GetTransactionsListFilterParameter filter, String sort, String include) throws ApiException {
    ApiResponse<UnitTransactionsListResponse> localVarResponse = getTransactionsListWithHttpInfo(page, filter, sort, include);
    return localVarResponse.getData();
  }

  /**
   * Get List Transactions
   * Get List Transactions from API 
   * @param page  (optional)
   * @param filter  (optional)
   * @param sort  (optional)
   * @param include  (optional)
   * @return ApiResponse&lt;UnitTransactionsListResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitTransactionsListResponse> getTransactionsListWithHttpInfo(ListPageParameters page, GetTransactionsListFilterParameter filter, String sort, String include) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = getTransactionsListRequestBuilder(page, filter, sort, include);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("getTransactionsList", localVarResponse);
        }
        return new ApiResponse<UnitTransactionsListResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitTransactionsListResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder getTransactionsListRequestBuilder(ListPageParameters page, GetTransactionsListFilterParameter filter, String sort, String include) throws ApiException {

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/transactions";

    List<Pair> localVarQueryParams = new ArrayList<>();
    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    localVarQueryParameterBaseName = "page";
    if (page != null) {
      String queryString = page.toUrlQueryString("page");
      if (!queryString.isBlank()) {
        localVarQueryStringJoiner.add(queryString);
      }
    }
    localVarQueryParameterBaseName = "filter";
    if (filter != null) {
      String queryString = filter.toUrlQueryString("filter");
      if (!queryString.isBlank()) {
        localVarQueryStringJoiner.add(queryString);
      }
    }
    localVarQueryParameterBaseName = "sort";
    localVarQueryParams.addAll(ApiClient.parameterToPairs("sort", sort));
    localVarQueryParameterBaseName = "include";
    localVarQueryParams.addAll(ApiClient.parameterToPairs("include", include));

    if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
      StringJoiner queryJoiner = new StringJoiner("&");
      localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + '=' + p.getValue()));
      if (localVarQueryStringJoiner.length() != 0) {
        queryJoiner.add(localVarQueryStringJoiner.toString());
      }
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath + '?' + queryJoiner.toString()));
    } else {
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));
    }

    localVarRequestBuilder.header("Accept", "application/vnd.api+json");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Get Webhook Id
   * Get a Webhook from API 
   * @param webhookId ID of the webhook to get (required)
   * @return UnitWebhookResponse
   * @throws ApiException if fails to make API call
   */
  public UnitWebhookResponse getWebhook(String webhookId) throws ApiException {
    ApiResponse<UnitWebhookResponse> localVarResponse = getWebhookWithHttpInfo(webhookId);
    return localVarResponse.getData();
  }

  /**
   * Get Webhook Id
   * Get a Webhook from API 
   * @param webhookId ID of the webhook to get (required)
   * @return ApiResponse&lt;UnitWebhookResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitWebhookResponse> getWebhookWithHttpInfo(String webhookId) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = getWebhookRequestBuilder(webhookId);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("getWebhook", localVarResponse);
        }
        return new ApiResponse<UnitWebhookResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitWebhookResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder getWebhookRequestBuilder(String webhookId) throws ApiException {
    // verify the required parameter 'webhookId' is set
    if (webhookId == null) {
      throw new ApiException(400, "Missing the required parameter 'webhookId' when calling getWebhook");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/webhooks/{webhookId}"
        .replace("{webhookId}", ApiClient.urlEncode(webhookId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Get List Webhooks
   * Get List Webhooks from API 
   * @param page  (optional)
   * @param filter  (optional)
   * @param sort  (optional)
   * @return UnitWebhooksListResponse
   * @throws ApiException if fails to make API call
   */
  public UnitWebhooksListResponse getWebhooksList(ListPageParameters page, GetWebhooksListFilterParameter filter, String sort) throws ApiException {
    ApiResponse<UnitWebhooksListResponse> localVarResponse = getWebhooksListWithHttpInfo(page, filter, sort);
    return localVarResponse.getData();
  }

  /**
   * Get List Webhooks
   * Get List Webhooks from API 
   * @param page  (optional)
   * @param filter  (optional)
   * @param sort  (optional)
   * @return ApiResponse&lt;UnitWebhooksListResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitWebhooksListResponse> getWebhooksListWithHttpInfo(ListPageParameters page, GetWebhooksListFilterParameter filter, String sort) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = getWebhooksListRequestBuilder(page, filter, sort);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("getWebhooksList", localVarResponse);
        }
        return new ApiResponse<UnitWebhooksListResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitWebhooksListResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder getWebhooksListRequestBuilder(ListPageParameters page, GetWebhooksListFilterParameter filter, String sort) throws ApiException {

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/webhooks";

    List<Pair> localVarQueryParams = new ArrayList<>();
    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    localVarQueryParameterBaseName = "page";
    if (page != null) {
      String queryString = page.toUrlQueryString("page");
      if (!queryString.isBlank()) {
        localVarQueryStringJoiner.add(queryString);
      }
    }
    localVarQueryParameterBaseName = "filter";
    if (filter != null) {
      String queryString = filter.toUrlQueryString("filter");
      if (!queryString.isBlank()) {
        localVarQueryStringJoiner.add(queryString);
      }
    }
    localVarQueryParameterBaseName = "sort";
    localVarQueryParams.addAll(ApiClient.parameterToPairs("sort", sort));

    if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
      StringJoiner queryJoiner = new StringJoiner("&");
      localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + '=' + p.getValue()));
      if (localVarQueryStringJoiner.length() != 0) {
        queryJoiner.add(localVarQueryStringJoiner.toString());
      }
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath + '?' + queryJoiner.toString()));
    } else {
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));
    }

    localVarRequestBuilder.header("Accept", "application/vnd.api+json");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Update Received Payment
   * Update a Received Payment via API 
   * @param paymentId ID of the payment to update (required)
   * @param updateReceivedPaymentRequest Update Received Payment Request (required)
   * @return UnitReceivedPaymentResponse
   * @throws ApiException if fails to make API call
   */
  public UnitReceivedPaymentResponse receivedPaymentsPaymentIdPatch(String paymentId, UpdateReceivedPaymentRequest updateReceivedPaymentRequest) throws ApiException {
    ApiResponse<UnitReceivedPaymentResponse> localVarResponse = receivedPaymentsPaymentIdPatchWithHttpInfo(paymentId, updateReceivedPaymentRequest);
    return localVarResponse.getData();
  }

  /**
   * Update Received Payment
   * Update a Received Payment via API 
   * @param paymentId ID of the payment to update (required)
   * @param updateReceivedPaymentRequest Update Received Payment Request (required)
   * @return ApiResponse&lt;UnitReceivedPaymentResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitReceivedPaymentResponse> receivedPaymentsPaymentIdPatchWithHttpInfo(String paymentId, UpdateReceivedPaymentRequest updateReceivedPaymentRequest) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = receivedPaymentsPaymentIdPatchRequestBuilder(paymentId, updateReceivedPaymentRequest);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("receivedPaymentsPaymentIdPatch", localVarResponse);
        }
        return new ApiResponse<UnitReceivedPaymentResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitReceivedPaymentResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder receivedPaymentsPaymentIdPatchRequestBuilder(String paymentId, UpdateReceivedPaymentRequest updateReceivedPaymentRequest) throws ApiException {
    // verify the required parameter 'paymentId' is set
    if (paymentId == null) {
      throw new ApiException(400, "Missing the required parameter 'paymentId' when calling receivedPaymentsPaymentIdPatch");
    }
    // verify the required parameter 'updateReceivedPaymentRequest' is set
    if (updateReceivedPaymentRequest == null) {
      throw new ApiException(400, "Missing the required parameter 'updateReceivedPaymentRequest' when calling receivedPaymentsPaymentIdPatch");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/received-payments/{paymentId}"
        .replace("{paymentId}", ApiClient.urlEncode(paymentId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Content-Type", "application/vnd.api+json");
    localVarRequestBuilder.header("Accept", "application/vnd.api+json");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(updateReceivedPaymentRequest);
      localVarRequestBuilder.method("PATCH", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
    } catch (IOException e) {
      throw new ApiException(e);
    }
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Remove Owners from Account by Id
   * Remove Owners from Account via API 
   * @param accountId ID of the account to add owners to (required)
   * @param removeAccountOwnersRequest Remove Account Owners Request (required)
   * @return UnitDepositAccountResponse
   * @throws ApiException if fails to make API call
   */
  public UnitDepositAccountResponse removeAccountOwners(String accountId, RemoveAccountOwnersRequest removeAccountOwnersRequest) throws ApiException {
    ApiResponse<UnitDepositAccountResponse> localVarResponse = removeAccountOwnersWithHttpInfo(accountId, removeAccountOwnersRequest);
    return localVarResponse.getData();
  }

  /**
   * Remove Owners from Account by Id
   * Remove Owners from Account via API 
   * @param accountId ID of the account to add owners to (required)
   * @param removeAccountOwnersRequest Remove Account Owners Request (required)
   * @return ApiResponse&lt;UnitDepositAccountResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitDepositAccountResponse> removeAccountOwnersWithHttpInfo(String accountId, RemoveAccountOwnersRequest removeAccountOwnersRequest) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = removeAccountOwnersRequestBuilder(accountId, removeAccountOwnersRequest);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("removeAccountOwners", localVarResponse);
        }
        return new ApiResponse<UnitDepositAccountResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitDepositAccountResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder removeAccountOwnersRequestBuilder(String accountId, RemoveAccountOwnersRequest removeAccountOwnersRequest) throws ApiException {
    // verify the required parameter 'accountId' is set
    if (accountId == null) {
      throw new ApiException(400, "Missing the required parameter 'accountId' when calling removeAccountOwners");
    }
    // verify the required parameter 'removeAccountOwnersRequest' is set
    if (removeAccountOwnersRequest == null) {
      throw new ApiException(400, "Missing the required parameter 'removeAccountOwnersRequest' when calling removeAccountOwners");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/accounts/{accountId}/relationships/customers"
        .replace("{accountId}", ApiClient.urlEncode(accountId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Content-Type", "application/vnd.api+json");
    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(removeAccountOwnersRequest);
      localVarRequestBuilder.method("DELETE", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
    } catch (IOException e) {
      throw new ApiException(e);
    }
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Remove Authorized Users by Id
   * Remove Authorized Users via API
   * @param customerId ID of the customer to remove authorized users from (required)
   * @param removeAuthorizedUsersRequest Add Authorized Users Request (required)
   * @return UnitCustomerResponse
   * @throws ApiException if fails to make API call
   */
  public UnitCustomerResponse removeAuthorizedUsers(String customerId, RemoveAuthorizedUsersRequest removeAuthorizedUsersRequest) throws ApiException {
    ApiResponse<UnitCustomerResponse> localVarResponse = removeAuthorizedUsersWithHttpInfo(customerId, removeAuthorizedUsersRequest);
    return localVarResponse.getData();
  }

  /**
   * Remove Authorized Users by Id
   * Remove Authorized Users via API
   * @param customerId ID of the customer to remove authorized users from (required)
   * @param removeAuthorizedUsersRequest Add Authorized Users Request (required)
   * @return ApiResponse&lt;UnitCustomerResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitCustomerResponse> removeAuthorizedUsersWithHttpInfo(String customerId, RemoveAuthorizedUsersRequest removeAuthorizedUsersRequest) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = removeAuthorizedUsersRequestBuilder(customerId, removeAuthorizedUsersRequest);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("removeAuthorizedUsers", localVarResponse);
        }
        return new ApiResponse<UnitCustomerResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitCustomerResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder removeAuthorizedUsersRequestBuilder(String customerId, RemoveAuthorizedUsersRequest removeAuthorizedUsersRequest) throws ApiException {
    // verify the required parameter 'customerId' is set
    if (customerId == null) {
      throw new ApiException(400, "Missing the required parameter 'customerId' when calling removeAuthorizedUsers");
    }
    // verify the required parameter 'removeAuthorizedUsersRequest' is set
    if (removeAuthorizedUsersRequest == null) {
      throw new ApiException(400, "Missing the required parameter 'removeAuthorizedUsersRequest' when calling removeAuthorizedUsers");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/customers/{customerId}/authorized-users"
        .replace("{customerId}", ApiClient.urlEncode(customerId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Content-Type", "application/vnd.api+json");
    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(removeAuthorizedUsersRequest);
      localVarRequestBuilder.method("DELETE", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
    } catch (IOException e) {
      throw new ApiException(e);
    }
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Reopen an Account by Id
   * Reopen an Account via API 
   * @param accountId ID of the account to close (required)
   * @return UnitAccountResponse
   * @throws ApiException if fails to make API call
   */
  public UnitAccountResponse reopenAccount(String accountId) throws ApiException {
    ApiResponse<UnitAccountResponse> localVarResponse = reopenAccountWithHttpInfo(accountId);
    return localVarResponse.getData();
  }

  /**
   * Reopen an Account by Id
   * Reopen an Account via API 
   * @param accountId ID of the account to close (required)
   * @return ApiResponse&lt;UnitAccountResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitAccountResponse> reopenAccountWithHttpInfo(String accountId) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = reopenAccountRequestBuilder(accountId);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("reopenAccount", localVarResponse);
        }
        return new ApiResponse<UnitAccountResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitAccountResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder reopenAccountRequestBuilder(String accountId) throws ApiException {
    // verify the required parameter 'accountId' is set
    if (accountId == null) {
      throw new ApiException(400, "Missing the required parameter 'accountId' when calling reopenAccount");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/accounts/{accountId}/reopen"
        .replace("{accountId}", ApiClient.urlEncode(accountId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Replace a Card
   * Replace a Card via API 
   * @param cardId ID of the card to replace (required)
   * @param replaceCardRequest  (required)
   * @return UnitCardResponse
   * @throws ApiException if fails to make API call
   */
  public UnitCardResponse replaceCard(String cardId, ReplaceCardRequest replaceCardRequest) throws ApiException {
    ApiResponse<UnitCardResponse> localVarResponse = replaceCardWithHttpInfo(cardId, replaceCardRequest);
    return localVarResponse.getData();
  }

  /**
   * Replace a Card
   * Replace a Card via API 
   * @param cardId ID of the card to replace (required)
   * @param replaceCardRequest  (required)
   * @return ApiResponse&lt;UnitCardResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitCardResponse> replaceCardWithHttpInfo(String cardId, ReplaceCardRequest replaceCardRequest) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = replaceCardRequestBuilder(cardId, replaceCardRequest);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("replaceCard", localVarResponse);
        }
        return new ApiResponse<UnitCardResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitCardResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder replaceCardRequestBuilder(String cardId, ReplaceCardRequest replaceCardRequest) throws ApiException {
    // verify the required parameter 'cardId' is set
    if (cardId == null) {
      throw new ApiException(400, "Missing the required parameter 'cardId' when calling replaceCard");
    }
    // verify the required parameter 'replaceCardRequest' is set
    if (replaceCardRequest == null) {
      throw new ApiException(400, "Missing the required parameter 'replaceCardRequest' when calling replaceCard");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/cards/{cardId}/replace"
        .replace("{cardId}", ApiClient.urlEncode(cardId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Content-Type", "application/vnd.api+json");
    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(replaceCardRequest);
      localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
    } catch (IOException e) {
      throw new ApiException(e);
    }
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Report lost as stolen
   * Report lost as stolen via API 
   * @param cardId ID of the card (required)
   * @return UnitCardResponse
   * @throws ApiException if fails to make API call
   */
  public UnitCardResponse reportCardAsLost(String cardId) throws ApiException {
    ApiResponse<UnitCardResponse> localVarResponse = reportCardAsLostWithHttpInfo(cardId);
    return localVarResponse.getData();
  }

  /**
   * Report lost as stolen
   * Report lost as stolen via API 
   * @param cardId ID of the card (required)
   * @return ApiResponse&lt;UnitCardResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitCardResponse> reportCardAsLostWithHttpInfo(String cardId) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = reportCardAsLostRequestBuilder(cardId);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("reportCardAsLost", localVarResponse);
        }
        return new ApiResponse<UnitCardResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitCardResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder reportCardAsLostRequestBuilder(String cardId) throws ApiException {
    // verify the required parameter 'cardId' is set
    if (cardId == null) {
      throw new ApiException(400, "Missing the required parameter 'cardId' when calling reportCardAsLost");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/cards/{cardId}/report-lost"
        .replace("{cardId}", ApiClient.urlEncode(cardId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Report card as stolen
   * Report card as stolen via API 
   * @param cardId ID of the card (required)
   * @return UnitCardResponse
   * @throws ApiException if fails to make API call
   */
  public UnitCardResponse reportCardAsStolen(String cardId) throws ApiException {
    ApiResponse<UnitCardResponse> localVarResponse = reportCardAsStolenWithHttpInfo(cardId);
    return localVarResponse.getData();
  }

  /**
   * Report card as stolen
   * Report card as stolen via API 
   * @param cardId ID of the card (required)
   * @return ApiResponse&lt;UnitCardResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitCardResponse> reportCardAsStolenWithHttpInfo(String cardId) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = reportCardAsStolenRequestBuilder(cardId);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("reportCardAsStolen", localVarResponse);
        }
        return new ApiResponse<UnitCardResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitCardResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder reportCardAsStolenRequestBuilder(String cardId) throws ApiException {
    // verify the required parameter 'cardId' is set
    if (cardId == null) {
      throw new ApiException(400, "Missing the required parameter 'cardId' when calling reportCardAsStolen");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/cards/{cardId}/report-stolen"
        .replace("{cardId}", ApiClient.urlEncode(cardId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Reprocess Received Payment by Id
   * Reprocess a Received Payment via API 
   * @param paymentId ID of the payment to advance (required)
   * @return UnitReceivedPaymentResponse
   * @throws ApiException if fails to make API call
   */
  public UnitReceivedPaymentResponse reprocessReceivedPayment(String paymentId) throws ApiException {
    ApiResponse<UnitReceivedPaymentResponse> localVarResponse = reprocessReceivedPaymentWithHttpInfo(paymentId);
    return localVarResponse.getData();
  }

  /**
   * Reprocess Received Payment by Id
   * Reprocess a Received Payment via API 
   * @param paymentId ID of the payment to advance (required)
   * @return ApiResponse&lt;UnitReceivedPaymentResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitReceivedPaymentResponse> reprocessReceivedPaymentWithHttpInfo(String paymentId) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = reprocessReceivedPaymentRequestBuilder(paymentId);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("reprocessReceivedPayment", localVarResponse);
        }
        return new ApiResponse<UnitReceivedPaymentResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitReceivedPaymentResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder reprocessReceivedPaymentRequestBuilder(String paymentId) throws ApiException {
    // verify the required parameter 'paymentId' is set
    if (paymentId == null) {
      throw new ApiException(400, "Missing the required parameter 'paymentId' when calling reprocessReceivedPayment");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/received-payments/{paymentId}/reprocess"
        .replace("{paymentId}", ApiClient.urlEncode(paymentId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Return Check Payment by Id
   * Return a Check Payment via API 
   * @param checkPaymentId ID of the check payment to return (required)
   * @param returnCheckPaymentRequest Return Check Payment Request (required)
   * @return UnitCheckPaymentResponse
   * @throws ApiException if fails to make API call
   */
  public UnitCheckPaymentResponse returnCheckPayment(String checkPaymentId, ReturnCheckPaymentRequest returnCheckPaymentRequest) throws ApiException {
    ApiResponse<UnitCheckPaymentResponse> localVarResponse = returnCheckPaymentWithHttpInfo(checkPaymentId, returnCheckPaymentRequest);
    return localVarResponse.getData();
  }

  /**
   * Return Check Payment by Id
   * Return a Check Payment via API 
   * @param checkPaymentId ID of the check payment to return (required)
   * @param returnCheckPaymentRequest Return Check Payment Request (required)
   * @return ApiResponse&lt;UnitCheckPaymentResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitCheckPaymentResponse> returnCheckPaymentWithHttpInfo(String checkPaymentId, ReturnCheckPaymentRequest returnCheckPaymentRequest) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = returnCheckPaymentRequestBuilder(checkPaymentId, returnCheckPaymentRequest);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("returnCheckPayment", localVarResponse);
        }
        return new ApiResponse<UnitCheckPaymentResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitCheckPaymentResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder returnCheckPaymentRequestBuilder(String checkPaymentId, ReturnCheckPaymentRequest returnCheckPaymentRequest) throws ApiException {
    // verify the required parameter 'checkPaymentId' is set
    if (checkPaymentId == null) {
      throw new ApiException(400, "Missing the required parameter 'checkPaymentId' when calling returnCheckPayment");
    }
    // verify the required parameter 'returnCheckPaymentRequest' is set
    if (returnCheckPaymentRequest == null) {
      throw new ApiException(400, "Missing the required parameter 'returnCheckPaymentRequest' when calling returnCheckPayment");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/check-payments/{checkPaymentId}/return"
        .replace("{checkPaymentId}", ApiClient.urlEncode(checkPaymentId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Content-Type", "application/vnd.api+json");
    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(returnCheckPaymentRequest);
      localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
    } catch (IOException e) {
      throw new ApiException(e);
    }
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Return Received ACH Transaction
   * Return Received ACH Transaction via API 
   * @param transactionId ID of the transaction to return (required)
   * @param returnReceivedACHTransactionRequest Pass empty object in order for content-type to be aquired correctly (required)
   * @return UnitReturnedReceivedAchTransactionResponse
   * @throws ApiException if fails to make API call
   */
  public UnitReturnedReceivedAchTransactionResponse returnReceivedACHTransaction(String transactionId, ReturnReceivedACHTransactionRequest returnReceivedACHTransactionRequest) throws ApiException {
    ApiResponse<UnitReturnedReceivedAchTransactionResponse> localVarResponse = returnReceivedACHTransactionWithHttpInfo(transactionId, returnReceivedACHTransactionRequest);
    return localVarResponse.getData();
  }

  /**
   * Return Received ACH Transaction
   * Return Received ACH Transaction via API 
   * @param transactionId ID of the transaction to return (required)
   * @param returnReceivedACHTransactionRequest Pass empty object in order for content-type to be aquired correctly (required)
   * @return ApiResponse&lt;UnitReturnedReceivedAchTransactionResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitReturnedReceivedAchTransactionResponse> returnReceivedACHTransactionWithHttpInfo(String transactionId, ReturnReceivedACHTransactionRequest returnReceivedACHTransactionRequest) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = returnReceivedACHTransactionRequestBuilder(transactionId, returnReceivedACHTransactionRequest);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("returnReceivedACHTransaction", localVarResponse);
        }
        return new ApiResponse<UnitReturnedReceivedAchTransactionResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitReturnedReceivedAchTransactionResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder returnReceivedACHTransactionRequestBuilder(String transactionId, ReturnReceivedACHTransactionRequest returnReceivedACHTransactionRequest) throws ApiException {
    // verify the required parameter 'transactionId' is set
    if (transactionId == null) {
      throw new ApiException(400, "Missing the required parameter 'transactionId' when calling returnReceivedACHTransaction");
    }
    // verify the required parameter 'returnReceivedACHTransactionRequest' is set
    if (returnReceivedACHTransactionRequest == null) {
      throw new ApiException(400, "Missing the required parameter 'returnReceivedACHTransactionRequest' when calling returnReceivedACHTransaction");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/returns/{transactionId}"
        .replace("{transactionId}", ApiClient.urlEncode(transactionId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Content-Type", "application/vnd.api+json");
    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(returnReceivedACHTransactionRequest);
      localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
    } catch (IOException e) {
      throw new ApiException(e);
    }
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Reverse Fee
   * Reverse a Fee via API 
   * @param reverseFeeRequest Reverse Fee Request (required)
   * @return UnitFeeReversalResponse
   * @throws ApiException if fails to make API call
   */
  public UnitFeeReversalResponse reverseFee(ReverseFeeRequest reverseFeeRequest) throws ApiException {
    ApiResponse<UnitFeeReversalResponse> localVarResponse = reverseFeeWithHttpInfo(reverseFeeRequest);
    return localVarResponse.getData();
  }

  /**
   * Reverse Fee
   * Reverse a Fee via API 
   * @param reverseFeeRequest Reverse Fee Request (required)
   * @return ApiResponse&lt;UnitFeeReversalResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitFeeReversalResponse> reverseFeeWithHttpInfo(ReverseFeeRequest reverseFeeRequest) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = reverseFeeRequestBuilder(reverseFeeRequest);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("reverseFee", localVarResponse);
        }
        return new ApiResponse<UnitFeeReversalResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitFeeReversalResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder reverseFeeRequestBuilder(ReverseFeeRequest reverseFeeRequest) throws ApiException {
    // verify the required parameter 'reverseFeeRequest' is set
    if (reverseFeeRequest == null) {
      throw new ApiException(400, "Missing the required parameter 'reverseFeeRequest' when calling reverseFee");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/fees/reverse";

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Content-Type", "application/vnd.api+json");
    localVarRequestBuilder.header("Accept", "application/vnd.api+json");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(reverseFeeRequest);
      localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
    } catch (IOException e) {
      throw new ApiException(e);
    }
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Unfreeze Account by Id
   * Unfreeze an Account via API 
   * @param accountId ID of the account to get (required)
   * @return UnitAccountResponse
   * @throws ApiException if fails to make API call
   */
  public UnitAccountResponse unfreezeAccount(String accountId) throws ApiException {
    ApiResponse<UnitAccountResponse> localVarResponse = unfreezeAccountWithHttpInfo(accountId);
    return localVarResponse.getData();
  }

  /**
   * Unfreeze Account by Id
   * Unfreeze an Account via API 
   * @param accountId ID of the account to get (required)
   * @return ApiResponse&lt;UnitAccountResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitAccountResponse> unfreezeAccountWithHttpInfo(String accountId) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = unfreezeAccountRequestBuilder(accountId);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("unfreezeAccount", localVarResponse);
        }
        return new ApiResponse<UnitAccountResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitAccountResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder unfreezeAccountRequestBuilder(String accountId) throws ApiException {
    // verify the required parameter 'accountId' is set
    if (accountId == null) {
      throw new ApiException(400, "Missing the required parameter 'accountId' when calling unfreezeAccount");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/accounts/{accountId}/unfreeze"
        .replace("{accountId}", ApiClient.urlEncode(accountId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Unfreeze a Card
   * Unfreeze a Card via API 
   * @param cardId ID of the card to unfreeze (required)
   * @return UnitCardResponse
   * @throws ApiException if fails to make API call
   */
  public UnitCardResponse unfreezeCard(String cardId) throws ApiException {
    ApiResponse<UnitCardResponse> localVarResponse = unfreezeCardWithHttpInfo(cardId);
    return localVarResponse.getData();
  }

  /**
   * Unfreeze a Card
   * Unfreeze a Card via API 
   * @param cardId ID of the card to unfreeze (required)
   * @return ApiResponse&lt;UnitCardResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitCardResponse> unfreezeCardWithHttpInfo(String cardId) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = unfreezeCardRequestBuilder(cardId);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("unfreezeCard", localVarResponse);
        }
        return new ApiResponse<UnitCardResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitCardResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder unfreezeCardRequestBuilder(String cardId) throws ApiException {
    // verify the required parameter 'cardId' is set
    if (cardId == null) {
      throw new ApiException(400, "Missing the required parameter 'cardId' when calling unfreezeCard");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/cards/{cardId}/unfreeze"
        .replace("{cardId}", ApiClient.urlEncode(cardId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Update Account
   * Update an Account via API 
   * @param accountId ID of the account to update (required)
   * @param updateAccountRequest Update Account Request (required)
   * @return UnitAccountResponse
   * @throws ApiException if fails to make API call
   */
  public UnitAccountResponse updateAccount(String accountId, UpdateAccountRequest updateAccountRequest) throws ApiException {
    ApiResponse<UnitAccountResponse> localVarResponse = updateAccountWithHttpInfo(accountId, updateAccountRequest);
    return localVarResponse.getData();
  }

  /**
   * Update Account
   * Update an Account via API 
   * @param accountId ID of the account to update (required)
   * @param updateAccountRequest Update Account Request (required)
   * @return ApiResponse&lt;UnitAccountResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitAccountResponse> updateAccountWithHttpInfo(String accountId, UpdateAccountRequest updateAccountRequest) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = updateAccountRequestBuilder(accountId, updateAccountRequest);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("updateAccount", localVarResponse);
        }
        return new ApiResponse<UnitAccountResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitAccountResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder updateAccountRequestBuilder(String accountId, UpdateAccountRequest updateAccountRequest) throws ApiException {
    // verify the required parameter 'accountId' is set
    if (accountId == null) {
      throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateAccount");
    }
    // verify the required parameter 'updateAccountRequest' is set
    if (updateAccountRequest == null) {
      throw new ApiException(400, "Missing the required parameter 'updateAccountRequest' when calling updateAccount");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/accounts/{accountId}"
        .replace("{accountId}", ApiClient.urlEncode(accountId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Content-Type", "application/vnd.api+json");
    localVarRequestBuilder.header("Accept", "application/vnd.api+json, application/vnd.api+json; charset=utf-8");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(updateAccountRequest);
      localVarRequestBuilder.method("PATCH", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
    } catch (IOException e) {
      throw new ApiException(e);
    }
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Update Application
   * Update an Application via API 
   * @param applicationId ID of the application to update (required)
   * @param updateApplicationRequest Update Application Request (required)
   * @return UnitApplicationResponseWithIncluded
   * @throws ApiException if fails to make API call
   */
  public UnitApplicationResponseWithIncluded updateApplication(String applicationId, UpdateApplicationRequest updateApplicationRequest) throws ApiException {
    ApiResponse<UnitApplicationResponseWithIncluded> localVarResponse = updateApplicationWithHttpInfo(applicationId, updateApplicationRequest);
    return localVarResponse.getData();
  }

  /**
   * Update Application
   * Update an Application via API 
   * @param applicationId ID of the application to update (required)
   * @param updateApplicationRequest Update Application Request (required)
   * @return ApiResponse&lt;UnitApplicationResponseWithIncluded&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitApplicationResponseWithIncluded> updateApplicationWithHttpInfo(String applicationId, UpdateApplicationRequest updateApplicationRequest) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = updateApplicationRequestBuilder(applicationId, updateApplicationRequest);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("updateApplication", localVarResponse);
        }
        return new ApiResponse<UnitApplicationResponseWithIncluded>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitApplicationResponseWithIncluded>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder updateApplicationRequestBuilder(String applicationId, UpdateApplicationRequest updateApplicationRequest) throws ApiException {
    // verify the required parameter 'applicationId' is set
    if (applicationId == null) {
      throw new ApiException(400, "Missing the required parameter 'applicationId' when calling updateApplication");
    }
    // verify the required parameter 'updateApplicationRequest' is set
    if (updateApplicationRequest == null) {
      throw new ApiException(400, "Missing the required parameter 'updateApplicationRequest' when calling updateApplication");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/applications/{applicationId}"
        .replace("{applicationId}", ApiClient.urlEncode(applicationId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Content-Type", "application/vnd.api+json");
    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(updateApplicationRequest);
      localVarRequestBuilder.method("PATCH", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
    } catch (IOException e) {
      throw new ApiException(e);
    }
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Update a Business Beneficial Owner via API
   * Update a Business Beneficial Owner
   * @param beneficialOwnerId ID of the beneficial owner to update (required)
   * @param updateBusinessBeneficialOwnerRequest Update Business Beneficial Owner Request (required)
   * @return UnitBeneficialOwnerResponse
   * @throws ApiException if fails to make API call
   */
  public UnitBeneficialOwnerResponse updateBusinessBeneficialOwner(String beneficialOwnerId, UpdateBusinessBeneficialOwnerRequest updateBusinessBeneficialOwnerRequest) throws ApiException {
    ApiResponse<UnitBeneficialOwnerResponse> localVarResponse = updateBusinessBeneficialOwnerWithHttpInfo(beneficialOwnerId, updateBusinessBeneficialOwnerRequest);
    return localVarResponse.getData();
  }

  /**
   * Update a Business Beneficial Owner via API
   * Update a Business Beneficial Owner
   * @param beneficialOwnerId ID of the beneficial owner to update (required)
   * @param updateBusinessBeneficialOwnerRequest Update Business Beneficial Owner Request (required)
   * @return ApiResponse&lt;UnitBeneficialOwnerResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitBeneficialOwnerResponse> updateBusinessBeneficialOwnerWithHttpInfo(String beneficialOwnerId, UpdateBusinessBeneficialOwnerRequest updateBusinessBeneficialOwnerRequest) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = updateBusinessBeneficialOwnerRequestBuilder(beneficialOwnerId, updateBusinessBeneficialOwnerRequest);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("updateBusinessBeneficialOwner", localVarResponse);
        }
        return new ApiResponse<UnitBeneficialOwnerResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitBeneficialOwnerResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder updateBusinessBeneficialOwnerRequestBuilder(String beneficialOwnerId, UpdateBusinessBeneficialOwnerRequest updateBusinessBeneficialOwnerRequest) throws ApiException {
    // verify the required parameter 'beneficialOwnerId' is set
    if (beneficialOwnerId == null) {
      throw new ApiException(400, "Missing the required parameter 'beneficialOwnerId' when calling updateBusinessBeneficialOwner");
    }
    // verify the required parameter 'updateBusinessBeneficialOwnerRequest' is set
    if (updateBusinessBeneficialOwnerRequest == null) {
      throw new ApiException(400, "Missing the required parameter 'updateBusinessBeneficialOwnerRequest' when calling updateBusinessBeneficialOwner");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/beneficial-owner/{beneficialOwnerId}"
        .replace("{beneficialOwnerId}", ApiClient.urlEncode(beneficialOwnerId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Content-Type", "application/vnd.api+json");
    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(updateBusinessBeneficialOwnerRequest);
      localVarRequestBuilder.method("PATCH", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
    } catch (IOException e) {
      throw new ApiException(e);
    }
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Update Card
   * Update a Card via API 
   * @param cardId ID of the card to update (required)
   * @param updateCardRequest Update Card Request (required)
   * @return UnitCardResponse
   * @throws ApiException if fails to make API call
   */
  public UnitCardResponse updateCard(String cardId, UpdateCardRequest updateCardRequest) throws ApiException {
    ApiResponse<UnitCardResponse> localVarResponse = updateCardWithHttpInfo(cardId, updateCardRequest);
    return localVarResponse.getData();
  }

  /**
   * Update Card
   * Update a Card via API 
   * @param cardId ID of the card to update (required)
   * @param updateCardRequest Update Card Request (required)
   * @return ApiResponse&lt;UnitCardResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitCardResponse> updateCardWithHttpInfo(String cardId, UpdateCardRequest updateCardRequest) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = updateCardRequestBuilder(cardId, updateCardRequest);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("updateCard", localVarResponse);
        }
        return new ApiResponse<UnitCardResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitCardResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder updateCardRequestBuilder(String cardId, UpdateCardRequest updateCardRequest) throws ApiException {
    // verify the required parameter 'cardId' is set
    if (cardId == null) {
      throw new ApiException(400, "Missing the required parameter 'cardId' when calling updateCard");
    }
    // verify the required parameter 'updateCardRequest' is set
    if (updateCardRequest == null) {
      throw new ApiException(400, "Missing the required parameter 'updateCardRequest' when calling updateCard");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/cards/{cardId}"
        .replace("{cardId}", ApiClient.urlEncode(cardId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Content-Type", "application/vnd.api+json");
    localVarRequestBuilder.header("Accept", "application/vnd.api+json");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(updateCardRequest);
      localVarRequestBuilder.method("PATCH", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
    } catch (IOException e) {
      throw new ApiException(e);
    }
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Update Check Deposit
   * Update a Check Deposit via API 
   * @param checkDepositId ID of the check deposit to update (required)
   * @param updateCheckDepositRequest Update Check Deposit Request (required)
   * @return UnitCheckDepositResponse
   * @throws ApiException if fails to make API call
   */
  public UnitCheckDepositResponse updateCheckDeposit(String checkDepositId, UpdateCheckDepositRequest updateCheckDepositRequest) throws ApiException {
    ApiResponse<UnitCheckDepositResponse> localVarResponse = updateCheckDepositWithHttpInfo(checkDepositId, updateCheckDepositRequest);
    return localVarResponse.getData();
  }

  /**
   * Update Check Deposit
   * Update a Check Deposit via API 
   * @param checkDepositId ID of the check deposit to update (required)
   * @param updateCheckDepositRequest Update Check Deposit Request (required)
   * @return ApiResponse&lt;UnitCheckDepositResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitCheckDepositResponse> updateCheckDepositWithHttpInfo(String checkDepositId, UpdateCheckDepositRequest updateCheckDepositRequest) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = updateCheckDepositRequestBuilder(checkDepositId, updateCheckDepositRequest);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("updateCheckDeposit", localVarResponse);
        }
        return new ApiResponse<UnitCheckDepositResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitCheckDepositResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder updateCheckDepositRequestBuilder(String checkDepositId, UpdateCheckDepositRequest updateCheckDepositRequest) throws ApiException {
    // verify the required parameter 'checkDepositId' is set
    if (checkDepositId == null) {
      throw new ApiException(400, "Missing the required parameter 'checkDepositId' when calling updateCheckDeposit");
    }
    // verify the required parameter 'updateCheckDepositRequest' is set
    if (updateCheckDepositRequest == null) {
      throw new ApiException(400, "Missing the required parameter 'updateCheckDepositRequest' when calling updateCheckDeposit");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/check-deposits/{checkDepositId}"
        .replace("{checkDepositId}", ApiClient.urlEncode(checkDepositId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Content-Type", "application/vnd.api+json");
    localVarRequestBuilder.header("Accept", "application/vnd.api+json");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(updateCheckDepositRequest);
      localVarRequestBuilder.method("PATCH", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
    } catch (IOException e) {
      throw new ApiException(e);
    }
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Update Counterparty
   * Update a Counterparty via API 
   * @param counterpartyId ID of the counterparty to update (required)
   * @param updateCounterpartyRequest Update Counterparty Request (required)
   * @return UnitCounterpartyResponse
   * @throws ApiException if fails to make API call
   */
  public UnitCounterpartyResponse updateCounterparty(String counterpartyId, UpdateCounterpartyRequest updateCounterpartyRequest) throws ApiException {
    ApiResponse<UnitCounterpartyResponse> localVarResponse = updateCounterpartyWithHttpInfo(counterpartyId, updateCounterpartyRequest);
    return localVarResponse.getData();
  }

  /**
   * Update Counterparty
   * Update a Counterparty via API 
   * @param counterpartyId ID of the counterparty to update (required)
   * @param updateCounterpartyRequest Update Counterparty Request (required)
   * @return ApiResponse&lt;UnitCounterpartyResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitCounterpartyResponse> updateCounterpartyWithHttpInfo(String counterpartyId, UpdateCounterpartyRequest updateCounterpartyRequest) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = updateCounterpartyRequestBuilder(counterpartyId, updateCounterpartyRequest);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("updateCounterparty", localVarResponse);
        }
        return new ApiResponse<UnitCounterpartyResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitCounterpartyResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder updateCounterpartyRequestBuilder(String counterpartyId, UpdateCounterpartyRequest updateCounterpartyRequest) throws ApiException {
    // verify the required parameter 'counterpartyId' is set
    if (counterpartyId == null) {
      throw new ApiException(400, "Missing the required parameter 'counterpartyId' when calling updateCounterparty");
    }
    // verify the required parameter 'updateCounterpartyRequest' is set
    if (updateCounterpartyRequest == null) {
      throw new ApiException(400, "Missing the required parameter 'updateCounterpartyRequest' when calling updateCounterparty");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/counterparties/{counterpartyId}"
        .replace("{counterpartyId}", ApiClient.urlEncode(counterpartyId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Content-Type", "application/vnd.api+json");
    localVarRequestBuilder.header("Accept", "application/vnd.api+json");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(updateCounterpartyRequest);
      localVarRequestBuilder.method("PATCH", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
    } catch (IOException e) {
      throw new ApiException(e);
    }
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Update Customer
   * Update an Customer via API 
   * @param customerId ID of the customer to update (required)
   * @param updateCustomerRequest Update Customer Request (required)
   * @return UnitCustomerResponse
   * @throws ApiException if fails to make API call
   */
  public UnitCustomerResponse updateCustomer(String customerId, UpdateCustomerRequest updateCustomerRequest) throws ApiException {
    ApiResponse<UnitCustomerResponse> localVarResponse = updateCustomerWithHttpInfo(customerId, updateCustomerRequest);
    return localVarResponse.getData();
  }

  /**
   * Update Customer
   * Update an Customer via API 
   * @param customerId ID of the customer to update (required)
   * @param updateCustomerRequest Update Customer Request (required)
   * @return ApiResponse&lt;UnitCustomerResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitCustomerResponse> updateCustomerWithHttpInfo(String customerId, UpdateCustomerRequest updateCustomerRequest) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = updateCustomerRequestBuilder(customerId, updateCustomerRequest);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("updateCustomer", localVarResponse);
        }
        return new ApiResponse<UnitCustomerResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitCustomerResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder updateCustomerRequestBuilder(String customerId, UpdateCustomerRequest updateCustomerRequest) throws ApiException {
    // verify the required parameter 'customerId' is set
    if (customerId == null) {
      throw new ApiException(400, "Missing the required parameter 'customerId' when calling updateCustomer");
    }
    // verify the required parameter 'updateCustomerRequest' is set
    if (updateCustomerRequest == null) {
      throw new ApiException(400, "Missing the required parameter 'updateCustomerRequest' when calling updateCustomer");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/customers/{customerId}"
        .replace("{customerId}", ApiClient.urlEncode(customerId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Content-Type", "application/vnd.api+json");
    localVarRequestBuilder.header("Accept", "application/vnd.api+json");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(updateCustomerRequest);
      localVarRequestBuilder.method("PATCH", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
    } catch (IOException e) {
      throw new ApiException(e);
    }
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Update Payment
   * Update an Payment via API 
   * @param paymentId ID of the payment to update (required)
   * @param updatePaymentRequest Update Payment Request (required)
   * @return UnitPaymentResponse
   * @throws ApiException if fails to make API call
   */
  public UnitPaymentResponse updatePayment(String paymentId, UpdatePaymentRequest updatePaymentRequest) throws ApiException {
    ApiResponse<UnitPaymentResponse> localVarResponse = updatePaymentWithHttpInfo(paymentId, updatePaymentRequest);
    return localVarResponse.getData();
  }

  /**
   * Update Payment
   * Update an Payment via API 
   * @param paymentId ID of the payment to update (required)
   * @param updatePaymentRequest Update Payment Request (required)
   * @return ApiResponse&lt;UnitPaymentResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitPaymentResponse> updatePaymentWithHttpInfo(String paymentId, UpdatePaymentRequest updatePaymentRequest) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = updatePaymentRequestBuilder(paymentId, updatePaymentRequest);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("updatePayment", localVarResponse);
        }
        return new ApiResponse<UnitPaymentResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitPaymentResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder updatePaymentRequestBuilder(String paymentId, UpdatePaymentRequest updatePaymentRequest) throws ApiException {
    // verify the required parameter 'paymentId' is set
    if (paymentId == null) {
      throw new ApiException(400, "Missing the required parameter 'paymentId' when calling updatePayment");
    }
    // verify the required parameter 'updatePaymentRequest' is set
    if (updatePaymentRequest == null) {
      throw new ApiException(400, "Missing the required parameter 'updatePaymentRequest' when calling updatePayment");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/payments/{paymentId}"
        .replace("{paymentId}", ApiClient.urlEncode(paymentId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Content-Type", "application/vnd.api+json");
    localVarRequestBuilder.header("Accept", "application/vnd.api+json");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(updatePaymentRequest);
      localVarRequestBuilder.method("PATCH", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
    } catch (IOException e) {
      throw new ApiException(e);
    }
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Update a stop payment
   * 
   * @param stopPaymentId ID of the stop payment (required)
   * @param updateStopPaymentRequest  (required)
   * @return StopPaymentResponse
   * @throws ApiException if fails to make API call
   */
  public StopPaymentResponse updateStopPayment(String stopPaymentId, UpdateStopPaymentRequest updateStopPaymentRequest) throws ApiException {
    ApiResponse<StopPaymentResponse> localVarResponse = updateStopPaymentWithHttpInfo(stopPaymentId, updateStopPaymentRequest);
    return localVarResponse.getData();
  }

  /**
   * Update a stop payment
   * 
   * @param stopPaymentId ID of the stop payment (required)
   * @param updateStopPaymentRequest  (required)
   * @return ApiResponse&lt;StopPaymentResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<StopPaymentResponse> updateStopPaymentWithHttpInfo(String stopPaymentId, UpdateStopPaymentRequest updateStopPaymentRequest) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = updateStopPaymentRequestBuilder(stopPaymentId, updateStopPaymentRequest);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("updateStopPayment", localVarResponse);
        }
        return new ApiResponse<StopPaymentResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<StopPaymentResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder updateStopPaymentRequestBuilder(String stopPaymentId, UpdateStopPaymentRequest updateStopPaymentRequest) throws ApiException {
    // verify the required parameter 'stopPaymentId' is set
    if (stopPaymentId == null) {
      throw new ApiException(400, "Missing the required parameter 'stopPaymentId' when calling updateStopPayment");
    }
    // verify the required parameter 'updateStopPaymentRequest' is set
    if (updateStopPaymentRequest == null) {
      throw new ApiException(400, "Missing the required parameter 'updateStopPaymentRequest' when calling updateStopPayment");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/stop-payments/{stopPaymentId}"
        .replace("{stopPaymentId}", ApiClient.urlEncode(stopPaymentId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Content-Type", "application/json");
    localVarRequestBuilder.header("Accept", "application/json");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(updateStopPaymentRequest);
      localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
    } catch (IOException e) {
      throw new ApiException(e);
    }
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Update Transaction
   * Update a Transaction via API 
   * @param accountId ID of the account to update transaction from (required)
   * @param transactionId ID of the transaction to update (required)
   * @param updateTransactionRequest Update Transaction Request (required)
   * @return UnitTransactionResponse
   * @throws ApiException if fails to make API call
   */
  public UnitTransactionResponse updateTransaction(String accountId, String transactionId, UpdateTransactionRequest updateTransactionRequest) throws ApiException {
    ApiResponse<UnitTransactionResponse> localVarResponse = updateTransactionWithHttpInfo(accountId, transactionId, updateTransactionRequest);
    return localVarResponse.getData();
  }

  /**
   * Update Transaction
   * Update a Transaction via API 
   * @param accountId ID of the account to update transaction from (required)
   * @param transactionId ID of the transaction to update (required)
   * @param updateTransactionRequest Update Transaction Request (required)
   * @return ApiResponse&lt;UnitTransactionResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitTransactionResponse> updateTransactionWithHttpInfo(String accountId, String transactionId, UpdateTransactionRequest updateTransactionRequest) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = updateTransactionRequestBuilder(accountId, transactionId, updateTransactionRequest);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("updateTransaction", localVarResponse);
        }
        return new ApiResponse<UnitTransactionResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitTransactionResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder updateTransactionRequestBuilder(String accountId, String transactionId, UpdateTransactionRequest updateTransactionRequest) throws ApiException {
    // verify the required parameter 'accountId' is set
    if (accountId == null) {
      throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateTransaction");
    }
    // verify the required parameter 'transactionId' is set
    if (transactionId == null) {
      throw new ApiException(400, "Missing the required parameter 'transactionId' when calling updateTransaction");
    }
    // verify the required parameter 'updateTransactionRequest' is set
    if (updateTransactionRequest == null) {
      throw new ApiException(400, "Missing the required parameter 'updateTransactionRequest' when calling updateTransaction");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/accounts/{accountId}/transactions/{transactionId}"
        .replace("{accountId}", ApiClient.urlEncode(accountId.toString()))
        .replace("{transactionId}", ApiClient.urlEncode(transactionId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Content-Type", "application/vnd.api+json");
    localVarRequestBuilder.header("Accept", "application/vnd.api+json");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(updateTransactionRequest);
      localVarRequestBuilder.method("PATCH", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
    } catch (IOException e) {
      throw new ApiException(e);
    }
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Update Webhook
   * Update a Webhook via API 
   * @param webhookId ID of the Webhook to update (required)
   * @param updateWebhookRequest Update Webhook Request (required)
   * @return UnitWebhookResponse
   * @throws ApiException if fails to make API call
   */
  public UnitWebhookResponse updateWebhook(String webhookId, UpdateWebhookRequest updateWebhookRequest) throws ApiException {
    ApiResponse<UnitWebhookResponse> localVarResponse = updateWebhookWithHttpInfo(webhookId, updateWebhookRequest);
    return localVarResponse.getData();
  }

  /**
   * Update Webhook
   * Update a Webhook via API 
   * @param webhookId ID of the Webhook to update (required)
   * @param updateWebhookRequest Update Webhook Request (required)
   * @return ApiResponse&lt;UnitWebhookResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitWebhookResponse> updateWebhookWithHttpInfo(String webhookId, UpdateWebhookRequest updateWebhookRequest) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = updateWebhookRequestBuilder(webhookId, updateWebhookRequest);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("updateWebhook", localVarResponse);
        }
        return new ApiResponse<UnitWebhookResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitWebhookResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder updateWebhookRequestBuilder(String webhookId, UpdateWebhookRequest updateWebhookRequest) throws ApiException {
    // verify the required parameter 'webhookId' is set
    if (webhookId == null) {
      throw new ApiException(400, "Missing the required parameter 'webhookId' when calling updateWebhook");
    }
    // verify the required parameter 'updateWebhookRequest' is set
    if (updateWebhookRequest == null) {
      throw new ApiException(400, "Missing the required parameter 'updateWebhookRequest' when calling updateWebhook");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/webhooks/{webhookId}"
        .replace("{webhookId}", ApiClient.urlEncode(webhookId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Content-Type", "application/vnd.api+json");
    localVarRequestBuilder.header("Accept", "application/vnd.api+json");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(updateWebhookRequest);
      localVarRequestBuilder.method("PATCH", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
    } catch (IOException e) {
      throw new ApiException(e);
    }
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Upload an application document file. Supports PDF, PNG and JPG files
   * 
   * @param applicationId ID of the application to upload a file to (required)
   * @param documentId ID of the document to upload a file for (required)
   * @param _file  (required)
   * @param fileType  (required)
   * @return UnitDocumentResponse
   * @throws ApiException if fails to make API call
   */
  public UnitDocumentResponse uploadApplicationDocumentFile(String applicationId, String documentId, File _file, UploadApplicationDocumentContentType fileType) throws ApiException {
    ApiResponse<UnitDocumentResponse> localVarResponse = uploadApplicationDocumentFileWithHttpInfo(applicationId, documentId, _file, fileType);
    return localVarResponse.getData();
  }

  /**
   * Upload an application document file. Supports PDF, PNG and JPG files
   * 
   * @param applicationId ID of the application to upload a file to (required)
   * @param documentId ID of the document to upload a file for (required)
   * @param _file  (required)
   * @param fileType  (required)
   * @return ApiResponse&lt;UnitDocumentResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitDocumentResponse> uploadApplicationDocumentFileWithHttpInfo(String applicationId, String documentId, File _file, UploadApplicationDocumentContentType fileType) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = uploadApplicationDocumentFileRequestBuilder(applicationId, documentId, _file, fileType);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("uploadApplicationDocumentFile", localVarResponse);
        }
        return new ApiResponse<UnitDocumentResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitDocumentResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder uploadApplicationDocumentFileRequestBuilder(String applicationId, String documentId, File _file, UploadApplicationDocumentContentType fileType) throws ApiException {
    // verify the required parameter 'applicationId' is set
    if (applicationId == null) {
      throw new ApiException(400, "Missing the required parameter 'applicationId' when calling uploadApplicationDocumentFile");
    }
    // verify the required parameter 'documentId' is set
    if (documentId == null) {
      throw new ApiException(400, "Missing the required parameter 'documentId' when calling uploadApplicationDocumentFile");
    }
    // verify the required parameter '_file' is set
    if (_file == null) {
      throw new ApiException(400, "Missing the required parameter '_file' when calling uploadApplicationDocumentFile");
    }
    // verify the required parameter 'fileType' is set
    if (fileType == null) {
      throw new ApiException(400, "Missing the required parameter 'fileType' when calling uploadApplicationDocumentFile");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/applications/{applicationId}/documents/{documentId}/multipart"
        .replace("{applicationId}", ApiClient.urlEncode(applicationId.toString()))
        .replace("{documentId}", ApiClient.urlEncode(documentId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    MultipartEntityBuilder multiPartBuilder = MultipartEntityBuilder.create();
    boolean hasFiles = false;
    multiPartBuilder.addBinaryBody("file", _file);
    hasFiles = true;
    multiPartBuilder.addTextBody("fileType", fileType.toString());
    HttpEntity entity = multiPartBuilder.build();
    HttpRequest.BodyPublisher formDataPublisher;
    if (hasFiles) {
        Pipe pipe;
        try {
            pipe = Pipe.open();
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
        new Thread(() -> {
            try (OutputStream outputStream = Channels.newOutputStream(pipe.sink())) {
                entity.writeTo(outputStream);
            } catch (IOException e) {
                e.printStackTrace();
            }
        }).start();
        formDataPublisher = HttpRequest.BodyPublishers.ofInputStream(() -> Channels.newInputStream(pipe.source()));
    } else {
        ByteArrayOutputStream formOutputStream = new ByteArrayOutputStream();
        try {
            entity.writeTo(formOutputStream);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
        formDataPublisher = HttpRequest.BodyPublishers
            .ofInputStream(() -> new ByteArrayInputStream(formOutputStream.toByteArray()));
    }
    localVarRequestBuilder
        .header("Content-Type", entity.getContentType().getValue())
        .method("PUT", formDataPublisher);
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Upload an application document file - Back Side. Supports PDF, PNG and JPG files
   * Upload an application file via API - Back Side. Supports PDF, PNG and JPG files
   * @param applicationId ID of the application to upload a file to (required)
   * @param documentId ID of the document to upload a file for (required)
   * @param _file  (required)
   * @param fileType  (required)
   * @return UnitDocumentResponse
   * @throws ApiException if fails to make API call
   */
  public UnitDocumentResponse uploadApplicationDocumentFileBackSide(String applicationId, String documentId, File _file, UploadApplicationDocumentContentType fileType) throws ApiException {
    ApiResponse<UnitDocumentResponse> localVarResponse = uploadApplicationDocumentFileBackSideWithHttpInfo(applicationId, documentId, _file, fileType);
    return localVarResponse.getData();
  }

  /**
   * Upload an application document file - Back Side. Supports PDF, PNG and JPG files
   * Upload an application file via API - Back Side. Supports PDF, PNG and JPG files
   * @param applicationId ID of the application to upload a file to (required)
   * @param documentId ID of the document to upload a file for (required)
   * @param _file  (required)
   * @param fileType  (required)
   * @return ApiResponse&lt;UnitDocumentResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitDocumentResponse> uploadApplicationDocumentFileBackSideWithHttpInfo(String applicationId, String documentId, File _file, UploadApplicationDocumentContentType fileType) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = uploadApplicationDocumentFileBackSideRequestBuilder(applicationId, documentId, _file, fileType);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("uploadApplicationDocumentFileBackSide", localVarResponse);
        }
        return new ApiResponse<UnitDocumentResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitDocumentResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder uploadApplicationDocumentFileBackSideRequestBuilder(String applicationId, String documentId, File _file, UploadApplicationDocumentContentType fileType) throws ApiException {
    // verify the required parameter 'applicationId' is set
    if (applicationId == null) {
      throw new ApiException(400, "Missing the required parameter 'applicationId' when calling uploadApplicationDocumentFileBackSide");
    }
    // verify the required parameter 'documentId' is set
    if (documentId == null) {
      throw new ApiException(400, "Missing the required parameter 'documentId' when calling uploadApplicationDocumentFileBackSide");
    }
    // verify the required parameter '_file' is set
    if (_file == null) {
      throw new ApiException(400, "Missing the required parameter '_file' when calling uploadApplicationDocumentFileBackSide");
    }
    // verify the required parameter 'fileType' is set
    if (fileType == null) {
      throw new ApiException(400, "Missing the required parameter 'fileType' when calling uploadApplicationDocumentFileBackSide");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/applications/{applicationId}/documents/{documentId}/back/multipart"
        .replace("{applicationId}", ApiClient.urlEncode(applicationId.toString()))
        .replace("{documentId}", ApiClient.urlEncode(documentId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    MultipartEntityBuilder multiPartBuilder = MultipartEntityBuilder.create();
    boolean hasFiles = false;
    multiPartBuilder.addBinaryBody("file", _file);
    hasFiles = true;
    multiPartBuilder.addTextBody("fileType", fileType.toString());
    HttpEntity entity = multiPartBuilder.build();
    HttpRequest.BodyPublisher formDataPublisher;
    if (hasFiles) {
        Pipe pipe;
        try {
            pipe = Pipe.open();
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
        new Thread(() -> {
            try (OutputStream outputStream = Channels.newOutputStream(pipe.sink())) {
                entity.writeTo(outputStream);
            } catch (IOException e) {
                e.printStackTrace();
            }
        }).start();
        formDataPublisher = HttpRequest.BodyPublishers.ofInputStream(() -> Channels.newInputStream(pipe.source()));
    } else {
        ByteArrayOutputStream formOutputStream = new ByteArrayOutputStream();
        try {
            entity.writeTo(formOutputStream);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
        formDataPublisher = HttpRequest.BodyPublishers
            .ofInputStream(() -> new ByteArrayInputStream(formOutputStream.toByteArray()));
    }
    localVarRequestBuilder
        .header("Content-Type", entity.getContentType().getValue())
        .method("PUT", formDataPublisher);
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Verify a document
   * Verify a document via API 
   * @param applicationId ID of the application to verify a file for (required)
   * @param documentId ID of the document to verify (required)
   * @param verifyDocument Verify Document (required)
   * @return UnitDocumentResponse
   * @throws ApiException if fails to make API call
   */
  public UnitDocumentResponse verifyApplicationDocument(String applicationId, String documentId, VerifyDocument verifyDocument) throws ApiException {
    ApiResponse<UnitDocumentResponse> localVarResponse = verifyApplicationDocumentWithHttpInfo(applicationId, documentId, verifyDocument);
    return localVarResponse.getData();
  }

  /**
   * Verify a document
   * Verify a document via API 
   * @param applicationId ID of the application to verify a file for (required)
   * @param documentId ID of the document to verify (required)
   * @param verifyDocument Verify Document (required)
   * @return ApiResponse&lt;UnitDocumentResponse&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<UnitDocumentResponse> verifyApplicationDocumentWithHttpInfo(String applicationId, String documentId, VerifyDocument verifyDocument) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = verifyApplicationDocumentRequestBuilder(applicationId, documentId, verifyDocument);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("verifyApplicationDocument", localVarResponse);
        }
        return new ApiResponse<UnitDocumentResponse>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<UnitDocumentResponse>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder verifyApplicationDocumentRequestBuilder(String applicationId, String documentId, VerifyDocument verifyDocument) throws ApiException {
    // verify the required parameter 'applicationId' is set
    if (applicationId == null) {
      throw new ApiException(400, "Missing the required parameter 'applicationId' when calling verifyApplicationDocument");
    }
    // verify the required parameter 'documentId' is set
    if (documentId == null) {
      throw new ApiException(400, "Missing the required parameter 'documentId' when calling verifyApplicationDocument");
    }
    // verify the required parameter 'verifyDocument' is set
    if (verifyDocument == null) {
      throw new ApiException(400, "Missing the required parameter 'verifyDocument' when calling verifyApplicationDocument");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/applications/{applicationId}/documents/{documentId}/verify"
        .replace("{applicationId}", ApiClient.urlEncode(applicationId.toString()))
        .replace("{documentId}", ApiClient.urlEncode(documentId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Content-Type", "application/json");
    localVarRequestBuilder.header("Accept", "application/vnd.api+json; charset=utf-8");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(verifyDocument);
      localVarRequestBuilder.method("PUT", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
    } catch (IOException e) {
      throw new ApiException(e);
    }
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

}
