/*
 * Unit OpenAPI specifications
 * An OpenAPI specifications for unit-sdk clients
 *
 * The version of the OpenAPI document: 0.2.3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package unit.java.sdk.model;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;
import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


import unit.java.sdk.ApiClient;
/**
 * CreatePlaidCounterpartyAttributes
 */
@JsonPropertyOrder({
  CreatePlaidCounterpartyAttributes.JSON_PROPERTY_TYPE,
  CreatePlaidCounterpartyAttributes.JSON_PROPERTY_NAME,
  CreatePlaidCounterpartyAttributes.JSON_PROPERTY_VERIFY_NAME,
  CreatePlaidCounterpartyAttributes.JSON_PROPERTY_PLAID_PROCESSOR_TOKEN,
  CreatePlaidCounterpartyAttributes.JSON_PROPERTY_PERMISSIONS,
  CreatePlaidCounterpartyAttributes.JSON_PROPERTY_TAGS,
  CreatePlaidCounterpartyAttributes.JSON_PROPERTY_IDEMPOTENCY_KEY
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.9.0")
public class CreatePlaidCounterpartyAttributes {
  /**
   * Gets or Sets type
   */
  public enum TypeEnum {
    BUSINESS("Business"),
    
    PERSON("Person"),
    
    UNKNOWN("Unknown");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_VERIFY_NAME = "verifyName";
  private Boolean verifyName = false;

  public static final String JSON_PROPERTY_PLAID_PROCESSOR_TOKEN = "plaidProcessorToken";
  private String plaidProcessorToken;

  /**
   * Gets or Sets permissions
   */
  public enum PermissionsEnum {
    CREDIT_ONLY("CreditOnly"),
    
    DEBIT_ONLY("DebitOnly"),
    
    CREDIT_AND_DEBIT("CreditAndDebit");

    private String value;

    PermissionsEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PermissionsEnum fromValue(String value) {
      for (PermissionsEnum b : PermissionsEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PERMISSIONS = "permissions";
  private PermissionsEnum permissions;

  public static final String JSON_PROPERTY_TAGS = "tags";
  private Map<String, String> tags = new HashMap<>();

  public static final String JSON_PROPERTY_IDEMPOTENCY_KEY = "idempotencyKey";
  private String idempotencyKey;

  public CreatePlaidCounterpartyAttributes() { 
  }

  public CreatePlaidCounterpartyAttributes type(TypeEnum type) {
    this.type = type;
    return this;
  }

  /**
   * Get type
   * @return type
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public CreatePlaidCounterpartyAttributes name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(String name) {
    this.name = name;
  }


  public CreatePlaidCounterpartyAttributes verifyName(Boolean verifyName) {
    this.verifyName = verifyName;
    return this;
  }

  /**
   * Get verifyName
   * @return verifyName
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_VERIFY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getVerifyName() {
    return verifyName;
  }


  @JsonProperty(JSON_PROPERTY_VERIFY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVerifyName(Boolean verifyName) {
    this.verifyName = verifyName;
  }


  public CreatePlaidCounterpartyAttributes plaidProcessorToken(String plaidProcessorToken) {
    this.plaidProcessorToken = plaidProcessorToken;
    return this;
  }

  /**
   * Get plaidProcessorToken
   * @return plaidProcessorToken
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_PLAID_PROCESSOR_TOKEN)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getPlaidProcessorToken() {
    return plaidProcessorToken;
  }


  @JsonProperty(JSON_PROPERTY_PLAID_PROCESSOR_TOKEN)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPlaidProcessorToken(String plaidProcessorToken) {
    this.plaidProcessorToken = plaidProcessorToken;
  }


  public CreatePlaidCounterpartyAttributes permissions(PermissionsEnum permissions) {
    this.permissions = permissions;
    return this;
  }

  /**
   * Get permissions
   * @return permissions
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PERMISSIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public PermissionsEnum getPermissions() {
    return permissions;
  }


  @JsonProperty(JSON_PROPERTY_PERMISSIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPermissions(PermissionsEnum permissions) {
    this.permissions = permissions;
  }


  public CreatePlaidCounterpartyAttributes tags(Map<String, String> tags) {
    this.tags = tags;
    return this;
  }

  public CreatePlaidCounterpartyAttributes putTagsItem(String key, String tagsItem) {
    if (this.tags == null) {
      this.tags = new HashMap<>();
    }
    this.tags.put(key, tagsItem);
    return this;
  }

  /**
   * Get tags
   * @return tags
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TAGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Map<String, String> getTags() {
    return tags;
  }


  @JsonProperty(JSON_PROPERTY_TAGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTags(Map<String, String> tags) {
    this.tags = tags;
  }


  public CreatePlaidCounterpartyAttributes idempotencyKey(String idempotencyKey) {
    this.idempotencyKey = idempotencyKey;
    return this;
  }

  /**
   * Get idempotencyKey
   * @return idempotencyKey
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_IDEMPOTENCY_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getIdempotencyKey() {
    return idempotencyKey;
  }


  @JsonProperty(JSON_PROPERTY_IDEMPOTENCY_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIdempotencyKey(String idempotencyKey) {
    this.idempotencyKey = idempotencyKey;
  }


  /**
   * Return true if this CreatePlaidCounterparty_attributes object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CreatePlaidCounterpartyAttributes createPlaidCounterpartyAttributes = (CreatePlaidCounterpartyAttributes) o;
    return Objects.equals(this.type, createPlaidCounterpartyAttributes.type) &&
        Objects.equals(this.name, createPlaidCounterpartyAttributes.name) &&
        Objects.equals(this.verifyName, createPlaidCounterpartyAttributes.verifyName) &&
        Objects.equals(this.plaidProcessorToken, createPlaidCounterpartyAttributes.plaidProcessorToken) &&
        Objects.equals(this.permissions, createPlaidCounterpartyAttributes.permissions) &&
        Objects.equals(this.tags, createPlaidCounterpartyAttributes.tags) &&
        Objects.equals(this.idempotencyKey, createPlaidCounterpartyAttributes.idempotencyKey);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, name, verifyName, plaidProcessorToken, permissions, tags, idempotencyKey);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreatePlaidCounterpartyAttributes {\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    verifyName: ").append(toIndentedString(verifyName)).append("\n");
    sb.append("    plaidProcessorToken: ").append(toIndentedString(plaidProcessorToken)).append("\n");
    sb.append("    permissions: ").append(toIndentedString(permissions)).append("\n");
    sb.append("    tags: ").append(toIndentedString(tags)).append("\n");
    sb.append("    idempotencyKey: ").append(toIndentedString(idempotencyKey)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `type` to the URL query string
    if (getType() != null) {
      joiner.add(String.format("%stype%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getType()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `name` to the URL query string
    if (getName() != null) {
      joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `verifyName` to the URL query string
    if (getVerifyName() != null) {
      joiner.add(String.format("%sverifyName%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getVerifyName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `plaidProcessorToken` to the URL query string
    if (getPlaidProcessorToken() != null) {
      joiner.add(String.format("%splaidProcessorToken%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getPlaidProcessorToken()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `permissions` to the URL query string
    if (getPermissions() != null) {
      joiner.add(String.format("%spermissions%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getPermissions()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `tags` to the URL query string
    if (getTags() != null) {
      for (String _key : getTags().keySet()) {
        joiner.add(String.format("%stags%s%s=%s", prefix, suffix,
            "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix),
            getTags().get(_key), URLEncoder.encode(ApiClient.valueToString(getTags().get(_key)), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
      }
    }

    // add `idempotencyKey` to the URL query string
    if (getIdempotencyKey() != null) {
      joiner.add(String.format("%sidempotencyKey%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getIdempotencyKey()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    return joiner.toString();
  }
}

