/*
 * Unit OpenAPI specifications
 * An OpenAPI specifications for unit-sdk clients
 *
 * The version of the OpenAPI document: 0.2.3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package unit.java.sdk.model;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;
import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


import unit.java.sdk.ApiClient;
/**
 * GetAuthorizationsListFilterParameter
 */
@JsonPropertyOrder({
  GetAuthorizationsListFilterParameter.JSON_PROPERTY_ACCOUNT_ID,
  GetAuthorizationsListFilterParameter.JSON_PROPERTY_ACCOUNT_TYPE,
  GetAuthorizationsListFilterParameter.JSON_PROPERTY_CUSTOMER_ID,
  GetAuthorizationsListFilterParameter.JSON_PROPERTY_CARD_ID,
  GetAuthorizationsListFilterParameter.JSON_PROPERTY_INCLUDE_NON_AUTHORIZED,
  GetAuthorizationsListFilterParameter.JSON_PROPERTY_MERCHANT_CATEGORY_CODE,
  GetAuthorizationsListFilterParameter.JSON_PROPERTY_SINCE,
  GetAuthorizationsListFilterParameter.JSON_PROPERTY_UNTIL,
  GetAuthorizationsListFilterParameter.JSON_PROPERTY_FROM_AMOUNT,
  GetAuthorizationsListFilterParameter.JSON_PROPERTY_TO_AMOUNT,
  GetAuthorizationsListFilterParameter.JSON_PROPERTY_STATUS
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.9.0")
public class GetAuthorizationsListFilterParameter {
  public static final String JSON_PROPERTY_ACCOUNT_ID = "accountId";
  private String accountId;

  public static final String JSON_PROPERTY_ACCOUNT_TYPE = "accountType";
  private String accountType;

  public static final String JSON_PROPERTY_CUSTOMER_ID = "customerId";
  private String customerId;

  public static final String JSON_PROPERTY_CARD_ID = "cardId";
  private String cardId;

  public static final String JSON_PROPERTY_INCLUDE_NON_AUTHORIZED = "includeNonAuthorized";
  private Boolean includeNonAuthorized;

  public static final String JSON_PROPERTY_MERCHANT_CATEGORY_CODE = "merchantCategoryCode";
  private List<String> merchantCategoryCode = new ArrayList<>();

  public static final String JSON_PROPERTY_SINCE = "since";
  private String since;

  public static final String JSON_PROPERTY_UNTIL = "until";
  private String until;

  public static final String JSON_PROPERTY_FROM_AMOUNT = "fromAmount";
  private Long fromAmount;

  public static final String JSON_PROPERTY_TO_AMOUNT = "toAmount";
  private Long toAmount;

  /**
   * Gets or Sets status
   */
  public enum StatusEnum {
    AUTHORIZED("Authorized"),
    
    COMPLETED("Completed"),
    
    CANCELED("Canceled"),
    
    DECLINED("Declined");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_STATUS = "status";
  private List<StatusEnum> status = new ArrayList<>();

  public GetAuthorizationsListFilterParameter() { 
  }

  public GetAuthorizationsListFilterParameter accountId(String accountId) {
    this.accountId = accountId;
    return this;
  }

  /**
   * Get accountId
   * @return accountId
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ACCOUNT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getAccountId() {
    return accountId;
  }


  @JsonProperty(JSON_PROPERTY_ACCOUNT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAccountId(String accountId) {
    this.accountId = accountId;
  }


  public GetAuthorizationsListFilterParameter accountType(String accountType) {
    this.accountType = accountType;
    return this;
  }

  /**
   * Get accountType
   * @return accountType
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ACCOUNT_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getAccountType() {
    return accountType;
  }


  @JsonProperty(JSON_PROPERTY_ACCOUNT_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAccountType(String accountType) {
    this.accountType = accountType;
  }


  public GetAuthorizationsListFilterParameter customerId(String customerId) {
    this.customerId = customerId;
    return this;
  }

  /**
   * Get customerId
   * @return customerId
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CUSTOMER_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getCustomerId() {
    return customerId;
  }


  @JsonProperty(JSON_PROPERTY_CUSTOMER_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCustomerId(String customerId) {
    this.customerId = customerId;
  }


  public GetAuthorizationsListFilterParameter cardId(String cardId) {
    this.cardId = cardId;
    return this;
  }

  /**
   * Get cardId
   * @return cardId
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CARD_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getCardId() {
    return cardId;
  }


  @JsonProperty(JSON_PROPERTY_CARD_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCardId(String cardId) {
    this.cardId = cardId;
  }


  public GetAuthorizationsListFilterParameter includeNonAuthorized(Boolean includeNonAuthorized) {
    this.includeNonAuthorized = includeNonAuthorized;
    return this;
  }

  /**
   * Get includeNonAuthorized
   * @return includeNonAuthorized
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_INCLUDE_NON_AUTHORIZED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getIncludeNonAuthorized() {
    return includeNonAuthorized;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_NON_AUTHORIZED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeNonAuthorized(Boolean includeNonAuthorized) {
    this.includeNonAuthorized = includeNonAuthorized;
  }


  public GetAuthorizationsListFilterParameter merchantCategoryCode(List<String> merchantCategoryCode) {
    this.merchantCategoryCode = merchantCategoryCode;
    return this;
  }

  public GetAuthorizationsListFilterParameter addMerchantCategoryCodeItem(String merchantCategoryCodeItem) {
    if (this.merchantCategoryCode == null) {
      this.merchantCategoryCode = new ArrayList<>();
    }
    this.merchantCategoryCode.add(merchantCategoryCodeItem);
    return this;
  }

  /**
   * Get merchantCategoryCode
   * @return merchantCategoryCode
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_MERCHANT_CATEGORY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<String> getMerchantCategoryCode() {
    return merchantCategoryCode;
  }


  @JsonProperty(JSON_PROPERTY_MERCHANT_CATEGORY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMerchantCategoryCode(List<String> merchantCategoryCode) {
    this.merchantCategoryCode = merchantCategoryCode;
  }


  public GetAuthorizationsListFilterParameter since(String since) {
    this.since = since;
    return this;
  }

  /**
   * Get since
   * @return since
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SINCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getSince() {
    return since;
  }


  @JsonProperty(JSON_PROPERTY_SINCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSince(String since) {
    this.since = since;
  }


  public GetAuthorizationsListFilterParameter until(String until) {
    this.until = until;
    return this;
  }

  /**
   * Get until
   * @return until
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_UNTIL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getUntil() {
    return until;
  }


  @JsonProperty(JSON_PROPERTY_UNTIL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUntil(String until) {
    this.until = until;
  }


  public GetAuthorizationsListFilterParameter fromAmount(Long fromAmount) {
    this.fromAmount = fromAmount;
    return this;
  }

  /**
   * Get fromAmount
   * @return fromAmount
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_FROM_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Long getFromAmount() {
    return fromAmount;
  }


  @JsonProperty(JSON_PROPERTY_FROM_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFromAmount(Long fromAmount) {
    this.fromAmount = fromAmount;
  }


  public GetAuthorizationsListFilterParameter toAmount(Long toAmount) {
    this.toAmount = toAmount;
    return this;
  }

  /**
   * Get toAmount
   * @return toAmount
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TO_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Long getToAmount() {
    return toAmount;
  }


  @JsonProperty(JSON_PROPERTY_TO_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setToAmount(Long toAmount) {
    this.toAmount = toAmount;
  }


  public GetAuthorizationsListFilterParameter status(List<StatusEnum> status) {
    this.status = status;
    return this;
  }

  public GetAuthorizationsListFilterParameter addStatusItem(StatusEnum statusItem) {
    if (this.status == null) {
      this.status = new ArrayList<>();
    }
    this.status.add(statusItem);
    return this;
  }

  /**
   * Get status
   * @return status
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<StatusEnum> getStatus() {
    return status;
  }


  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStatus(List<StatusEnum> status) {
    this.status = status;
  }


  /**
   * Return true if this getAuthorizationsList_filter_parameter object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GetAuthorizationsListFilterParameter getAuthorizationsListFilterParameter = (GetAuthorizationsListFilterParameter) o;
    return Objects.equals(this.accountId, getAuthorizationsListFilterParameter.accountId) &&
        Objects.equals(this.accountType, getAuthorizationsListFilterParameter.accountType) &&
        Objects.equals(this.customerId, getAuthorizationsListFilterParameter.customerId) &&
        Objects.equals(this.cardId, getAuthorizationsListFilterParameter.cardId) &&
        Objects.equals(this.includeNonAuthorized, getAuthorizationsListFilterParameter.includeNonAuthorized) &&
        Objects.equals(this.merchantCategoryCode, getAuthorizationsListFilterParameter.merchantCategoryCode) &&
        Objects.equals(this.since, getAuthorizationsListFilterParameter.since) &&
        Objects.equals(this.until, getAuthorizationsListFilterParameter.until) &&
        Objects.equals(this.fromAmount, getAuthorizationsListFilterParameter.fromAmount) &&
        Objects.equals(this.toAmount, getAuthorizationsListFilterParameter.toAmount) &&
        Objects.equals(this.status, getAuthorizationsListFilterParameter.status);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accountId, accountType, customerId, cardId, includeNonAuthorized, merchantCategoryCode, since, until, fromAmount, toAmount, status);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GetAuthorizationsListFilterParameter {\n");
    sb.append("    accountId: ").append(toIndentedString(accountId)).append("\n");
    sb.append("    accountType: ").append(toIndentedString(accountType)).append("\n");
    sb.append("    customerId: ").append(toIndentedString(customerId)).append("\n");
    sb.append("    cardId: ").append(toIndentedString(cardId)).append("\n");
    sb.append("    includeNonAuthorized: ").append(toIndentedString(includeNonAuthorized)).append("\n");
    sb.append("    merchantCategoryCode: ").append(toIndentedString(merchantCategoryCode)).append("\n");
    sb.append("    since: ").append(toIndentedString(since)).append("\n");
    sb.append("    until: ").append(toIndentedString(until)).append("\n");
    sb.append("    fromAmount: ").append(toIndentedString(fromAmount)).append("\n");
    sb.append("    toAmount: ").append(toIndentedString(toAmount)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `accountId` to the URL query string
    if (getAccountId() != null) {
      joiner.add(String.format("%saccountId%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getAccountId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `accountType` to the URL query string
    if (getAccountType() != null) {
      joiner.add(String.format("%saccountType%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getAccountType()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `customerId` to the URL query string
    if (getCustomerId() != null) {
      joiner.add(String.format("%scustomerId%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getCustomerId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `cardId` to the URL query string
    if (getCardId() != null) {
      joiner.add(String.format("%scardId%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getCardId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `includeNonAuthorized` to the URL query string
    if (getIncludeNonAuthorized() != null) {
      joiner.add(String.format("%sincludeNonAuthorized%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getIncludeNonAuthorized()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `merchantCategoryCode` to the URL query string
    if (getMerchantCategoryCode() != null) {
      for (int i = 0; i < getMerchantCategoryCode().size(); i++) {
        joiner.add(String.format("%smerchantCategoryCode%s%s=%s", prefix, suffix,
            "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
            URLEncoder.encode(ApiClient.valueToString(getMerchantCategoryCode().get(i)), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
      }
    }

    // add `since` to the URL query string
    if (getSince() != null) {
      joiner.add(String.format("%ssince%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getSince()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `until` to the URL query string
    if (getUntil() != null) {
      joiner.add(String.format("%suntil%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getUntil()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `fromAmount` to the URL query string
    if (getFromAmount() != null) {
      joiner.add(String.format("%sfromAmount%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getFromAmount()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `toAmount` to the URL query string
    if (getToAmount() != null) {
      joiner.add(String.format("%stoAmount%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getToAmount()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `status` to the URL query string
    if (getStatus() != null) {
      for (int i = 0; i < getStatus().size(); i++) {
        joiner.add(String.format("%sstatus%s%s=%s", prefix, suffix,
            "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
            URLEncoder.encode(ApiClient.valueToString(getStatus().get(i)), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
      }
    }

    return joiner.toString();
  }
}

