/*
 * Unit OpenAPI specifications
 * An OpenAPI specifications for unit-sdk clients
 *
 * The version of the OpenAPI document: 0.2.3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package unit.java.sdk.model;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;
import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


import unit.java.sdk.ApiClient;
/**
 * WalletAccountAllOfAttributes
 */
@JsonPropertyOrder({
  WalletAccountAllOfAttributes.JSON_PROPERTY_CREATED_AT,
  WalletAccountAllOfAttributes.JSON_PROPERTY_NAME,
  WalletAccountAllOfAttributes.JSON_PROPERTY_STATUS,
  WalletAccountAllOfAttributes.JSON_PROPERTY_WALLET_TERMS,
  WalletAccountAllOfAttributes.JSON_PROPERTY_ROUTING_NUMBER,
  WalletAccountAllOfAttributes.JSON_PROPERTY_ACCOUNT_NUMBER,
  WalletAccountAllOfAttributes.JSON_PROPERTY_CURRENCY,
  WalletAccountAllOfAttributes.JSON_PROPERTY_BALANCE,
  WalletAccountAllOfAttributes.JSON_PROPERTY_HOLD,
  WalletAccountAllOfAttributes.JSON_PROPERTY_AVAILABLE,
  WalletAccountAllOfAttributes.JSON_PROPERTY_TAGS,
  WalletAccountAllOfAttributes.JSON_PROPERTY_CLOSE_REASON,
  WalletAccountAllOfAttributes.JSON_PROPERTY_FRAUD_REASON,
  WalletAccountAllOfAttributes.JSON_PROPERTY_FREEZE_REASON
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.9.0")
public class WalletAccountAllOfAttributes {
  public static final String JSON_PROPERTY_CREATED_AT = "createdAt";
  private OffsetDateTime createdAt;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  /**
   * Gets or Sets status
   */
  public enum StatusEnum {
    OPEN("Open"),
    
    CLOSED("Closed"),
    
    FROZEN("Frozen");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_STATUS = "status";
  private StatusEnum status;

  public static final String JSON_PROPERTY_WALLET_TERMS = "walletTerms";
  private String walletTerms;

  public static final String JSON_PROPERTY_ROUTING_NUMBER = "routingNumber";
  private String routingNumber;

  public static final String JSON_PROPERTY_ACCOUNT_NUMBER = "accountNumber";
  private String accountNumber;

  public static final String JSON_PROPERTY_CURRENCY = "currency";
  private String currency = "USD";

  public static final String JSON_PROPERTY_BALANCE = "balance";
  private Long balance;

  public static final String JSON_PROPERTY_HOLD = "hold";
  private Long hold;

  public static final String JSON_PROPERTY_AVAILABLE = "available";
  private Long available;

  public static final String JSON_PROPERTY_TAGS = "tags";
  private Map<String, String> tags = new HashMap<>();

  /**
   * Gets or Sets closeReason
   */
  public enum CloseReasonEnum {
    BY_CUSTOMER("ByCustomer"),
    
    FRAUD("Fraud"),
    
    OVERDUE("Overdue"),
    
    NEGATIVE_BALANCE("NegativeBalance"),
    
    BY_BANK("ByBank"),
    
    BREACH_OF_TERMS_AND_CONDITIONS("BreachOfTermsAndConditions"),
    
    NO_ACCOUNT_ACTIVITY("NoAccountActivity"),
    
    PROGRAM_CHANGE("ProgramChange");

    private String value;

    CloseReasonEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static CloseReasonEnum fromValue(String value) {
      for (CloseReasonEnum b : CloseReasonEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_CLOSE_REASON = "closeReason";
  private CloseReasonEnum closeReason;

  /**
   * Gets or Sets fraudReason
   */
  public enum FraudReasonEnum {
    ACH_ACTIVITY("ACHActivity"),
    
    CARD_ACTIVITY("CardActivity"),
    
    CHECK_ACTIVITY("CheckActivity"),
    
    APPLICATION_HISTORY("ApplicationHistory"),
    
    ACCOUNT_ACTIVITY("AccountActivity"),
    
    CLIENT_IDENTIFIED("ClientIdentified"),
    
    IDENTITY_THEFT("IdentityTheft"),
    
    LINKED_TO_FRAUDULENT_CUSTOMER("LinkedToFraudulentCustomer");

    private String value;

    FraudReasonEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static FraudReasonEnum fromValue(String value) {
      for (FraudReasonEnum b : FraudReasonEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_FRAUD_REASON = "fraudReason";
  private FraudReasonEnum fraudReason;

  public static final String JSON_PROPERTY_FREEZE_REASON = "freezeReason";
  private String freezeReason;

  public WalletAccountAllOfAttributes() { 
  }

  public WalletAccountAllOfAttributes createdAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
    return this;
  }

  /**
   * Get createdAt
   * @return createdAt
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }


  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }


  public WalletAccountAllOfAttributes name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
    this.name = name;
  }


  public WalletAccountAllOfAttributes status(StatusEnum status) {
    this.status = status;
    return this;
  }

  /**
   * Get status
   * @return status
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public StatusEnum getStatus() {
    return status;
  }


  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setStatus(StatusEnum status) {
    this.status = status;
  }


  public WalletAccountAllOfAttributes walletTerms(String walletTerms) {
    this.walletTerms = walletTerms;
    return this;
  }

  /**
   * Get walletTerms
   * @return walletTerms
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_WALLET_TERMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getWalletTerms() {
    return walletTerms;
  }


  @JsonProperty(JSON_PROPERTY_WALLET_TERMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWalletTerms(String walletTerms) {
    this.walletTerms = walletTerms;
  }


  public WalletAccountAllOfAttributes routingNumber(String routingNumber) {
    this.routingNumber = routingNumber;
    return this;
  }

  /**
   * Get routingNumber
   * @return routingNumber
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ROUTING_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getRoutingNumber() {
    return routingNumber;
  }


  @JsonProperty(JSON_PROPERTY_ROUTING_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRoutingNumber(String routingNumber) {
    this.routingNumber = routingNumber;
  }


  public WalletAccountAllOfAttributes accountNumber(String accountNumber) {
    this.accountNumber = accountNumber;
    return this;
  }

  /**
   * Get accountNumber
   * @return accountNumber
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ACCOUNT_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getAccountNumber() {
    return accountNumber;
  }


  @JsonProperty(JSON_PROPERTY_ACCOUNT_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAccountNumber(String accountNumber) {
    this.accountNumber = accountNumber;
  }


  public WalletAccountAllOfAttributes currency(String currency) {
    this.currency = currency;
    return this;
  }

  /**
   * Get currency
   * @return currency
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getCurrency() {
    return currency;
  }


  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCurrency(String currency) {
    this.currency = currency;
  }


  public WalletAccountAllOfAttributes balance(Long balance) {
    this.balance = balance;
    return this;
  }

  /**
   * Get balance
   * @return balance
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_BALANCE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public Long getBalance() {
    return balance;
  }


  @JsonProperty(JSON_PROPERTY_BALANCE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setBalance(Long balance) {
    this.balance = balance;
  }


  public WalletAccountAllOfAttributes hold(Long hold) {
    this.hold = hold;
    return this;
  }

  /**
   * Get hold
   * @return hold
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_HOLD)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public Long getHold() {
    return hold;
  }


  @JsonProperty(JSON_PROPERTY_HOLD)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setHold(Long hold) {
    this.hold = hold;
  }


  public WalletAccountAllOfAttributes available(Long available) {
    this.available = available;
    return this;
  }

  /**
   * Get available
   * @return available
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_AVAILABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public Long getAvailable() {
    return available;
  }


  @JsonProperty(JSON_PROPERTY_AVAILABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAvailable(Long available) {
    this.available = available;
  }


  public WalletAccountAllOfAttributes tags(Map<String, String> tags) {
    this.tags = tags;
    return this;
  }

  public WalletAccountAllOfAttributes putTagsItem(String key, String tagsItem) {
    if (this.tags == null) {
      this.tags = new HashMap<>();
    }
    this.tags.put(key, tagsItem);
    return this;
  }

  /**
   * Get tags
   * @return tags
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_TAGS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public Map<String, String> getTags() {
    return tags;
  }


  @JsonProperty(JSON_PROPERTY_TAGS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTags(Map<String, String> tags) {
    this.tags = tags;
  }


  public WalletAccountAllOfAttributes closeReason(CloseReasonEnum closeReason) {
    this.closeReason = closeReason;
    return this;
  }

  /**
   * Get closeReason
   * @return closeReason
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CLOSE_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public CloseReasonEnum getCloseReason() {
    return closeReason;
  }


  @JsonProperty(JSON_PROPERTY_CLOSE_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCloseReason(CloseReasonEnum closeReason) {
    this.closeReason = closeReason;
  }


  public WalletAccountAllOfAttributes fraudReason(FraudReasonEnum fraudReason) {
    this.fraudReason = fraudReason;
    return this;
  }

  /**
   * Get fraudReason
   * @return fraudReason
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_FRAUD_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public FraudReasonEnum getFraudReason() {
    return fraudReason;
  }


  @JsonProperty(JSON_PROPERTY_FRAUD_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFraudReason(FraudReasonEnum fraudReason) {
    this.fraudReason = fraudReason;
  }


  public WalletAccountAllOfAttributes freezeReason(String freezeReason) {
    this.freezeReason = freezeReason;
    return this;
  }

  /**
   * Get freezeReason
   * @return freezeReason
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_FREEZE_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getFreezeReason() {
    return freezeReason;
  }


  @JsonProperty(JSON_PROPERTY_FREEZE_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFreezeReason(String freezeReason) {
    this.freezeReason = freezeReason;
  }


  /**
   * Return true if this WalletAccount_allOf_attributes object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    WalletAccountAllOfAttributes walletAccountAllOfAttributes = (WalletAccountAllOfAttributes) o;
    return Objects.equals(this.createdAt, walletAccountAllOfAttributes.createdAt) &&
        Objects.equals(this.name, walletAccountAllOfAttributes.name) &&
        Objects.equals(this.status, walletAccountAllOfAttributes.status) &&
        Objects.equals(this.walletTerms, walletAccountAllOfAttributes.walletTerms) &&
        Objects.equals(this.routingNumber, walletAccountAllOfAttributes.routingNumber) &&
        Objects.equals(this.accountNumber, walletAccountAllOfAttributes.accountNumber) &&
        Objects.equals(this.currency, walletAccountAllOfAttributes.currency) &&
        Objects.equals(this.balance, walletAccountAllOfAttributes.balance) &&
        Objects.equals(this.hold, walletAccountAllOfAttributes.hold) &&
        Objects.equals(this.available, walletAccountAllOfAttributes.available) &&
        Objects.equals(this.tags, walletAccountAllOfAttributes.tags) &&
        Objects.equals(this.closeReason, walletAccountAllOfAttributes.closeReason) &&
        Objects.equals(this.fraudReason, walletAccountAllOfAttributes.fraudReason) &&
        Objects.equals(this.freezeReason, walletAccountAllOfAttributes.freezeReason);
  }

  @Override
  public int hashCode() {
    return Objects.hash(createdAt, name, status, walletTerms, routingNumber, accountNumber, currency, balance, hold, available, tags, closeReason, fraudReason, freezeReason);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class WalletAccountAllOfAttributes {\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    walletTerms: ").append(toIndentedString(walletTerms)).append("\n");
    sb.append("    routingNumber: ").append(toIndentedString(routingNumber)).append("\n");
    sb.append("    accountNumber: ").append(toIndentedString(accountNumber)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    balance: ").append(toIndentedString(balance)).append("\n");
    sb.append("    hold: ").append(toIndentedString(hold)).append("\n");
    sb.append("    available: ").append(toIndentedString(available)).append("\n");
    sb.append("    tags: ").append(toIndentedString(tags)).append("\n");
    sb.append("    closeReason: ").append(toIndentedString(closeReason)).append("\n");
    sb.append("    fraudReason: ").append(toIndentedString(fraudReason)).append("\n");
    sb.append("    freezeReason: ").append(toIndentedString(freezeReason)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `createdAt` to the URL query string
    if (getCreatedAt() != null) {
      joiner.add(String.format("%screatedAt%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getCreatedAt()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `name` to the URL query string
    if (getName() != null) {
      joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `status` to the URL query string
    if (getStatus() != null) {
      joiner.add(String.format("%sstatus%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getStatus()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `walletTerms` to the URL query string
    if (getWalletTerms() != null) {
      joiner.add(String.format("%swalletTerms%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getWalletTerms()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `routingNumber` to the URL query string
    if (getRoutingNumber() != null) {
      joiner.add(String.format("%sroutingNumber%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getRoutingNumber()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `accountNumber` to the URL query string
    if (getAccountNumber() != null) {
      joiner.add(String.format("%saccountNumber%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getAccountNumber()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `currency` to the URL query string
    if (getCurrency() != null) {
      joiner.add(String.format("%scurrency%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getCurrency()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `balance` to the URL query string
    if (getBalance() != null) {
      joiner.add(String.format("%sbalance%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getBalance()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `hold` to the URL query string
    if (getHold() != null) {
      joiner.add(String.format("%shold%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getHold()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `available` to the URL query string
    if (getAvailable() != null) {
      joiner.add(String.format("%savailable%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getAvailable()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `tags` to the URL query string
    if (getTags() != null) {
      for (String _key : getTags().keySet()) {
        joiner.add(String.format("%stags%s%s=%s", prefix, suffix,
            "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix),
            getTags().get(_key), URLEncoder.encode(ApiClient.valueToString(getTags().get(_key)), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
      }
    }

    // add `closeReason` to the URL query string
    if (getCloseReason() != null) {
      joiner.add(String.format("%scloseReason%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getCloseReason()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `fraudReason` to the URL query string
    if (getFraudReason() != null) {
      joiner.add(String.format("%sfraudReason%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getFraudReason()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `freezeReason` to the URL query string
    if (getFreezeReason() != null) {
      joiner.add(String.format("%sfreezeReason%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getFreezeReason()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    return joiner.toString();
  }
}

