/*
 * Decompiled with CFR 0.152.
 */
package unit.java.sdk.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.StringJoiner;
import unit.java.sdk.ApiClient;

@JsonPropertyOrder(value={"token", "expiresIn"})
public class CustomerTokenAttributes {
    public static final String JSON_PROPERTY_TOKEN = "token";
    private String token;
    public static final String JSON_PROPERTY_EXPIRES_IN = "expiresIn";
    private Integer expiresIn;

    public CustomerTokenAttributes token(String token) {
        this.token = token;
        return this;
    }

    @Nullable
    @JsonProperty(value="token")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getToken() {
        return this.token;
    }

    @JsonProperty(value="token")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setToken(String token) {
        this.token = token;
    }

    public CustomerTokenAttributes expiresIn(Integer expiresIn) {
        this.expiresIn = expiresIn;
        return this;
    }

    @Nullable
    @JsonProperty(value="expiresIn")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getExpiresIn() {
        return this.expiresIn;
    }

    @JsonProperty(value="expiresIn")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExpiresIn(Integer expiresIn) {
        this.expiresIn = expiresIn;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomerTokenAttributes customerTokenAttributes = (CustomerTokenAttributes)o;
        return Objects.equals(this.token, customerTokenAttributes.token) && Objects.equals(this.expiresIn, customerTokenAttributes.expiresIn);
    }

    public int hashCode() {
        return Objects.hash(this.token, this.expiresIn);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CustomerTokenAttributes {\n");
        sb.append("    token: ").append(this.toIndentedString(this.token)).append("\n");
        sb.append("    expiresIn: ").append(this.toIndentedString(this.expiresIn)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getToken() != null) {
            joiner.add(String.format("%stoken%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getToken()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getExpiresIn() != null) {
            joiner.add(String.format("%sexpiresIn%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getExpiresIn()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }
}

