/*
 * Decompiled with CFR 0.152.
 */
package unit.java.sdk.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nullable;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import unit.java.sdk.ApiClient;

@JsonPropertyOrder(value={"customerId", "status", "type", "fromBalance", "toBalance", "tags"})
public class GetAccountsListFilterParameter {
    public static final String JSON_PROPERTY_CUSTOMER_ID = "customerId";
    private String customerId;
    public static final String JSON_PROPERTY_STATUS = "status";
    private List<StatusEnum> status = new ArrayList<StatusEnum>();
    public static final String JSON_PROPERTY_TYPE = "type";
    private List<TypeEnum> type = new ArrayList<TypeEnum>();
    public static final String JSON_PROPERTY_FROM_BALANCE = "fromBalance";
    private BigDecimal fromBalance;
    public static final String JSON_PROPERTY_TO_BALANCE = "toBalance";
    private BigDecimal toBalance;
    public static final String JSON_PROPERTY_TAGS = "tags";
    private Map<String, String> tags = new HashMap<String, String>();

    public GetAccountsListFilterParameter customerId(String customerId) {
        this.customerId = customerId;
        return this;
    }

    @Nullable
    @JsonProperty(value="customerId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCustomerId() {
        return this.customerId;
    }

    @JsonProperty(value="customerId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCustomerId(String customerId) {
        this.customerId = customerId;
    }

    public GetAccountsListFilterParameter status(List<StatusEnum> status) {
        this.status = status;
        return this;
    }

    public GetAccountsListFilterParameter addStatusItem(StatusEnum statusItem) {
        if (this.status == null) {
            this.status = new ArrayList<StatusEnum>();
        }
        this.status.add(statusItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<StatusEnum> getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(List<StatusEnum> status) {
        this.status = status;
    }

    public GetAccountsListFilterParameter type(List<TypeEnum> type) {
        this.type = type;
        return this;
    }

    public GetAccountsListFilterParameter addTypeItem(TypeEnum typeItem) {
        if (this.type == null) {
            this.type = new ArrayList<TypeEnum>();
        }
        this.type.add(typeItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<TypeEnum> getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(List<TypeEnum> type) {
        this.type = type;
    }

    public GetAccountsListFilterParameter fromBalance(BigDecimal fromBalance) {
        this.fromBalance = fromBalance;
        return this;
    }

    @Nullable
    @JsonProperty(value="fromBalance")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BigDecimal getFromBalance() {
        return this.fromBalance;
    }

    @JsonProperty(value="fromBalance")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFromBalance(BigDecimal fromBalance) {
        this.fromBalance = fromBalance;
    }

    public GetAccountsListFilterParameter toBalance(BigDecimal toBalance) {
        this.toBalance = toBalance;
        return this;
    }

    @Nullable
    @JsonProperty(value="toBalance")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BigDecimal getToBalance() {
        return this.toBalance;
    }

    @JsonProperty(value="toBalance")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setToBalance(BigDecimal toBalance) {
        this.toBalance = toBalance;
    }

    public GetAccountsListFilterParameter tags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public GetAccountsListFilterParameter putTagsItem(String key, String tagsItem) {
        if (this.tags == null) {
            this.tags = new HashMap<String, String>();
        }
        this.tags.put(key, tagsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getTags() {
        return this.tags;
    }

    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetAccountsListFilterParameter getAccountsListFilterParameter = (GetAccountsListFilterParameter)o;
        return Objects.equals(this.customerId, getAccountsListFilterParameter.customerId) && Objects.equals(this.status, getAccountsListFilterParameter.status) && Objects.equals(this.type, getAccountsListFilterParameter.type) && Objects.equals(this.fromBalance, getAccountsListFilterParameter.fromBalance) && Objects.equals(this.toBalance, getAccountsListFilterParameter.toBalance) && Objects.equals(this.tags, getAccountsListFilterParameter.tags);
    }

    public int hashCode() {
        return Objects.hash(this.customerId, this.status, this.type, this.fromBalance, this.toBalance, this.tags);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GetAccountsListFilterParameter {\n");
        sb.append("    customerId: ").append(this.toIndentedString(this.customerId)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    fromBalance: ").append(this.toIndentedString(this.fromBalance)).append("\n");
        sb.append("    toBalance: ").append(this.toIndentedString(this.toBalance)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        int i;
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getCustomerId() != null) {
            joiner.add(String.format("%scustomerId%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getCustomerId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getStatus() != null) {
            for (i = 0; i < this.getStatus().size(); ++i) {
                joiner.add(String.format("%sstatus%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(ApiClient.valueToString((Object)this.getStatus().get(i)), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
            }
        }
        if (this.getType() != null) {
            for (i = 0; i < this.getType().size(); ++i) {
                joiner.add(String.format("%stype%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(ApiClient.valueToString((Object)this.getType().get(i)), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
            }
        }
        if (this.getFromBalance() != null) {
            joiner.add(String.format("%sfromBalance%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getFromBalance()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getToBalance() != null) {
            joiner.add(String.format("%stoBalance%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getToBalance()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getTags() != null) {
            for (String _key : this.getTags().keySet()) {
                joiner.add(String.format("%stags%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix), this.getTags().get(_key), URLEncoder.encode(ApiClient.valueToString(this.getTags().get(_key)), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
            }
        }
        return joiner.toString();
    }

    public static enum TypeEnum {
        DEPOSIT("deposit"),
        CREDIT("credit");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum StatusEnum {
        OPEN("Open"),
        FROZEN("Frozen"),
        CLOSED("Closed");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

