/*
 * Decompiled with CFR 0.152.
 */
package unit.java.sdk.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.StringJoiner;
import unit.java.sdk.ApiClient;
import unit.java.sdk.model.Coordinates;

@JsonPropertyOrder(value={"postalCode", "coordinates", "serviceType"})
public class GetCashDepositStoreLocationsListFilterParameter {
    public static final String JSON_PROPERTY_POSTAL_CODE = "postalCode";
    private String postalCode;
    public static final String JSON_PROPERTY_COORDINATES = "coordinates";
    private Coordinates coordinates;
    public static final String JSON_PROPERTY_SERVICE_TYPE = "serviceType";
    private ServiceTypeEnum serviceType;

    public GetCashDepositStoreLocationsListFilterParameter postalCode(String postalCode) {
        this.postalCode = postalCode;
        return this;
    }

    @Nullable
    @JsonProperty(value="postalCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPostalCode() {
        return this.postalCode;
    }

    @JsonProperty(value="postalCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public GetCashDepositStoreLocationsListFilterParameter coordinates(Coordinates coordinates) {
        this.coordinates = coordinates;
        return this;
    }

    @Nullable
    @JsonProperty(value="coordinates")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Coordinates getCoordinates() {
        return this.coordinates;
    }

    @JsonProperty(value="coordinates")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCoordinates(Coordinates coordinates) {
        this.coordinates = coordinates;
    }

    public GetCashDepositStoreLocationsListFilterParameter serviceType(ServiceTypeEnum serviceType) {
        this.serviceType = serviceType;
        return this;
    }

    @Nonnull
    @JsonProperty(value="serviceType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ServiceTypeEnum getServiceType() {
        return this.serviceType;
    }

    @JsonProperty(value="serviceType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setServiceType(ServiceTypeEnum serviceType) {
        this.serviceType = serviceType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetCashDepositStoreLocationsListFilterParameter getCashDepositStoreLocationsListFilterParameter = (GetCashDepositStoreLocationsListFilterParameter)o;
        return Objects.equals(this.postalCode, getCashDepositStoreLocationsListFilterParameter.postalCode) && Objects.equals(this.coordinates, getCashDepositStoreLocationsListFilterParameter.coordinates) && Objects.equals((Object)this.serviceType, (Object)getCashDepositStoreLocationsListFilterParameter.serviceType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.postalCode, this.coordinates, this.serviceType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GetCashDepositStoreLocationsListFilterParameter {\n");
        sb.append("    postalCode: ").append(this.toIndentedString(this.postalCode)).append("\n");
        sb.append("    coordinates: ").append(this.toIndentedString(this.coordinates)).append("\n");
        sb.append("    serviceType: ").append(this.toIndentedString((Object)this.serviceType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getPostalCode() != null) {
            joiner.add(String.format("%spostalCode%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getPostalCode()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getCoordinates() != null) {
            joiner.add(this.getCoordinates().toUrlQueryString((String)prefix + JSON_PROPERTY_COORDINATES + suffix));
        }
        if (this.getServiceType() != null) {
            joiner.add(String.format("%sserviceType%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString((Object)this.getServiceType()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }

    public static enum ServiceTypeEnum {
        SWIPE("Swipe"),
        BARCODE("Barcode");

        private String value;

        private ServiceTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ServiceTypeEnum fromValue(String value) {
            for (ServiceTypeEnum b : ServiceTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

