/*
 * Decompiled with CFR 0.152.
 */
package unit.java.sdk.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum Industry {
    RETAIL("Retail"),
    WHOLESALE("Wholesale"),
    RESTAURANTS("Restaurants"),
    HOSPITALS("Hospitals"),
    CONSTRUCTION("Construction"),
    INSURANCE("Insurance"),
    UNIONS("Unions"),
    REAL_ESTATE("RealEstate"),
    FREELANCE_PROFESSIONAL("FreelanceProfessional"),
    OTHER_PROFESSIONAL_SERVICES("OtherProfessionalServices"),
    ONLINE_RETAILER("OnlineRetailer"),
    OTHER_EDUCATION_SERVICES("OtherEducationServices");

    private String value;

    private Industry(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @JsonCreator
    public static Industry fromValue(String value) {
        for (Industry b : Industry.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public String toUrlQueryString(String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        return String.format("%s=%s", prefix, this.toString());
    }
}

