/*
 * Decompiled with CFR 0.152.
 */
package unit.java.sdk.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import unit.java.sdk.ApiClient;

@JsonPropertyOrder(value={"barcodeNumber", "expiration", "tags"})
public class CashDepositBarcodeAttributes {
    public static final String JSON_PROPERTY_BARCODE_NUMBER = "barcodeNumber";
    private String barcodeNumber;
    public static final String JSON_PROPERTY_EXPIRATION = "expiration";
    private OffsetDateTime expiration;
    public static final String JSON_PROPERTY_TAGS = "tags";
    private Map<String, String> tags = new HashMap<String, String>();

    public CashDepositBarcodeAttributes barcodeNumber(String barcodeNumber) {
        this.barcodeNumber = barcodeNumber;
        return this;
    }

    @Nullable
    @JsonProperty(value="barcodeNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBarcodeNumber() {
        return this.barcodeNumber;
    }

    @JsonProperty(value="barcodeNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBarcodeNumber(String barcodeNumber) {
        this.barcodeNumber = barcodeNumber;
    }

    public CashDepositBarcodeAttributes expiration(OffsetDateTime expiration) {
        this.expiration = expiration;
        return this;
    }

    @Nullable
    @JsonProperty(value="expiration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getExpiration() {
        return this.expiration;
    }

    @JsonProperty(value="expiration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExpiration(OffsetDateTime expiration) {
        this.expiration = expiration;
    }

    public CashDepositBarcodeAttributes tags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public CashDepositBarcodeAttributes putTagsItem(String key, String tagsItem) {
        if (this.tags == null) {
            this.tags = new HashMap<String, String>();
        }
        this.tags.put(key, tagsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getTags() {
        return this.tags;
    }

    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CashDepositBarcodeAttributes cashDepositBarcodeAttributes = (CashDepositBarcodeAttributes)o;
        return Objects.equals(this.barcodeNumber, cashDepositBarcodeAttributes.barcodeNumber) && Objects.equals(this.expiration, cashDepositBarcodeAttributes.expiration) && Objects.equals(this.tags, cashDepositBarcodeAttributes.tags);
    }

    public int hashCode() {
        return Objects.hash(this.barcodeNumber, this.expiration, this.tags);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CashDepositBarcodeAttributes {\n");
        sb.append("    barcodeNumber: ").append(this.toIndentedString(this.barcodeNumber)).append("\n");
        sb.append("    expiration: ").append(this.toIndentedString(this.expiration)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getBarcodeNumber() != null) {
            joiner.add(String.format("%sbarcodeNumber%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getBarcodeNumber()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getExpiration() != null) {
            joiner.add(String.format("%sexpiration%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getExpiration()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getTags() != null) {
            for (String _key : this.getTags().keySet()) {
                joiner.add(String.format("%stags%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix), this.getTags().get(_key), URLEncoder.encode(ApiClient.valueToString(this.getTags().get(_key)), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
            }
        }
        return joiner.toString();
    }
}

