/*
 * Decompiled with CFR 0.152.
 */
package unit.java.sdk.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.StringJoiner;
import unit.java.sdk.ApiClient;
import unit.java.sdk.model.CounterpartyAttributes;
import unit.java.sdk.model.CounterpartyRelationships;

@JsonPropertyOrder(value={"type", "id", "attributes", "relationships"})
public class Counterparty {
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type = TypeEnum.ACH_COUNTERPARTY;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_ATTRIBUTES = "attributes";
    private CounterpartyAttributes attributes;
    public static final String JSON_PROPERTY_RELATIONSHIPS = "relationships";
    private CounterpartyRelationships relationships;

    public Counterparty type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nullable
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public Counterparty id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public Counterparty attributes(CounterpartyAttributes attributes) {
        this.attributes = attributes;
        return this;
    }

    @Nullable
    @JsonProperty(value="attributes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CounterpartyAttributes getAttributes() {
        return this.attributes;
    }

    @JsonProperty(value="attributes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAttributes(CounterpartyAttributes attributes) {
        this.attributes = attributes;
    }

    public Counterparty relationships(CounterpartyRelationships relationships) {
        this.relationships = relationships;
        return this;
    }

    @Nullable
    @JsonProperty(value="relationships")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CounterpartyRelationships getRelationships() {
        return this.relationships;
    }

    @JsonProperty(value="relationships")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRelationships(CounterpartyRelationships relationships) {
        this.relationships = relationships;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Counterparty counterparty = (Counterparty)o;
        return Objects.equals((Object)this.type, (Object)counterparty.type) && Objects.equals(this.id, counterparty.id) && Objects.equals(this.attributes, counterparty.attributes) && Objects.equals(this.relationships, counterparty.relationships);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.id, this.attributes, this.relationships});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Counterparty {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    relationships: ").append(this.toIndentedString(this.relationships)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getType() != null) {
            joiner.add(String.format("%stype%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString((Object)this.getType()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getId() != null) {
            joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getAttributes() != null) {
            joiner.add(this.getAttributes().toUrlQueryString((String)prefix + JSON_PROPERTY_ATTRIBUTES + suffix));
        }
        if (this.getRelationships() != null) {
            joiner.add(this.getRelationships().toUrlQueryString((String)prefix + JSON_PROPERTY_RELATIONSHIPS + suffix));
        }
        return joiner.toString();
    }

    public static enum TypeEnum {
        ACH_COUNTERPARTY("achCounterparty");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

