/*
 * Decompiled with CFR 0.152.
 */
package unit.java.sdk.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import unit.java.sdk.ApiClient;

@JsonPropertyOrder(value={"type", "name", "verifyName", "plaidProcessorToken", "permissions", "tags", "idempotencyKey"})
public class CreatePlaidCounterpartyAttributes {
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_VERIFY_NAME = "verifyName";
    private Boolean verifyName = false;
    public static final String JSON_PROPERTY_PLAID_PROCESSOR_TOKEN = "plaidProcessorToken";
    private String plaidProcessorToken;
    public static final String JSON_PROPERTY_PERMISSIONS = "permissions";
    private PermissionsEnum permissions;
    public static final String JSON_PROPERTY_TAGS = "tags";
    private Map<String, String> tags = new HashMap<String, String>();
    public static final String JSON_PROPERTY_IDEMPOTENCY_KEY = "idempotencyKey";
    private String idempotencyKey;

    public CreatePlaidCounterpartyAttributes type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public CreatePlaidCounterpartyAttributes name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public CreatePlaidCounterpartyAttributes verifyName(Boolean verifyName) {
        this.verifyName = verifyName;
        return this;
    }

    @Nullable
    @JsonProperty(value="verifyName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getVerifyName() {
        return this.verifyName;
    }

    @JsonProperty(value="verifyName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVerifyName(Boolean verifyName) {
        this.verifyName = verifyName;
    }

    public CreatePlaidCounterpartyAttributes plaidProcessorToken(String plaidProcessorToken) {
        this.plaidProcessorToken = plaidProcessorToken;
        return this;
    }

    @Nonnull
    @JsonProperty(value="plaidProcessorToken")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getPlaidProcessorToken() {
        return this.plaidProcessorToken;
    }

    @JsonProperty(value="plaidProcessorToken")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPlaidProcessorToken(String plaidProcessorToken) {
        this.plaidProcessorToken = plaidProcessorToken;
    }

    public CreatePlaidCounterpartyAttributes permissions(PermissionsEnum permissions) {
        this.permissions = permissions;
        return this;
    }

    @Nullable
    @JsonProperty(value="permissions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PermissionsEnum getPermissions() {
        return this.permissions;
    }

    @JsonProperty(value="permissions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPermissions(PermissionsEnum permissions) {
        this.permissions = permissions;
    }

    public CreatePlaidCounterpartyAttributes tags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public CreatePlaidCounterpartyAttributes putTagsItem(String key, String tagsItem) {
        if (this.tags == null) {
            this.tags = new HashMap<String, String>();
        }
        this.tags.put(key, tagsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getTags() {
        return this.tags;
    }

    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public CreatePlaidCounterpartyAttributes idempotencyKey(String idempotencyKey) {
        this.idempotencyKey = idempotencyKey;
        return this;
    }

    @Nullable
    @JsonProperty(value="idempotencyKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    @JsonProperty(value="idempotencyKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIdempotencyKey(String idempotencyKey) {
        this.idempotencyKey = idempotencyKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreatePlaidCounterpartyAttributes createPlaidCounterpartyAttributes = (CreatePlaidCounterpartyAttributes)o;
        return Objects.equals((Object)this.type, (Object)createPlaidCounterpartyAttributes.type) && Objects.equals(this.name, createPlaidCounterpartyAttributes.name) && Objects.equals(this.verifyName, createPlaidCounterpartyAttributes.verifyName) && Objects.equals(this.plaidProcessorToken, createPlaidCounterpartyAttributes.plaidProcessorToken) && Objects.equals((Object)this.permissions, (Object)createPlaidCounterpartyAttributes.permissions) && Objects.equals(this.tags, createPlaidCounterpartyAttributes.tags) && Objects.equals(this.idempotencyKey, createPlaidCounterpartyAttributes.idempotencyKey);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.name, this.verifyName, this.plaidProcessorToken, this.permissions, this.tags, this.idempotencyKey});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreatePlaidCounterpartyAttributes {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    verifyName: ").append(this.toIndentedString(this.verifyName)).append("\n");
        sb.append("    plaidProcessorToken: ").append(this.toIndentedString(this.plaidProcessorToken)).append("\n");
        sb.append("    permissions: ").append(this.toIndentedString((Object)this.permissions)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    idempotencyKey: ").append(this.toIndentedString(this.idempotencyKey)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getType() != null) {
            joiner.add(String.format("%stype%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString((Object)this.getType()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getName() != null) {
            joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getVerifyName() != null) {
            joiner.add(String.format("%sverifyName%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getVerifyName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getPlaidProcessorToken() != null) {
            joiner.add(String.format("%splaidProcessorToken%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getPlaidProcessorToken()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getPermissions() != null) {
            joiner.add(String.format("%spermissions%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString((Object)this.getPermissions()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getTags() != null) {
            for (String _key : this.getTags().keySet()) {
                joiner.add(String.format("%stags%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix), this.getTags().get(_key), URLEncoder.encode(ApiClient.valueToString(this.getTags().get(_key)), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
            }
        }
        if (this.getIdempotencyKey() != null) {
            joiner.add(String.format("%sidempotencyKey%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getIdempotencyKey()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }

    public static enum PermissionsEnum {
        CREDIT_ONLY("CreditOnly"),
        DEBIT_ONLY("DebitOnly"),
        CREDIT_AND_DEBIT("CreditAndDebit");

        private String value;

        private PermissionsEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PermissionsEnum fromValue(String value) {
            for (PermissionsEnum b : PermissionsEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum TypeEnum {
        BUSINESS("Business"),
        PERSON("Person"),
        UNKNOWN("Unknown");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

