/*
 * Decompiled with CFR 0.152.
 */
package unit.java.sdk.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import unit.java.sdk.ApiClient;

@JsonPropertyOrder(value={"query", "status", "email", "tags"})
public class GetApplicationsListFilterParameter {
    public static final String JSON_PROPERTY_QUERY = "query";
    private String query;
    public static final String JSON_PROPERTY_STATUS = "status";
    private List<StatusEnum> status = new ArrayList<StatusEnum>();
    public static final String JSON_PROPERTY_EMAIL = "email";
    private String email;
    public static final String JSON_PROPERTY_TAGS = "tags";
    private Map<String, String> tags = new HashMap<String, String>();

    public GetApplicationsListFilterParameter query(String query) {
        this.query = query;
        return this;
    }

    @Nullable
    @JsonProperty(value="query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getQuery() {
        return this.query;
    }

    @JsonProperty(value="query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setQuery(String query) {
        this.query = query;
    }

    public GetApplicationsListFilterParameter status(List<StatusEnum> status) {
        this.status = status;
        return this;
    }

    public GetApplicationsListFilterParameter addStatusItem(StatusEnum statusItem) {
        if (this.status == null) {
            this.status = new ArrayList<StatusEnum>();
        }
        this.status.add(statusItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<StatusEnum> getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(List<StatusEnum> status) {
        this.status = status;
    }

    public GetApplicationsListFilterParameter email(String email) {
        this.email = email;
        return this;
    }

    @Nullable
    @JsonProperty(value="email")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEmail() {
        return this.email;
    }

    @JsonProperty(value="email")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEmail(String email) {
        this.email = email;
    }

    public GetApplicationsListFilterParameter tags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public GetApplicationsListFilterParameter putTagsItem(String key, String tagsItem) {
        if (this.tags == null) {
            this.tags = new HashMap<String, String>();
        }
        this.tags.put(key, tagsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getTags() {
        return this.tags;
    }

    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetApplicationsListFilterParameter getApplicationsListFilterParameter = (GetApplicationsListFilterParameter)o;
        return Objects.equals(this.query, getApplicationsListFilterParameter.query) && Objects.equals(this.status, getApplicationsListFilterParameter.status) && Objects.equals(this.email, getApplicationsListFilterParameter.email) && Objects.equals(this.tags, getApplicationsListFilterParameter.tags);
    }

    public int hashCode() {
        return Objects.hash(this.query, this.status, this.email, this.tags);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GetApplicationsListFilterParameter {\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getQuery() != null) {
            joiner.add(String.format("%squery%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getQuery()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getStatus() != null) {
            for (int i = 0; i < this.getStatus().size(); ++i) {
                joiner.add(String.format("%sstatus%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(ApiClient.valueToString((Object)this.getStatus().get(i)), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
            }
        }
        if (this.getEmail() != null) {
            joiner.add(String.format("%semail%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getEmail()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getTags() != null) {
            for (String _key : this.getTags().keySet()) {
                joiner.add(String.format("%stags%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix), this.getTags().get(_key), URLEncoder.encode(ApiClient.valueToString(this.getTags().get(_key)), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
            }
        }
        return joiner.toString();
    }

    public static enum StatusEnum {
        AWAITING_DOCUMENTS("AwaitingDocuments"),
        PENDING_REVIEW("PendingReview"),
        PENDING("Pending"),
        APPROVED("Approved"),
        DENIED("Denied"),
        CANCELED("Canceled");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

