/*
 * Decompiled with CFR 0.152.
 */
package unit.java.sdk.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.StringJoiner;
import unit.java.sdk.ApiClient;

@JsonPropertyOrder(value={"routingNumber", "accountNumber", "accountType", "name"})
public class PaymentCounterparty {
    public static final String JSON_PROPERTY_ROUTING_NUMBER = "routingNumber";
    private String routingNumber;
    public static final String JSON_PROPERTY_ACCOUNT_NUMBER = "accountNumber";
    private String accountNumber;
    public static final String JSON_PROPERTY_ACCOUNT_TYPE = "accountType";
    private AccountTypeEnum accountType;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;

    public PaymentCounterparty routingNumber(String routingNumber) {
        this.routingNumber = routingNumber;
        return this;
    }

    @Nonnull
    @JsonProperty(value="routingNumber")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getRoutingNumber() {
        return this.routingNumber;
    }

    @JsonProperty(value="routingNumber")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRoutingNumber(String routingNumber) {
        this.routingNumber = routingNumber;
    }

    public PaymentCounterparty accountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
        return this;
    }

    @Nonnull
    @JsonProperty(value="accountNumber")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAccountNumber() {
        return this.accountNumber;
    }

    @JsonProperty(value="accountNumber")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public PaymentCounterparty accountType(AccountTypeEnum accountType) {
        this.accountType = accountType;
        return this;
    }

    @Nonnull
    @JsonProperty(value="accountType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public AccountTypeEnum getAccountType() {
        return this.accountType;
    }

    @JsonProperty(value="accountType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAccountType(AccountTypeEnum accountType) {
        this.accountType = accountType;
    }

    public PaymentCounterparty name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentCounterparty paymentCounterparty = (PaymentCounterparty)o;
        return Objects.equals(this.routingNumber, paymentCounterparty.routingNumber) && Objects.equals(this.accountNumber, paymentCounterparty.accountNumber) && Objects.equals((Object)this.accountType, (Object)paymentCounterparty.accountType) && Objects.equals(this.name, paymentCounterparty.name);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.routingNumber, this.accountNumber, this.accountType, this.name});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentCounterparty {\n");
        sb.append("    routingNumber: ").append(this.toIndentedString(this.routingNumber)).append("\n");
        sb.append("    accountNumber: ").append(this.toIndentedString(this.accountNumber)).append("\n");
        sb.append("    accountType: ").append(this.toIndentedString((Object)this.accountType)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getRoutingNumber() != null) {
            joiner.add(String.format("%sroutingNumber%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getRoutingNumber()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getAccountNumber() != null) {
            joiner.add(String.format("%saccountNumber%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getAccountNumber()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getAccountType() != null) {
            joiner.add(String.format("%saccountType%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString((Object)this.getAccountType()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getName() != null) {
            joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }

    public static enum AccountTypeEnum {
        CHECKING("Checking"),
        SAVINGS("Savings"),
        LOAN("Loan");

        private String value;

        private AccountTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AccountTypeEnum fromValue(String value) {
            for (AccountTypeEnum b : AccountTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

