/*
 * Decompiled with CFR 0.152.
 */
package unit.java.sdk.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import unit.java.sdk.ApiClient;

@JsonPropertyOrder(value={"createdAt", "amount", "description", "status", "rejectReason", "tags"})
public class RewardAttributes {
    public static final String JSON_PROPERTY_CREATED_AT = "createdAt";
    private OffsetDateTime createdAt;
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private Long amount;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status;
    public static final String JSON_PROPERTY_REJECT_REASON = "rejectReason";
    private String rejectReason;
    public static final String JSON_PROPERTY_TAGS = "tags";
    private Map<String, String> tags = new HashMap<String, String>();

    public RewardAttributes createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nonnull
    @JsonProperty(value="createdAt")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="createdAt")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public RewardAttributes amount(Long amount) {
        this.amount = amount;
        return this;
    }

    @Nonnull
    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Long getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAmount(Long amount) {
        this.amount = amount;
    }

    public RewardAttributes description(String description) {
        this.description = description;
        return this;
    }

    @Nonnull
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDescription(String description) {
        this.description = description;
    }

    public RewardAttributes status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @Nonnull
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public RewardAttributes rejectReason(String rejectReason) {
        this.rejectReason = rejectReason;
        return this;
    }

    @Nullable
    @JsonProperty(value="rejectReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRejectReason() {
        return this.rejectReason;
    }

    @JsonProperty(value="rejectReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRejectReason(String rejectReason) {
        this.rejectReason = rejectReason;
    }

    public RewardAttributes tags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public RewardAttributes putTagsItem(String key, String tagsItem) {
        if (this.tags == null) {
            this.tags = new HashMap<String, String>();
        }
        this.tags.put(key, tagsItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Map<String, String> getTags() {
        return this.tags;
    }

    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RewardAttributes rewardAttributes = (RewardAttributes)o;
        return Objects.equals(this.createdAt, rewardAttributes.createdAt) && Objects.equals(this.amount, rewardAttributes.amount) && Objects.equals(this.description, rewardAttributes.description) && Objects.equals((Object)this.status, (Object)rewardAttributes.status) && Objects.equals(this.rejectReason, rewardAttributes.rejectReason) && Objects.equals(this.tags, rewardAttributes.tags);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.createdAt, this.amount, this.description, this.status, this.rejectReason, this.tags});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RewardAttributes {\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    rejectReason: ").append(this.toIndentedString(this.rejectReason)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getCreatedAt() != null) {
            joiner.add(String.format("%screatedAt%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getCreatedAt()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getAmount() != null) {
            joiner.add(String.format("%samount%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getAmount()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getDescription() != null) {
            joiner.add(String.format("%sdescription%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getDescription()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getStatus() != null) {
            joiner.add(String.format("%sstatus%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString((Object)this.getStatus()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getRejectReason() != null) {
            joiner.add(String.format("%srejectReason%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getRejectReason()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getTags() != null) {
            for (String _key : this.getTags().keySet()) {
                joiner.add(String.format("%stags%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix), this.getTags().get(_key), URLEncoder.encode(ApiClient.valueToString(this.getTags().get(_key)), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
            }
        }
        return joiner.toString();
    }

    public static enum StatusEnum {
        REJECTED("Rejected"),
        SENT("Sent");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

