/*
 * Decompiled with CFR 0.152.
 */
package unit.java.sdk.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import unit.java.sdk.ApiClient;

@JsonPropertyOrder(value={"createdAt", "name", "status", "walletTerms", "routingNumber", "accountNumber", "currency", "balance", "hold", "available", "tags", "closeReason", "fraudReason", "freezeReason"})
public class WalletAccountAllOfAttributes {
    public static final String JSON_PROPERTY_CREATED_AT = "createdAt";
    private OffsetDateTime createdAt;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status;
    public static final String JSON_PROPERTY_WALLET_TERMS = "walletTerms";
    private String walletTerms;
    public static final String JSON_PROPERTY_ROUTING_NUMBER = "routingNumber";
    private String routingNumber;
    public static final String JSON_PROPERTY_ACCOUNT_NUMBER = "accountNumber";
    private String accountNumber;
    public static final String JSON_PROPERTY_CURRENCY = "currency";
    private String currency = "USD";
    public static final String JSON_PROPERTY_BALANCE = "balance";
    private Long balance;
    public static final String JSON_PROPERTY_HOLD = "hold";
    private Long hold;
    public static final String JSON_PROPERTY_AVAILABLE = "available";
    private Long available;
    public static final String JSON_PROPERTY_TAGS = "tags";
    private Map<String, String> tags = new HashMap<String, String>();
    public static final String JSON_PROPERTY_CLOSE_REASON = "closeReason";
    private CloseReasonEnum closeReason;
    public static final String JSON_PROPERTY_FRAUD_REASON = "fraudReason";
    private FraudReasonEnum fraudReason;
    public static final String JSON_PROPERTY_FREEZE_REASON = "freezeReason";
    private String freezeReason;

    public WalletAccountAllOfAttributes createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nonnull
    @JsonProperty(value="createdAt")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="createdAt")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public WalletAccountAllOfAttributes name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public WalletAccountAllOfAttributes status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @Nonnull
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public WalletAccountAllOfAttributes walletTerms(String walletTerms) {
        this.walletTerms = walletTerms;
        return this;
    }

    @Nullable
    @JsonProperty(value="walletTerms")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getWalletTerms() {
        return this.walletTerms;
    }

    @JsonProperty(value="walletTerms")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWalletTerms(String walletTerms) {
        this.walletTerms = walletTerms;
    }

    public WalletAccountAllOfAttributes routingNumber(String routingNumber) {
        this.routingNumber = routingNumber;
        return this;
    }

    @Nullable
    @JsonProperty(value="routingNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRoutingNumber() {
        return this.routingNumber;
    }

    @JsonProperty(value="routingNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRoutingNumber(String routingNumber) {
        this.routingNumber = routingNumber;
    }

    public WalletAccountAllOfAttributes accountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
        return this;
    }

    @Nullable
    @JsonProperty(value="accountNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccountNumber() {
        return this.accountNumber;
    }

    @JsonProperty(value="accountNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public WalletAccountAllOfAttributes currency(String currency) {
        this.currency = currency;
        return this;
    }

    @Nonnull
    @JsonProperty(value="currency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getCurrency() {
        return this.currency;
    }

    @JsonProperty(value="currency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public WalletAccountAllOfAttributes balance(Long balance) {
        this.balance = balance;
        return this;
    }

    @Nonnull
    @JsonProperty(value="balance")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Long getBalance() {
        return this.balance;
    }

    @JsonProperty(value="balance")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setBalance(Long balance) {
        this.balance = balance;
    }

    public WalletAccountAllOfAttributes hold(Long hold) {
        this.hold = hold;
        return this;
    }

    @Nonnull
    @JsonProperty(value="hold")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Long getHold() {
        return this.hold;
    }

    @JsonProperty(value="hold")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setHold(Long hold) {
        this.hold = hold;
    }

    public WalletAccountAllOfAttributes available(Long available) {
        this.available = available;
        return this;
    }

    @Nonnull
    @JsonProperty(value="available")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Long getAvailable() {
        return this.available;
    }

    @JsonProperty(value="available")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAvailable(Long available) {
        this.available = available;
    }

    public WalletAccountAllOfAttributes tags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public WalletAccountAllOfAttributes putTagsItem(String key, String tagsItem) {
        if (this.tags == null) {
            this.tags = new HashMap<String, String>();
        }
        this.tags.put(key, tagsItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Map<String, String> getTags() {
        return this.tags;
    }

    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public WalletAccountAllOfAttributes closeReason(CloseReasonEnum closeReason) {
        this.closeReason = closeReason;
        return this;
    }

    @Nullable
    @JsonProperty(value="closeReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CloseReasonEnum getCloseReason() {
        return this.closeReason;
    }

    @JsonProperty(value="closeReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCloseReason(CloseReasonEnum closeReason) {
        this.closeReason = closeReason;
    }

    public WalletAccountAllOfAttributes fraudReason(FraudReasonEnum fraudReason) {
        this.fraudReason = fraudReason;
        return this;
    }

    @Nullable
    @JsonProperty(value="fraudReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public FraudReasonEnum getFraudReason() {
        return this.fraudReason;
    }

    @JsonProperty(value="fraudReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFraudReason(FraudReasonEnum fraudReason) {
        this.fraudReason = fraudReason;
    }

    public WalletAccountAllOfAttributes freezeReason(String freezeReason) {
        this.freezeReason = freezeReason;
        return this;
    }

    @Nullable
    @JsonProperty(value="freezeReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFreezeReason() {
        return this.freezeReason;
    }

    @JsonProperty(value="freezeReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFreezeReason(String freezeReason) {
        this.freezeReason = freezeReason;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WalletAccountAllOfAttributes walletAccountAllOfAttributes = (WalletAccountAllOfAttributes)o;
        return Objects.equals(this.createdAt, walletAccountAllOfAttributes.createdAt) && Objects.equals(this.name, walletAccountAllOfAttributes.name) && Objects.equals((Object)this.status, (Object)walletAccountAllOfAttributes.status) && Objects.equals(this.walletTerms, walletAccountAllOfAttributes.walletTerms) && Objects.equals(this.routingNumber, walletAccountAllOfAttributes.routingNumber) && Objects.equals(this.accountNumber, walletAccountAllOfAttributes.accountNumber) && Objects.equals(this.currency, walletAccountAllOfAttributes.currency) && Objects.equals(this.balance, walletAccountAllOfAttributes.balance) && Objects.equals(this.hold, walletAccountAllOfAttributes.hold) && Objects.equals(this.available, walletAccountAllOfAttributes.available) && Objects.equals(this.tags, walletAccountAllOfAttributes.tags) && Objects.equals((Object)this.closeReason, (Object)walletAccountAllOfAttributes.closeReason) && Objects.equals((Object)this.fraudReason, (Object)walletAccountAllOfAttributes.fraudReason) && Objects.equals(this.freezeReason, walletAccountAllOfAttributes.freezeReason);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.createdAt, this.name, this.status, this.walletTerms, this.routingNumber, this.accountNumber, this.currency, this.balance, this.hold, this.available, this.tags, this.closeReason, this.fraudReason, this.freezeReason});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WalletAccountAllOfAttributes {\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    walletTerms: ").append(this.toIndentedString(this.walletTerms)).append("\n");
        sb.append("    routingNumber: ").append(this.toIndentedString(this.routingNumber)).append("\n");
        sb.append("    accountNumber: ").append(this.toIndentedString(this.accountNumber)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    balance: ").append(this.toIndentedString(this.balance)).append("\n");
        sb.append("    hold: ").append(this.toIndentedString(this.hold)).append("\n");
        sb.append("    available: ").append(this.toIndentedString(this.available)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    closeReason: ").append(this.toIndentedString((Object)this.closeReason)).append("\n");
        sb.append("    fraudReason: ").append(this.toIndentedString((Object)this.fraudReason)).append("\n");
        sb.append("    freezeReason: ").append(this.toIndentedString(this.freezeReason)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getCreatedAt() != null) {
            joiner.add(String.format("%screatedAt%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getCreatedAt()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getName() != null) {
            joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getStatus() != null) {
            joiner.add(String.format("%sstatus%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString((Object)this.getStatus()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getWalletTerms() != null) {
            joiner.add(String.format("%swalletTerms%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getWalletTerms()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getRoutingNumber() != null) {
            joiner.add(String.format("%sroutingNumber%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getRoutingNumber()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getAccountNumber() != null) {
            joiner.add(String.format("%saccountNumber%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getAccountNumber()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getCurrency() != null) {
            joiner.add(String.format("%scurrency%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getCurrency()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getBalance() != null) {
            joiner.add(String.format("%sbalance%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getBalance()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getHold() != null) {
            joiner.add(String.format("%shold%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getHold()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getAvailable() != null) {
            joiner.add(String.format("%savailable%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getAvailable()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getTags() != null) {
            for (String _key : this.getTags().keySet()) {
                joiner.add(String.format("%stags%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix), this.getTags().get(_key), URLEncoder.encode(ApiClient.valueToString(this.getTags().get(_key)), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
            }
        }
        if (this.getCloseReason() != null) {
            joiner.add(String.format("%scloseReason%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString((Object)this.getCloseReason()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getFraudReason() != null) {
            joiner.add(String.format("%sfraudReason%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString((Object)this.getFraudReason()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getFreezeReason() != null) {
            joiner.add(String.format("%sfreezeReason%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getFreezeReason()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }

    public static enum FraudReasonEnum {
        ACH_ACTIVITY("ACHActivity"),
        CARD_ACTIVITY("CardActivity"),
        CHECK_ACTIVITY("CheckActivity"),
        APPLICATION_HISTORY("ApplicationHistory"),
        ACCOUNT_ACTIVITY("AccountActivity"),
        CLIENT_IDENTIFIED("ClientIdentified"),
        IDENTITY_THEFT("IdentityTheft"),
        LINKED_TO_FRAUDULENT_CUSTOMER("LinkedToFraudulentCustomer");

        private String value;

        private FraudReasonEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static FraudReasonEnum fromValue(String value) {
            for (FraudReasonEnum b : FraudReasonEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum CloseReasonEnum {
        BY_CUSTOMER("ByCustomer"),
        FRAUD("Fraud"),
        OVERDUE("Overdue"),
        NEGATIVE_BALANCE("NegativeBalance"),
        BY_BANK("ByBank"),
        BREACH_OF_TERMS_AND_CONDITIONS("BreachOfTermsAndConditions"),
        NO_ACCOUNT_ACTIVITY("NoAccountActivity"),
        PROGRAM_CHANGE("ProgramChange");

        private String value;

        private CloseReasonEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CloseReasonEnum fromValue(String value) {
            for (CloseReasonEnum b : CloseReasonEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum StatusEnum {
        OPEN("Open"),
        CLOSED("Closed"),
        FROZEN("Frozen");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

