/*
 * Decompiled with CFR 0.152.
 */
package com.abasecode.opencode.pay.config;

import com.abasecode.opencode.pay.plugin.wechatpay.constant.WechatConstant;
import com.abasecode.opencode.pay.plugin.wechatpay.util.WechatUtils;
import com.abasecode.opencode.pay.util.BaseUtils;
import java.security.cert.X509Certificate;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;

@Component
@Configuration
public class WechatProperties
implements ApplicationRunner {
    @Bean
    @ConfigurationProperties(prefix="app.pay.wechat")
    public WechatConfigParam wechatConfigParam() {
        return new WechatConfigParam();
    }

    public void run(ApplicationArguments args) throws Exception {
        WechatConstant.wechatAppAppid = this.wechatConfigParam().appAppid;
        WechatConstant.wechatMpAppid = this.wechatConfigParam().mpAppid;
        WechatConstant.wechatMicroAppid = this.wechatConfigParam().microAppid;
        WechatConstant.wechatAppSecret = this.wechatConfigParam().appSecret;
        WechatConstant.wechatMpSecret = this.wechatConfigParam().mpSecret;
        WechatConstant.wechatMicroSecret = this.wechatConfigParam().microSecret;
        WechatConstant.wechatMchid = this.wechatConfigParam().mchid;
        WechatConstant.wechatBaseDomain = this.wechatConfigParam().baseDomain;
        WechatConstant.wechatCertUrl = this.wechatConfigParam().certPath;
        WechatConstant.wechatCertKey = this.wechatConfigParam().certKey;
        WechatConstant.wechatPayNotifyUrl = BaseUtils.getURI(WechatConstant.wechatBaseDomain, this.wechatConfigParam().payNotifyUrl);
        WechatConstant.wechatRefundNotifyUrl = BaseUtils.getURI(WechatConstant.wechatBaseDomain, this.wechatConfigParam().refundNotifyUrl);
        WechatConstant.wechatCodeReturnUrl = BaseUtils.getURI(WechatConstant.wechatBaseDomain, this.wechatConfigParam().mpCodeReturnUrl);
        WechatConstant.wechatV3key = this.wechatConfigParam().v3key;
        WechatConstant.wechatPrivateKey = WechatUtils.getPrivateKey();
        WechatConstant.wechatSerialNo = WechatUtils.getSerialNumber();
        WechatConstant.wechatCertificateMap = WechatUtils.refreshCertificate();
        X509Certificate certificate = WechatUtils.getCertificate();
    }

    public static class WechatConfigParam {
        private String appAppid;
        private String microAppid;
        private String mpAppid;
        private String appSecret;
        private String microSecret;
        private String mpSecret;
        private String mchid;
        private String certPath;
        private String certKey;
        private String v3key;
        private String baseDomain;
        private String payNotifyUrl;
        private String refundNotifyUrl;
        private String mpCodeReturnUrl;

        public String getAppAppid() {
            return this.appAppid;
        }

        public String getMicroAppid() {
            return this.microAppid;
        }

        public String getMpAppid() {
            return this.mpAppid;
        }

        public String getAppSecret() {
            return this.appSecret;
        }

        public String getMicroSecret() {
            return this.microSecret;
        }

        public String getMpSecret() {
            return this.mpSecret;
        }

        public String getMchid() {
            return this.mchid;
        }

        public String getCertPath() {
            return this.certPath;
        }

        public String getCertKey() {
            return this.certKey;
        }

        public String getV3key() {
            return this.v3key;
        }

        public String getBaseDomain() {
            return this.baseDomain;
        }

        public String getPayNotifyUrl() {
            return this.payNotifyUrl;
        }

        public String getRefundNotifyUrl() {
            return this.refundNotifyUrl;
        }

        public String getMpCodeReturnUrl() {
            return this.mpCodeReturnUrl;
        }

        public void setAppAppid(String appAppid) {
            this.appAppid = appAppid;
        }

        public void setMicroAppid(String microAppid) {
            this.microAppid = microAppid;
        }

        public void setMpAppid(String mpAppid) {
            this.mpAppid = mpAppid;
        }

        public void setAppSecret(String appSecret) {
            this.appSecret = appSecret;
        }

        public void setMicroSecret(String microSecret) {
            this.microSecret = microSecret;
        }

        public void setMpSecret(String mpSecret) {
            this.mpSecret = mpSecret;
        }

        public void setMchid(String mchid) {
            this.mchid = mchid;
        }

        public void setCertPath(String certPath) {
            this.certPath = certPath;
        }

        public void setCertKey(String certKey) {
            this.certKey = certKey;
        }

        public void setV3key(String v3key) {
            this.v3key = v3key;
        }

        public void setBaseDomain(String baseDomain) {
            this.baseDomain = baseDomain;
        }

        public void setPayNotifyUrl(String payNotifyUrl) {
            this.payNotifyUrl = payNotifyUrl;
        }

        public void setRefundNotifyUrl(String refundNotifyUrl) {
            this.refundNotifyUrl = refundNotifyUrl;
        }

        public void setMpCodeReturnUrl(String mpCodeReturnUrl) {
            this.mpCodeReturnUrl = mpCodeReturnUrl;
        }
    }
}

