/*
 * Decompiled with CFR 0.152.
 */
package com.abasecode.opencode.base.safe.util;

import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.Provider;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class CodeAesUtils {
    private static final String AES_NAME = "AES";
    private static final String ALGORITHM_CTR = "AES/CTR/NoPadding";
    private static final String ALGORITHM_GCM = "AES/GCM/NoPadding";
    private static final int GCM_LENGTH = 128;

    public static String encrypt(String source, String key, String iv) throws Exception {
        byte[] data = null;
        Cipher cipher = Cipher.getInstance(ALGORITHM_CTR);
        SecretKeySpec keySpec = new SecretKeySpec(key.getBytes(StandardCharsets.UTF_8), AES_NAME);
        IvParameterSpec paramSpec = new IvParameterSpec(iv.getBytes(StandardCharsets.UTF_8));
        cipher.init(1, (Key)keySpec, paramSpec);
        data = cipher.doFinal(source.getBytes(StandardCharsets.UTF_8));
        return Base64.encodeBase64String((byte[])data);
    }

    public static String decrypt(String encString, String key, String iv) throws Exception {
        Cipher cipher = Cipher.getInstance(ALGORITHM_CTR);
        SecretKeySpec secretKeySpec = new SecretKeySpec(key.getBytes(StandardCharsets.UTF_8), AES_NAME);
        IvParameterSpec parameterSpec = new IvParameterSpec(iv.getBytes(StandardCharsets.UTF_8));
        cipher.init(2, (Key)secretKeySpec, parameterSpec);
        return new String(cipher.doFinal(Base64.decodeBase64((String)encString)), StandardCharsets.UTF_8);
    }

    public static String encrypt(String source, String key, String iv, String additionalData) throws Exception {
        byte[] data = null;
        Cipher cipher = Cipher.getInstance(ALGORITHM_GCM);
        SecretKeySpec secretKeySpec = new SecretKeySpec(key.getBytes(StandardCharsets.UTF_8), AES_NAME);
        GCMParameterSpec parameterSpec = new GCMParameterSpec(128, iv.getBytes(StandardCharsets.UTF_8));
        cipher.init(1, (Key)secretKeySpec, parameterSpec);
        cipher.updateAAD(additionalData.getBytes(StandardCharsets.UTF_8));
        data = cipher.doFinal(source.getBytes(StandardCharsets.UTF_8));
        return Base64.encodeBase64String((byte[])data);
    }

    public static String decrypt(String encString, String key, String iv, String additionalData) throws Exception {
        Cipher cipher = Cipher.getInstance(ALGORITHM_GCM);
        SecretKeySpec secretKeySpec = new SecretKeySpec(key.getBytes(StandardCharsets.UTF_8), AES_NAME);
        GCMParameterSpec parameterSpec = new GCMParameterSpec(128, iv.getBytes(StandardCharsets.UTF_8));
        cipher.init(2, (Key)secretKeySpec, parameterSpec);
        cipher.updateAAD(additionalData.getBytes(StandardCharsets.UTF_8));
        return new String(cipher.doFinal(java.util.Base64.getDecoder().decode(encString)), StandardCharsets.UTF_8);
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

